/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.custom.runtime.provider;

import com.sun.encoder.custom.runtime.provider.Delim;
import com.sun.encoder.runtime.provider.Misc;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Map;

public class OtdDelim {
    public static final byte FIXED_FIELD_PRECEDENCE = 10;
    public final Delim[] mDelims;
    public final Delim.Slot[] mSlots;
    public final long mSlotsOffset;
    public final int mSlotsLength;
    private final DelimCache mConstStacks = new DelimCache();
    public final DelimStack mEmptyStack;

    public DelimLevel build(int[][] refs) {
        if (refs == null) {
            return null;
        }
        DelimLevel level = null;
        int i = refs.length;
        while (i-- > 0) {
            level = new DelimLevel(refs[i], level);
        }
        return level;
    }

    public OtdDelim(Delim[] delims, Delim.Slot[] slots) {
        if (delims == null) {
            delims = new Delim[]{};
        }
        this.mDelims = delims;
        this.mSlots = slots;
        if (slots == null || slots.length == 0) {
            this.mSlotsOffset = -1L;
            this.mSlotsLength = 0;
        } else {
            long offset = slots[0].mOffset;
            long end = offset + (long)slots[0].mLength;
            for (int i = 1; i < slots.length; ++i) {
                offset = Math.min(offset, slots[i].mOffset);
                end = Math.max(end, slots[i].mOffset + (long)slots[i].mLength);
            }
            this.mSlotsOffset = offset;
            this.mSlotsLength = (int)(end - offset);
        }
        this.mEmptyStack = new DelimStack();
        this.mConstStacks.put(this.mEmptyStack);
    }

    public Delim get(int index) {
        if (index < 0 || this.mDelims.length <= index) {
            throw new IllegalArgumentException("index out of delim range: " + index);
        }
        if (this.mDelims[index] == null) {
            throw new RuntimeException("missing delim descriptor #" + index);
        }
        return this.mDelims[index];
    }

    public void print(PrintStream out) {
        int i;
        boolean count = false;
        if (this.mDelims != null) {
            for (i = 0; i < this.mDelims.length; ++i) {
                Delim delim = this.mDelims[i];
                out.println("[" + i + "] " + delim.typeName() + "(" + delim.mPrec + ")=" + (delim.embedded() ? "embed#" + delim.mSlot : Misc.printable((byte[])delim.mData)) + ", term=" + delim.termName() + ", lieu=" + delim.lieuName());
            }
        }
        if (this.mSlots != null) {
            for (i = 0; i < this.mSlots.length; ++i) {
                Delim.Slot slot = this.mSlots[i];
                out.println("[" + i + "] EMBED: off=" + slot.mOffset + ", len=" + slot.mLength);
            }
        }
    }

    public static void main(String[] args) {
        try {
            System.out.println("[ start ]");
            byte[] data = "xxA".getBytes("ISO-8859-1");
            Delim[] delims = new Delim[]{new Delim(5, "A"), new Delim(6, "AA"), new Delim(4, "AAA"), new Delim(5, "A4"), new Delim(7, "B")};
            OtdDelim otd = new OtdDelim(delims, null);
            OtdDelimInst inst = otd.new OtdDelimInst();
            DelimStack ds = otd.mEmptyStack;
            Pos pos = new Pos();
            for (int i = 0; i < delims.length; ++i) {
                ds = inst.push(ds, i);
                System.out.println("[ push #" + i + " ]");
                ds.print(System.out);
                Delim match = ds.match(data, 0, data.length, pos);
                if (match != null) {
                    System.out.println("[ match: pos=" + pos.getPos() + ", d=" + new String(match.mData, "ISO-8859-1") + " ]");
                    continue;
                }
                System.out.println("[ no match: pos=" + pos.getPos() + " ]");
            }
            System.out.println("[ ready ]");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private static class Pos
    implements MatchReply {
        public int mPos = 0;
        public int mDataStartPos = 0;
        public int mDataLength = 0;
        private boolean mSet = false;

        private Pos() {
        }

        public void setPos(int pos) {
            this.mPos = pos;
            this.mSet = true;
        }

        public int getPos() {
            if (!this.mSet) {
                throw new RuntimeException("pos not set");
            }
            return this.mPos;
        }

        public void setDataStartPos(int pos) {
            this.mDataStartPos = pos;
        }

        public void setDataLength(int length) {
            this.mDataLength = length;
        }
    }

    public class OtdDelimInst {
        private byte[][] mSlotData = null;
        private DelimCache mDynamStacks = null;

        public OtdDelim getOtd() {
            return OtdDelim.this;
        }

        public void setSlotData(byte[][] data) {
            if (data != null) {
                if (OtdDelim.this.mSlots == null) {
                    throw new RuntimeException("no embedded delims to set");
                }
                if (data.length != OtdDelim.this.mSlots.length) {
                    throw new IllegalArgumentException("slot count wrong: need " + OtdDelim.this.mSlots.length + ", got " + data.length);
                }
                if (this.mSlotData != null) {
                    boolean same = true;
                    for (int i = 0; i < data.length; ++i) {
                        if (data[i] == null) {
                            throw new NullPointerException("null slot #" + i);
                        }
                        int len = data[i].length;
                        if (!(same &= len == this.mSlotData[i].length)) break;
                        for (int j = 0; j < len && (same &= data[i][j] == this.mSlotData[i][j]); ++j) {
                        }
                    }
                    if (!same) {
                        this.mDynamStacks.clear();
                    }
                }
                this.mSlotData = data;
            }
        }

        public DelimStack hide(DelimStack stack, int prec) {
            if (prec != 10) {
                throw new IllegalArgumentException("hide precedence must be 10, not " + prec);
            }
            DelimStack next = stack.mHide;
            if (next == null) {
                String id = stack.idHide(prec);
                if (this.mDynamStacks != null) {
                    next = this.mDynamStacks.get(id);
                }
                if (next == null) {
                    next = OtdDelim.this.mConstStacks.get(id);
                }
                if (next == null) {
                    next = new DelimStack(stack, prec, false);
                    if (next.mConstant) {
                        OtdDelim.this.mConstStacks.put(next);
                    } else {
                        if (this.mDynamStacks == null) {
                            this.mDynamStacks = new DelimCache();
                        }
                        this.mDynamStacks.put(next);
                    }
                }
                stack.mHide = next;
            }
            return next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DelimStack push(DelimStack stack, int index) {
            if (stack == null) {
                throw new NullPointerException("no base stack");
            }
            DelimStack next = stack.mPush[index];
            if (next == null) {
                DelimCache delimCache = OtdDelim.this.mConstStacks;
                synchronized (delimCache) {
                    next = stack.mPush[index];
                    if (next == null) {
                        String id = stack.idPush(index);
                        if (this.mDynamStacks != null) {
                            next = this.mDynamStacks.get(id);
                        }
                        if (next == null) {
                            next = OtdDelim.this.mConstStacks.get(id);
                        }
                        if (next == null) {
                            next = new DelimStack(stack, index, this.mSlotData);
                            if (next.mConstant) {
                                OtdDelim.this.mConstStacks.put(next);
                            } else {
                                if (this.mDynamStacks == null) {
                                    this.mDynamStacks = new DelimCache();
                                }
                                this.mDynamStacks.put(next);
                            }
                        }
                        stack.mPush[index] = next;
                    }
                }
            }
            return next;
        }

        public DelimStack push(DelimStack stack, DelimLevel level, boolean repSep) {
            if (level == null) {
                throw new NullPointerException("no level to push");
            }
            for (int i = 0; i < level.mRefs.length; ++i) {
                int index = level.mRefs[i];
                if (!repSep && OtdDelim.this.mDelims[index].mType == 1) continue;
                stack = this.push(stack, index);
            }
            return stack;
        }
    }

    public class DelimStack {
        public final DelimStack[] mPush;
        public DelimStack mHide;
        public final String mId;
        public final int[][] mRefs;
        public final boolean mConstant;

        private DelimStack() {
            this.mPush = new DelimStack[OtdDelim.this.mDelims.length];
            this.mHide = null;
            this.mId = "";
            this.mRefs = new int[256][];
            this.mConstant = true;
        }

        private DelimStack(DelimStack stack, int index, byte[][] slotData) {
            int[] add;
            byte[] data;
            this.mPush = new DelimStack[OtdDelim.this.mDelims.length];
            this.mHide = null;
            if (stack == null) {
                throw new NullPointerException("no stack");
            }
            if (index < 0 || OtdDelim.this.mDelims.length <= index) {
                throw new IllegalArgumentException("invalid delimiter index: " + index);
            }
            this.mId = stack.idPush(index);
            this.mRefs = (int[][])stack.mRefs.clone();
            Delim delim = OtdDelim.this.mDelims[index];
            if (delim.embedded()) {
                if (slotData == null) {
                    throw new RuntimeException("missing setSlotData()");
                }
                data = slotData[delim.mSlot];
            } else {
                data = delim.mData;
            }
            int first = data[0] & 0xFF;
            int[] sub = this.mRefs[first];
            if (sub == null) {
                add = new int[]{index};
            } else {
                int pos;
                add = new int[sub.length + 1];
                for (pos = 0; pos < sub.length; ++pos) {
                    add[pos] = sub[pos];
                    if (OtdDelim.this.mDelims[sub[pos]].mPrec <= delim.mPrec) break;
                }
                add[pos] = index;
                while (pos < sub.length) {
                    add[pos + 1] = sub[pos];
                    ++pos;
                }
            }
            this.mRefs[first] = add;
            this.mConstant = stack.mConstant && !delim.embedded();
        }

        private DelimStack(DelimStack stack, int prec, boolean dummy) {
            this.mPush = new DelimStack[OtdDelim.this.mDelims.length];
            this.mHide = null;
            if (stack == null) {
                throw new NullPointerException("no stack");
            }
            if (prec != 10) {
                throw new IllegalArgumentException("precedence must be 10");
            }
            this.mId = stack.idHide(prec);
            this.mRefs = (int[][])stack.mRefs.clone();
            boolean change = false;
            boolean constant = true;
            int[] tmp = new int[OtdDelim.this.mDelims.length];
            for (int i = 0; i < 256; ++i) {
                int[] sub = this.mRefs[i];
                if (sub == null) continue;
                int k = 0;
                for (int j = 0; j < sub.length; ++j) {
                    Delim delim = OtdDelim.this.mDelims[sub[j]];
                    if (delim.mPrec <= prec) continue;
                    tmp[k++] = sub[j];
                    constant &= !delim.embedded();
                }
                if (k == 0) {
                    this.mRefs[i] = null;
                    change = true;
                    continue;
                }
                if (k >= sub.length) continue;
                sub = new int[k];
                while (k-- > 0) {
                    sub[k] = tmp[k];
                }
                this.mRefs[i] = sub;
                change = true;
            }
            this.mConstant = constant;
        }

        public String idPush(int index) {
            if (index < 0) {
                throw new IllegalArgumentException("negative index");
            }
            if (index >= 65534) {
                throw new RuntimeException("cannot handle index > 0xFFFE");
            }
            int pos = this.mId.indexOf((char)index);
            return (pos < 0 ? this.mId : this.mId.substring(0, pos) + this.mId.substring(pos + 1)) + (char)index;
        }

        public String idHide(int prec) {
            if (prec < 0) {
                throw new IllegalArgumentException("negative precedence");
            }
            StringBuffer sb = new StringBuffer();
            int len = this.mId.length();
            for (int i = 0; i < len; ++i) {
                char c = this.mId.charAt(i);
                if (OtdDelim.this.mDelims[c].mPrec <= prec) continue;
                sb.append(c);
            }
            return sb.toString();
        }

        public void print(PrintWriter out) {
            int count = 0;
            for (int i = 0; i < 256; ++i) {
                int[] sub = this.mRefs[i];
                if (sub == null) continue;
                ++count;
                out.print("[" + i + "]");
                for (int j = 0; j < sub.length; ++j) {
                    Delim delim = OtdDelim.this.mDelims[sub[j]];
                    out.print(" " + delim.typeName() + "(" + delim.mPrec + ")=" + (delim.embedded() ? "embed#" + delim.mSlot : Misc.printable((byte[])delim.mData)));
                }
                out.println();
            }
            out.println("[ " + count + " entries ]");
        }

        public void print(PrintStream out) {
            PrintWriter pw = new PrintWriter(out);
            this.print(pw);
            pw.flush();
        }

        public Delim match(byte[] data, int pos, int end, MatchReply reply) {
            if (pos < 0) {
                throw new IllegalArgumentException("negative start position");
            }
            if (data.length < end) {
                throw new IllegalArgumentException("end past length");
            }
            int startPos = pos;
            int dataStart = -1;
            int dataEnd = -1;
            block0: while (pos < end) {
                block17: {
                    int bVal = data[pos] & 0xFF;
                    int[] ref = this.mRefs[bVal];
                    if (ref != null) {
                        block1: for (int j = 0; j < ref.length; ++j) {
                            int i;
                            int len;
                            Delim delim = OtdDelim.this.mDelims[ref[j]];
                            int n = len = delim.embedded() ? OtdDelim.this.mSlots[delim.mSlot].mLength : delim.mData.length;
                            if (pos + len > end) break block0;
                            for (i = 1; i < len; ++i) {
                                if (delim.mData[i] != data[pos + i]) continue block1;
                            }
                            if (delim.mType == 2) {
                                pos += len - 1;
                                break block17;
                            }
                            if (pos == startPos && delim.skipLeading()) {
                                while ((pos += len) <= end - len) {
                                    for (i = 0; i < len; ++i) {
                                        if (delim.mData[i] == data[pos + i]) continue;
                                        dataStart = pos;
                                        dataEnd = pos;
                                        break block17;
                                    }
                                }
                                pos -= len;
                            }
                            if (dataStart != -1) {
                                dataEnd = pos;
                            }
                            if (delim.collapse()) {
                                block5: while ((pos += len) <= end - len) {
                                    for (i = 0; i < len; ++i) {
                                        if (delim.mData[i] != data[pos + i]) break block5;
                                    }
                                }
                                pos -= len;
                            }
                            reply.setPos(pos);
                            if (dataStart != -1) {
                                reply.setDataStartPos(dataStart);
                                reply.setDataLength(dataEnd - dataStart);
                            } else {
                                reply.setDataStartPos(startPos);
                                reply.setDataLength(0);
                            }
                            return delim;
                        }
                    }
                    if (dataStart == -1) {
                        dataStart = pos;
                        dataEnd = pos + 1;
                    }
                }
                ++pos;
            }
            reply.setPos(pos);
            return null;
        }
    }

    public static interface MatchReply {
        public void setPos(int var1);

        public void setDataStartPos(int var1);

        public void setDataLength(int var1);
    }

    public class DelimCache {
        private Map mMap = new Hashtable();

        public void clear() {
            this.mMap.clear();
        }

        public DelimStack get(String id) {
            if (id == null) {
                throw new NullPointerException("no key");
            }
            return (DelimStack)this.mMap.get(id);
        }

        public void put(DelimStack stack) {
            if (stack == null) {
                throw new NullPointerException("no stack");
            }
            if (this.mMap.containsKey(stack.mId)) {
                throw new IllegalArgumentException("duplicate entry");
            }
            this.mMap.put(stack.mId, stack);
        }
    }

    public class DelimLevel {
        public final DelimLevel mNext;
        public final int[] mRefs;
        public final int mPlain;
        public final int mArray;
        public final boolean mTerm;
        public final boolean mLieu;
        public final Delim mPlainDelim;

        public DelimLevel(int[] refs, int plain, int array, DelimLevel next) {
            if (refs == null) {
                throw new NullPointerException("no delimiter references");
            }
            boolean terminal = true;
            boolean explicit = true;
            int i = refs.length;
            while (i-- > 0) {
                Delim delim = OtdDelim.this.get(refs[i]);
                if (delim.mType != 0) continue;
                terminal &= delim.mTerm == 3;
                explicit &= delim.mLieu == 3;
            }
            this.mRefs = refs;
            this.mPlain = plain;
            this.mArray = array;
            this.mTerm = terminal;
            this.mLieu = explicit;
            this.mNext = next;
            this.mPlainDelim = this.mPlain >= 0 ? OtdDelim.this.get(this.mPlain) : null;
        }

        public DelimLevel(int[] refs, DelimLevel next) {
            if (refs == null) {
                throw new NullPointerException("no delimiter references");
            }
            boolean terminal = true;
            boolean explicit = true;
            int plain = -1;
            int array = -1;
            int i = refs.length;
            while (i-- > 0) {
                Delim delim = OtdDelim.this.get(refs[i]);
                switch (delim.mType) {
                    case 0: {
                        plain = refs[i];
                        terminal &= delim.mTerm == 3;
                        explicit &= delim.mLieu == 3;
                        break;
                    }
                    case 1: {
                        array = refs[i];
                    }
                }
                if ((OtdDelim.this.mSlots == null ? 0 : OtdDelim.this.mSlots.length) >= delim.mSlot) continue;
                throw new RuntimeException("invalid slot #" + delim.mSlot + " in delim #" + refs[i]);
            }
            this.mRefs = refs;
            this.mPlain = plain;
            this.mArray = array;
            this.mTerm = terminal;
            this.mLieu = explicit;
            this.mNext = next;
            this.mPlainDelim = this.mPlain >= 0 ? OtdDelim.this.get(this.mPlain) : null;
        }

        public boolean contains(Delim delim) {
            for (int i = 0; i < this.mRefs.length; ++i) {
                if (OtdDelim.this.mDelims[this.mRefs[i]] != delim) continue;
                return true;
            }
            return false;
        }

        public boolean isTerminal() {
            return this.mTerm;
        }

        public boolean isExplicit() {
            return this.mLieu;
        }
    }
}

