/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.context;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xhtmlrenderer.css.extend.ContentFunction;
import org.xhtmlrenderer.css.parser.FSFunction;
import org.xhtmlrenderer.css.parser.PropertyValue;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.InlineText;
import org.xhtmlrenderer.render.RenderingContext;

public class ContentFunctionFactory {
    private List _functions = new ArrayList();

    public ContentFunctionFactory() {
        this._functions.add(new PageCounterFunction());
        this._functions.add(new PagesCounterFunction());
    }

    public ContentFunction lookupFunction(LayoutContext c, FSFunction function) {
        Iterator i = this._functions.iterator();
        while (i.hasNext()) {
            ContentFunction f = (ContentFunction)i.next();
            if (!f.canHandle(c, function)) continue;
            return f;
        }
        return null;
    }

    public void registerFunction(ContentFunction function) {
        this._functions.add(function);
    }

    private static class PagesCounterFunction
    extends PageNumberFunction
    implements ContentFunction {
        private PagesCounterFunction() {
        }

        public String calculate(RenderingContext c, FSFunction function, InlineText text) {
            return Integer.toString(c.getPageCount());
        }

        public boolean canHandle(LayoutContext c, FSFunction function) {
            return c.isPrint() && this.isCounter(function, "pages");
        }
    }

    private static class PageCounterFunction
    extends PageNumberFunction
    implements ContentFunction {
        private PageCounterFunction() {
        }

        public String calculate(RenderingContext c, FSFunction function, InlineText text) {
            return Integer.toString(c.getPageNo() + 1);
        }

        public boolean canHandle(LayoutContext c, FSFunction function) {
            return c.isPrint() && this.isCounter(function, "page");
        }
    }

    private static abstract class PageNumberFunction
    implements ContentFunction {
        private PageNumberFunction() {
        }

        public boolean isStatic() {
            return false;
        }

        public String calculate(LayoutContext c, FSFunction function) {
            return null;
        }

        public String getLayoutReplacementText() {
            return "999";
        }

        protected boolean isCounter(FSFunction function, String counterName) {
            PropertyValue param;
            List parameters;
            return function.getName().equals("counter") && (parameters = function.getParameters()).size() == 1 && (param = (PropertyValue)parameters.get(0)).getPrimitiveType() == 21 && param.getStringValue().equals(counterName);
        }
    }
}

