/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.hl7.xsdbuilder;

import com.sun.encoder.codegen.Emit;
import com.sun.encoder.hl7.xsdbuilder.BaseGenerator;
import com.sun.encoder.hl7.xsdbuilder.GeneratorException;
import com.sun.encoder.hl7.xsdbuilder.NameGenerator;
import com.sun.encoder.hl7.xsdbuilder.XSDGenerator;
import com.sun.encoder.util.UnicodeFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;

public class DataTypesGenerator
extends BaseGenerator
implements XSDGenerator {
    public static final String DATATYPES_SQL = "com/sun/encoder/hl7/xsdbuilder/datatypes.sql";
    public static final String DATATYPECOMPONENTS_SQL = "com/sun/encoder/hl7/xsdbuilder/datatypecomponents.sql";
    private final NameGenerator mNameGen;

    DataTypesGenerator(Connection conn, String version, File targetLocation, NameGenerator nameGen) {
        super(conn, version, targetLocation);
        this.mNameGen = nameGen;
    }

    /*
     * Loose catch block
     */
    public void generate() throws GeneratorException {
        block25: {
            SQLException e2222;
            SQLException expRet;
            ResultSet rs;
            Statement pstmtOneDataType;
            Statement pstmtAllDataTypes;
            block22: {
                pstmtAllDataTypes = null;
                pstmtOneDataType = null;
                rs = null;
                Emit emit1 = null;
                Emit emit2 = null;
                this.populateComplexDataTypes();
                emit1 = new Emit(this.getWriter1(), 0, 4);
                emit2 = new Emit(this.getWriter2(), 0, 4);
                emit2.indent();
                this.printHeader(emit1);
                this.printEscapeType(emit1);
                String sqlAllDataTypes = this.getSQLStmt(DATATYPES_SQL);
                pstmtAllDataTypes = this.mConn.prepareStatement(sqlAllDataTypes, 1004, 1007);
                pstmtAllDataTypes.setString(1, this.mHL7Version);
                rs = pstmtAllDataTypes.executeQuery();
                String sqlOneDataType = this.getSQLStmt(DATATYPECOMPONENTS_SQL);
                pstmtOneDataType = this.mConn.prepareStatement(sqlOneDataType, 1004, 1007);
                rs.beforeFirst();
                while (rs.next()) {
                    System.out.println(rs.getString("data_structure"));
                    this.generateOneDataType((PreparedStatement)pstmtOneDataType, emit1, emit2, rs.getString("data_structure"), rs.getBoolean("elementary"));
                }
                this.printFooter(emit2);
                emit1.flush();
                emit1.close();
                emit1 = null;
                emit2.flush();
                emit2.close();
                emit2 = null;
                this.moveFile(this.getTempTargetFile1(), this.getTargetFile());
                this.concatFile(this.getTempTargetFile2(), this.getTargetFile());
                Object var10_8 = null;
                expRet = null;
                if (rs == null) break block22;
                try {
                    rs.close();
                }
                catch (SQLException e2222) {
                    expRet = e2222;
                }
            }
            if (pstmtAllDataTypes != null) {
                try {
                    pstmtAllDataTypes.close();
                }
                catch (SQLException e2222) {
                    expRet = e2222;
                }
            }
            if (pstmtOneDataType != null) {
                try {
                    pstmtOneDataType.close();
                }
                catch (SQLException e2222) {
                    expRet = e2222;
                }
            }
            this.getTempTargetFile1().delete();
            this.getTempTargetFile2().delete();
            if (expRet != null) {
                throw new GeneratorException(expRet);
            }
            break block25;
            {
                catch (IOException e3) {
                    throw new GeneratorException(e3);
                }
                catch (SQLException e4) {
                    throw new GeneratorException(e4);
                }
            }
            catch (Throwable throwable) {
                SQLException e2222;
                Object var10_9 = null;
                expRet = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e2222) {
                        expRet = e2222;
                    }
                }
                if (pstmtAllDataTypes != null) {
                    try {
                        pstmtAllDataTypes.close();
                    }
                    catch (SQLException e2222) {
                        expRet = e2222;
                    }
                }
                if (pstmtOneDataType != null) {
                    try {
                        pstmtOneDataType.close();
                    }
                    catch (SQLException e2222) {
                        expRet = e2222;
                    }
                }
                this.getTempTargetFile1().delete();
                this.getTempTargetFile2().delete();
                if (expRet != null) {
                    throw new GeneratorException(expRet);
                }
                throw throwable;
            }
        }
    }

    private void printHeader(Emit emit) {
        emit.emit("<?xml version =\"1.0\" encoding=\"UTF-8\"?>");
        emit.down("<!--");
        emit.emit("v2.xml Message Definitions Version v" + this.mHL7Version + "  - data types");
        emit.emit("Copyright (C) Sun Microsystems. All rights reserved.");
        emit.done("-->");
        emit.down("<xsd:schema");
        emit.emit("xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        emit.emit("xmlns=\"urn:hl7-org:v2xml\"");
        emit.emit("xmlns:hl7=\"urn:com.sun:encoder-hl7-1.0\"");
        emit.emit("targetNamespace=\"urn:hl7-org:v2xml\" xmlns:jaxb=\"http://java.sun.com/xml/ns/jaxb\" jaxb:version=\"2.0\">");
        emit.emit();
        emit.down("<xsd:annotation>");
        emit.down("<xsd:appinfo source=\"urn:com.sun:encoder\">");
        emit.emit("<encoding xmlns=\"urn:com.sun:encoder\" name=\"HL7 v2 Encoding\" namespace=\"urn:com.sun:encoder-hl7-1.0\" style=\"hl7encoder-1.0\"/>");
        emit.done("</xsd:appinfo>");
        emit.done("</xsd:annotation>");
        emit.emit();
    }

    private void printFooter(Emit emit) {
        emit.done("</xsd:schema>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateOneDataType(PreparedStatement pstmt, Emit emit1, Emit emit2, String datatype, boolean isElementary) throws SQLException {
        if (!isElementary) {
            StringBuffer sb = new StringBuffer();
            pstmt.setString(1, this.mHL7Version);
            pstmt.setString(2, datatype);
            ResultSet rs = null;
            try {
                rs = pstmt.executeQuery();
                rs.beforeFirst();
                boolean printStart = false;
                DecimalFormat tableNmFormatter = new DecimalFormat("0000");
                int seq_no = 1;
                while (rs.next()) {
                    if (!printStart) {
                        emit1.down("<!--");
                        emit1.emit("COMPOSITE DATATYPE " + datatype);
                        emit1.done("-->");
                        sb.setLength(0);
                        emit1.down(sb.append("<xsd:complexType name=\"").append(datatype).append("\">").toString());
                        if (!this.mNameGen.nameExists(datatype)) {
                            this.mNameGen.markUsed(datatype);
                        } else {
                            emit1.down("<xsd:annotation>");
                            DataTypesGenerator.printJAXBCustomization(emit1, this.mNameGen.suggestClassName(datatype));
                            emit1.done("</xsd:annotation>");
                        }
                        emit1.down("<xsd:sequence>");
                        printStart = true;
                    }
                    String elemName = datatype + "." + seq_no;
                    ++seq_no;
                    sb.setLength(0);
                    emit1.emit(sb.append("<xsd:element ref=\"").append(elemName).append("\" minOccurs=\"0\" maxOccurs=\"1\"/>").toString());
                    String tableId = null;
                    if (rs.getInt("table_id") != 0) {
                        tableId = "HL7" + tableNmFormatter.format(rs.getInt("table_id"));
                    }
                    String dataType = rs.getString("data_type_code");
                    String dataStruct = rs.getString("data_structure");
                    this.printSubElement(emit2, elemName, dataType, dataStruct, rs.getString("subdesc"), tableId, !this.mCompTypeSet.contains(dataStruct) && !this.mCompTypeSet.contains(dataType) && !this.mAllowEscapeSet.contains(dataType));
                }
                if (printStart) {
                    emit1.done("</xsd:sequence>");
                    emit1.done("</xsd:complexType>");
                    return;
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        this.printPrimType(emit1, datatype);
    }

    private void printPrimType(Emit emit, String dataType) {
        emit.down("<!--");
        emit.emit("PRIMITIVE DATATYPE " + dataType);
        emit.done("-->");
        if (this.mAllowEscapeSet.contains(dataType)) {
            emit.down("<xsd:complexType name=\"" + dataType + "\" mixed=\"true\">");
            emit.down("<xsd:sequence>");
            emit.emit("<xsd:element name=\"escape\" minOccurs=\"0\" maxOccurs=\"unbounded\" type=\"escapeType\"/>");
            emit.done("</xsd:sequence>");
            emit.done("</xsd:complexType>");
        } else if ("varies".equals(dataType)) {
            emit.down("<xsd:complexType name=\"varies\">");
            emit.down("<xsd:complexContent>");
            emit.emit("<xsd:extension base=\"xsd:anyType\"/>");
            emit.done("</xsd:complexContent>");
            emit.done("</xsd:complexType>");
        } else {
            emit.down("<xsd:simpleType name=\"" + dataType + "\">");
            emit.emit("<xsd:restriction base=\"xsd:string\"/>");
            emit.done("</xsd:simpleType>");
        }
    }

    private void printSubElement(Emit emit, String elemName, String dataType, String dataStruct, String desc, String tableId, boolean elementary) {
        emit.down("<!--");
        emit.emit("COMPONENT " + elemName);
        emit.done("-->");
        emit.down("<xsd:attributeGroup name=\"" + elemName + ".ATTRIBUTES\">");
        emit.emit("<xsd:attribute name=\"Type\" type=\"xsd:string\" fixed=\"" + dataType + "\"/>");
        if (tableId != null) {
            emit.emit("<xsd:attribute name=\"Table\" type=\"xsd:string\" fixed=\"" + tableId + "\"/>");
        }
        emit.emit("<xsd:attribute name=\"LongName\" type=\"xsd:string\" fixed=\"" + this.encData(desc) + "\"/>");
        emit.done("</xsd:attributeGroup>");
        String ctName = elemName + ".CONTENT";
        emit.down("<xsd:complexType name=\"" + ctName + "\">");
        emit.down("<xsd:annotation>");
        emit.emit("<xsd:documentation xml:lang=\"en\">" + this.encData(desc) + "</xsd:documentation>");
        if (!this.mNameGen.nameExists(ctName)) {
            this.mNameGen.markUsed(ctName);
        } else {
            DataTypesGenerator.printJAXBCustomization(emit, this.mNameGen.suggestClassName(ctName));
        }
        emit.down("<xsd:appinfo source=\"urn:com.sun:encoder\">");
        emit.emit("<hl7:Type>" + dataType + "</hl7:Type>");
        if (tableId != null) {
            emit.emit("<hl7:Table>" + tableId + "</hl7:Table>");
        }
        emit.emit("<hl7:LongName>" + this.encData(desc) + "</hl7:LongName>");
        emit.done("</xsd:appinfo>");
        emit.done("</xsd:annotation>");
        if (elementary) {
            emit.down("<xsd:simpleContent>");
        } else {
            emit.down("<xsd:complexContent>");
        }
        if (dataStruct.startsWith("CE_")) {
            emit.down("<xsd:extension base=\"" + dataType + "\">");
        } else {
            emit.down("<xsd:extension base=\"" + dataStruct + "\">");
        }
        emit.emit("<xsd:attributeGroup ref=\"" + elemName + ".ATTRIBUTES\"/>");
        emit.done("</xsd:extension>");
        if (elementary) {
            emit.done("</xsd:simpleContent>");
        } else {
            emit.done("</xsd:complexContent>");
        }
        emit.done("</xsd:complexType>");
        if (!this.mNameGen.nameExists(elemName)) {
            emit.emit("<xsd:element name=\"" + elemName + "\" type=\"" + elemName + ".CONTENT\"/>");
            this.mNameGen.markUsed(elemName);
        } else {
            emit.down("<xsd:element name=\"" + elemName + "\" type=\"" + elemName + ".CONTENT\">");
            emit.down("<xsd:annotation>");
            DataTypesGenerator.printJAXBCustomization(emit, this.mNameGen.suggestClassName(elemName));
            emit.done("</xsd:annotation>");
            emit.done("</xsd:element>");
        }
    }

    private void printEscapeType(Emit emit) {
        emit.down("<xsd:complexType name=\"escapeType\">");
        emit.down("<xsd:simpleContent>");
        emit.down("<xsd:extension base=\"xsd:string\">");
        emit.emit("<xsd:attribute name=\"V\" type=\"xsd:string\"/>");
        emit.done("</xsd:extension>");
        emit.done("</xsd:simpleContent>");
        emit.done("</xsd:complexType>");
    }

    private Writer getWriter1() throws FileNotFoundException, IOException {
        return UnicodeFile.makeOutputWriter((File)this.getTempTargetFile1());
    }

    private Writer getWriter2() throws FileNotFoundException, IOException {
        return UnicodeFile.makeOutputWriter((File)this.getTempTargetFile2());
    }

    private File getTempTargetFile1() {
        return new File(this.mTargetLocation, "datatypes.xsd.~temp1");
    }

    private File getTempTargetFile2() {
        return new File(this.mTargetLocation, "datatypes.xsd.~temp2");
    }

    private File getTargetFile() {
        return new File(this.mTargetLocation, "datatypes.xsd");
    }
}

