/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.hl7.xsdbuilder;

import com.sun.encoder.codegen.Emit;
import com.sun.encoder.hl7.xsdbuilder.XSDGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

public abstract class BaseGenerator
implements XSDGenerator {
    public static final String COMPLEXDATATYPES_SQL = "com/sun/encoder/hl7/xsdbuilder/complexdatatypes.sql";
    protected final Set<String> mCompTypeSet = new HashSet<String>();
    protected final Connection mConn;
    protected final File mTargetLocation;
    protected final String mHL7Version;
    protected final Set<String> mAllowEscapeSet = new HashSet<String>();
    protected final Set<String> mVariantDataTypes = new HashSet<String>();

    BaseGenerator(Connection conn, String version, File targetLocation) {
        this.mConn = conn;
        this.mHL7Version = version;
        this.mTargetLocation = targetLocation;
        this.mAllowEscapeSet.add("FT");
        this.mAllowEscapeSet.add("TX");
        this.mVariantDataTypes.add("*");
        this.mVariantDataTypes.add("varies");
        this.mVariantDataTypes.add("var");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSQLStmt(String location) throws IOException {
        Reader reader = null;
        try {
            int count;
            reader = new InputStreamReader(this.getClazzLoader().getResourceAsStream(location), "UTF-8");
            char[] readBlock = new char[512];
            StringBuffer buffer = new StringBuffer();
            while ((count = reader.read(readBlock)) >= 0) {
                buffer.append(readBlock, 0, count);
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    protected ClassLoader getClazzLoader() {
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl != null) {
            return cl;
        }
        return ClassLoader.getSystemClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveFile(File source, File dest) throws IOException {
        boolean isRenamed = source.renameTo(dest);
        if (isRenamed) {
            return;
        }
        FileInputStream in = null;
        OutputStream out = null;
        try {
            int count;
            in = new FileInputStream(source);
            out = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            while ((count = ((InputStream)in).read(buffer)) >= 0) {
                out.write(buffer, 0, count);
            }
            out.flush();
        }
        finally {
            block12: {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        if (in == null) break block12;
                        ((InputStream)in).close();
                    }
                }
            }
            if (in != null) {
                ((InputStream)in).close();
            }
            source.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void concatFile(File source, File dest) throws IOException {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            int count;
            in = new FileInputStream(source);
            out = new FileOutputStream(dest, true);
            byte[] buffer = new byte[1024];
            while ((count = ((InputStream)in).read(buffer)) >= 0) {
                out.write(buffer, 0, count);
            }
            out.flush();
        }
        finally {
            block11: {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        if (in == null) break block11;
                        ((InputStream)in).close();
                    }
                }
            }
            if (in != null) {
                ((InputStream)in).close();
            }
            source.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateComplexDataTypes() throws IOException, SQLException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String sql = this.getSQLStmt(COMPLEXDATATYPES_SQL);
            pstmt = this.mConn.prepareStatement(sql, 1004, 1007);
            pstmt.setString(1, this.mHL7Version);
            rs = pstmt.executeQuery();
            this.mCompTypeSet.clear();
            rs.beforeFirst();
            while (rs.next()) {
                this.mCompTypeSet.add(rs.getString("data_structure"));
            }
        }
        finally {
            SQLException expRet = null;
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    expRet = e;
                }
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException e) {
                    expRet = e;
                }
            }
            if (expRet != null) {
                throw expRet;
            }
        }
    }

    protected String encData(String pcdata) {
        return pcdata.replace("&", "&amp;").replace("'", "&apos;").replace("\"", "&quot;").replace("<", "&lt;").replace(">", "&gt;");
    }

    public static void printJAXBCustomization(Emit emit, String className) {
        emit.down("<xsd:appinfo source=\"http://java.sun.com/xml/ns/jaxb\">");
        emit.emit("<jaxb:class name=\"" + className + "\"/>");
        emit.done("</xsd:appinfo>");
    }
}

