/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.webservice.runtime;

import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import it.imolinfo.jbi4corba.webservice.descriptor.ProviderServiceDescriptor;
import it.imolinfo.jbi4corba.webservice.runtime.ByteType;
import it.imolinfo.jbi4corba.webservice.runtime.ProviderServiceInvoker;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.aegis.AegisBindingProvider;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.aegis.type.TypeMapping;
import org.codehaus.xfire.aegis.type.TypeMappingRegistry;
import org.codehaus.xfire.annotations.AnnotationServiceFactory;
import org.codehaus.xfire.annotations.WebAnnotations;
import org.codehaus.xfire.annotations.jsr181.Jsr181WebAnnotations;
import org.codehaus.xfire.jaxb2.JaxbTypeRegistry;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.BindingProvider;
import org.codehaus.xfire.service.invoker.Invoker;

public class ProviderServiceCreator {
    private static final Logger LOG = LoggerFactory.getLogger(ProviderServiceCreator.class);

    public Service createService(ProviderServiceDescriptor serviceDescriptor, XFire xfire) throws IOException {
        LOG.debug(">>>>> createService - begin");
        AnnotationServiceFactory factory = new AnnotationServiceFactory((WebAnnotations)new Jsr181WebAnnotations(), xfire.getTransportManager(), (BindingProvider)new AegisBindingProvider((TypeMappingRegistry)new JaxbTypeRegistry()));
        HashMap<String, Boolean> properties = new HashMap<String, Boolean>();
        properties.put("annotations.allow.interface", Boolean.TRUE);
        Service service = factory.create(serviceDescriptor.getServiceInterface(), serviceDescriptor.getServiceName(), serviceDescriptor.getServiceNameSpace(), properties);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Service=" + service);
        }
        service.setInvoker((Invoker)new ProviderServiceInvoker(serviceDescriptor));
        service.setProperty("wsdlBuilder.generateImports", (Object)"true");
        if (LOG.isInfoEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            service.getWSDLWriter().write((OutputStream)baos);
            LOG.info("CRB000733_Wsdl_of_created_service", baos.toString());
        }
        LOG.debug("<<<<< createService - end");
        return service;
    }

    public Service createJbiService(ProviderServiceDescriptor serviceDescriptor, XFire xfire, QName interfaceName) {
        AnnotationServiceFactory factory = new AnnotationServiceFactory((WebAnnotations)new Jsr181WebAnnotations(), xfire.getTransportManager(), (BindingProvider)new AegisBindingProvider((TypeMappingRegistry)new JaxbTypeRegistry()));
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("objectServiceFactory.portType", interfaceName);
        props.put("objectServiceFactory.style", "wrapped");
        props.put("objectServiceFactory.use", "literal");
        props.put("annotations.allow.interface", Boolean.TRUE);
        factory.getSoap11Transports().clear();
        factory.getSoap12Transports().clear();
        factory.getSoap11Transports().add("http://java.sun.com/xml/ns/jbi/binding/service+engine");
        Service service = factory.create(serviceDescriptor.getServiceInterface(), serviceDescriptor.getServiceName(), serviceDescriptor.getServiceNameSpace(), props);
        service.setInvoker((Invoker)new ProviderServiceInvoker(serviceDescriptor));
        service.setProperty("wsdlBuilder.generateImports", (Object)"true");
        AegisBindingProvider abp = (AegisBindingProvider)factory.getBindingProvider();
        TypeMapping typeMapping = abp.getTypeMapping(service);
        typeMapping.register((Type)new ByteType());
        return service;
    }

    public Service createServiceUtility(ProviderServiceDescriptor sd, XFire xfire, QName interfaceName) {
        AnnotationServiceFactory factory = new AnnotationServiceFactory((WebAnnotations)new Jsr181WebAnnotations(), xfire.getTransportManager(), (BindingProvider)new AegisBindingProvider((TypeMappingRegistry)new JaxbTypeRegistry()));
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("objectServiceFactory.portType", interfaceName);
        props.put("objectServiceFactory.style", "wrapped");
        props.put("objectServiceFactory.use", "literal");
        props.put("annotations.allow.interface", Boolean.TRUE);
        factory.getSoap11Transports().clear();
        factory.getSoap12Transports().clear();
        factory.getSoap11Transports().add("http://java.sun.com/xml/ns/jbi/binding/service+engine");
        Service service = factory.create(sd.getServiceInterface(), sd.getServiceName(), sd.getServiceNameSpace(), props);
        return service;
    }
}

