/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.webservice.runtime;

import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import it.imolinfo.jbi4corba.exception.ServiceActivationException;
import it.imolinfo.jbi4corba.exception.ServiceCreationException;
import it.imolinfo.jbi4corba.webservice.descriptor.ConsumerServiceDescriptor;
import it.imolinfo.jbi4corba.webservice.generator.ServerCorbaClassesHolder;
import it.imolinfo.jbi4corba.webservice.runtime.ConsumerInvocationHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.ORB;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.Servant;

public class ConsumerServiceCreator {
    private static final Logger LOG = LoggerFactory.getLogger(ConsumerServiceCreator.class);

    public void createJbiService(ConsumerServiceDescriptor consumerServiceDescriptor) throws ServiceCreationException {
        ServerCorbaClassesHolder serverCorbaClassesHolder = consumerServiceDescriptor.getServerCorbaClassesHolder();
        ConsumerInvocationHandler consumerInvocationHandler = new ConsumerInvocationHandler(consumerServiceDescriptor);
        consumerServiceDescriptor.setConsumerInvocationHandler(consumerInvocationHandler);
        Class corbaImplClass = serverCorbaClassesHolder.getCorbaImplClass();
        Constructor corbaImplConstructor = this.getConstructorWithConsumerInvocationHandler(corbaImplClass);
        java.lang.Object corbaImpl = this.newObject(corbaImplConstructor, new java.lang.Object[]{consumerInvocationHandler});
        LOG.debug("new corbaImpl=" + corbaImpl);
        org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init((String[])null, (Properties)consumerServiceDescriptor.getOrbProperties());
        LOG.debug("ORB.init ... ok");
        consumerServiceDescriptor.setOrb(orb);
        Constructor constructor = this.getDefaultConstructorFromPoaTie(serverCorbaClassesHolder.getCorbaPOATie());
        LOG.debug("getDefaultConstructorFromPoaTie ... ok");
        Servant poaTie = this.newPoaTie(constructor);
        LOG.debug("newPoaTie ... ok. Servant=" + poaTie);
        this.setOrbOnPoaTie(poaTie, serverCorbaClassesHolder.getCorbaPOATie(), orb);
        LOG.debug("setup ORB on the Servant ... done");
        this.setTargetOnPoaTie(poaTie, serverCorbaClassesHolder.getCorbaPOATie(), corbaImpl);
        LOG.debug("Registering the Corba Servant Implementation on the Servant(TIE)... done");
        consumerServiceDescriptor.setPoaTie(poaTie);
    }

    protected void setTargetOnPoaTie(Servant poaTie, Class poaTieClass, java.lang.Object poaDelegate) throws ServiceCreationException {
        Method setTargetMethod = null;
        try {
            setTargetMethod = poaTieClass.getMethod("setTarget", Remote.class);
        }
        catch (SecurityException e) {
            java.lang.Object[] args = new java.lang.Object[]{"setTarget(java.rmi.Remote)", poaTieClass, e.getMessage()};
            LOG.error("CRB000741_CreatingMethodError", args, e);
            throw new ServiceCreationException("CRB000741_CreatingMethodError", args, e);
        }
        catch (NoSuchMethodException e) {
            java.lang.Object[] args = new java.lang.Object[]{"setTarget(java.rmi.Remote)", poaTieClass, e.getMessage()};
            LOG.error("CRB000741_CreatingMethodError", args, e);
            throw new ServiceCreationException("CRB000741_CreatingMethodError", args, e);
        }
        try {
            setTargetMethod.invoke((java.lang.Object)poaTie, poaDelegate);
        }
        catch (IllegalArgumentException e) {
            java.lang.Object[] args = new java.lang.Object[]{"setTarget(java.rmi.Remote)", poaTie, e.getMessage()};
            LOG.error("CRB000742_InvokingMethodError", args, e);
            throw new ServiceCreationException("CRB000742_InvokingMethodError", args, e);
        }
        catch (IllegalAccessException e) {
            java.lang.Object[] args = new java.lang.Object[]{"setTarget(java.rmi.Remote)", poaTie, e.getMessage()};
            LOG.error("CRB000742_InvokingMethodError", args, e);
            throw new ServiceCreationException("CRB000742_InvokingMethodError", args, e);
        }
        catch (InvocationTargetException e) {
            java.lang.Object[] args = new java.lang.Object[]{"setTarget(java.rmi.Remote)", poaTie, e.getMessage()};
            LOG.error("CRB000742_InvokingMethodError", args, e);
            throw new ServiceCreationException("CRB000742_InvokingMethodError", args, e);
        }
    }

    protected void setOrbOnPoaTie(Servant poaTie, Class poaTieClass, org.omg.CORBA.ORB orb) throws ServiceCreationException {
        Method method = null;
        try {
            method = poaTieClass.getMethod("orb", org.omg.CORBA.ORB.class);
        }
        catch (SecurityException e) {
            java.lang.Object[] args = new java.lang.Object[]{"orb(org.omg.CORBA.ORB)", poaTieClass, e.getMessage()};
            LOG.error("CRB000741_CreatingMethodError", args, e);
            throw new ServiceCreationException("CRB000741_CreatingMethodError", args, e);
        }
        catch (NoSuchMethodException e) {
            java.lang.Object[] args = new java.lang.Object[]{"orb(org.omg.CORBA.ORB)", poaTieClass, e.getMessage()};
            LOG.error("CRB000741_CreatingMethodError", args, e);
            throw new ServiceCreationException("CRB000741_CreatingMethodError", args, e);
        }
        try {
            method.invoke((java.lang.Object)poaTie, orb);
        }
        catch (IllegalArgumentException e) {
            java.lang.Object[] args = new java.lang.Object[]{"orb(org.omg.CORBA.ORB)", poaTie, e.getMessage()};
            LOG.error("CRB000742_InvokingMethodError", args, e);
            throw new ServiceCreationException("CRB000742_InvokingMethodError", args, e);
        }
        catch (IllegalAccessException e) {
            java.lang.Object[] args = new java.lang.Object[]{"orb(org.omg.CORBA.ORB)", poaTie, e.getMessage()};
            LOG.error("CRB000742_InvokingMethodError", args, e);
            throw new ServiceCreationException("CRB000742_InvokingMethodError", args, e);
        }
        catch (InvocationTargetException e) {
            java.lang.Object[] args = new java.lang.Object[]{"orb(org.omg.CORBA.ORB)", poaTie, e.getMessage()};
            LOG.error("CRB000742_InvokingMethodError", args, e);
            throw new ServiceCreationException("CRB000742_InvokingMethodError", args, e);
        }
    }

    protected Constructor getDefaultConstructorFromPoaTie(Class poaTieClass) throws ServiceCreationException {
        Constructor constructor = null;
        java.lang.Object[] classes = new Class[]{};
        try {
            constructor = poaTieClass.getConstructor((Class<?>[])classes);
        }
        catch (SecurityException e) {
            java.lang.Object[] args = new java.lang.Object[]{poaTieClass, Arrays.toString(classes), e.getMessage()};
            LOG.error("CRB000723_Unable_to_create_constructor", args, e);
            throw new ServiceCreationException("CRB000723_Unable_to_create_constructor", args, e);
        }
        catch (NoSuchMethodException e) {
            java.lang.Object[] args = new java.lang.Object[]{poaTieClass, Arrays.toString(classes), e.getMessage()};
            LOG.error("CRB000723_Unable_to_create_constructor", args, e);
            throw new ServiceCreationException("CRB000723_Unable_to_create_constructor", args, e);
        }
        return constructor;
    }

    protected Constructor getConstructorWithConsumerInvocationHandler(Class clazz) throws ServiceCreationException {
        Constructor constructor = null;
        java.lang.Object[] classes = new Class[]{ConsumerInvocationHandler.class};
        try {
            constructor = clazz.getConstructor((Class<?>[])classes);
        }
        catch (SecurityException e) {
            java.lang.Object[] args = new java.lang.Object[]{clazz, Arrays.toString(classes), e.getMessage()};
            LOG.error("CRB000723_Unable_to_create_constructor", args, e);
            throw new ServiceCreationException("CRB000723_Unable_to_create_constructor", args, e);
        }
        catch (NoSuchMethodException e) {
            java.lang.Object[] args = new java.lang.Object[]{clazz, Arrays.toString(classes), e.getMessage()};
            LOG.error("CRB000723_Unable_to_create_constructor", args, e);
            throw new ServiceCreationException("CRB000723_Unable_to_create_constructor", args, e);
        }
        return constructor;
    }

    protected Servant newPoaTie(Constructor constructor) throws ServiceCreationException {
        Servant poaTie = null;
        try {
            poaTie = (Servant)constructor.newInstance(new java.lang.Object[0]);
        }
        catch (IllegalArgumentException e) {
            java.lang.Object[] args = new java.lang.Object[]{constructor, "default constructor", e.getMessage()};
            LOG.error("CRB000724_Unable_to_instatiate_object", args, e);
            throw new ServiceCreationException("CRB000724_Unable_to_instatiate_object", args, e);
        }
        catch (InstantiationException e) {
            java.lang.Object[] args = new java.lang.Object[]{constructor, "default constructor", e.getMessage()};
            LOG.error("CRB000724_Unable_to_instatiate_object", args, e);
            throw new ServiceCreationException("CRB000724_Unable_to_instatiate_object", args, e);
        }
        catch (IllegalAccessException e) {
            java.lang.Object[] args = new java.lang.Object[]{constructor, "default constructor", e.getMessage()};
            LOG.error("CRB000724_Unable_to_instatiate_object", args, e);
            throw new ServiceCreationException("CRB000724_Unable_to_instatiate_object", args, e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            java.lang.Object[] args = new java.lang.Object[]{constructor, "default constructor", cause.getMessage()};
            LOG.error("CRB000725_Exception_calling_constructor", args, cause);
            throw new ServiceCreationException("CRB000725_Exception_calling_constructor", args, cause);
        }
        return poaTie;
    }

    protected java.lang.Object newObject(Constructor constructor, java.lang.Object[] parameter) throws ServiceCreationException {
        java.lang.Object newObject = null;
        try {
            newObject = constructor.newInstance(parameter);
        }
        catch (IllegalArgumentException e) {
            java.lang.Object[] args = new java.lang.Object[]{constructor, "constructor", e.getMessage()};
            LOG.error("CRB000724_Unable_to_instatiate_object", args, e);
            throw new ServiceCreationException("CRB000724_Unable_to_instatiate_object", args, e);
        }
        catch (InstantiationException e) {
            java.lang.Object[] args = new java.lang.Object[]{constructor, "constructor", e.getMessage()};
            LOG.error("CRB000724_Unable_to_instatiate_object", args, e);
            throw new ServiceCreationException("CRB000724_Unable_to_instatiate_object", args, e);
        }
        catch (IllegalAccessException e) {
            java.lang.Object[] args = new java.lang.Object[]{constructor, "constructor", e.getMessage()};
            LOG.error("CRB000724_Unable_to_instatiate_object", args, e);
            throw new ServiceCreationException("CRB000724_Unable_to_instatiate_object", args, e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            java.lang.Object[] args = new java.lang.Object[]{constructor, "default constructor", cause.getMessage()};
            LOG.error("CRB000725_Exception_calling_constructor", args, cause);
            throw new ServiceCreationException("CRB000725_Exception_calling_constructor", args, cause);
        }
        return newObject;
    }

    public void createJbiServicePRE(ConsumerServiceDescriptor consumerServiceDescriptor) throws ServiceCreationException {
        Servant poaTie;
        Constructor constructor;
        POA rootPoa;
        ServerCorbaClassesHolder serverCorbaClassesHolder = consumerServiceDescriptor.getServerCorbaClassesHolder();
        ConsumerInvocationHandler consumerInvocationHandler = new ConsumerInvocationHandler(consumerServiceDescriptor);
        consumerServiceDescriptor.setConsumerInvocationHandler(consumerInvocationHandler);
        LOG.debug("Trying to create the poaDelegate");
        java.lang.Object poaDelegate = Proxy.newProxyInstance(serverCorbaClassesHolder.getCorbaPOATie().getClassLoader(), new Class[]{serverCorbaClassesHolder.getCorbaOperations()}, (InvocationHandler)consumerInvocationHandler);
        org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init((String[])null, (Properties)consumerServiceDescriptor.getOrbProperties());
        consumerServiceDescriptor.setOrb(orb);
        try {
            rootPoa = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName e) {
            java.lang.Object[] args = new java.lang.Object[]{orb, e.getMessage()};
            LOG.error("CRB000722_Unable_to_instantiate_resolve_RootPOA", args, e);
            throw new ServiceCreationException("CRB000722_Unable_to_instantiate_resolve_RootPOA", args, e);
        }
        Map<String, java.lang.Object> map = consumerServiceDescriptor.getServerCorbaClassesHolder().getValueTypeIdAndInstance();
        if (map == null || map.size() == 0) {
            LOG.info("CRB000130_No_value_type_factory_to_register_using_the_ORB");
        } else {
            LOG.debug("ValueTypeFactoryMap.size=" + map.size());
            for (String id : map.keySet()) {
                ValueFactory vf = (ValueFactory)map.get(id);
                LOG.debug("Registering a ValueType Factory. id=" + id + "; instance=" + vf);
                ((ORB)orb).register_value_factory(id, vf);
            }
        }
        java.lang.Object[] classes = new Class[]{serverCorbaClassesHolder.getCorbaOperations(), POA.class};
        try {
            Class clazz = serverCorbaClassesHolder.getCorbaPOATie();
            constructor = clazz.getConstructor((Class<?>[])classes);
        }
        catch (SecurityException e) {
            java.lang.Object[] args = new java.lang.Object[]{serverCorbaClassesHolder.getCorbaPOATie(), Arrays.toString(classes), e.getMessage()};
            LOG.error("CRB000723_Unable_to_create_constructor", args, e);
            throw new ServiceCreationException("CRB000723_Unable_to_create_constructor", args, e);
        }
        catch (NoSuchMethodException e) {
            java.lang.Object[] args = new java.lang.Object[]{serverCorbaClassesHolder.getCorbaPOATie(), Arrays.toString(classes), e.getMessage()};
            LOG.error("CRB000723_Unable_to_create_constructor", args, e);
            throw new ServiceCreationException("CRB000723_Unable_to_create_constructor", args, e);
        }
        java.lang.Object[] arguments = new java.lang.Object[]{poaDelegate, rootPoa};
        try {
            poaTie = (Servant)constructor.newInstance(arguments);
        }
        catch (IllegalArgumentException e) {
            java.lang.Object[] args = new java.lang.Object[]{constructor, Arrays.toString(arguments), e.getMessage()};
            LOG.error("CRB000724_Unable_to_instatiate_object", args, e);
            throw new ServiceCreationException("CRB000724_Unable_to_instatiate_object", args, e);
        }
        catch (InstantiationException e) {
            java.lang.Object[] args = new java.lang.Object[]{constructor, Arrays.toString(arguments), e.getMessage()};
            LOG.error("CRB000724_Unable_to_instatiate_object", args, e);
            throw new ServiceCreationException("CRB000724_Unable_to_instatiate_object", args, e);
        }
        catch (IllegalAccessException e) {
            java.lang.Object[] args = new java.lang.Object[]{constructor, Arrays.toString(arguments), e.getMessage()};
            LOG.error("CRB000724_Unable_to_instatiate_object", args, e);
            throw new ServiceCreationException("CRB000724_Unable_to_instatiate_object", args, e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            java.lang.Object[] args = new java.lang.Object[]{constructor, Arrays.toString(arguments), cause.getMessage()};
            LOG.error("CRB000725_Exception_calling_constructor", args, cause);
            throw new ServiceCreationException("CRB000725_Exception_calling_constructor", args, cause);
        }
        consumerServiceDescriptor.setPoaTie(poaTie);
    }

    public void registerAndActivateService(ConsumerServiceDescriptor consumerServiceDescriptor) throws ServiceActivationException {
        NameComponent[] path;
        Object objRef;
        Servant poaTie = consumerServiceDescriptor.getPoaTie();
        POA rootPoa = poaTie._default_POA();
        org.omg.CORBA.ORB orb = consumerServiceDescriptor.getOrb();
        LOG.debug("Trying to activate POA");
        try {
            rootPoa.the_POAManager().activate();
        }
        catch (AdapterInactive e) {
            java.lang.Object[] args = new java.lang.Object[]{rootPoa, e.getMessage()};
            LOG.error("CRB000726_Unable_to_activate_RootPOA", args, e);
            throw new ServiceActivationException("CRB000726_Unable_to_activate_RootPOA", args, e);
        }
        Object servantRef = poaTie._this_object(orb);
        try {
            LOG.debug("Trying to resolve the NameService");
            objRef = orb.resolve_initial_references("NameService");
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName e) {
            java.lang.Object[] args = new java.lang.Object[]{orb, e.getMessage()};
            LOG.error("CRB000727_Unable_to_resolve_inital_reference", args, e);
            throw new ServiceActivationException("CRB000727_Unable_to_resolve_inital_reference", args, e);
        }
        NamingContextExt ncRef = NamingContextExtHelper.narrow((Object)objRef);
        String name = consumerServiceDescriptor.getCorbaServiceName();
        LOG.debug("Trying to registering the service with name: " + name);
        if (name == null || "".equals(name)) {
            LOG.error("CRB000728_Trying_to_register_service", name);
            throw new ServiceActivationException("CRB000728_Trying_to_register_service", new java.lang.Object[]{name}, null);
        }
        try {
            path = ncRef.to_name(name);
        }
        catch (InvalidName e) {
            java.lang.Object[] args = new java.lang.Object[]{name, ncRef, e.getMessage()};
            LOG.error("CRB000729_Invalid_name", args, e);
            throw new ServiceActivationException("CRB000729_Invalid_name", args, e);
        }
        try {
            LOG.debug("Trying to rebind the servant");
            ncRef.rebind(path, servantRef);
        }
        catch (NotFound e) {
            java.lang.Object[] args = new java.lang.Object[]{servantRef, path, ncRef, e.getMessage()};
            LOG.error("CRB000730_Not_found_registering_servant", args, e);
            throw new ServiceActivationException("CRB000730_Not_found_registering_servant", args, e);
        }
        catch (CannotProceed e) {
            java.lang.Object[] args = new java.lang.Object[]{servantRef, path, ncRef, e.getMessage()};
            LOG.error("CRB000731_Cannot_proceed_registering_servant", args, e);
            throw new ServiceActivationException("CRB000731_Cannot_proceed_registering_servant", args, e);
        }
        catch (InvalidName e) {
            java.lang.Object[] args = new java.lang.Object[]{servantRef, path, ncRef, e.getMessage()};
            LOG.error("CRB000732_Invalid_name_registering_servant", args, e);
            throw new ServiceActivationException("CRB000732_Invalid_name_registering_servant", args, e);
        }
    }
}

