/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.webservice.generator.bcm;

import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import it.imolinfo.jbi4corba.webservice.generator.MethodSignature;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceAnnotationAdapter
extends ClassAdapter {
    public static final String JSR181_WEB_SERVICE = "Ljavax/jws/WebService;";
    public static final String JSR181_WEB_METHOD = "Ljavax/jws/WebMethod;";
    public static final String JSR181_WEB_PARAM = "Ljavax/jws/WebParam;";
    public static final String JSR181_WEB_RESULT = "Ljavax/jws/WebResult;";
    public static final String JSR181_SOAP_BINDING = "Ljavax/jws/soap/SOAPBinding;";
    public static final String JSR181_SOAP_BINDING_USE = "Ljavax/jws/soap/SOAPBinding$Use;";
    public static final String JSR181_SOAP_BINDING_STYLE = "Ljavax/jws/soap/SOAPBinding$ParameterStyle;";
    public static final String JSR181_LITERAL = "LITERAL";
    public static final String JSR181_WRAPPED = "WRAPPED";
    public static final String JSR181_ONEWAY = "Ljavax/jws/Oneway;";
    protected static Set<String> noAnnotatedMethods = new HashSet<String>();
    private static final Logger LOG;
    protected ClassWriter classWriter = null;
    protected List<MethodSignature> methodSignatureList = null;

    public WebServiceAnnotationAdapter(ClassVisitor cv, ClassWriter cw, List<MethodSignature> aMethodSignatureList) {
        super(cv);
        this.classWriter = cw;
        this.methodSignatureList = aMethodSignatureList;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        LOG.debug("WebServiceAnnotationAdapter.visit. access=" + access + "; name=" + name + "; access=" + access + "; signature=" + signature + "; superName=" + superName);
        super.visit(version, access, name, signature, superName, interfaces);
        AnnotationVisitor avClass = this.classWriter.visitAnnotation(JSR181_WEB_SERVICE, true);
        String javaSimpleName = name.substring(name.lastIndexOf("/") + 1);
        avClass.visit("name", (Object)javaSimpleName);
        avClass.visitEnd();
        avClass = this.classWriter.visitAnnotation(JSR181_SOAP_BINDING, true);
        avClass.visitEnum("use", JSR181_SOAP_BINDING_USE, JSR181_LITERAL);
        avClass.visitEnum("parameterStyle", JSR181_SOAP_BINDING_STYLE, JSR181_WRAPPED);
        avClass.visitEnd();
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        LOG.debug("WebServiceAnnotationAdapter.visitMethod. access=" + access + "; name=" + name + "; desc=" + desc + "; signature=" + signature + "; exceptions=" + exceptions);
        if (noAnnotatedMethods.contains(name)) {
            LOG.debug("NO WebService Annotations [methodName=" + name + "]");
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        LOG.debug("WebService Annotations for [methodName=" + name + "]");
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        MethodSignature sig = this.findFirstMethodSignature(name);
        this.addMethodSignatureAnnotation(mv, sig);
        return mv;
    }

    protected void addMethodSignatureAnnotation(MethodVisitor methodVisitor, MethodSignature sig) {
        this.addAnnotationOperationName(methodVisitor, sig.getMethodName());
        if (sig.isOneway()) {
            LOG.debug("The method " + sig.getMethodName() + " is marked 'oneway'.");
            AnnotationVisitor avOneway = methodVisitor.visitAnnotation(JSR181_ONEWAY, true);
            avOneway.visitEnd();
        }
        this.addAnnotationReturnName(methodVisitor, sig.getReturnName());
        this.addParameterAnnotation(methodVisitor, sig);
    }

    protected void addParameterAnnotation(MethodVisitor methodVisitor, MethodSignature sig) {
        if (methodVisitor == null) {
            LOG.debug("The method visitor is null. add no annotation");
            return;
        }
        if (sig == null) {
            LOG.debug("The method's signature is null. add no annotation");
            return;
        }
        if (sig.getParamentersName() == null || sig.getParamentersName().size() == 0) {
            LOG.debug("The list of parameter name is null or empty.add no annotation");
            return;
        }
        for (int pos = 0; pos < sig.getParamentersName().size(); ++pos) {
            String param = sig.getParamentersName().get(pos);
            AnnotationVisitor av = methodVisitor.visitParameterAnnotation(pos, JSR181_WEB_PARAM, true);
            av.visit("name", (Object)param);
            av.visitEnd();
            LOG.debug("WebParam annotation for [parameterName=" + param + "; parameterPosition=" + pos + "]");
        }
    }

    protected void addAnnotationReturnName(MethodVisitor methodVisitor, String returnName) {
        if (methodVisitor == null) {
            LOG.debug("The method visitor is null. add no annotation");
            return;
        }
        if (returnName == null || "".equals(returnName)) {
            LOG.debug("The return name is null or empty. add no annotation");
            return;
        }
        AnnotationVisitor av = methodVisitor.visitAnnotation(JSR181_WEB_RESULT, true);
        av.visit("name", (Object)returnName);
        av.visitEnd();
    }

    protected void addAnnotationOperationName(MethodVisitor methodVisitor, String operationName) {
        if (methodVisitor == null) {
            LOG.debug("The method visitor is null. add no annotation");
            return;
        }
        if (operationName == null || "".equals(operationName)) {
            LOG.debug("The operation name is null or empty. add no annotation");
            return;
        }
        AnnotationVisitor av = methodVisitor.visitAnnotation(JSR181_WEB_METHOD, true);
        av.visit("operationName", (Object)operationName);
        av.visitEnd();
    }

    protected MethodSignature findFirstMethodSignature(String methodName) {
        if (this.methodSignatureList == null) {
            LOG.debug("Method's signature not found:The list of the MethodSignature is null.");
            return null;
        }
        if (methodName == null) {
            LOG.debug("Method's signature not found:The method name is null.");
            return null;
        }
        for (MethodSignature sig : this.methodSignatureList) {
            if (!methodName.equals(sig.getMethodName())) continue;
            LOG.debug("MethodSignature FOUND. MethodName=" + methodName + "; MethodSignature=" + sig);
            return sig;
        }
        LOG.debug("Method's signature not found for the method " + methodName);
        return null;
    }

    static {
        noAnnotatedMethods.add("<init>");
        noAnnotatedMethods.add("hashCode");
        noAnnotatedMethods.add("getClass");
        noAnnotatedMethods.add("wait");
        noAnnotatedMethods.add("equals");
        noAnnotatedMethods.add("notify");
        noAnnotatedMethods.add("notifyAll");
        noAnnotatedMethods.add("toString");
        LOG = LoggerFactory.getLogger(WebServiceAnnotationAdapter.class);
    }
}

