/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.typemapping.cobol;

import it.imolinfo.jbi4cics.Logger;
import it.imolinfo.jbi4cics.LoggerFactory;
import it.imolinfo.jbi4cics.exception.FormatException;
import it.imolinfo.jbi4cics.typemapping.cobol.CobolFieldFormatter;
import it.imolinfo.jbi4cics.typemapping.cobol.CobolTypeDescriptor;
import it.imolinfo.jbi4cics.typemapping.cobol.IntegerMarshaller;
import it.imolinfo.jbi4cics.typemapping.cobol.PackedDecimalMarshaller;
import it.imolinfo.jbi4cics.typemapping.cobol.StringMarshaller;
import it.imolinfo.jbi4cics.typemapping.cobol.ZonedMarshaller;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CobolType {
    STRING{

        Class getPreferredJavaType(CobolTypeDescriptor desc) {
            return String.class;
        }

        int getBufferedLength(CobolTypeDescriptor desc) throws FormatException {
            return desc.getStringLength();
        }

        void format(Object value, byte[] buffer, CobolTypeDescriptor desc, int startingOffset) throws FormatException {
            if (value == null) {
                value = "";
            } else if (!(value instanceof String)) {
                LOG.error("CIC002104_String_not_found", value.getClass());
                throw new FormatException("CIC002104_String_not_found", new Object[]{value.getClass()});
            }
            StringMarshaller.marshallStringIntoBuffer((String)value, buffer, startingOffset, desc.getCodePage(), desc.getBufferedLength(), desc.getJustification(), desc.getPadCharacter());
        }

        Object unformat(byte[] buffer, CobolTypeDescriptor desc, int startingOffset) throws FormatException {
            return StringMarshaller.unmarshallString(buffer, startingOffset, desc.getCodePage(), desc.getBufferedLength()).trim();
        }
    }
    ,
    INTEGER{

        Class getPreferredJavaType(CobolTypeDescriptor desc) {
            return BigInteger.class;
        }

        int getBufferedLength(CobolTypeDescriptor desc) throws FormatException {
            int length = desc.getIntegerPartLength();
            if (length < 0 || length >= BUFFERED_LENGTH.length) {
                LOG.error("CIC002109_Integer_too_much_long", length);
                throw new FormatException("CIC002109_Integer_too_much_long", new Object[]{length});
            }
            return BUFFERED_LENGTH[length];
        }

        void format(Object value, byte[] buffer, CobolTypeDescriptor desc, int startingOffset) throws FormatException {
            if (value == null) {
                value = BigInteger.ZERO;
            }
            CobolFieldFormatter.formatInteger(value, buffer, desc, startingOffset);
        }

        Object unformat(byte[] buffer, CobolTypeDescriptor desc, int startingOffset) throws FormatException {
            return IntegerMarshaller.unmarshallInteger(buffer, startingOffset, desc.getBufferedLength(), desc.isBigEndian());
        }
    }
    ,
    PACKED_DECIMAL{

        Class getPreferredJavaType(CobolTypeDescriptor desc) {
            return BigDecimal.class;
        }

        int getBufferedLength(CobolTypeDescriptor desc) throws FormatException {
            return Math.round((float)(desc.getIntegerPartLength() + desc.getDecimalPartLength() + 1) / 2.0f);
        }

        void format(Object value, byte[] buffer, CobolTypeDescriptor desc, int startingOffset) throws FormatException {
            if (value == null) {
                value = BigDecimal.ZERO;
            }
            CobolFieldFormatter.formatPackedDecimal(value, buffer, desc, startingOffset);
        }

        Object unformat(byte[] buffer, CobolTypeDescriptor desc, int startingOffset) throws FormatException {
            return PackedDecimalMarshaller.unmarshallBigDecimal(buffer, desc, startingOffset);
        }
    }
    ,
    ZONED{

        Class getPreferredJavaType(CobolTypeDescriptor desc) {
            return BigDecimal.class;
        }

        int getBufferedLength(CobolTypeDescriptor desc) throws FormatException {
            int length = desc.getIntegerPartLength() + desc.getDecimalPartLength();
            if (desc.getZonedSignFormat() == 2) {
                ++length;
            }
            return length;
        }

        void format(Object value, byte[] buffer, CobolTypeDescriptor desc, int startingOffset) throws FormatException {
            if (value == null) {
                value = BigDecimal.ZERO;
            }
            CobolFieldFormatter.formatZoned(value, buffer, desc, startingOffset);
        }

        Object unformat(byte[] buffer, CobolTypeDescriptor desc, int startingOffset) throws FormatException {
            return ZonedMarshaller.unmarshallZoned(buffer, startingOffset, desc.getBufferedLength(), desc.isSigned(), desc.getVirtualDecimalPoint(), desc.getZonedSignFormat(), desc.getCodePage());
        }
    }
    ,
    NESTED_COMMAREA{

        Class getPreferredJavaType(CobolTypeDescriptor desc) {
            return desc.getNestedCommarea().getBeanClass();
        }

        int getBufferedLength(CobolTypeDescriptor desc) throws FormatException {
            return desc.getNestedCommarea().getBufferedLength();
        }

        void format(Object value, byte[] buffer, CobolTypeDescriptor desc, int startingOffset) throws FormatException {
            if (value == null) {
                throw new FormatException("CIC002100_Null_nested_commarea");
            }
            CobolFieldFormatter.formatNestedCommarea(value, buffer, desc, startingOffset);
        }

        Object unformat(byte[] buffer, CobolTypeDescriptor desc, int startingOffset) throws FormatException {
            return CobolFieldFormatter.unformatNestedCommarea(buffer, desc, startingOffset);
        }
    }
    ,
    OCCURS{

        Class getPreferredJavaType(CobolTypeDescriptor desc) {
            Class beanClass = desc.getNestedCommarea().getBeanClass();
            return Array.newInstance(beanClass, 0).getClass();
        }

        int getBufferedLength(CobolTypeDescriptor desc) throws FormatException {
            return desc.getNestedCommarea().getBufferedLength() * desc.getOccursSize();
        }

        void format(Object value, byte[] buffer, CobolTypeDescriptor desc, int startingOffset) throws FormatException {
            if (value == null) {
                throw new FormatException("CIC002101_Null_occurs_value");
            }
            CobolFieldFormatter.formatOccurs(value, buffer, desc, startingOffset);
        }

        Object unformat(byte[] buffer, CobolTypeDescriptor desc, int startingOffset) throws FormatException {
            return CobolFieldFormatter.unformatOccurs(buffer, desc, startingOffset);
        }
    };

    private static final int[] BUFFERED_LENGTH;
    private static final Logger LOG;

    abstract Class getPreferredJavaType(CobolTypeDescriptor var1);

    abstract int getBufferedLength(CobolTypeDescriptor var1) throws FormatException;

    abstract void format(Object var1, byte[] var2, CobolTypeDescriptor var3, int var4) throws FormatException;

    abstract Object unformat(byte[] var1, CobolTypeDescriptor var2, int var3) throws FormatException;

    static {
        BUFFERED_LENGTH = new int[]{1, 1, 1, 2, 2, 4, 4, 4, 4, 4, 8, 8, 8, 8, 8, 8, 8, 8, 8, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
        LOG = LoggerFactory.getLogger(CobolType.class);
    }
}

