/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.locator;

import it.imolinfo.jbi4cics.exception.LocationException;
import it.imolinfo.jbi4cics.jbi.Messages;
import it.imolinfo.jbi4cics.locator.ServiceLocation;

public class SimpleLocation
implements ServiceLocation {
    public static final String DUMMY_TYPE = "DUMMY";
    public static final String CICS_TYPE = "CICS";
    public static final String IMS_TYPE = "IMS";
    public static final String JDBC_TYPE = "JDBC";
    String locationName;
    int connectionType;
    private static final Messages MESSAGES = Messages.getMessages(SimpleLocation.class);

    public String getLocationName() {
        return this.locationName;
    }

    public void setLocationName(String locationName) {
        this.locationName = locationName;
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(int connectionType) {
        this.connectionType = connectionType;
    }

    public String getConnectionTypeName() throws LocationException {
        switch (this.getConnectionType()) {
            case -1: {
                return DUMMY_TYPE;
            }
            case 0: {
                return CICS_TYPE;
            }
            case 1: {
                return IMS_TYPE;
            }
            case 2: {
                return JDBC_TYPE;
            }
        }
        throw new LocationException(MESSAGES.getString("CIC001500_Unknown_type", this.getConnectionType()));
    }

    public void setConnectionTypeName(String connectionTypeName) throws LocationException {
        if (DUMMY_TYPE.equals(connectionTypeName)) {
            this.setConnectionType(-1);
            return;
        }
        if (CICS_TYPE.equals(connectionTypeName)) {
            this.setConnectionType(0);
            return;
        }
        if (IMS_TYPE.equals(connectionTypeName)) {
            this.setConnectionType(1);
            return;
        }
        if (JDBC_TYPE.equals(connectionTypeName)) {
            this.setConnectionType(2);
            return;
        }
        throw new LocationException(MESSAGES.getString("CIC001501_Invalid_type", connectionTypeName));
    }
}

