/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.jbi;

import it.imolinfo.jbi4cics.Logger;
import it.imolinfo.jbi4cics.LoggerFactory;
import it.imolinfo.jbi4cics.connection.jca.cics.CICSInteractionDescription;
import it.imolinfo.jbi4cics.exception.LocationException;
import it.imolinfo.jbi4cics.jbi.Jbi4cicsEndpoint;
import it.imolinfo.jbi4cics.jbi.Messages;
import it.imolinfo.jbi4cics.jbi.wsdl.Jbi4CicsAddress;
import it.imolinfo.jbi4cics.jbi.wsdl.Jbi4CicsBinding;
import it.imolinfo.jbi4cics.jbi.wsdl.Jbi4CicsExtension;
import it.imolinfo.jbi4cics.locator.SimpleLocation;
import it.imolinfo.jbi4cics.security.J2CAccount;
import it.imolinfo.jbi4cics.webservices.descriptor.ServiceDescriptor;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jbi.management.DeploymentException;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.servicemix.common.AbstractDeployer;
import org.apache.servicemix.common.BaseComponent;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Jbi4cicsWSDLDeployer
extends AbstractDeployer {
    private static final String IO_BEAN_NAME = "InputOutputBean";
    private static final String INPUT_BEAN_NAME = "InputBean";
    private static final String OUTPUT_BEAN_NAME = "OutputBean";
    private static final String TASK = "deploy";
    private static final Logger LOG = LoggerFactory.getLogger(Jbi4cicsWSDLDeployer.class);
    private static final Messages MESSAGES = Messages.getMessages(Jbi4cicsWSDLDeployer.class);
    private static final FilenameFilter DEPLOYABLE_FILTER = new WsdlFilter();

    public Jbi4cicsWSDLDeployer(BaseComponent component) {
        super((ServiceMixComponent)component);
    }

    public boolean canDeploy(String suName, String suRootPath) {
        File[] wsdls = this.getWSDL(suRootPath);
        if (wsdls.length == 0) {
            LOG.info("CIC001032_No_WSDLs_file_found", suRootPath, suName);
            return false;
        }
        return true;
    }

    public ServiceUnit deploy(String suName, String suRootPath) throws DeploymentException {
        File[] wsdls = this.getWSDL(suRootPath);
        ArrayList<Jbi4cicsEndpoint> endpoints = new ArrayList<Jbi4cicsEndpoint>();
        if (wsdls.length == 0) {
            throw this.failure(TASK, MESSAGES.getString("CIC001033_No_valid_wsdl_found", new Object[0]), null);
        }
        ServiceUnit serviceUnit = new ServiceUnit();
        serviceUnit.setComponent(this.component);
        serviceUnit.setName(suName);
        serviceUnit.setRootPath(suRootPath);
        for (File wsdl : wsdls) {
            endpoints.addAll(this.getEndpointFromWsdl(wsdl));
        }
        if (endpoints.isEmpty()) {
            throw this.failure(TASK, MESSAGES.getString("CIC001034_Invalid_wsdl_no_valid_endpoints_found", new Object[0]), null);
        }
        for (Jbi4cicsEndpoint endpoint : endpoints) {
            endpoint.setServiceUnit(serviceUnit);
            try {
                endpoint.registerService();
            }
            catch (Exception e) {
                LOG.error("CIC001035_Could_not_register_endpoint", e);
                throw this.failure(TASK, MESSAGES.getString("CIC001035_Could_not_register_endpoint", new Object[0]), e);
            }
            serviceUnit.addEndpoint((Endpoint)endpoint);
        }
        return serviceUnit;
    }

    protected void validate(Endpoint endpoint) throws DeploymentException {
    }

    private WSDLReader createJbi4CicsWsdlReader() throws WSDLException {
        WSDLFactory factory = WSDLFactory.newInstance();
        ExtensionRegistry registry = factory.newPopulatedExtensionRegistry();
        WSDLReader reader = factory.newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setFeature("javax.wsdl.importDocuments", true);
        Jbi4CicsExtension.register(registry);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extension QName: " + Jbi4CicsExtension.Q_ELEM_JBI4CICS_BINDING);
        }
        reader.setExtensionRegistry(registry);
        return reader;
    }

    public List<Jbi4cicsEndpoint> getEndpointFromWsdl(File wsdl) throws DeploymentException {
        Definition definition;
        Document document = this.readXMLFile(wsdl);
        try {
            definition = this.createJbi4CicsWsdlReader().readWSDL(null, document);
        }
        catch (WSDLException e) {
            throw this.createParseFailure(wsdl, (Exception)((Object)e));
        }
        if (definition.getServices().isEmpty()) {
            throw this.failure(TASK, MESSAGES.getString("CIC001037_Invalid_wsdl_no_defined_services", wsdl), null);
        }
        List<Jbi4cicsEndpoint> endpoints = this.getJbi4CicsEndpoints(definition, document);
        if (endpoints.isEmpty()) {
            LOG.warn("CIC001038_No_EstensibilityElement_found_from_WSDL_file", wsdl);
        }
        return endpoints;
    }

    private Document readXMLFile(File file) throws DeploymentException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            return factory.newDocumentBuilder().parse(file);
        }
        catch (IOException e) {
            throw this.createParseFailure(file, e);
        }
        catch (ParserConfigurationException e) {
            throw this.createParseFailure(file, e);
        }
        catch (SAXException e) {
            throw this.createParseFailure(file, e);
        }
    }

    private DeploymentException createParseFailure(File file, Exception cause) {
        String errorMsgKey = "CIC001036_Could_not_parse";
        String errorMsg = MESSAGES.getString(errorMsgKey, file);
        LOG.error(errorMsgKey, new Object[]{file}, cause);
        return this.failure(TASK, errorMsg, cause);
    }

    private List<Jbi4cicsEndpoint> getJbi4CicsEndpoints(Definition definition, Document document) throws DeploymentException {
        ArrayList<Jbi4cicsEndpoint> endpoints = new ArrayList<Jbi4cicsEndpoint>();
        for (Object i : definition.getServices().values()) {
            Service svc = (Service)i;
            for (Object j : svc.getPorts().values()) {
                Port port = (Port)j;
                for (Object k : port.getExtensibilityElements()) {
                    if (!(k instanceof Jbi4CicsAddress)) continue;
                    Jbi4CicsAddress cicsAddress = (Jbi4CicsAddress)k;
                    Binding binding = port.getBinding();
                    for (Object l : binding.getExtensibilityElements()) {
                        if (!(l instanceof Jbi4CicsBinding)) continue;
                        Jbi4cicsEndpoint endpoint = this.createServiceDescriptor(svc, port, binding, cicsAddress, (Jbi4CicsBinding)l);
                        endpoint.setDescription(document);
                        endpoint.setDefinition(definition);
                        endpoints.add(endpoint);
                    }
                }
            }
        }
        return endpoints;
    }

    protected Jbi4cicsEndpoint createServiceDescriptor(Service service, Port port, Binding binding, Jbi4CicsAddress addressExtension, Jbi4CicsBinding bindingExtension) throws DeploymentException {
        ServiceDescriptor serviceDescriptor = new ServiceDescriptor();
        Jbi4cicsEndpoint endpoint = new Jbi4cicsEndpoint();
        List bindingOperations = binding.getBindingOperations();
        CICSInteractionDescription cicsDescription = new CICSInteractionDescription();
        J2CAccount account = new J2CAccount();
        SimpleLocation location = new SimpleLocation();
        Boolean sameCopyCobol = bindingExtension.getSameCopyCobol();
        endpoint.setCopyCobol(bindingExtension.getCopyCobol());
        endpoint.setCodePage(bindingExtension.getCodePage());
        serviceDescriptor.setServiceName(service.getQName().getLocalPart());
        serviceDescriptor.setServiceNameSpace(service.getQName().getNamespaceURI());
        if (bindingOperations.size() != 1) {
            throw new DeploymentException(MESSAGES.getString("CIC001039_More_than_one_operation_find_in_extension_binding", new Object[0]));
        }
        serviceDescriptor.setOperationName(((BindingOperation)bindingOperations.get(0)).getName());
        serviceDescriptor.setServiceInterfacePackageName(bindingExtension.getServicePackageName());
        serviceDescriptor.setServiceInterfaceName(binding.getPortType().getQName().getLocalPart());
        if (sameCopyCobol == null || Boolean.FALSE.equals(sameCopyCobol)) {
            serviceDescriptor.setInputBeanClassName(IO_BEAN_NAME);
            serviceDescriptor.setOutputBeanClassName(IO_BEAN_NAME);
        } else {
            serviceDescriptor.setInputBeanClassName(INPUT_BEAN_NAME);
            serviceDescriptor.setOutputBeanClassName(OUTPUT_BEAN_NAME);
        }
        account.setUsername(addressExtension.getUsername());
        account.setPassword(addressExtension.getPassword());
        serviceDescriptor.setAccount(account);
        try {
            location.setConnectionTypeName(addressExtension.getConnectionType());
        }
        catch (LocationException e) {
            String msg = e.getLocalizedMessage();
            LOG.error("CIC001040_Error_loading_location_type", new Object[]{msg}, e);
            throw new DeploymentException(MESSAGES.getString("CIC001040_Error_loading_location_type", msg), (Throwable)e);
        }
        location.setLocationName(addressExtension.getJNDIConnectionName());
        serviceDescriptor.setServiceLocation(location);
        cicsDescription.setProgramName(addressExtension.getProgramName());
        cicsDescription.setTpn(addressExtension.getTpn());
        cicsDescription.setTransactionName(addressExtension.getTransactionName());
        serviceDescriptor.setInteractionDescription(cicsDescription);
        endpoint.setServiceDescriptor(serviceDescriptor);
        return endpoint;
    }

    private File[] getWSDL(String suRootPath) {
        File suRoot = new File(suRootPath);
        File[] firstLevelWsdls = suRoot.listFiles(DEPLOYABLE_FILTER);
        File[] firstLevelDirs = suRoot.listFiles(DirectoryFilter.THE_INSTANCE);
        ArrayList<File> files = new ArrayList<File>();
        boolean debug = LOG.isDebugEnabled();
        files.addAll(Arrays.asList(firstLevelWsdls));
        for (File dir : firstLevelDirs) {
            File[] secondLevelWsdls = dir.listFiles(DEPLOYABLE_FILTER);
            if (debug) {
                LOG.debug("Found directory: " + dir.getName());
            }
            files.addAll(Arrays.asList(secondLevelWsdls));
        }
        return files.toArray(new File[files.size()]);
    }

    private static final class DirectoryFilter
    implements FileFilter {
        static final DirectoryFilter THE_INSTANCE = new DirectoryFilter();

        private DirectoryFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() && !file.getName().equalsIgnoreCase("meta-inf");
        }
    }

    private static final class WsdlFilter
    implements FilenameFilter {
        private WsdlFilter() {
        }

        public boolean accept(File dir, String name) {
            boolean isWSDL = name.toUpperCase().endsWith(".WSDL");
            if (isWSDL) {
                try {
                    WSDLFactory factory = WSDLFactory.newInstance();
                    WSDLReader reader = factory.newWSDLReader();
                    reader.setFeature("javax.wsdl.verbose", false);
                    reader.setFeature("javax.wsdl.importDocuments", true);
                    Definition def = reader.readWSDL(dir.getAbsolutePath(), name);
                    if (WsdlFilter.containsExtensionNamespace(def)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Found namespace uri://schemas.imola.it/jbi/wsdl-extensions/cics/ in file " + name);
                        }
                        return true;
                    }
                }
                catch (WSDLException e) {
                    Object[] args = new Object[]{name, "uri://schemas.imola.it/jbi/wsdl-extensions/cics/"};
                    LOG.warn("CIC001041_File_doesnt_contain_the_estension_jbi4corba", args, e);
                }
            }
            return false;
        }

        private static boolean containsExtensionNamespace(Definition definition) {
            for (Object obj : definition.getNamespaces().values()) {
                String namespace = (String)obj;
                if (!namespace.equalsIgnoreCase("uri://schemas.imola.it/jbi/wsdl-extensions/cics/")) continue;
                return true;
            }
            return false;
        }
    }
}

