/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.connection;

import it.imolinfo.jbi4cics.Logger;
import it.imolinfo.jbi4cics.LoggerFactory;
import it.imolinfo.jbi4cics.connection.ConnectionManager;
import it.imolinfo.jbi4cics.connection.EchoConnectionManager;
import it.imolinfo.jbi4cics.connection.jca.cics.CICSConnectionManager;
import it.imolinfo.jbi4cics.connection.jca.ims.IMSConnectionManager;
import it.imolinfo.jbi4cics.connection.jdbc.JdbcConnectionManager;
import it.imolinfo.jbi4cics.service.ServiceContext;

public class ConnectionManagerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionManagerFactory.class);
    private static CICSConnectionManager cicsConnectionManager = new CICSConnectionManager();
    private static IMSConnectionManager imsConnectionManager = new IMSConnectionManager();
    private static JdbcConnectionManager jdbcConnectionManager = new JdbcConnectionManager();
    private static EchoConnectionManager echoConnectionManager = new EchoConnectionManager();

    public static ConnectionManager createConnectionManager(ServiceContext serviceContext) {
        LOG.debug("Using service location: {0}", serviceContext.getServiceLocation());
        LOG.debug("Using connection type: {0}", serviceContext.getServiceLocation().getConnectionType());
        switch (serviceContext.getServiceLocation().getConnectionType()) {
            case 0: {
                return cicsConnectionManager;
            }
            case 1: {
                return imsConnectionManager;
            }
            case 2: {
                return jdbcConnectionManager;
            }
        }
        return echoConnectionManager;
    }
}

