/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.beansbinding;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.jdesktop.beansbinding.BindingListener;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.beansbinding.PropertyStateEvent;
import org.jdesktop.beansbinding.PropertyStateListener;
import org.jdesktop.beansbinding.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Binding<SS, SV, TS, TV> {
    private String name;
    private SS sourceObject;
    private TS targetObject;
    private Property<SS, SV> sourceProperty;
    private Property<TS, TV> targetProperty;
    private Validator<? super SV> validator;
    private Converter<SV, TV> converter;
    private TV sourceNullValue;
    private SV targetNullValue;
    private TV sourceUnreadableValue;
    private boolean sourceUnreadableValueSet;
    private List<BindingListener> listeners;
    private PropertyStateListener psl;
    private boolean ignoreChange;
    private boolean isManaged;
    private boolean isBound;
    private PropertyChangeSupport changeSupport;

    protected Binding(SS sourceObject, Property<SS, SV> sourceProperty, TS targetObject, Property<TS, TV> targetProperty, String name) {
        this.setSourceProperty(sourceProperty);
        this.setTargetProperty(targetProperty);
        this.sourceObject = sourceObject;
        this.sourceProperty = sourceProperty;
        this.targetObject = targetObject;
        this.targetProperty = targetProperty;
        this.name = name;
    }

    protected final void setSourceProperty(Property<SS, SV> sourceProperty) {
        this.throwIfBound();
        if (sourceProperty == null) {
            throw new IllegalArgumentException("source property can't be null");
        }
        Property<SS, SV> old = this.sourceProperty;
        this.sourceProperty = sourceProperty;
        this.firePropertyChange("sourceProperty", old, sourceProperty);
    }

    protected final void setTargetProperty(Property<TS, TV> targetProperty) {
        this.throwIfBound();
        if (targetProperty == null) {
            throw new IllegalArgumentException("target property can't be null");
        }
        Property<TS, TV> old = this.targetProperty;
        this.targetProperty = targetProperty;
        this.firePropertyChange("targetProperty", old, targetProperty);
    }

    public final String getName() {
        return this.name;
    }

    public final Property<SS, SV> getSourceProperty() {
        return this.sourceProperty;
    }

    public final Property<TS, TV> getTargetProperty() {
        return this.targetProperty;
    }

    public final SS getSourceObject() {
        return this.sourceObject;
    }

    public final TS getTargetObject() {
        return this.targetObject;
    }

    public final void setSourceObject(SS sourceObject) {
        this.throwIfManaged();
        this.setSourceObjectUnmanaged(sourceObject);
    }

    protected final void setSourceObjectUnmanaged(SS sourceObject) {
        this.throwIfBound();
        SS old = this.sourceObject;
        this.sourceObject = sourceObject;
        this.firePropertyChange("sourceObject", old, sourceObject);
    }

    public final void setTargetObject(TS targetObject) {
        this.throwIfManaged();
        this.setTargetObjectUnmanaged(targetObject);
    }

    protected final void setTargetObjectUnmanaged(TS targetObject) {
        this.throwIfBound();
        TS old = this.targetObject;
        this.targetObject = targetObject;
        this.firePropertyChange("targetObject", old, targetObject);
    }

    public final void setValidator(Validator<? super SV> validator) {
        this.throwIfBound();
        Validator<? super SV> old = this.validator;
        this.validator = validator;
        this.firePropertyChange("validator", old, validator);
    }

    public final Validator<? super SV> getValidator() {
        return this.validator;
    }

    public final void setConverter(Converter<SV, TV> converter) {
        this.throwIfBound();
        Converter<SV, TV> old = this.converter;
        this.converter = converter;
        this.firePropertyChange("converter", old, converter);
    }

    public final Converter<SV, TV> getConverter() {
        return this.converter;
    }

    public final void setSourceNullValue(TV sourceNullValue) {
        this.throwIfBound();
        TV old = this.sourceNullValue;
        this.sourceNullValue = sourceNullValue;
        this.firePropertyChange("sourceNullValue", old, sourceNullValue);
    }

    public final TV getSourceNullValue() {
        return this.sourceNullValue;
    }

    public final void setTargetNullValue(SV targetNullValue) {
        this.throwIfBound();
        SV old = this.targetNullValue;
        this.targetNullValue = targetNullValue;
        this.firePropertyChange("targetNullValue", old, targetNullValue);
    }

    public final SV getTargetNullValue() {
        return this.targetNullValue;
    }

    public final void setSourceUnreadableValue(TV sourceUnreadableValue) {
        this.throwIfBound();
        TV old = this.sourceUnreadableValue;
        boolean oldSet = this.sourceUnreadableValueSet;
        this.sourceUnreadableValue = sourceUnreadableValue;
        this.sourceUnreadableValueSet = true;
        this.firePropertyChange("sourceUnreadableValueSet", oldSet, true);
        this.firePropertyChange("sourceUnreadableValue", old, sourceUnreadableValue);
    }

    public final void unsetSourceUnreadableValue() {
        this.throwIfBound();
        if (this.isSourceUnreadableValueSet()) {
            TV old = this.sourceUnreadableValue;
            this.sourceUnreadableValue = null;
            this.sourceUnreadableValueSet = false;
            this.firePropertyChange("sourceUnreadableValueSet", true, false);
            this.firePropertyChange("sourceUnreadableValue", old, null);
        }
    }

    public final boolean isSourceUnreadableValueSet() {
        return this.sourceUnreadableValueSet;
    }

    public final TV getSourceUnreadableValue() {
        if (!this.isSourceUnreadableValueSet()) {
            throw new UnsupportedOperationException("not set");
        }
        return this.sourceUnreadableValue;
    }

    public final void addBindingListener(BindingListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList<BindingListener>();
        }
        this.listeners.add(listener);
    }

    public final void removeBindingListener(BindingListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public final BindingListener[] getBindingListeners() {
        if (this.listeners == null) {
            return new BindingListener[0];
        }
        BindingListener[] ret = new BindingListener[this.listeners.size()];
        ret = this.listeners.toArray(ret);
        return ret;
    }

    public final ValueResult<TV> getSourceValueForTarget() {
        if (!this.targetProperty.isWriteable(this.targetObject)) {
            return new ValueResult(SyncFailure.TARGET_UNWRITEABLE);
        }
        if (!this.sourceProperty.isReadable(this.sourceObject)) {
            if (this.sourceUnreadableValueSet) {
                return new ValueResult(this.sourceUnreadableValue);
            }
            return new ValueResult(SyncFailure.SOURCE_UNREADABLE);
        }
        SV rawValue = this.sourceProperty.getValue(this.sourceObject);
        TV value = rawValue == null ? this.sourceNullValue : this.convertForward(rawValue);
        return new ValueResult(value);
    }

    public final ValueResult<SV> getTargetValueForSource() {
        if (!this.sourceProperty.isWriteable(this.sourceObject)) {
            return new ValueResult(SyncFailure.SOURCE_UNWRITEABLE);
        }
        if (!this.targetProperty.isReadable(this.targetObject)) {
            return new ValueResult(SyncFailure.TARGET_UNREADABLE);
        }
        Object value = null;
        TV rawValue = this.targetProperty.getValue(this.targetObject);
        if (rawValue == null) {
            value = this.targetNullValue;
        } else {
            Validator.Result vr;
            try {
                value = this.convertReverse(rawValue);
            }
            catch (ClassCastException cce) {
                throw cce;
            }
            catch (RuntimeException rte) {
                return new ValueResult(SyncFailure.conversionFailure(rte));
            }
            if (this.validator != null && (vr = this.validator.validate(value)) != null) {
                return new ValueResult(SyncFailure.validationFailure(vr));
            }
        }
        return new ValueResult(value);
    }

    public final void bind() {
        this.throwIfManaged();
        this.bindUnmanaged();
    }

    protected final void bindUnmanaged() {
        this.throwIfBound();
        this.bindImpl();
        this.psl = new PSL();
        this.sourceProperty.addPropertyStateListener(this.sourceObject, this.psl);
        this.targetProperty.addPropertyStateListener(this.targetObject, this.psl);
        this.isBound = true;
        if (this.listeners != null) {
            for (BindingListener listener : this.listeners) {
                listener.bindingBecameBound(this);
            }
        }
        this.firePropertyChange("bound", false, true);
    }

    protected abstract void bindImpl();

    public final void unbind() {
        this.throwIfManaged();
        this.unbindUnmanaged();
    }

    protected final void unbindUnmanaged() {
        this.throwIfUnbound();
        this.sourceProperty.removePropertyStateListener(this.sourceObject, this.psl);
        this.targetProperty.removePropertyStateListener(this.targetObject, this.psl);
        this.psl = null;
        this.unbindImpl();
        this.isBound = false;
        if (this.listeners != null) {
            for (BindingListener listener : this.listeners) {
                listener.bindingBecameUnbound(this);
            }
        }
        this.firePropertyChange("bound", true, false);
    }

    protected abstract void unbindImpl();

    public final boolean isBound() {
        return this.isBound;
    }

    protected final void setManaged(boolean isManaged) {
        this.isManaged = isManaged;
    }

    public final boolean isManaged() {
        return this.isManaged;
    }

    protected final void notifySynced() {
        if (this.listeners == null) {
            return;
        }
        for (BindingListener listener : this.listeners) {
            listener.synced(this);
        }
    }

    protected final void notifySyncFailed(SyncFailure failure) {
        if (this.listeners == null) {
            return;
        }
        for (BindingListener listener : this.listeners) {
            listener.syncFailed(this, failure);
        }
    }

    private final SyncFailure notifyAndReturn(SyncFailure failure) {
        if (failure == null) {
            this.notifySynced();
        } else {
            this.notifySyncFailed(failure);
        }
        return failure;
    }

    public final SyncFailure refreshAndNotify() {
        return this.notifyAndReturn(this.refresh());
    }

    protected final SyncFailure refreshAndNotifyUnmanaged() {
        return this.notifyAndReturn(this.refreshUnmanaged());
    }

    public final SyncFailure saveAndNotify() {
        return this.notifyAndReturn(this.save());
    }

    protected final SyncFailure saveAndNotifyUnmanaged() {
        return this.notifyAndReturn(this.saveUnmanaged());
    }

    public final SyncFailure refresh() {
        this.throwIfManaged();
        return this.refreshUnmanaged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final SyncFailure refreshUnmanaged() {
        ValueResult<TV> vr = this.getSourceValueForTarget();
        if (vr.failed()) {
            return vr.getFailure();
        }
        try {
            this.ignoreChange = true;
            this.targetProperty.setValue(this.targetObject, vr.getValue());
        }
        finally {
            this.ignoreChange = false;
        }
        return null;
    }

    public final SyncFailure save() {
        this.throwIfManaged();
        return this.saveUnmanaged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final SyncFailure saveUnmanaged() {
        ValueResult<SV> vr = this.getTargetValueForSource();
        if (vr.failed()) {
            return vr.getFailure();
        }
        try {
            this.ignoreChange = true;
            this.sourceProperty.setValue(this.sourceObject, vr.getValue());
        }
        finally {
            this.ignoreChange = false;
        }
        return null;
    }

    private final Class<?> noPrimitiveType(Class<?> klass) {
        if (!klass.isPrimitive()) {
            return klass;
        }
        if (klass == Byte.TYPE) {
            return Byte.class;
        }
        if (klass == Short.TYPE) {
            return Short.class;
        }
        if (klass == Integer.TYPE) {
            return Integer.class;
        }
        if (klass == Long.TYPE) {
            return Long.class;
        }
        if (klass == Boolean.TYPE) {
            return Boolean.class;
        }
        if (klass == Character.TYPE) {
            return Character.class;
        }
        if (klass == Float.TYPE) {
            return Float.class;
        }
        if (klass == Double.TYPE) {
            return Double.class;
        }
        throw new AssertionError();
    }

    private final TV convertForward(SV value) {
        if (this.converter == null) {
            Class<TV> targetType = this.noPrimitiveType(this.targetProperty.getWriteType(this.targetObject));
            return targetType.cast(Converter.defaultConvert(value, targetType));
        }
        return this.converter.convertForward(value);
    }

    private final SV convertReverse(TV value) {
        if (this.converter == null) {
            Class<SV> sourceType = this.noPrimitiveType(this.sourceProperty.getWriteType(this.sourceObject));
            return sourceType.cast(Converter.defaultConvert(value, sourceType));
        }
        return this.converter.convertReverse(value);
    }

    protected final void throwIfManaged() {
        if (this.isManaged()) {
            throw new UnsupportedOperationException("Can not call this method on a managed binding");
        }
    }

    protected final void throwIfBound() {
        if (this.isBound()) {
            throw new IllegalStateException("Can not call this method on a bound binding");
        }
    }

    protected final void throwIfUnbound() {
        if (!this.isBound()) {
            throw new IllegalStateException("Can not call this method on an unbound binding");
        }
    }

    public String toString() {
        return this.getClass().getName() + " [" + this.paramString() + "]";
    }

    protected String paramString() {
        return "name=" + this.getName() + ", sourceObject=" + this.sourceObject + ", sourceProperty=" + this.sourceProperty + ", targetObject=" + this.targetObject + ", targetProperty=" + this.targetProperty + ", validator=" + this.validator + ", converter=" + this.converter + ", sourceNullValue=" + this.sourceNullValue + ", targetNullValue=" + this.targetNullValue + ", sourceUnreadableValueSet=" + this.sourceUnreadableValueSet + ", sourceUnreadableValue=" + this.sourceUnreadableValue + ", bound=" + this.isBound;
    }

    private void sourceChanged(PropertyStateEvent pse) {
        if (this.listeners != null) {
            for (BindingListener listener : this.listeners) {
                listener.sourceChanged(this, pse);
            }
        }
        this.sourceChangedImpl(pse);
    }

    protected void sourceChangedImpl(PropertyStateEvent pse) {
    }

    private void targetChanged(PropertyStateEvent pse) {
        if (this.listeners != null) {
            for (BindingListener listener : this.listeners) {
                listener.targetChanged(this, pse);
            }
        }
        this.targetChangedImpl(pse);
    }

    protected void targetChangedImpl(PropertyStateEvent pse) {
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public final void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public final PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    public final PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners(propertyName);
    }

    protected final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    private class PSL
    implements PropertyStateListener {
        private PSL() {
        }

        public void propertyStateChanged(PropertyStateEvent pse) {
            if (Binding.this.ignoreChange) {
                return;
            }
            if (pse.getSourceProperty() == Binding.this.sourceProperty && pse.getSourceObject() == Binding.this.sourceObject) {
                Binding.this.sourceChanged(pse);
            } else {
                Binding.this.targetChanged(pse);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ValueResult<V> {
        private V value;
        private SyncFailure failure;

        private ValueResult(V value) {
            this.value = value;
        }

        private ValueResult(SyncFailure failure) {
            if (failure == null) {
                throw new AssertionError();
            }
            this.failure = failure;
        }

        public boolean failed() {
            return this.failure != null;
        }

        public V getValue() {
            if (this.failed()) {
                throw new UnsupportedOperationException();
            }
            return this.value;
        }

        public SyncFailure getFailure() {
            if (!this.failed()) {
                throw new UnsupportedOperationException();
            }
            return this.failure;
        }

        public String toString() {
            return this.value == null ? "failure: " + this.failure : "value: " + this.value;
        }
    }

    public static final class SyncFailure {
        private SyncFailureType type;
        private Object reason;
        private static SyncFailure TARGET_UNWRITEABLE = new SyncFailure(SyncFailureType.TARGET_UNWRITEABLE);
        private static SyncFailure SOURCE_UNWRITEABLE = new SyncFailure(SyncFailureType.SOURCE_UNWRITEABLE);
        private static SyncFailure TARGET_UNREADABLE = new SyncFailure(SyncFailureType.TARGET_UNREADABLE);
        private static SyncFailure SOURCE_UNREADABLE = new SyncFailure(SyncFailureType.SOURCE_UNREADABLE);

        private static SyncFailure conversionFailure(RuntimeException rte) {
            return new SyncFailure(rte);
        }

        private static SyncFailure validationFailure(Validator.Result result) {
            return new SyncFailure(result);
        }

        private SyncFailure(SyncFailureType type) {
            if (type == SyncFailureType.CONVERSION_FAILED || type == SyncFailureType.VALIDATION_FAILED) {
                throw new IllegalArgumentException();
            }
            this.type = type;
        }

        private SyncFailure(RuntimeException exception) {
            this.type = SyncFailureType.CONVERSION_FAILED;
            this.reason = exception;
        }

        private SyncFailure(Validator.Result result) {
            this.type = SyncFailureType.VALIDATION_FAILED;
            this.reason = result;
        }

        public SyncFailureType getType() {
            return this.type;
        }

        public RuntimeException getConversionException() {
            if (this.type != SyncFailureType.CONVERSION_FAILED) {
                throw new UnsupportedOperationException();
            }
            return (RuntimeException)this.reason;
        }

        public Validator.Result getValidationResult() {
            if (this.type != SyncFailureType.VALIDATION_FAILED) {
                throw new UnsupportedOperationException();
            }
            return (Validator.Result)this.reason;
        }

        public String toString() {
            return (Object)((Object)this.type) + (this.reason == null ? "" : ": " + this.reason.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SyncFailureType {
        TARGET_UNWRITEABLE,
        SOURCE_UNWRITEABLE,
        TARGET_UNREADABLE,
        SOURCE_UNREADABLE,
        CONVERSION_FAILED,
        VALIDATION_FAILED;

    }
}

