/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoCopyMap;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoDocumentEvent;
import com.nwoods.jgo.JGoDocumentListener;
import com.nwoods.jgo.JGoIdentifiablePart;
import com.nwoods.jgo.JGoLayer;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoNode;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoObjectCollection;
import com.nwoods.jgo.JGoObjectSimpleCollection;
import com.nwoods.jgo.JGoPositionArray;
import com.nwoods.jgo.JGoSubGraph;
import com.nwoods.jgo.JGoUndoManager;
import com.nwoods.jgo.JGoXMLSaveRestore;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class JGoDocument
implements JGoObjectCollection,
Transferable,
Serializable,
JGoXMLSaveRestore {
    public static final int CyclesAllowAll = 0;
    public static final int CyclesNotDirected = 1;
    public static final int CyclesNotDirectedFast = 2;
    public static final int CyclesNotUndirected = 3;
    public static final int CyclesDestinationTree = 4;
    public static final int CyclesSourceTree = 5;
    static boolean myCaching = false;
    private JGoLayer myDefaultLayer = null;
    private JGoLayer myFirstLayer = null;
    private JGoLayer myLastLayer = null;
    private Dimension myDocumentSize = new Dimension(0, 0);
    private Point myDocumentTopLeft = new Point(0, 0);
    private Color myPaperColor = null;
    private boolean myModifiable = true;
    private transient boolean mySuspendUpdates = false;
    private transient boolean mySkipsUndoManager = false;
    private static transient DataFlavor myStandardFlavor = null;
    private static transient DataFlavor[] myFlavors = null;
    private transient ArrayList myDocumentListeners = null;
    private transient JGoDocumentEvent myDocumentEvent = null;
    private transient JGoUndoManager myUndoManager = null;
    private transient JGoPositionArray myPositions = null;
    private transient JGoObject mySkippedAvoidable = null;
    private boolean myMaintainsPartID = false;
    private int myLastPartID = -1;
    private transient HashMap myParts = null;
    private int myValidCycle = 0;
    private static HashMap myCycleMap = null;

    public JGoDocument() {
        this.myDefaultLayer = new JGoLayer();
        this.myDefaultLayer.init(this);
        this.myFirstLayer = this.myDefaultLayer;
        this.myLastLayer = this.myDefaultLayer;
        myCycleMap = new HashMap();
    }

    public Dimension getDocumentSize() {
        return this.myDocumentSize;
    }

    public void setDocumentSize(int width, int height) {
        if (width == -23) {
            if (height == -23) {
                myCaching = true;
            } else if (height == -24) {
                myCaching = false;
            }
        }
        Dimension oldDocSize = this.myDocumentSize;
        if (width >= 0 && height >= 0 && (oldDocSize.width != width || oldDocSize.height != height)) {
            Dimension oldSize = new Dimension(oldDocSize);
            this.myDocumentSize.width = width;
            this.myDocumentSize.height = height;
            this.fireUpdate(205, 0, null, 0, oldSize);
        }
    }

    public final void setDocumentSize(Dimension size) {
        this.setDocumentSize(size.width, size.height);
    }

    protected void updateDocumentSize(JGoObject obj) {
        Dimension dim = this.getDocumentSize();
        Point pnt = this.getDocumentTopLeft();
        Rectangle rect = obj.getBoundingRect();
        int newx = Math.min(pnt.x, rect.x);
        int newy = Math.min(pnt.y, rect.y);
        int newright = Math.max(pnt.x + dim.width, rect.x + rect.width);
        int newbottom = Math.max(pnt.y + dim.height, rect.y + rect.height);
        int newwidth = newright - newx;
        int newheight = newbottom - newy;
        if (newx < pnt.x || newy < pnt.y) {
            this.setDocumentTopLeft(newx, newy);
        }
        if (newwidth > dim.width || newheight > dim.height) {
            this.setDocumentSize(newwidth, newheight);
        }
    }

    public Point getDocumentTopLeft() {
        return this.myDocumentTopLeft;
    }

    public void setDocumentTopLeft(int x, int y) {
        Point oldDocTopLeft = this.myDocumentTopLeft;
        if (oldDocTopLeft.x != x || oldDocTopLeft.y != y) {
            Point oldTopLeft = new Point(oldDocTopLeft.x, oldDocTopLeft.y);
            this.myDocumentTopLeft.x = x;
            this.myDocumentTopLeft.y = y;
            this.fireUpdate(209, 0, null, 0, oldTopLeft);
        }
    }

    public final void setDocumentTopLeft(Point topleft) {
        this.setDocumentTopLeft(topleft.x, topleft.y);
    }

    public static Rectangle computeBounds(JGoObjectSimpleCollection coll) {
        Rectangle rect = new Rectangle(0, 0, 0, 0);
        int left = 0;
        int top = 0;
        int right = 0;
        int bottom = 0;
        boolean init = false;
        JGoListPosition pos = coll.getFirstObjectPos();
        while (pos != null) {
            JGoObject obj = coll.getObjectAtPos(pos);
            pos = coll.getNextObjectPosAtTop(pos);
            if (!obj.isVisible()) continue;
            Rectangle b = obj.getBoundingRect();
            rect.x = b.x;
            rect.y = b.y;
            rect.width = b.width;
            rect.height = b.height;
            obj.expandRectByPenWidth(rect);
            if (!init) {
                init = true;
                left = rect.x;
                top = rect.y;
                right = rect.x + rect.width;
                bottom = rect.y + rect.height;
                continue;
            }
            left = Math.min(left, rect.x);
            top = Math.min(top, rect.y);
            right = Math.max(right, rect.x + rect.width);
            bottom = Math.max(bottom, rect.y + rect.height);
        }
        rect.x = left;
        rect.y = top;
        rect.width = right - left;
        rect.height = bottom - top;
        return rect;
    }

    public Rectangle computeBounds() {
        return JGoDocument.computeBounds(this);
    }

    public Color getPaperColor() {
        return this.myPaperColor;
    }

    public void setPaperColor(Color col) {
        Color oldColor = this.myPaperColor;
        if (!(col == oldColor || col != null && col.equals(oldColor))) {
            this.myPaperColor = col;
            this.fireUpdate(206, 0, null, 0, oldColor);
        }
    }

    public boolean isModifiable() {
        return this.myModifiable;
    }

    public void setModifiable(boolean b) {
        boolean oldModifiable = this.myModifiable;
        if (oldModifiable != b) {
            this.myModifiable = b;
            this.fireUpdate(208, 0, null, oldModifiable ? 1 : 0, null);
        }
    }

    public int getNumObjects() {
        int count = 0;
        for (JGoLayer layer = this.getFirstLayer(); layer != null; layer = layer.getNextLayer()) {
            count += layer.getNumObjects();
        }
        return count;
    }

    public boolean isEmpty() {
        return this.getNumObjects() == 0;
    }

    public JGoListPosition addObjectAtHead(JGoObject obj) {
        return this.getFirstLayer().addObjectAtHead(obj);
    }

    public JGoListPosition addObjectAtTail(JGoObject obj) {
        return this.getLastLayer().addObjectAtTail(obj);
    }

    public JGoListPosition insertObjectBefore(JGoListPosition pos, JGoObject obj) {
        if (pos == null || obj == null) {
            return null;
        }
        JGoObject posobj = this.getObjectAtPos(pos);
        return posobj.getLayer().insertObjectBefore(pos, obj);
    }

    public JGoListPosition insertObjectAfter(JGoListPosition pos, JGoObject obj) {
        if (pos == null || obj == null) {
            return null;
        }
        JGoObject posobj = this.getObjectAtPos(pos);
        return posobj.getLayer().insertObjectAfter(pos, obj);
    }

    public void bringObjectToFront(JGoObject obj) {
        this.getLastLayer().bringObjectToFront(obj);
    }

    public void sendObjectToBack(JGoObject obj) {
        this.getFirstLayer().sendObjectToBack(obj);
    }

    public void removeObject(JGoObject obj) {
        if (obj == null) {
            return;
        }
        JGoLayer layer = obj.getLayer();
        if (layer == null) {
            return;
        }
        if (layer.getDocument() != this) {
            return;
        }
        layer.removeObject(obj);
    }

    public JGoObject removeObjectAtPos(JGoListPosition pos) {
        JGoObject obj = this.getObjectAtPos(pos);
        return obj.getLayer().removeObjectAtPos(pos);
    }

    public void deleteContents() {
        while (this.getLastLayer() != this.getFirstLayer()) {
            this.removeLayer(this.getLastLayer());
        }
        this.getFirstLayer().removeAll();
        this.setDocumentSize(0, 0);
    }

    public JGoObject pickObject(Point pointToCheck, boolean selectableOnly) {
        for (JGoLayer layer = this.getLastLayer(); layer != null; layer = layer.getPrevLayer()) {
            JGoObject obj = layer.pickObject(pointToCheck, selectableOnly);
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    public ArrayList pickObjects(Point p, boolean selectableOnly, ArrayList coll, int max) {
        if (coll == null) {
            coll = new ArrayList();
        }
        for (JGoLayer layer = this.getLastLayer(); layer != null; layer = layer.getPrevLayer()) {
            if (coll.size() >= max) {
                return coll;
            }
            layer.pickObjects(p, selectableOnly, coll, max);
        }
        return coll;
    }

    public JGoListPosition getFirstObjectPos() {
        for (JGoLayer layer = this.getFirstLayer(); layer != null; layer = layer.getNextLayer()) {
            JGoListPosition pos = layer.getFirstObjectPos();
            if (pos == null) continue;
            return pos;
        }
        return null;
    }

    public JGoListPosition getLastObjectPos() {
        for (JGoLayer layer = this.getLastLayer(); layer != null; layer = layer.getPrevLayer()) {
            JGoListPosition pos = layer.getLastObjectPos();
            if (pos == null) continue;
            return pos;
        }
        return null;
    }

    public JGoListPosition getNextObjectPos(JGoListPosition pos) {
        JGoObjectCollection area;
        if (pos == null) {
            return null;
        }
        JGoObject obj = pos.obj;
        if (obj instanceof JGoObjectCollection && !(area = (JGoObjectCollection)((Object)obj)).isEmpty()) {
            return area.getFirstObjectPos();
        }
        pos = pos.next;
        while (pos == null) {
            JGoArea parent = obj.getParent();
            if (parent == null) {
                JGoLayer layer = obj.getLayer();
                for (layer = layer.getNextLayer(); layer != null; layer = layer.getNextLayer()) {
                    JGoListPosition firstpos = layer.getFirstObjectPos();
                    if (firstpos == null) continue;
                    return firstpos;
                }
                return null;
            }
            JGoListPosition parentpos = parent.getCurrentListPosition();
            obj = parent;
            pos = parentpos.next;
        }
        return pos;
    }

    public JGoListPosition getNextObjectPosAtTop(JGoListPosition pos) {
        if (pos == null) {
            return null;
        }
        JGoObject obj = pos.obj;
        while (obj.getParent() != null) {
            pos = obj.getParent().getCurrentListPosition();
            obj = obj.getParent();
        }
        pos = pos.next;
        if (pos == null) {
            JGoLayer layer = obj.getLayer();
            for (layer = layer.getNextLayer(); layer != null; layer = layer.getNextLayer()) {
                JGoListPosition firstpos = layer.getFirstObjectPos();
                if (firstpos == null) continue;
                return firstpos;
            }
        }
        return pos;
    }

    public JGoListPosition getPrevObjectPos(JGoListPosition pos) {
        if (pos == null) {
            return null;
        }
        return pos.prev;
    }

    public JGoObject getObjectAtPos(JGoListPosition pos) {
        if (pos == null) {
            return null;
        }
        return pos.obj;
    }

    public JGoListPosition findObject(JGoObject obj) {
        for (JGoLayer layer = this.getFirstLayer(); layer != null; layer = layer.getNextLayer()) {
            JGoListPosition pos = layer.findObject(obj);
            if (pos == null) continue;
            return pos;
        }
        return null;
    }

    public void addDocumentListener(JGoDocumentListener l) {
        if (this.myDocumentListeners == null) {
            this.myDocumentListeners = new ArrayList();
        }
        if (!this.myDocumentListeners.contains(l)) {
            this.myDocumentListeners.add(l);
        }
    }

    public void removeDocumentListener(JGoDocumentListener l) {
        if (this.myDocumentListeners == null) {
            return;
        }
        int i = this.myDocumentListeners.indexOf(l);
        if (i >= 0) {
            this.myDocumentListeners.remove(i);
        }
    }

    public JGoDocumentListener[] getDocumentListeners() {
        if (this.myDocumentListeners == null) {
            return new JGoDocumentListener[0];
        }
        Object[] objList = this.myDocumentListeners.toArray();
        JGoDocumentListener[] listenerList = new JGoDocumentListener[objList.length];
        for (int i = 0; i < objList.length; ++i) {
            listenerList[i] = (JGoDocumentListener)objList[i];
        }
        return listenerList;
    }

    public void fireUpdate(int hint, int flags, Object object, int prevInt, Object prevObj) {
        this.invokeListeners(hint, flags, object, prevInt, prevObj);
    }

    void invokeListeners(int hint, int flags, Object object, int prevInt, Object prevObj) {
        JGoObject obj;
        if (hint == 203 && flags == 1) {
            JGoLayer layer;
            obj = (JGoObject)object;
            this.invalidatePositionArray(obj);
            if (obj.isTopLevel() && (layer = obj.getLayer()) != null) {
                layer.updateCache(obj, (Rectangle)prevObj);
            }
        } else if (hint == 202) {
            obj = (JGoObject)object;
            if (this.isMaintainsPartID()) {
                this.addAllParts(obj);
            }
            this.invalidatePositionArray(obj);
        } else if (hint == 204) {
            obj = (JGoObject)object;
            this.removeAllParts(obj);
            this.invalidatePositionArray(obj);
        } else if (hint == 210) {
            this.invalidatePositionArray(null);
        } else if (hint == 211) {
            this.invalidatePositionArray(null);
        }
        if (this.isSuspendUpdates()) {
            return;
        }
        if (this.myDocumentEvent == null) {
            this.myDocumentEvent = new JGoDocumentEvent(this, hint, flags, object, prevInt, prevObj);
        } else {
            this.myDocumentEvent.setHint(hint);
            this.myDocumentEvent.setFlags(flags);
            this.myDocumentEvent.setObject(object);
            this.myDocumentEvent.setPreviousValueInt(prevInt);
            this.myDocumentEvent.setPreviousValue(prevObj);
        }
        JGoDocumentEvent e = this.myDocumentEvent;
        this.myDocumentEvent = null;
        ArrayList listeners = this.myDocumentListeners;
        if (listeners != null) {
            int numlisteners = listeners.size();
            for (int i = 0; i < numlisteners; ++i) {
                JGoDocumentListener l = (JGoDocumentListener)listeners.get(i);
                l.documentChanged(e);
            }
        }
        this.myDocumentEvent = e;
        this.myDocumentEvent.setObject(null);
    }

    public void fireForedate(int hint, int flags, Object obj) {
        this.invokeListeners(hint |= 0x8000, flags, obj, 0, null);
    }

    public final void update() {
        this.fireUpdate(100, 0, null, 0, null);
    }

    public boolean isSuspendUpdates() {
        return this.mySuspendUpdates;
    }

    public void setSuspendUpdates(boolean bFlag) {
        this.mySuspendUpdates = bFlag;
        if (!bFlag) {
            this.invalidatePositionArray(null);
            for (JGoLayer layer = this.getFirstLayer(); layer != null; layer = layer.getNextLayer()) {
                layer.resetCache();
            }
            this.update();
        }
    }

    public boolean isSkipsUndoManager() {
        return this.mySkipsUndoManager;
    }

    public void setSkipsUndoManager(boolean bFlag) {
        this.mySkipsUndoManager = bFlag;
    }

    public boolean isMaintainsPartID() {
        return this.myMaintainsPartID;
    }

    public void setMaintainsPartID(boolean bFlag) {
        this.internalSetMaintainsPartID(bFlag, false);
    }

    private void internalSetMaintainsPartID(boolean bFlag, boolean undoing) {
        boolean old = this.myMaintainsPartID;
        if (old != bFlag) {
            this.myMaintainsPartID = bFlag;
            this.fireUpdate(219, 0, null, old ? 1 : 0, null);
            if (!undoing) {
                if (bFlag) {
                    this.ensureUniquePartID();
                } else {
                    this.myParts = null;
                }
            }
        }
    }

    public JGoIdentifiablePart findPart(int id) {
        if (this.myParts != null) {
            return (JGoIdentifiablePart)this.myParts.get(new Integer(id));
        }
        return null;
    }

    void addPart(JGoIdentifiablePart p) {
        if (this.myParts == null) {
            this.myParts = new HashMap(1000);
        }
        int pid = p.getPartID();
        Integer pidint = null;
        if (pid != -1) {
            pidint = new Integer(pid);
            if (this.myParts.get(pidint) == p) {
                return;
            }
            if (this.myParts.get(pidint) == null) {
                this.myParts.put(pidint, p);
                return;
            }
        }
        pid = ++this.myLastPartID;
        pidint = new Integer(pid);
        while (this.myParts.get(pidint) != null) {
            pid = ++this.myLastPartID;
            pidint = new Integer(pid);
        }
        this.myParts.put(pidint, p);
        p.setPartID(pid);
    }

    void removePart(JGoIdentifiablePart p) {
        if (this.myParts != null) {
            this.myParts.remove(new Integer(p.getPartID()));
        }
    }

    public void ensureUniquePartID() {
        if (this.isMaintainsPartID()) {
            JGoListPosition pos = this.getFirstObjectPos();
            while (pos != null) {
                JGoObject obj = this.getObjectAtPos(pos);
                pos = this.getNextObjectPosAtTop(pos);
                this.addAllParts(obj);
            }
        }
    }

    void addAllParts(JGoObject obj) {
        if (obj instanceof JGoIdentifiablePart) {
            JGoIdentifiablePart p = (JGoIdentifiablePart)((Object)obj);
            this.addPart(p);
        }
        if (obj instanceof JGoArea) {
            JGoArea g = (JGoArea)obj;
            JGoListPosition pos = g.getFirstObjectPos();
            while (pos != null) {
                JGoObject o = g.getObjectAtPos(pos);
                pos = g.getNextObjectPosAtTop(pos);
                this.addAllParts(o);
            }
        }
    }

    void removeAllParts(JGoObject obj) {
        if (this.myParts != null) {
            if (obj instanceof JGoIdentifiablePart) {
                JGoIdentifiablePart p = (JGoIdentifiablePart)((Object)obj);
                this.removePart(p);
            }
            if (obj instanceof JGoArea) {
                JGoArea g = (JGoArea)obj;
                JGoListPosition pos = g.getFirstObjectPos();
                while (pos != null) {
                    JGoObject o = g.getObjectAtPos(pos);
                    pos = g.getNextObjectPosAtTop(pos);
                    this.removeAllParts(o);
                }
            }
        }
    }

    public void copyOldValueForUndo(JGoDocumentChangedEdit e) {
        switch (e.getHint()) {
            case 202: {
                return;
            }
            case 203: {
                JGoObject obj = (JGoObject)e.getObject();
                obj.copyOldValueForUndo(e);
                return;
            }
            case 204: {
                return;
            }
            case 205: {
                e.setOldValue(new Dimension((Dimension)e.getOldValue()));
                return;
            }
            case 206: {
                return;
            }
            case 208: {
                return;
            }
            case 209: {
                Point p = (Point)e.getOldValue();
                e.setOldValue(new Point(p.x, p.y));
                return;
            }
            case 210: {
                return;
            }
            case 211: {
                return;
            }
            case 212: {
                return;
            }
            case 213: 
            case 214: 
            case 215: 
            case 217: 
            case 219: {
                return;
            }
            case 218: {
                JGoDocumentChangedEdit before;
                if (!e.isBeforeChanging() && (before = e.findBeforeChangingEdit()) != null) {
                    e.setOldValue(before.getNewValue());
                }
                return;
            }
        }
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit e) {
        switch (e.getHint()) {
            case 202: {
                return;
            }
            case 203: {
                JGoObject obj = (JGoObject)e.getObject();
                obj.copyNewValueForRedo(e);
                return;
            }
            case 204: {
                return;
            }
            case 205: {
                e.setNewValue(new Dimension(this.getDocumentSize()));
                return;
            }
            case 206: {
                e.setNewValue(this.getPaperColor());
                return;
            }
            case 208: {
                e.setNewValueBoolean(this.isModifiable());
                return;
            }
            case 209: {
                Point p = this.getDocumentTopLeft();
                e.setNewValue(new Point(p.x, p.y));
                return;
            }
            case 210: {
                return;
            }
            case 211: {
                return;
            }
            case 212: {
                JGoLayer layer = (JGoLayer)e.getObject();
                e.setNewValue(layer.getNextLayer());
                return;
            }
            case 213: {
                JGoLayer layer = (JGoLayer)e.getObject();
                e.setNewValueBoolean(layer.isVisible());
                return;
            }
            case 214: {
                JGoLayer layer = (JGoLayer)e.getObject();
                e.setNewValueBoolean(layer.isModifiable());
                return;
            }
            case 215: {
                JGoLayer layer = (JGoLayer)e.getObject();
                e.setNewValue(new Float(layer.getTransparency()));
                return;
            }
            case 217: {
                JGoLayer layer = (JGoLayer)e.getObject();
                e.setNewValue(layer.getIdentifier());
                return;
            }
            case 218: {
                ArrayList<Serializable> copy = new ArrayList<Serializable>();
                int i = 0;
                JGoListPosition pos = this.getFirstObjectPos();
                while (pos != null) {
                    JGoObject obj = this.getObjectAtPos(pos);
                    pos = this.getNextObjectPosAtTop(pos);
                    copy.add(i++, obj);
                    if (obj instanceof JGoLink) {
                        JGoLink link = (JGoLink)obj;
                        Vector v = link.copyPoints();
                        copy.add(i++, v);
                        continue;
                    }
                    Rectangle rect = obj.getBoundingRect();
                    copy.add(i++, new Rectangle(rect.x, rect.y, rect.width, rect.height));
                }
                e.setNewValue(copy);
                return;
            }
            case 219: {
                e.setNewValueBoolean(this.isMaintainsPartID());
                return;
            }
            case 220: {
                e.setNewValueInt(this.getValidCycle());
                return;
            }
            case 1902: {
                return;
            }
        }
        if (e.getHint() >= 65535) {
            throw new IllegalArgumentException("unknown JGoDocumentEvent hint: " + Integer.toString(e.getHint()));
        }
    }

    public void changeValue(JGoDocumentChangedEdit e, boolean undo) {
        switch (e.getHint()) {
            case 202: {
                if (undo) {
                    JGoObject obj = (JGoObject)e.getObject();
                    this.removeObject(obj);
                } else {
                    this.reinsertObject(e);
                }
                return;
            }
            case 203: {
                JGoObject obj = (JGoObject)e.getObject();
                obj.changeValue(e, undo);
                return;
            }
            case 204: {
                if (undo) {
                    this.reinsertObject(e);
                } else {
                    JGoObject obj = (JGoObject)e.getObject();
                    this.removeObject(obj);
                }
                return;
            }
            case 205: {
                this.setDocumentSize((Dimension)e.getValue(undo));
                return;
            }
            case 206: {
                this.setPaperColor((Color)e.getValue(undo));
                return;
            }
            case 208: {
                this.setModifiable(e.getValueBoolean(undo));
                return;
            }
            case 209: {
                this.setDocumentTopLeft((Point)e.getValue(undo));
                return;
            }
            case 210: {
                JGoLayer layer = (JGoLayer)e.getObject();
                if (undo) {
                    this.removeLayer(layer);
                } else {
                    JGoLayer old = (JGoLayer)e.getOldValue();
                    switch (e.getOldValueInt()) {
                        case 8: {
                            this.insertBefore(old, layer);
                            break;
                        }
                        case 4: {
                            this.insertAfter(old, layer);
                        }
                    }
                }
                return;
            }
            case 211: {
                JGoLayer layer = (JGoLayer)e.getObject();
                if (undo) {
                    JGoLayer old = (JGoLayer)e.getOldValue();
                    if (old != null) {
                        this.insertBefore(old, layer);
                    } else {
                        this.insertLayerAfter(this.getLastLayer(), layer);
                    }
                } else {
                    this.removeLayer(layer);
                }
                return;
            }
            case 212: {
                JGoLayer layer = (JGoLayer)e.getObject();
                JGoLayer nextlayer = (JGoLayer)e.getValue(undo);
                if (nextlayer != null) {
                    this.insertLayerBefore(nextlayer, layer);
                } else {
                    this.insertLayerAfter(this.getLastLayer(), layer);
                }
                return;
            }
            case 213: {
                JGoLayer layer = (JGoLayer)e.getObject();
                layer.setVisible(e.getValueBoolean(undo));
                return;
            }
            case 214: {
                JGoLayer layer = (JGoLayer)e.getObject();
                layer.setModifiable(e.getValueBoolean(undo));
                return;
            }
            case 215: {
                JGoLayer layer = (JGoLayer)e.getObject();
                Float fobj = (Float)e.getValue(undo);
                layer.setTransparency(fobj.floatValue());
                return;
            }
            case 217: {
                JGoLayer layer = (JGoLayer)e.getObject();
                layer.setIdentifier(e.getValue(undo));
                return;
            }
            case 218: {
                ArrayList copy = (ArrayList)e.getValue(undo);
                for (int i = 0; i < copy.size(); i += 2) {
                    JGoObject obj = (JGoObject)copy.get(i);
                    if (obj instanceof JGoLink) {
                        Vector v = (Vector)copy.get(i + 1);
                        JGoLink link = (JGoLink)obj;
                        link.setPoints(v);
                        continue;
                    }
                    Rectangle rect = (Rectangle)copy.get(i + 1);
                    obj.setBoundingRect(rect);
                }
                this.update();
                return;
            }
            case 219: {
                this.internalSetMaintainsPartID(e.getValueBoolean(undo), true);
                return;
            }
            case 220: {
                this.setValidCycle(e.getValueInt(undo));
                return;
            }
            case 1902: {
                ArrayList coll = (ArrayList)e.getOldValue();
                boolean b = undo ? e.getOldValueInt() == 1 : e.getOldValueInt() == 0;
                for (int i = 0; i < coll.size(); ++i) {
                    JGoObject obj = (JGoObject)coll.get(i);
                    JGoArea.setAllNoClear(obj, b);
                }
                return;
            }
        }
        if (e.getHint() >= 65535) {
            throw new IllegalArgumentException("unknown JGoDocumentEvent hint: " + Integer.toString(e.getHint()));
        }
    }

    void reinsertObject(JGoDocumentChangedEdit e) {
        JGoObject obj = (JGoObject)e.getObject();
        switch (e.getOldValueInt()) {
            case 2: {
                JGoObjectCollection coll = (JGoObjectCollection)e.getOldValue();
                if (coll instanceof JGoArea) {
                    ((JGoArea)coll).addObjectAtTailInternal(obj, true);
                    break;
                }
                coll.addObjectAtTail(obj);
                break;
            }
            case 6: {
                JGoObjectCollection coll = (JGoObjectCollection)e.getOldValue();
                if (coll instanceof JGoArea) {
                    ((JGoArea)coll).addObjectAtHeadInternal(obj, true);
                    break;
                }
                coll.addObjectAtHead(obj);
                break;
            }
            case 8: {
                JGoObject nextobj = (JGoObject)e.getOldValue();
                JGoLayer coll = nextobj.getLayer();
                if (coll == null) break;
                JGoListPosition nextpos = coll.findObject(nextobj);
                if (nextpos != null) {
                    if (coll instanceof JGoArea) {
                        ((JGoArea)((Object)coll)).insertObjectBeforeInternal(nextpos, obj, true);
                        break;
                    }
                    coll.insertObjectBefore(nextpos, obj);
                    break;
                }
                if (coll instanceof JGoArea) {
                    ((JGoArea)((Object)coll)).addObjectAtTailInternal(obj, true);
                    break;
                }
                coll.addObjectAtTail(obj);
                break;
            }
            case 4: {
                JGoObject prevobj = (JGoObject)e.getOldValue();
                JGoLayer coll = prevobj.getLayer();
                if (coll == null) break;
                JGoListPosition prevpos = coll.findObject(prevobj);
                if (prevpos != null) {
                    if (coll instanceof JGoArea) {
                        ((JGoArea)((Object)coll)).insertObjectAfterInternal(prevpos, obj, true);
                        break;
                    }
                    coll.insertObjectAfter(prevpos, obj);
                    break;
                }
                if (coll instanceof JGoArea) {
                    ((JGoArea)((Object)coll)).addObjectAtTailInternal(obj, true);
                    break;
                }
                coll.addObjectAtTail(obj);
                break;
            }
            case 0: {
                JGoObject nextobj;
                JGoListPosition nextpos;
                JGoObject prevobj;
                JGoListPosition prevpos;
                Object[] info = (Object[])e.getOldValue();
                JGoObjectCollection coll = (JGoObjectCollection)info[0];
                if (info[1] != null && (prevpos = coll.findObject(prevobj = (JGoObject)info[1])) != null) {
                    if (coll instanceof JGoArea) {
                        ((JGoArea)coll).insertObjectAfterInternal(prevpos, obj, true);
                    } else {
                        coll.insertObjectAfter(prevpos, obj);
                    }
                    return;
                }
                if (info[2] != null && (nextpos = coll.findObject(nextobj = (JGoObject)info[2])) != null) {
                    if (coll instanceof JGoArea) {
                        ((JGoArea)coll).insertObjectBeforeInternal(nextpos, obj, true);
                    } else {
                        coll.insertObjectBefore(nextpos, obj);
                    }
                    return;
                }
                if (coll instanceof JGoArea) {
                    ((JGoArea)coll).addObjectAtTailInternal(obj, true);
                    break;
                }
                coll.addObjectAtTail(obj);
                break;
            }
        }
    }

    public static DataFlavor getStandardDataFlavor() {
        if (myStandardFlavor == null) {
            try {
                myStandardFlavor = new DataFlavor(Class.forName("com.nwoods.jgo.JGoSelection"), "JGo Selection");
                DataFlavor[] v = new DataFlavor[]{myStandardFlavor};
                myFlavors = v;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return myStandardFlavor;
    }

    public DataFlavor[] getTransferDataFlavors() {
        JGoDocument.getStandardDataFlavor();
        return myFlavors;
    }

    public boolean isDataFlavorSupported(DataFlavor f) {
        return f.equals(JGoDocument.getStandardDataFlavor());
    }

    public synchronized Object getTransferData(DataFlavor f) throws UnsupportedFlavorException, IOException {
        if (f.equals(JGoDocument.getStandardDataFlavor())) {
            return this;
        }
        throw new UnsupportedFlavorException(f);
    }

    public JGoCopyEnvironment createDefaultCopyEnvironment() {
        return new JGoCopyMap();
    }

    public JGoCopyEnvironment copyFromCollection(JGoObjectSimpleCollection coll) {
        return this.copyFromCollection(coll, new Point(0, 0), null);
    }

    public JGoCopyEnvironment copyFromCollection(JGoObjectSimpleCollection coll, Point offset, JGoCopyEnvironment map) {
        if (map == null) {
            map = this.createDefaultCopyEnvironment();
        }
        Point oldloc = new Point(0, 0);
        JGoListPosition pos = coll.getFirstObjectPos();
        while (pos != null) {
            JGoObject obj = coll.getObjectAtPos(pos);
            pos = coll.getNextObjectPosAtTop(pos);
            JGoObject newobj = map.copy(obj = obj.getDraggingObject());
            if (newobj == null) continue;
            oldloc = newobj.getLocation(oldloc);
            Point newloc = newobj.computeMove(oldloc.x, oldloc.y, oldloc.x + offset.x, oldloc.y + offset.y, oldloc);
            newobj.setLocation(newloc.x, newloc.y);
            JGoLayer oldlayer = obj.getLayer();
            JGoLayer newlayer = null;
            if (oldlayer != null) {
                newlayer = oldlayer.getDocument() == this ? oldlayer : this.findLayer(oldlayer.getIdentifier());
            }
            if (newlayer == null) {
                newlayer = this.getDefaultLayer();
            }
            newlayer.addObjectAtTail(newobj);
        }
        Vector delayeds = map.getDelayeds();
        for (int i = 0; i < delayeds.size(); ++i) {
            JGoObject oldobj;
            JGoObject newo;
            Object oldo = delayeds.get(i);
            if (!(oldo instanceof JGoObject) || !((newo = (JGoObject)map.get(oldobj = (JGoObject)oldo)) instanceof JGoObject)) continue;
            JGoObject newobj = newo;
            oldobj.copyObjectDelayed(map, newobj);
        }
        return map;
    }

    public int getNumLayers() {
        int count = 0;
        for (JGoLayer layer = this.getFirstLayer(); layer != null; layer = layer.getNextLayer()) {
            ++count;
        }
        return count;
    }

    public JGoLayer getFirstLayer() {
        return this.myFirstLayer;
    }

    public JGoLayer getLastLayer() {
        return this.myLastLayer;
    }

    public JGoLayer getNextLayer(JGoLayer layer) {
        if (layer == null) {
            return null;
        }
        return layer.getNextLayer();
    }

    public JGoLayer getPrevLayer(JGoLayer layer) {
        if (layer == null) {
            return null;
        }
        return layer.getPrevLayer();
    }

    public JGoLayer getDefaultLayer() {
        return this.myDefaultLayer;
    }

    public void setDefaultLayer(JGoLayer layer) {
        if (layer.getDocument() != this) {
            return;
        }
        this.myDefaultLayer = layer;
    }

    public JGoLayer addLayerAfter(JGoLayer old) {
        if (old == null) {
            old = this.getLastLayer();
        }
        JGoLayer layer = new JGoLayer();
        layer.init(this);
        return this.insertAfter(old, layer);
    }

    JGoLayer insertAfter(JGoLayer old, JGoLayer layer) {
        layer.insert(old.getNextLayer(), old);
        if (layer.getNextLayer() == null) {
            this.myLastLayer = layer;
        }
        this.fireUpdate(210, 0, layer, 4, old);
        return layer;
    }

    public JGoLayer addLayerBefore(JGoLayer old) {
        if (old == null) {
            old = this.getFirstLayer();
        }
        JGoLayer layer = new JGoLayer();
        layer.init(this);
        return this.insertBefore(old, layer);
    }

    JGoLayer insertBefore(JGoLayer old, JGoLayer layer) {
        layer.insert(old, old.getPrevLayer());
        if (layer.getPrevLayer() == null) {
            this.myFirstLayer = layer;
        }
        this.fireUpdate(210, 0, layer, 8, old);
        return layer;
    }

    public void removeLayer(JGoLayer layer) {
        if (layer.getDocument() != this) {
            return;
        }
        if (layer == this.getFirstLayer() && layer == this.getLastLayer()) {
            return;
        }
        JGoLayer nextlayer = layer.getNextLayer();
        layer.removeAll();
        if (layer.getPrevLayer() == null) {
            this.myFirstLayer = nextlayer;
        }
        if (nextlayer == null) {
            this.myLastLayer = layer.getPrevLayer();
        }
        layer.extract();
        if (layer == this.getDefaultLayer()) {
            if (layer.getNextLayer() != null) {
                this.setDefaultLayer(layer.getNextLayer());
            } else if (layer.getPrevLayer() != null) {
                this.setDefaultLayer(layer.getPrevLayer());
            } else {
                this.setDefaultLayer(this.getLastLayer());
            }
        }
        this.fireUpdate(211, 0, layer, 0, nextlayer);
    }

    public void insertLayerAfter(JGoLayer old, JGoLayer insert) {
        if (old.getDocument() != this || insert.getDocument() != this || old == insert || insert.getPrevLayer() == old) {
            return;
        }
        JGoLayer nextlayer = insert.getNextLayer();
        if (this.myFirstLayer == insert) {
            this.myFirstLayer = nextlayer;
        }
        insert.extract();
        insert.insert(old.getNextLayer(), old);
        if (this.myLastLayer == old) {
            this.myLastLayer = insert;
        }
        this.fireUpdate(212, 0, insert, 0, nextlayer);
    }

    public void insertLayerBefore(JGoLayer old, JGoLayer insert) {
        if (old.getDocument() != this || insert.getDocument() != this || old == insert || insert.getNextLayer() == old) {
            return;
        }
        JGoLayer nextlayer = insert.getNextLayer();
        if (this.myLastLayer == insert) {
            this.myLastLayer = insert.getPrevLayer();
        }
        insert.extract();
        insert.insert(old, old.getPrevLayer());
        if (this.myFirstLayer == old) {
            this.myFirstLayer = insert;
        }
        this.fireUpdate(212, 0, insert, 0, nextlayer);
    }

    public void bringLayerToFront(JGoLayer layer) {
        this.insertLayerAfter(this.getLastLayer(), layer);
    }

    public void sendLayerToBack(JGoLayer layer) {
        this.insertLayerBefore(this.getFirstLayer(), layer);
    }

    public JGoLayer findLayer(Object identifier) {
        if (identifier == null) {
            return null;
        }
        for (JGoLayer layer = this.getFirstLayer(); layer != null; layer = layer.getNextLayer()) {
            Object id = layer.getIdentifier();
            if (id == null || !id.equals(identifier)) continue;
            return layer;
        }
        return null;
    }

    void copyLayersFrom(JGoDocument other) {
        JGoLayer oldlayer = other.getFirstLayer();
        while (oldlayer != null) {
            Object oldID = oldlayer.getIdentifier();
            if (oldID != null && this.findLayer(oldID) == null) {
                JGoLayer newlayer = this.addLayerAfter(this.getLastLayer());
                newlayer.setIdentifier(oldID);
            }
            oldlayer = other.getNextLayer(oldlayer);
        }
        Object defID = other.getDefaultLayer().getIdentifier();
        JGoLayer defLayer = this.findLayer(defID);
        if (defLayer != null) {
            this.setDefaultLayer(defLayer);
        }
    }

    public JGoUndoManager getUndoManager() {
        return this.myUndoManager;
    }

    public void setUndoManager(JGoUndoManager m) {
        JGoUndoManager oldMgr = this.myUndoManager;
        if (oldMgr != m) {
            if (oldMgr != null) {
                this.removeDocumentListener(oldMgr);
            }
            this.myUndoManager = m;
            if (m != null) {
                this.addDocumentListener(m);
            }
        }
    }

    public boolean canUndo() {
        JGoUndoManager m = this.getUndoManager();
        if (m != null) {
            return m.canUndo();
        }
        return false;
    }

    public void undo() {
        JGoUndoManager m = this.getUndoManager();
        if (m != null) {
            try {
                UndoableEdit edit = m.getEditToUndo();
                this.fireUpdate(107, 0, edit, 0, null);
                m.undo();
                this.fireUpdate(108, 0, edit, 0, null);
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
        }
    }

    public boolean canRedo() {
        JGoUndoManager m = this.getUndoManager();
        if (m != null) {
            return m.canRedo();
        }
        return false;
    }

    public void redo() {
        JGoUndoManager m = this.getUndoManager();
        if (m != null) {
            try {
                UndoableEdit edit = m.getEditToRedo();
                this.fireUpdate(109, 0, edit, 0, null);
                m.redo();
                this.fireUpdate(110, 0, edit, 0, null);
            }
            catch (CannotRedoException cannotRedoException) {
                // empty catch block
            }
        }
    }

    public void startTransaction() {
        JGoUndoManager m = this.getUndoManager();
        if (m != null) {
            m.startTransaction();
            if (m.getTransactionLevel() == 1) {
                this.fireUpdate(104, 0, null, 0, null);
            }
        }
    }

    public void endTransaction(boolean commit) {
        JGoUndoManager m = this.getUndoManager();
        if (m != null) {
            JGoUndoManager.JGoCompoundEdit edit = m.getCurrentEdit();
            m.endTransaction(commit);
            if (m.getTransactionLevel() == 0 && edit != null) {
                if (commit) {
                    this.fireUpdate(105, 0, edit, 0, null);
                } else {
                    this.fireUpdate(106, 0, null, 0, null);
                }
            }
        }
    }

    public void endTransaction(String pname) {
        JGoUndoManager m = this.getUndoManager();
        if (m != null) {
            JGoUndoManager.JGoCompoundEdit edit = m.getCurrentEdit();
            m.endTransaction(pname);
            if (m.getTransactionLevel() == 0 && edit != null) {
                this.fireUpdate(105, 0, edit, 0, pname);
            }
        }
    }

    public void discardAllEdits() {
        JGoUndoManager m = this.getUndoManager();
        if (m != null) {
            m.discardAllEdits();
        }
    }

    public boolean isAvoidable(JGoObject obj) {
        if (!obj.isVisible()) {
            return false;
        }
        return obj instanceof JGoNode;
    }

    public Rectangle getAvoidableRectangle(JGoObject obj, Rectangle rect) {
        if (rect == null) {
            rect = new Rectangle(0, 0, 0, 0);
        }
        Rectangle b = obj.getBoundingRect();
        rect.x = b.x;
        rect.y = b.y;
        rect.width = b.width;
        rect.height = b.height;
        obj.expandRectByPenWidth(rect);
        return rect;
    }

    public boolean isUnoccupied(Rectangle r, JGoObject skip) {
        if (skip != this.mySkippedAvoidable) {
            this.invalidatePositionArray(null);
            this.mySkippedAvoidable = skip;
        }
        JGoPositionArray positions = this.getPositions(false, skip);
        return positions.isUnoccupied(r.x, r.y, r.width, r.height);
    }

    JGoPositionArray getPositions() {
        return this.getPositions(true, null);
    }

    JGoPositionArray getPositions(boolean clearunoccupied, JGoObject skip) {
        if (this.myPositions == null) {
            this.myPositions = new JGoPositionArray();
        }
        if (this.myPositions.isInvalid()) {
            Rectangle rect = this.computeBounds();
            rect.x -= 100;
            rect.y -= 100;
            rect.width += 200;
            rect.height += 200;
            this.myPositions.initialize(rect);
            JGoListPosition pos = this.getFirstObjectPos();
            while (pos != null) {
                JGoObject obj = this.getObjectAtPos(pos);
                pos = this.getNextObjectPosAtTop(pos);
                this.getPositions1(obj, rect, skip);
            }
            this.myPositions.setInvalid(false);
        } else if (clearunoccupied) {
            this.myPositions.setAllUnoccupied(Integer.MAX_VALUE);
        }
        return this.myPositions;
    }

    private void getPositions1(JGoObject obj, Rectangle rect, JGoObject skip) {
        block5: {
            block4: {
                if (obj == skip) {
                    return;
                }
                if (!(obj instanceof JGoSubGraph)) break block4;
                JGoSubGraph sg = (JGoSubGraph)obj;
                JGoListPosition pos = sg.getFirstObjectPos();
                while (pos != null) {
                    JGoObject o = sg.getObjectAtPos(pos);
                    pos = sg.getNextObjectPosAtTop(pos);
                    this.getPositions1(o, rect, skip);
                }
                break block5;
            }
            if (!this.isAvoidable(obj)) break block5;
            rect = this.getAvoidableRectangle(obj, rect);
            int cellx = this.myPositions.getCellSize().width;
            int celly = this.myPositions.getCellSize().height;
            for (int i = rect.x; i <= rect.x + rect.width; i += cellx) {
                for (int j = rect.y; j <= rect.y + rect.height; j += celly) {
                    this.myPositions.setDist(i, j, 0);
                }
            }
        }
    }

    private void invalidatePositionArray(JGoObject obj) {
        this.mySkippedAvoidable = null;
        if (this.myPositions != null && !this.myPositions.isInvalid() && (obj == null || this.isAvoidable(obj))) {
            this.myPositions.setInvalid(true);
        }
    }

    public void setValidCycle(int validCycle) {
        int old = this.myValidCycle;
        if (old != validCycle) {
            this.myValidCycle = validCycle;
            this.fireUpdate(220, 0, null, old, null);
        }
    }

    public int getValidCycle() {
        return this.myValidCycle;
    }

    public static boolean makesDirectedCycleFast(JGoNode a, JGoNode b) {
        if (a == b) {
            return true;
        }
        ArrayList items = b.findAll(16, null);
        Iterator it = items.iterator();
        while (it.hasNext()) {
            JGoNode n = (JGoNode)it.next();
            if (n == b || !JGoDocument.makesDirectedCycleFast(a, n)) continue;
            return true;
        }
        return false;
    }

    public static boolean makesDirectedCycle(JGoNode a, JGoNode b) {
        if (a == b) {
            return true;
        }
        myCycleMap.clear();
        myCycleMap.put(a, null);
        boolean result = JGoDocument.makesDirectedCycle1(a, b, myCycleMap);
        myCycleMap.clear();
        return result;
    }

    private static boolean makesDirectedCycle1(JGoNode a, JGoNode b, HashMap map) {
        if (a == b) {
            return true;
        }
        if (map.containsKey(b)) {
            return false;
        }
        map.put(b, null);
        ArrayList items = b.findAll(16, null);
        Iterator it = items.iterator();
        while (it.hasNext()) {
            JGoNode n = (JGoNode)it.next();
            if (n == b || !JGoDocument.makesDirectedCycle1(a, n, map)) continue;
            return true;
        }
        return false;
    }

    public static boolean makesUndirectedCycle(JGoNode a, JGoNode b) {
        if (a == b) {
            return true;
        }
        myCycleMap.clear();
        myCycleMap.put(a, null);
        boolean result = JGoDocument.makesUndirectedCycle1(a, b, myCycleMap);
        myCycleMap.clear();
        return result;
    }

    private static boolean makesUndirectedCycle1(JGoNode a, JGoNode b, HashMap map) {
        if (a == b) {
            return true;
        }
        if (map.containsKey(b)) {
            return false;
        }
        map.put(b, null);
        ArrayList items = b.findAll(24, null);
        Iterator it = items.iterator();
        while (it.hasNext()) {
            JGoNode n = (JGoNode)it.next();
            if (n == b || !JGoDocument.makesUndirectedCycle1(a, n, map)) continue;
            return true;
        }
        return false;
    }

    public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup) {
        if (svgDoc.JGoXMLOutputEnabled()) {
            DomElement jGoDocElement = svgDoc.createJGoClassElement("com.nwoods.jgo.JGoDocument", jGoElementGroup);
            jGoDocElement.setAttribute("docwidth", Integer.toString(this.myDocumentSize.width));
            jGoDocElement.setAttribute("docheight", Integer.toString(this.myDocumentSize.height));
            jGoDocElement.setAttribute("docleft", Integer.toString(this.myDocumentTopLeft.x));
            jGoDocElement.setAttribute("doctop", Integer.toString(this.myDocumentTopLeft.y));
            if (this.myPaperColor != null) {
                int nRed = this.myPaperColor.getRed();
                int nGreen = this.myPaperColor.getGreen();
                int nBlue = this.myPaperColor.getBlue();
                int nAlpha = this.myPaperColor.getAlpha();
                String sColor = "rgbalpha(" + Integer.toString(nRed) + "," + Integer.toString(nGreen) + "," + Integer.toString(nBlue) + "," + Integer.toString(nAlpha) + ")";
                jGoDocElement.setAttribute("papercolor", sColor);
            }
            jGoDocElement.setAttribute("modifiable", this.myModifiable ? "true" : "false");
            svgDoc.registerReferencingNode(jGoDocElement, "defaultlayer", this.getDefaultLayer());
        }
    }

    public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement) {
        if (jGoChildElement != null) {
            this.myDocumentSize.width = Integer.parseInt(jGoChildElement.getAttribute("docwidth"));
            this.myDocumentSize.height = Integer.parseInt(jGoChildElement.getAttribute("docheight"));
            this.myDocumentTopLeft.x = Integer.parseInt(jGoChildElement.getAttribute("docleft"));
            this.myDocumentTopLeft.y = Integer.parseInt(jGoChildElement.getAttribute("doctop"));
            String sColor = jGoChildElement.getAttribute("papercolor");
            if (sColor.length() > 0 && sColor.startsWith("rgbalpha")) {
                int nAttStart = sColor.indexOf("(") + 1;
                int nAttEnd = sColor.indexOf(",", nAttStart);
                String red = sColor.substring(nAttStart, nAttEnd);
                nAttStart = nAttEnd + 1;
                nAttEnd = sColor.indexOf(",", nAttStart);
                String green = sColor.substring(nAttStart, nAttEnd);
                nAttStart = nAttEnd + 1;
                nAttEnd = sColor.indexOf(",", nAttStart);
                String blue = sColor.substring(nAttStart, nAttEnd);
                nAttStart = nAttEnd + 1;
                nAttEnd = sColor.indexOf(")", nAttStart);
                String alpha = sColor.substring(nAttStart, nAttEnd);
                this.myPaperColor = new Color(Integer.parseInt(red), Integer.parseInt(green), Integer.parseInt(blue), Integer.parseInt(alpha));
            }
            this.myModifiable = jGoChildElement.getAttribute("modifiable").equals("true");
            String defaultLayer = jGoChildElement.getAttribute("defaultlayer");
            svgDoc.registerReferencingObject(this, "defaultlayer", defaultLayer);
        }
        return svgElement.getNextSibling();
    }

    public void SVGUpdateReference(String attr, Object referencedObject) {
        if (attr.equals("defaultlayer")) {
            this.setDefaultLayer((JGoLayer)referencedObject);
        }
    }

    public void SVGWriteLayer(DomDoc svgDoc, DomElement jGoElementGroup, JGoLayer layer) {
        if (svgDoc.JGoXMLOutputEnabled()) {
            DomElement jGoLayer = svgDoc.createJGoClassElement("com.nwoods.jgo.JGoLayer", jGoElementGroup);
            jGoLayer.setAttribute("visible", layer.myVisible ? "true" : "false");
            jGoLayer.setAttribute("transparency", new Float(layer.myTransparency).toString());
            jGoLayer.setAttribute("modifiable", layer.myModifiable ? "true" : "false");
            if (layer.myIdentifier instanceof String) {
                jGoLayer.setAttribute("idtype", "string");
                jGoLayer.setAttribute("identifier", (String)layer.myIdentifier);
            } else if (layer.myIdentifier instanceof Integer) {
                jGoLayer.setAttribute("idtype", "integer");
                jGoLayer.setAttribute("identifier", ((Integer)layer.myIdentifier).toString());
            }
            svgDoc.registerObject(this, jGoLayer);
        }
        JGoListPosition pos = layer.getFirstObjectPos();
        while (pos != null) {
            JGoObject obj = layer.getObjectAtPos(pos);
            pos = layer.getNextObjectPosAtTop(pos);
            try {
                svgDoc.setDisabledDrawing(false);
                DomElement subGroup = jGoElementGroup;
                if (svgDoc.JGoXMLOutputEnabled() || svgDoc.SVGOutputEnabled()) {
                    subGroup = svgDoc.createElement("g");
                    jGoElementGroup.appendChild(subGroup);
                }
                obj.SVGWriteObject(svgDoc, subGroup);
            }
            catch (Exception e) {}
        }
    }

    public DomNode SVGReadLayer(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement, JGoLayer layer) {
        if (jGoChildElement != null) {
            layer.myVisible = jGoChildElement.getAttribute("visible").equals("true");
            layer.myTransparency = new Float(jGoChildElement.getAttribute("transparency")).floatValue();
            layer.myModifiable = jGoChildElement.getAttribute("modifiable").equals("true");
            if (jGoChildElement.getAttribute("idtype").equals("string")) {
                layer.myIdentifier = jGoChildElement.getAttribute("identifier");
            } else if (jGoChildElement.getAttribute("idtype").equals("integer")) {
                layer.myIdentifier = new Integer(jGoChildElement.getAttribute("identifier"));
            }
            svgDoc.SVGTraverseChildren(jGoDoc, svgElement, null, true);
            return svgElement.getNextSibling();
        }
        return svgElement.getNextSibling();
    }
}

