/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javahl;

import org.tigris.subversion.javahl.Lock;
import org.tigris.subversion.javahl.Notify2;
import org.tigris.subversion.javahl.NotifyInformation;
import org.tigris.subversion.svnclientadapter.SVNNotificationHandler;
import org.tigris.subversion.svnclientadapter.javahl.JhlConverter;
import org.tigris.subversion.svnclientadapter.utils.Messages;

public class JhlNotificationHandler
extends SVNNotificationHandler
implements Notify2 {
    private boolean receivedSomeChange;
    private boolean sentFirstTxdelta;
    private int updates;
    private int adds;
    private int deletes;
    private int conflicts;
    private int merges;
    private int exists;
    private int propConflicts;
    private int propMerges;
    private int propUpdates;
    private boolean inExternal;
    private boolean holdStats;
    private String lastUpdate;
    private String lastExternalUpdate;
    private static final int COMMIT_ACROSS_WC_COMPLETED = -11;
    private static final int ENDED_ABNORMAL = -1;

    public void onNotify(NotifyInformation info) {
        this.onNotify(info.getPath(), info.getAction(), info.getKind(), info.getMimeType(), info.getContentState(), info.getPropState(), info.getRevision(), info.getLock(), info.getErrMsg());
    }

    private void onNotify(String path, int action, int kind, String mimeType, int contentState, int propState, long revision, Lock lock, String errorMsg) {
        boolean notify = true;
        switch (action) {
            case -1: {
                if (this.command == 3) {
                    this.logError(Messages.bind("notify.commit.abnormal"));
                } else {
                    this.logError(Messages.bind("notify.end.abnormal"));
                }
                if (errorMsg != null) {
                    this.logError(errorMsg);
                }
                notify = false;
                break;
            }
            case 7: {
                this.logMessage(Messages.bind("notify.skipped", path));
                notify = false;
                break;
            }
            case 23: {
                if (errorMsg == null) {
                    this.logError(Messages.bind("notify.lock.failed", path));
                } else {
                    this.logError(errorMsg);
                }
                notify = false;
                break;
            }
            case 24: {
                if (errorMsg == null) {
                    this.logError(Messages.bind("notify.unlock.failed", path));
                } else {
                    this.logError(errorMsg);
                }
                notify = false;
                break;
            }
            case 21: {
                if (lock != null && lock.getOwner() != null) {
                    this.logMessage(Messages.bind("notify.lock.other", lock.getPath(), lock.getOwner()));
                } else {
                    this.logMessage(Messages.bind("notify.lock", path));
                }
                notify = false;
                break;
            }
            case 22: {
                this.logMessage(Messages.bind("notify.unlock", path));
                notify = false;
                break;
            }
            case 8: {
                this.logMessage("D  " + path);
                this.receivedSomeChange = true;
                ++this.deletes;
                break;
            }
            case 9: {
                this.logMessage("A  " + path);
                this.receivedSomeChange = true;
                ++this.adds;
                break;
            }
            case 25: {
                this.logMessage("E  " + path);
                this.receivedSomeChange = true;
                ++this.exists;
                break;
            }
            case 3: {
                this.logMessage(Messages.bind("notify.restored", path));
                break;
            }
            case 4: {
                this.logMessage(Messages.bind("notify.reverted", path));
                break;
            }
            case 5: {
                this.logError(Messages.bind("notify.revert.failed", path));
                notify = false;
                break;
            }
            case 6: {
                this.logMessage(Messages.bind("notify.resolved", path));
                break;
            }
            case 0: {
                this.logMessage("A         " + path);
                break;
            }
            case 2: {
                this.logMessage("D         " + path);
                this.receivedSomeChange = true;
                break;
            }
            case 10: {
                boolean error = false;
                if (kind == 2 && (propState == 0 || propState == 1 || propState == 2)) break;
                this.receivedSomeChange = true;
                char[] statecharBuf = new char[]{' ', ' '};
                if (kind == 1) {
                    if (contentState == 7) {
                        statecharBuf[0] = 67;
                        ++this.conflicts;
                        error = true;
                    } else if (contentState == 6) {
                        statecharBuf[0] = 71;
                        ++this.merges;
                        error = true;
                    } else if (contentState == 5) {
                        statecharBuf[0] = 85;
                        ++this.updates;
                    } else if (contentState == 2 && this.command == 27 && propState < 4) break;
                }
                if (propState == 7) {
                    statecharBuf[1] = 67;
                    ++this.propConflicts;
                    error = true;
                } else if (propState == 6) {
                    statecharBuf[1] = 71;
                    ++this.propMerges;
                    error = true;
                } else if (propState == 5) {
                    statecharBuf[1] = 85;
                    ++this.propUpdates;
                }
                if (error) {
                    this.logError("" + statecharBuf[0] + statecharBuf[1] + " " + path);
                    break;
                }
                this.logMessage("" + statecharBuf[0] + statecharBuf[1] + " " + path);
                break;
            }
            case 12: {
                this.logMessage(Messages.bind("notify.update.external", path));
                this.inExternal = true;
                break;
            }
            case 11: {
                notify = false;
                if (revision >= 0L) {
                    this.logRevision(revision, path);
                    if (this.command == 8) {
                        this.logCompleted(Messages.bind("notify.export", Long.toString(revision)));
                        break;
                    }
                    if (this.command == 2) {
                        this.logCompleted(Messages.bind("notify.checkout", Long.toString(revision)));
                        break;
                    }
                    if (this.receivedSomeChange) {
                        if (this.holdStats) {
                            if (this.inExternal) {
                                this.lastExternalUpdate = Messages.bind("notify.update", Long.toString(revision));
                                break;
                            }
                            this.lastUpdate = Messages.bind("notify.update", Long.toString(revision));
                            break;
                        }
                        this.logCompleted(Messages.bind("notify.update", Long.toString(revision)));
                        break;
                    }
                    this.logCompleted(Messages.bind("notify.at", Long.toString(revision)));
                    break;
                }
                if (this.command == 8) {
                    this.logCompleted(Messages.bind("notify.export.complete"));
                    break;
                }
                if (this.command == 2) {
                    this.logCompleted(Messages.bind("notify.checkout.complete"));
                    break;
                }
                this.logCompleted(Messages.bind("notify.update.complete"));
                break;
            }
            case 14: {
                if (!this.skipCommand()) {
                    this.logMessage(Messages.bind("notify.status.external", path));
                }
                notify = false;
                break;
            }
            case 13: {
                notify = false;
                if (revision < 0L) break;
                this.logRevision(revision, path);
                if (this.skipCommand()) break;
                this.logMessage(Messages.bind("notify.status.revision", Long.toString(revision)));
                break;
            }
            case 15: {
                this.logMessage(Messages.bind("notify.commit.modified", path));
                break;
            }
            case 16: {
                this.logMessage(Messages.bind("notify.commit.add", path));
                break;
            }
            case 17: {
                this.logMessage(Messages.bind("notify.commit.delete", path));
                break;
            }
            case 18: {
                this.logMessage(Messages.bind("notify.commit.replace", path));
                break;
            }
            case 19: {
                notify = false;
                if (this.sentFirstTxdelta) break;
                this.logMessage(Messages.bind("notify.commit.transmit"));
                this.sentFirstTxdelta = true;
                break;
            }
            case -11: {
                notify = false;
                this.logCompleted(Messages.bind("notify.commit", Long.toString(revision)));
            }
        }
        if (notify) {
            this.notifyListenersOfChange(path, JhlConverter.convertNodeKind(kind));
        }
    }

    public void setCommand(int command) {
        this.receivedSomeChange = false;
        this.sentFirstTxdelta = false;
        this.clearStats();
        super.setCommand(command);
    }

    public void logCompleted(String message) {
        super.logCompleted(message);
        if (this.inExternal) {
            this.inExternal = false;
        } else {
            this.logStats();
        }
    }

    private void clearStats() {
        this.adds = 0;
        this.updates = 0;
        this.deletes = 0;
        this.conflicts = 0;
        this.merges = 0;
        this.exists = 0;
        this.propConflicts = 0;
        this.propMerges = 0;
        this.propUpdates = 0;
        this.inExternal = false;
        this.holdStats = false;
        this.lastUpdate = null;
        this.lastExternalUpdate = null;
    }

    private void logStats() {
        if (this.holdStats) {
            return;
        }
        if (this.command == 4 || this.command == 27 || this.command == 26) {
            if (this.fileStats()) {
                this.logMessage(Messages.bind("notify.stats.file.head"));
                if (this.conflicts > 0) {
                    this.logMessage(Messages.bind("notify.stats.conflict", Integer.toString(this.conflicts)));
                }
                if (this.merges > 0) {
                    this.logMessage(Messages.bind("notify.stats.merge", Integer.toString(this.merges)));
                }
                if (this.deletes > 0) {
                    this.logMessage(Messages.bind("notify.stats.delete", Integer.toString(this.deletes)));
                }
                if (this.adds > 0) {
                    this.logMessage(Messages.bind("notify.stats.add", Integer.toString(this.adds)));
                }
                if (this.updates > 0) {
                    this.logMessage(Messages.bind("notify.stats.update", Integer.toString(this.updates)));
                }
                if (this.exists > 0) {
                    this.logMessage(Messages.bind("notify.stats.exists", Integer.toString(this.exists)));
                }
            }
            if (this.propStats()) {
                this.logMessage(Messages.bind("notify.stats.prop.head"));
                if (this.propConflicts > 0) {
                    this.logMessage(Messages.bind("notify.stats.conflict", Integer.toString(this.propConflicts)));
                }
                if (this.propMerges > 0) {
                    this.logMessage(Messages.bind("notify.stats.merge", Integer.toString(this.propMerges)));
                }
                if (this.propUpdates > 0) {
                    this.logMessage(Messages.bind("notify.stats.update", Integer.toString(this.propUpdates)));
                }
            }
        }
        this.clearStats();
    }

    private boolean fileStats() {
        return this.updates > 0 || this.adds > 0 || this.deletes > 0 || this.conflicts > 0 || this.merges > 0 || this.exists > 0;
    }

    private boolean propStats() {
        return this.propUpdates > 0 || this.propConflicts > 0 || this.propMerges > 0;
    }

    public void holdStats() {
        this.holdStats = true;
    }

    public void releaseStats() {
        this.holdStats = false;
        if (this.command == 4) {
            if (this.lastExternalUpdate != null) {
                this.logCompleted(this.lastExternalUpdate);
            }
            if (this.lastUpdate != null) {
                this.logCompleted(this.lastUpdate);
            }
        }
        this.logStats();
    }
}

