/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.commandline.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

class SvnActionRE {
    public static final String PATH = "path";
    public static final String CONTENTSTATE = "contentState";
    public static final String PROPSTATE = "propState";
    public static final String REVISION = "revision";
    private Pattern pattern;
    private Matcher matcher;
    private int action;
    private int contentStatus = 1;
    private int propStatus = 1;
    private String[] notificationProperties;

    public SvnActionRE(String re, int action, String[] notificationProperties) {
        this.pattern = Pattern.compile('^' + re + '$');
        this.action = action;
        this.notificationProperties = notificationProperties;
    }

    public SvnActionRE(String re, int action, String notificationProperty) {
        this.pattern = Pattern.compile('^' + re + '$');
        this.action = action;
        this.notificationProperties = new String[]{notificationProperty};
    }

    public SvnActionRE(String re, int action) {
        this.pattern = Pattern.compile('^' + re + '$');
        this.action = action;
        this.notificationProperties = new String[0];
    }

    public SvnActionRE(String re, int action, int contentStatus, int propStatus) {
        this(re, action);
        this.contentStatus = contentStatus;
        this.propStatus = propStatus;
    }

    public SvnActionRE(String re, int action, int contentStatus, String[] notificationProperties) {
        this(re, action, notificationProperties);
        this.contentStatus = contentStatus;
    }

    public SvnActionRE(String re, int action, int contentStatus, int propStatus, String[] notificationProperties) {
        this(re, action, notificationProperties);
        this.contentStatus = contentStatus;
        this.propStatus = propStatus;
    }

    public int getAction() {
        return this.action;
    }

    private int getIndex(String notificationProperty) {
        for (int i = 0; i < this.notificationProperties.length; ++i) {
            if (!this.notificationProperties[i].equals(notificationProperty)) continue;
            return i;
        }
        return -1;
    }

    public boolean match(String line) {
        this.matcher = this.pattern.matcher(line);
        return this.matcher.matches();
    }

    public String getPath() {
        int index = this.getIndex(PATH);
        if (index == -1) {
            return null;
        }
        return this.matcher.group(index + 1);
    }

    private int getStatus(char statusChar) {
        if (statusChar == ' ') {
            return 2;
        }
        if (statusChar == 'C') {
            return 7;
        }
        if (statusChar == 'G') {
            return 6;
        }
        if (statusChar == 'U') {
            return 5;
        }
        return 1;
    }

    public int getContentState() {
        if (this.contentStatus != 1) {
            return this.contentStatus;
        }
        int index = this.getIndex(CONTENTSTATE);
        if (index == -1) {
            return 1;
        }
        String stateChar = this.matcher.group(index + 1);
        return this.getStatus(stateChar.charAt(0));
    }

    public int getPropStatus() {
        if (this.propStatus != 1) {
            return this.propStatus;
        }
        int index = this.getIndex(PROPSTATE);
        if (index == -1) {
            return 1;
        }
        String stateChar = this.matcher.group(index + 1);
        return this.getStatus(stateChar.charAt(0));
    }

    public long getRevision() {
        int index = this.getIndex(REVISION);
        if (index == -1) {
            return -1L;
        }
        String revisionString = this.matcher.group(index + 1);
        return Long.parseLong(revisionString);
    }
}

