/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.platform;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;

public class GZIPSupport {
    public static final String HTTP_ACCEPT_ENCODING = "Accept-Encoding";
    static final String HTTP_GZIP_ENCODING = "gzip";

    public static InputStream openHandleGZIP(String svgURI) throws IOException {
        try {
            URL svgURL = new URL(svgURI);
            URLConnection svgURLConnection = svgURL.openConnection();
            GZIPSupport.setupHttpEncoding(svgURLConnection);
            return svgURLConnection.getInputStream();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    static void setupHttpEncoding(URLConnection svgURLConnection) throws IOException {
        if (svgURLConnection instanceof HttpURLConnection) {
            HttpURLConnection httpC = (HttpURLConnection)svgURLConnection;
            String encodings = httpC.getRequestProperty(HTTP_ACCEPT_ENCODING);
            if (encodings == null) {
                encodings = "";
            }
            if (encodings.trim().length() > 0) {
                encodings = encodings + ",";
            }
            encodings = encodings + HTTP_GZIP_ENCODING;
            httpC.setRequestProperty(HTTP_ACCEPT_ENCODING, encodings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream handleGZIP(InputStream is) throws IOException {
        if (!is.markSupported()) {
            is = new BufferedInputStream(is);
        }
        int magicIn = 0;
        try {
            is.mark(2);
            magicIn = 0xFFFF & (is.read() | is.read() << 8);
        }
        catch (IOException ex) {
            is.reset();
            InputStream inputStream = is;
            return inputStream;
        }
        finally {
            try {
                is.reset();
            }
            catch (IOException ioe) {
                throw new Error();
            }
        }
        if (magicIn == 35615) {
            return new GZIPInputStream(is);
        }
        return is;
    }
}

