/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.Box;
import com.sun.perseus.j2d.Path;
import com.sun.perseus.j2d.RenderGraphics;
import com.sun.perseus.j2d.Transform;
import com.sun.perseus.model.ConditionalProcessing;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNodeProxy;
import com.sun.perseus.model.ModelEvent;
import com.sun.perseus.model.UpdateListener;
import org.w3c.dom.DOMException;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGMatrix;

public abstract class ModelNode
implements EventTarget {
    protected final Transform IDENTITY = new Transform(null);
    protected ModelNode parent;
    protected ModelNode nextSibling;
    protected ModelNode prevSibling;
    public static final int CAN_RENDER_RENDERABLE_MASK = -2;
    public static final int CAN_RENDER_REQUIRED_FEATURES_MASK = -3;
    public static final int CAN_RENDER_REQUIRED_EXTENSIONS_MASK = -5;
    public static final int CAN_RENDER_SYSTEM_LANGUAGE_MASK = -9;
    public static final int CAN_RENDER_CONDITIONS_MET_MASK = -15;
    public static final int CAN_RENDER_PROXY_BITS_MASK = 2030;
    public static final int CAN_RENDER_NON_INVERTIBLE_TXF_MASK = -17;
    public static final int CAN_RENDER_DISPLAY_MASK = -33;
    public static final int CAN_RENDER_ZERO_WIDTH_MASK = -65;
    public static final int CAN_RENDER_ZERO_HEIGHT_MASK = -129;
    public static final int CAN_RENDER_EMPTY_VIEWBOX_MASK = -257;
    public static final int CAN_RENDER_EMPTY_PATH_MASK = -513;
    public static final int CAN_RENDER_ZERO_FONT_SIZE_MASK = -1025;
    public static final int CAN_RENDER_IN_DOCUMENT_TREE_MASK = -2049;
    public static final int CAN_RENDER_PARENT_STATE_MASK = -4097;
    public static final int CAN_RENDER_RENDERABLE_BIT = 1;
    public static final int CAN_RENDER_REQUIRED_FEATURES_BIT = 2;
    public static final int CAN_RENDER_REQUIRED_EXTENSIONS_BIT = 4;
    public static final int CAN_RENDER_SYSTEM_LANGUAGE_BIT = 8;
    public static final int CAN_RENDER_CONDITIONS_MET_BITS = 14;
    public static final int CAN_RENDER_NON_INVERTIBLE_TXF_BIT = 16;
    public static final int CAN_RENDER_DISPLAY_BIT = 32;
    public static final int CAN_RENDER_ZERO_WIDTH_BIT = 64;
    public static final int CAN_RENDER_ZERO_HEIGHT_BIT = 128;
    public static final int CAN_RENDER_EMPTY_VIEWBOX_BIT = 256;
    public static final int CAN_RENDER_EMPTY_PATH_BIT = 512;
    public static final int CAN_RENDER_ZERO_FONT_SIZE_BIT = 1024;
    public static final int CAN_RENDER_IN_DOCUMENT_TREE_BIT = 2048;
    public static final int CAN_RENDER_PARENT_STATE_BIT = 4096;
    protected int canRenderState = 2049;
    protected boolean loaded = true;
    protected DocumentNode ownerDocument;

    protected boolean contributeBBox() {
        return false;
    }

    protected UpdateListener getUpdateListener() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getUpdateListener();
    }

    public ModelNode getNextSiblingNode() {
        return this.nextSibling;
    }

    public ModelNode getPreviousSiblingNode() {
        return this.prevSibling;
    }

    public ModelNode getParent() {
        return this.parent;
    }

    protected void setParent(ModelNode newParent) {
        this.modifyingNode();
        this.setParentQuiet(newParent);
        ModelNode.nodeInserted(this);
    }

    protected void setParentQuiet(ModelNode newParent) {
        if (this.parent == newParent) {
            return;
        }
        if (this.parent != null) {
            this.onUnhookedFromDocumentTree();
        }
        this.parent = newParent;
        if (this.parent != null && this.parent.isInDocumentTree()) {
            this.onHookedInDocumentTree();
        }
    }

    protected final void unhookQuiet(ModelNode node) {
        if (node != null && node.prevSibling != null) {
            node.prevSibling.nextSibling = null;
        }
        while (node != null) {
            node.setParentQuiet(null);
            if (node instanceof ElementNodeProxy) {
                ((ElementNodeProxy)node).setProxied(null);
            }
            node.unhookChildrenQuiet();
            node.unhookExpandedQuiet();
            node = node.nextSibling;
        }
    }

    protected boolean isInDocumentTree() {
        return (this.canRenderState & 0x800) == 0;
    }

    public DocumentNode getOwnerDocument() {
        return this.ownerDocument;
    }

    public boolean hasDescendants() {
        return this.getFirstChildNode() != null;
    }

    static void paint(ModelNode node, RenderGraphics rg) {
        while (node != null) {
            node.paint(rg);
            node = node.nextSibling;
        }
    }

    protected final Object getInheritedPropertyState(int propertyIndex) {
        if (this.parent == null) {
            return this.ownerDocument.getInitialPropertyState(propertyIndex);
        }
        return this.parent.getPropertyState(propertyIndex);
    }

    protected final float getInheritedFloatPropertyState(int propertyIndex) {
        if (this.parent == null) {
            return this.ownerDocument.getInitialFloatPropertyState(propertyIndex);
        }
        return this.parent.getFloatPropertyState(propertyIndex);
    }

    protected final int getInheritedPackedPropertyState(int propertyIndex) {
        if (this.parent == null) {
            return this.ownerDocument.getInitialPackedPropertyState(propertyIndex);
        }
        return this.parent.getPackedPropertyState(propertyIndex);
    }

    protected Object getPropertyState(int propertyIndex) {
        return this.ownerDocument.getInitialPropertyState(propertyIndex);
    }

    protected int getPackedPropertyState(int propertyIndex) {
        return this.ownerDocument.getInitialPackedPropertyState(propertyIndex);
    }

    protected float getFloatPropertyState(int propertyIndex) {
        return this.ownerDocument.getInitialFloatPropertyState(propertyIndex);
    }

    protected void setPropertyState(int propertyIndex, Object propertyValue) {
    }

    protected void setFloatPropertyState(int propertyIndex, float propertyValue) {
    }

    protected void setPackedPropertyState(int propertyIndex, int propertyValue) {
    }

    protected boolean isPropertyState(int propertyIndex, Object propertyValue) {
        return true;
    }

    protected boolean isFloatPropertyState(int propertyIndex, float propertyValue) {
        return true;
    }

    protected boolean isPackedPropertyState(int propertyIndex, int propertyValue) {
        return true;
    }

    protected void recomputePropertyState(int propertyIndex, Object parentPropertyValue) {
        this.propagatePropertyState(propertyIndex, parentPropertyValue);
    }

    protected void recomputeFloatPropertyState(int propertyIndex, float parentPropertyValue) {
        this.propagateFloatPropertyState(propertyIndex, parentPropertyValue);
    }

    protected void recomputePackedPropertyState(int propertyIndex, int parentPropertyValue) {
        this.propagatePackedPropertyState(propertyIndex, parentPropertyValue);
    }

    void recomputeInheritedProperties() {
        ModelNode c = this.getFirstChildNode();
        while (c != null) {
            c.recomputeInheritedProperties();
            c = c.nextSibling;
        }
    }

    protected void propagateCanRenderState(int oldCanRenderState, int newCanRenderState) {
        block6: {
            if (oldCanRenderState == newCanRenderState || oldCanRenderState != 0 && newCanRenderState != 0) break block6;
            if (newCanRenderState == 0) {
                ModelNode node = this.getFirstChildNode();
                boolean nodeDisplay = false;
                int nodeOldState = 0;
                while (node != null) {
                    nodeOldState = node.canRenderState;
                    node.canRenderState &= 0xFFFFEFFF;
                    node.propagateCanRenderState(nodeOldState, node.canRenderState);
                    node = node.nextSibling;
                }
                node = this.getFirstComputedExpandedChild();
                while (node != null) {
                    nodeOldState = node.canRenderState;
                    node.canRenderState &= 0xFFFFEFFF;
                    node.propagateCanRenderState(nodeOldState, node.canRenderState);
                    node = node.nextSibling;
                }
            } else {
                ModelNode node = this.getFirstChildNode();
                boolean nodeDisplay = false;
                int nodeOldState = 0;
                while (node != null) {
                    nodeOldState = node.canRenderState;
                    node.canRenderState |= 0x1000;
                    node.propagateCanRenderState(nodeOldState, node.canRenderState);
                    node = node.nextSibling;
                }
                node = this.getFirstComputedExpandedChild();
                while (node != null) {
                    nodeOldState = node.canRenderState;
                    node.canRenderState |= 0x1000;
                    node.propagateCanRenderState(nodeOldState, node.canRenderState);
                    node = node.nextSibling;
                }
            }
        }
    }

    protected void propagatePropertyState(int propertyIndex, Object parentPropertyValue) {
        ModelNode node = this.getFirstChildNode();
        while (node != null) {
            node.recomputePropertyState(propertyIndex, parentPropertyValue);
            node = node.nextSibling;
        }
        node = this.getFirstExpandedChild();
        while (node != null) {
            node.recomputePropertyState(propertyIndex, parentPropertyValue);
            node = node.nextSibling;
        }
    }

    protected void propagateFloatPropertyState(int propertyIndex, float parentPropertyValue) {
        ModelNode node = this.getFirstChildNode();
        while (node != null) {
            node.recomputeFloatPropertyState(propertyIndex, parentPropertyValue);
            node = node.nextSibling;
        }
        node = this.getFirstExpandedChild();
        while (node != null) {
            node.recomputeFloatPropertyState(propertyIndex, parentPropertyValue);
            node = node.nextSibling;
        }
    }

    protected void propagatePackedPropertyState(int propertyIndex, int parentPropertyValue) {
        ModelNode node = this.getFirstChildNode();
        while (node != null) {
            node.recomputePackedPropertyState(propertyIndex, parentPropertyValue);
            node = node.nextSibling;
        }
        node = this.getFirstExpandedChild();
        while (node != null) {
            node.recomputePackedPropertyState(propertyIndex, parentPropertyValue);
            node = node.nextSibling;
        }
    }

    public Transform getTransformState() {
        if (this.parent != null) {
            return this.parent.getTransformState();
        }
        return this.IDENTITY;
    }

    Transform getInverseTransformState() {
        if (this.parent != null) {
            return this.parent.getInverseTransformState();
        }
        return this.IDENTITY;
    }

    protected void recomputeTransformState() {
        if (this.parent == null) {
            this.recomputeTransformState(new Transform(null));
        } else {
            this.recomputeTransformState(this.parent.getTransformState());
        }
    }

    protected void recomputeTransformState(Transform parentTransform) {
        this.recomputeTransformState(this.getTransformState(), this.getFirstChildNode());
        this.recomputeTransformState(this.getTransformState(), this.getFirstExpandedChild());
        this.computeCanRenderTransformBit(this.getTransformState());
    }

    void recomputeTransformState(Transform parentTransform, ModelNode node) {
        while (node != null) {
            node.recomputeTransformState(parentTransform);
            node = node.nextSibling;
        }
    }

    boolean inDocumentTree() {
        return this.parent != null && this.parent.inDocumentTree();
    }

    public SVGMatrix getScreenCTM() {
        if (!this.inDocumentTree()) {
            return null;
        }
        return new Transform(this.getTransformState());
    }

    protected final Transform recycleTransform(Transform tx, Transform workTx) {
        if (workTx != null && workTx != tx) {
            workTx.setTransform(tx);
            return workTx;
        }
        return new Transform(tx);
    }

    protected Transform appendTransform(Transform tx, Transform workTx) {
        return tx;
    }

    Box addBBox(Box bbox, Transform t) {
        return bbox;
    }

    static Box addShapeBBox(Box bbox, Path path, Transform t) {
        if (path == null || path.getNumberOfSegments() == 0) {
            return bbox;
        }
        Box b = null;
        b = t == null ? path.getBounds() : path.getTransformedBounds(t);
        return ModelNode.addBBox(bbox, b.getX(), b.getY(), b.getWidth(), b.getHeight());
    }

    static Box addBBox(Box bbox, float x, float y, float width, float height) {
        if (bbox == null) {
            bbox = new Box(x, y, width, height);
            return bbox;
        }
        bbox.width = bbox.x + bbox.width;
        bbox.height = bbox.y + bbox.height;
        if (bbox.x > x) {
            bbox.x = x;
        }
        if (bbox.y > y) {
            bbox.y = y;
        }
        if (bbox.width < x + width) {
            bbox.width = x + width;
        }
        if (bbox.height < y + height) {
            bbox.height = y + height;
        }
        bbox.width -= bbox.x;
        bbox.height -= bbox.y;
        return bbox;
    }

    static Box addTransformedBBox(Box bbox, float x, float y, float width, float height, Transform m) {
        if (m == null) {
            return ModelNode.addBBox(bbox, x, y, width, height);
        }
        float tx = m.getComponent(0) * x + m.getComponent(2) * y + m.getComponent(4);
        float ty = m.getComponent(1) * x + m.getComponent(3) * y + m.getComponent(5);
        float dx1 = m.getComponent(0) * width;
        float dy1 = m.getComponent(1) * width;
        float dx2 = m.getComponent(2) * height;
        float dy2 = m.getComponent(3) * height;
        if (dx1 < 0.0f) {
            tx += dx1;
            dx1 = -dx1;
        }
        if (dx2 > 0.0f) {
            dx1 += dx2;
        } else {
            dx1 -= dx2;
            tx += dx2;
        }
        if (dy1 < 0.0f) {
            ty += dy1;
            dy1 = -dy1;
        }
        if (dy2 > 0.0f) {
            dy1 += dy2;
        } else {
            dy1 -= dy2;
            ty += dy2;
        }
        return ModelNode.addBBox(bbox, tx, ty, dx1, dy1);
    }

    Box addNodeBBox(Box bbox, Transform t) {
        return bbox;
    }

    public ModelNode nodeHitAt(float[] pt) {
        return null;
    }

    protected final ModelNode nodeHitAt(ModelNode node, float[] pt) {
        ModelNode hit = null;
        while (node != null) {
            hit = node.nodeHitAt(pt);
            if (hit != null) {
                return hit;
            }
            node = node.prevSibling;
        }
        return null;
    }

    protected String getURIBase() {
        if (this.parent != null) {
            return this.parent.getURIBase();
        }
        return null;
    }

    final void computeCanRenderRequiredFeaturesBit(String[] requiredFeatures) {
        int oldCanRenderState = this.canRenderState;
        this.canRenderState = requiredFeatures == null || ConditionalProcessing.checkFeatures(requiredFeatures) ? (this.canRenderState &= 0xFFFFFFFD) : (this.canRenderState |= 2);
        this.propagateCanRenderState(oldCanRenderState, this.canRenderState);
    }

    final void computeCanRenderRequiredExtensionsBit(String[] requiredExtensions) {
        int oldCanRenderState = this.canRenderState;
        this.canRenderState = requiredExtensions == null || ConditionalProcessing.checkExtensions(requiredExtensions) ? (this.canRenderState &= 0xFFFFFFFB) : (this.canRenderState |= 4);
        this.propagateCanRenderState(oldCanRenderState, this.canRenderState);
    }

    final void computeCanRenderSystemLanguageBit(String[] systemLanguage) {
        int oldCanRenderState = this.canRenderState;
        this.canRenderState = systemLanguage == null || ConditionalProcessing.checkLanguage(systemLanguage) ? (this.canRenderState &= 0xFFFFFFF7) : (this.canRenderState |= 8);
        this.propagateCanRenderState(oldCanRenderState, this.canRenderState);
    }

    final void computeCanRenderTransformBit(Transform transform) {
        int oldCanRenderState = this.canRenderState;
        this.canRenderState = transform == null || transform.isInvertible() ? (this.canRenderState &= 0xFFFFFFEF) : (this.canRenderState |= 0x10);
        this.propagateCanRenderState(oldCanRenderState, this.canRenderState);
    }

    final void computeCanRenderEmptyViewBoxBit(float[][] viewBox) {
        int oldCanRenderState = this.canRenderState;
        this.canRenderState = viewBox == null || viewBox[1][0] > 0.0f && viewBox[2][0] > 0.0f ? (this.canRenderState &= 0xFFFFFEFF) : (this.canRenderState |= 0x100);
        this.propagateCanRenderState(oldCanRenderState, this.canRenderState);
    }

    final void computeCanRenderDisplayBit(boolean display) {
        int oldCanRenderState = this.canRenderState;
        this.canRenderState = display ? (this.canRenderState &= 0xFFFFFFDF) : (this.canRenderState |= 0x20);
        this.propagateCanRenderState(oldCanRenderState, this.canRenderState);
    }

    final void computeCanRenderWidthBit(float width) {
        int oldCanRenderState = this.canRenderState;
        this.canRenderState = width > 0.0f ? (this.canRenderState &= 0xFFFFFFBF) : (this.canRenderState |= 0x40);
        this.propagateCanRenderState(oldCanRenderState, this.canRenderState);
    }

    final void computeCanRenderHeightBit(float height) {
        int oldCanRenderState = this.canRenderState;
        this.canRenderState = height > 0.0f ? (this.canRenderState &= 0xFFFFFF7F) : (this.canRenderState |= 0x80);
        this.propagateCanRenderState(oldCanRenderState, this.canRenderState);
    }

    final void computeCanRenderFontSizeBit(float fontSize) {
        int oldCanRenderState = this.canRenderState;
        this.canRenderState = fontSize > 0.0f ? (this.canRenderState &= 0xFFFFFBFF) : (this.canRenderState |= 0x400);
        this.propagateCanRenderState(oldCanRenderState, this.canRenderState);
    }

    final void computeCanRenderEmptyPathBit(Path path) {
        int oldCanRenderState = this.canRenderState;
        this.canRenderState = path == null || path.getNumberOfSegments() == 0 ? (this.canRenderState |= 0x200) : (this.canRenderState &= 0xFFFFFDFF);
        this.propagateCanRenderState(oldCanRenderState, this.canRenderState);
    }

    protected boolean hasNodeRendering() {
        return false;
    }

    protected abstract void clearLayouts();

    void clearLayouts(ModelNode node) {
        while (node != null) {
            node.clearLayouts();
            node = node.nextSibling;
        }
    }

    public final boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean isLoaded) {
        this.loaded = isLoaded;
    }

    boolean getPaintNeedsLoad() {
        return false;
    }

    protected void modifyingNode() {
        UpdateListener updateListener = this.getUpdateListener();
        if (updateListener != null) {
            updateListener.modifyingNode(this);
        }
    }

    protected void modifyingNodeRendering() {
        UpdateListener updateListener = this.getUpdateListener();
        if (updateListener != null) {
            updateListener.modifyingNodeRendering(this);
        }
    }

    protected void modifiedNode() {
        UpdateListener updateListener = this.getUpdateListener();
        if (updateListener != null) {
            updateListener.modifiedNode(this);
        }
    }

    protected static void nodeInserted(ModelNode node) {
        UpdateListener updateListener = node.getUpdateListener();
        if (updateListener != null) {
            updateListener.nodeInserted(node);
        }
    }

    public void addEventListener(String type, EventListener listener, boolean useCapture) throws DOMException {
        this.ownerDocument.eventSupport.addEventListener(this, type, useCapture ? 0 : 1, listener);
    }

    public void removeEventListener(String type, EventListener listener, boolean useCapture) throws DOMException {
        this.ownerDocument.eventSupport.removeEventListener(this, type, useCapture ? 0 : 1, listener);
    }

    public void dispatchEvent(ModelEvent evt) {
        this.ownerDocument.eventSupport.dispatchEvent(evt);
    }

    void onHookedInDocumentTree() {
        int oldCanRenderState = this.canRenderState;
        this.canRenderState &= 0xFFFFF7FF;
        this.canRenderState = this.parent.canRenderState == 0 ? (this.canRenderState &= 0xFFFFEFFF) : (this.canRenderState |= 0x1000);
        this.propagateCanRenderState(oldCanRenderState, this.canRenderState);
        this.recomputeTransformState();
        this.recomputeInheritedProperties();
    }

    void onUnhookedFromDocumentTree() {
        int oldCanRenderState = this.canRenderState;
        this.canRenderState |= 0x800;
        this.canRenderState &= 0xFFFFEFFF;
        this.propagateCanRenderState(oldCanRenderState, this.canRenderState);
        this.recomputeTransformState();
        this.recomputeInheritedProperties();
    }

    public void paint(RenderGraphics rg) {
    }

    protected void nodeRendered() {
    }

    protected abstract void unhookChildrenQuiet();

    protected abstract void unhookExpandedQuiet();

    public abstract ModelNode getFirstChildNode();

    public abstract ModelNode getLastChildNode();

    abstract ModelNode getFirstExpandedChild();

    abstract ModelNode getFirstComputedExpandedChild();

    abstract ModelNode getLastExpandedChild();
}

