/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.Box;
import com.sun.perseus.j2d.RenderGraphics;
import com.sun.perseus.j2d.TextRenderingProperties;
import com.sun.perseus.j2d.Transform;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.GlyphProxy;

class GlyphLayout {
    protected float advance;
    protected float x;
    protected float y;
    protected GlyphProxy firstChild;
    protected GlyphProxy lastChild;
    protected GlyphLayout prevSibling;
    protected GlyphLayout nextSibling;
    protected DocumentNode ownerDocument;
    protected float[] helperDashArray;

    GlyphLayout(DocumentNode doc) {
        this.ownerDocument = doc;
    }

    Box addBBox(Box bbox, Transform t) {
        GlyphProxy gp = this.firstChild;
        while (gp != null) {
            this.ownerDocument.bboxGlyphTxf.setTransform(t);
            gp.applyTransform(this.ownerDocument.bboxGlyphTxf);
            bbox = gp.addNodeBBox(bbox, this.ownerDocument.bboxGlyphTxf);
            gp = gp.nextSibling;
        }
        return bbox;
    }

    public void add(GlyphProxy proxy) {
        if (proxy == null) {
            throw new NullPointerException();
        }
        if (this.firstChild == null) {
            this.firstChild = proxy;
            this.lastChild = proxy;
            proxy.nextSibling = null;
            proxy.prevSibling = null;
        } else {
            this.lastChild.nextSibling = proxy;
            proxy.nextSibling = null;
            proxy.prevSibling = this.lastChild;
            this.lastChild = proxy;
        }
    }

    protected void applyTransform(TextRenderingProperties trp, Transform tx) {
        tx.mTranslate(this.x, this.y);
        float fontSize = trp.getFontSize();
        if (fontSize > 0.0f) {
            tx.mScale(fontSize);
        }
        switch (trp.getTextAnchor()) {
            default: {
                break;
            }
            case 1: {
                tx.mTranslate(-this.advance / 2.0f, 0.0f);
                break;
            }
            case 2: {
                tx.mTranslate(-this.advance, 0.0f);
            }
        }
    }

    protected void applyInverseTransform(TextRenderingProperties trp, Transform tx) {
        switch (trp.getTextAnchor()) {
            default: {
                break;
            }
            case 1: {
                tx.mTranslate(this.advance / 2.0f, 0.0f);
                break;
            }
            case 2: {
                tx.mTranslate(this.advance, 0.0f);
            }
        }
        float fontSize = trp.getFontSize();
        if (fontSize > 0.0f) {
            tx.mScale(1.0f / fontSize);
        }
        tx.mTranslate(-this.x, -this.y);
    }

    void fillText(RenderGraphics rg, Transform tx) {
        GlyphProxy c = this.firstChild;
        while (c != null) {
            this.ownerDocument.paintGlyphTxf.setTransform(tx);
            c.applyTransform(this.ownerDocument.paintGlyphTxf);
            rg.setTransform(this.ownerDocument.paintGlyphTxf);
            if (c.proxied.d != null) {
                rg.fill(c.proxied.d);
            }
            c = c.nextSibling;
        }
    }

    void drawText(RenderGraphics rg, Transform tx) {
        GlyphProxy c = this.firstChild;
        float strokeWidth = rg.getStrokeWidth();
        float dashOffset = rg.getStrokeDashOffset();
        float[] dashArray = rg.getStrokeDashArray();
        if (dashArray != null && (this.helperDashArray == null || this.helperDashArray.length != dashArray.length)) {
            this.helperDashArray = new float[dashArray.length];
        }
        float lastEMSquareScale = 0.0f;
        while (c != null) {
            this.ownerDocument.paintGlyphTxf.setTransform(tx);
            c.applyTransform(this.ownerDocument.paintGlyphTxf);
            rg.setTransform(this.ownerDocument.paintGlyphTxf);
            if (lastEMSquareScale != c.proxied.emSquareScale) {
                rg.setStrokeWidth(strokeWidth / c.proxied.emSquareScale);
                if (dashArray != null) {
                    float emSquareScale = c.proxied.emSquareScale;
                    float lengthSum = 0.0f;
                    for (int i = 0; i < dashArray.length; ++i) {
                        this.helperDashArray[i] = dashArray[i] / emSquareScale;
                        lengthSum += dashArray[i];
                    }
                    float reducedDashOffset = dashOffset;
                    if (lengthSum > 0.0f) {
                        int r = (int)(dashOffset / lengthSum);
                        reducedDashOffset -= (float)r * lengthSum;
                    }
                    rg.setStrokeDashArray(this.helperDashArray);
                    rg.setStrokeDashOffset(reducedDashOffset / emSquareScale);
                }
                lastEMSquareScale = c.proxied.emSquareScale;
            }
            if (c.proxied.d != null) {
                rg.draw(c.proxied.d);
            }
            c = c.nextSibling;
        }
        rg.setStrokeWidth(strokeWidth);
        if (dashArray != null) {
            rg.setStrokeDashArray(dashArray);
            rg.setStrokeDashOffset(dashOffset);
        }
    }

    protected boolean isHitVP(float[] pt, TextRenderingProperties trp, Transform chunkTxf) {
        GlyphProxy c = this.lastChild;
        while (c != null) {
            this.ownerDocument.hitGlyphTxf.setTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            c.applyInverseTransform(this.ownerDocument.hitGlyphTxf);
            this.ownerDocument.hitGlyphTxf.mMultiply(chunkTxf);
            this.ownerDocument.hitGlyphTxf.transformPoint(pt, this.ownerDocument.upt);
            if (c.isHit(this.ownerDocument.upt, trp)) {
                return true;
            }
            c = c.prevSibling;
        }
        return false;
    }

    public String toString() {
        return "GlyphLayout[x=" + this.x + ", y=" + this.y + " advance=" + this.advance + "]";
    }
}

