/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.lucene.store.BufferedIndexInput;

class FSIndexInput
extends BufferedIndexInput {
    private final Descriptor file;
    boolean isClone;

    public FSIndexInput(File path) throws IOException {
        this.file = new Descriptor(path, "r");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readInternal(byte[] b, int offset, int len) throws IOException {
        Descriptor descriptor = this.file;
        synchronized (descriptor) {
            int i;
            long position = this.getFilePointer();
            if (position != this.file.position) {
                this.file.seek(position);
                this.file.position = position;
            }
            int total = 0;
            do {
                if ((i = this.file.read(b, offset + total, len - total)) == -1) {
                    throw new IOException("read past EOF");
                }
                this.file.position += (long)i;
            } while ((total += i) < len);
        }
    }

    public void close() throws IOException {
        if (!this.isClone) {
            this.file.close();
        }
    }

    protected void seekInternal(long position) {
    }

    public long length() {
        return this.file.length;
    }

    public Object clone() {
        FSIndexInput clone = (FSIndexInput)super.clone();
        clone.isClone = true;
        return clone;
    }

    boolean isFDValid() throws IOException {
        return this.file.getFD().valid();
    }

    private static class Descriptor
    extends RandomAccessFile {
        private boolean isOpen = true;
        long position;
        final long length = this.length();

        public Descriptor(File file, String mode) throws IOException {
            super(file, mode);
        }

        public void close() throws IOException {
            if (this.isOpen) {
                this.isOpen = false;
                super.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }
}

