/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FieldDocSortedHitQueue;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.HitQueue;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.PriorityQueue;

public class MultiSearcher
extends Searcher {
    private Searchable[] searchables;
    private int[] starts;
    private int maxDoc = 0;

    public MultiSearcher(Searchable[] searchables) throws IOException {
        this.searchables = searchables;
        this.starts = new int[searchables.length + 1];
        for (int i = 0; i < searchables.length; ++i) {
            this.starts[i] = this.maxDoc;
            this.maxDoc += searchables[i].maxDoc();
        }
        this.starts[searchables.length] = this.maxDoc;
    }

    public Searchable[] getSearchables() {
        return this.searchables;
    }

    protected int[] getStarts() {
        return this.starts;
    }

    public void close() throws IOException {
        for (int i = 0; i < this.searchables.length; ++i) {
            this.searchables[i].close();
        }
    }

    public int docFreq(Term term) throws IOException {
        int docFreq = 0;
        for (int i = 0; i < this.searchables.length; ++i) {
            docFreq += this.searchables[i].docFreq(term);
        }
        return docFreq;
    }

    public Document doc(int n) throws IOException {
        int i = this.subSearcher(n);
        return this.searchables[i].doc(n - this.starts[i]);
    }

    public int subSearcher(int n) {
        int lo = 0;
        int hi = this.searchables.length - 1;
        while (hi >= lo) {
            int mid = lo + hi >> 1;
            int midValue = this.starts[mid];
            if (n < midValue) {
                hi = mid - 1;
                continue;
            }
            if (n > midValue) {
                lo = mid + 1;
                continue;
            }
            while (mid + 1 < this.searchables.length && this.starts[mid + 1] == midValue) {
                ++mid;
            }
            return mid;
        }
        return hi;
    }

    public int subDoc(int n) {
        return n - this.starts[this.subSearcher(n)];
    }

    public int maxDoc() throws IOException {
        return this.maxDoc;
    }

    public TopDocs search(Weight weight, Filter filter, int nDocs) throws IOException {
        HitQueue hq = new HitQueue(nDocs);
        int totalHits = 0;
        block0: for (int i = 0; i < this.searchables.length; ++i) {
            TopDocs docs = this.searchables[i].search(weight, filter, nDocs);
            totalHits += docs.totalHits;
            ScoreDoc[] scoreDocs = docs.scoreDocs;
            for (int j = 0; j < scoreDocs.length; ++j) {
                ScoreDoc scoreDoc = scoreDocs[j];
                scoreDoc.doc += this.starts[i];
                if (!hq.insert(scoreDoc)) continue block0;
            }
        }
        ScoreDoc[] scoreDocs = new ScoreDoc[hq.size()];
        for (int i = hq.size() - 1; i >= 0; --i) {
            scoreDocs[i] = (ScoreDoc)hq.pop();
        }
        float maxScore = totalHits == 0 ? Float.NEGATIVE_INFINITY : scoreDocs[0].score;
        return new TopDocs(totalHits, scoreDocs, maxScore);
    }

    public TopFieldDocs search(Weight weight, Filter filter, int n, Sort sort) throws IOException {
        PriorityQueue hq = null;
        int totalHits = 0;
        float maxScore = Float.NEGATIVE_INFINITY;
        block0: for (int i = 0; i < this.searchables.length; ++i) {
            TopFieldDocs docs = this.searchables[i].search(weight, filter, n, sort);
            if (hq == null) {
                hq = new FieldDocSortedHitQueue(docs.fields, n);
            }
            totalHits += docs.totalHits;
            maxScore = Math.max(maxScore, docs.getMaxScore());
            ScoreDoc[] scoreDocs = docs.scoreDocs;
            for (int j = 0; j < scoreDocs.length; ++j) {
                ScoreDoc scoreDoc = scoreDocs[j];
                scoreDoc.doc += this.starts[i];
                if (!hq.insert(scoreDoc)) continue block0;
            }
        }
        ScoreDoc[] scoreDocs = new ScoreDoc[hq.size()];
        for (int i = hq.size() - 1; i >= 0; --i) {
            scoreDocs[i] = (ScoreDoc)hq.pop();
        }
        return new TopFieldDocs(totalHits, scoreDocs, ((FieldDocSortedHitQueue)hq).getFields(), maxScore);
    }

    public void search(Weight weight, Filter filter, final HitCollector results) throws IOException {
        for (int i = 0; i < this.searchables.length; ++i) {
            final int start = this.starts[i];
            this.searchables[i].search(weight, filter, new HitCollector(){

                public void collect(int doc, float score) {
                    results.collect(doc + start, score);
                }
            });
        }
    }

    public Query rewrite(Query original) throws IOException {
        Query[] queries = new Query[this.searchables.length];
        for (int i = 0; i < this.searchables.length; ++i) {
            queries[i] = this.searchables[i].rewrite(original);
        }
        return queries[0].combine(queries);
    }

    public Explanation explain(Weight weight, int doc) throws IOException {
        int i = this.subSearcher(doc);
        return this.searchables[i].explain(weight, doc - this.starts[i]);
    }

    protected Weight createWeight(Query original) throws IOException {
        Query rewrittenQuery = this.rewrite(original);
        HashSet terms = new HashSet();
        rewrittenQuery.extractTerms(terms);
        Term[] allTermsArray = new Term[terms.size()];
        terms.toArray(allTermsArray);
        int[] aggregatedDfs = new int[terms.size()];
        for (int i = 0; i < this.searchables.length; ++i) {
            int[] dfs = this.searchables[i].docFreqs(allTermsArray);
            for (int j = 0; j < aggregatedDfs.length; ++j) {
                int n = j;
                aggregatedDfs[n] = aggregatedDfs[n] + dfs[j];
            }
        }
        HashMap<Term, Integer> dfMap = new HashMap<Term, Integer>();
        for (int i = 0; i < allTermsArray.length; ++i) {
            dfMap.put(allTermsArray[i], new Integer(aggregatedDfs[i]));
        }
        int numDocs = this.maxDoc();
        CachedDfSource cacheSim = new CachedDfSource(dfMap, numDocs);
        return rewrittenQuery.weight(cacheSim);
    }

    private static class CachedDfSource
    extends Searcher {
        private Map dfMap;
        private int maxDoc;

        public CachedDfSource(Map dfMap, int maxDoc) {
            this.dfMap = dfMap;
            this.maxDoc = maxDoc;
        }

        public int docFreq(Term term) {
            int df;
            try {
                df = (Integer)this.dfMap.get(term);
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException("df for term " + term.text() + " not available");
            }
            return df;
        }

        public int[] docFreqs(Term[] terms) {
            int[] result = new int[terms.length];
            for (int i = 0; i < terms.length; ++i) {
                result[i] = this.docFreq(terms[i]);
            }
            return result;
        }

        public int maxDoc() {
            return this.maxDoc;
        }

        public Query rewrite(Query query) {
            return query;
        }

        public void close() {
            throw new UnsupportedOperationException();
        }

        public Document doc(int i) {
            throw new UnsupportedOperationException();
        }

        public Explanation explain(Weight weight, int doc) {
            throw new UnsupportedOperationException();
        }

        public void search(Weight weight, Filter filter, HitCollector results) {
            throw new UnsupportedOperationException();
        }

        public TopDocs search(Weight weight, Filter filter, int n) {
            throw new UnsupportedOperationException();
        }

        public TopFieldDocs search(Weight weight, Filter filter, int n, Sort sort) {
            throw new UnsupportedOperationException();
        }
    }
}

