/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4ejb.webservice.generator;

import com.sun.tools.javac.Main;
import it.imolinfo.jbi4ejb.Logger;
import it.imolinfo.jbi4ejb.LoggerFactory;
import it.imolinfo.jbi4ejb.exception.ClassGenerationException;
import it.imolinfo.jbi4ejb.exception.EJBDeployException;
import it.imolinfo.jbi4ejb.webservice.generator.UtilClassCollector;
import it.imolinfo.jbi4ejb.webservice.generator.bcm.RemoteEnancherAdapter;
import it.imolinfo.jbi4ejb.webservice.generator.bcm.SerializableDecorationAdapter;
import it.imolinfo.jbi4ejb.webservice.generator.bcm.SerializableInspectorAdapter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.TraceClassVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Util {
    private static final Logger LOG = LoggerFactory.getLogger(Util.class);
    private static final String PROTOCOL = System.getProperty("os.name").indexOf("Win") >= 0 ? "file:///" : "file://";

    private Util() {
    }

    public static void compileJavaClasses(String workdirsrc, String workdirclasses, List<String> javaSources, List<String> jarFiles, List<String> extraClassPath) throws ClassGenerationException {
        LOG.debug(">>>>> compileJavaClasses - begin");
        LOG.debug("compileJavaClasses.\n workdirsrc=" + workdirsrc + ";\n workdirclasses=" + workdirclasses + ";\n javaSources=" + javaSources + ";\n jarFiles=" + jarFiles + ";\n extraClassPath=" + extraClassPath);
        ArrayList<String> params = new ArrayList<String>(Arrays.asList("-d", workdirclasses, "-sourcepath", workdirsrc));
        LOG.debug("creating classpath - begin");
        String classpath = "";
        if (jarFiles != null) {
            for (String jarFileName : jarFiles) {
                classpath = classpath + jarFileName + File.pathSeparator;
                LOG.debug("ClassPath + (jar) " + jarFileName);
            }
        }
        if (extraClassPath != null) {
            for (String extra : extraClassPath) {
                File f = new File(extra);
                if (!f.isDirectory()) {
                    String extraParent = f.getParent();
                    LOG.debug("-----> EXTRA=[" + extraParent + "]");
                    classpath = classpath + extraParent + File.pathSeparator;
                } else {
                    classpath = classpath + extra + File.pathSeparator;
                }
                LOG.debug("ClassPath + (extra) " + extra);
            }
        } else {
            LOG.debug("No extra classpath.");
        }
        if (!"".equals(classpath)) {
            LOG.debug("Final ClassPath=" + classpath);
            params.add("-cp");
            params.add(classpath);
        } else {
            LOG.debug("Final ClassPath=<<EMPTY>>");
        }
        LOG.debug("creating classpath - end.");
        params.addAll(javaSources);
        System.out.println("command line: " + Arrays.toString(params.toArray()));
        File classesdir = new File(workdirclasses);
        if (!classesdir.exists()) {
            boolean result = classesdir.mkdirs();
            if (!result) {
                String msg = "The classes directory creatin failed";
                throw new ClassGenerationException(msg);
            }
            LOG.debug("Classes Dir Created:" + classesdir);
        } else {
            LOG.debug("Classes Dir Already Exists:" + classesdir);
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printstream = new PrintWriter(stringWriter);
        LOG.debug("Compiling - begin");
        int result = Main.compile(params.toArray(new String[0]), printstream);
        LOG.debug("Compiling - end. result=" + result);
        LOG.debug("compilation output: \n" + stringWriter.toString());
        if (result != 0) {
            String msg = "The classes compilation failed (result != 0)";
            throw new ClassGenerationException(msg);
        }
        LOG.debug("Compilation OK.");
        LOG.debug("<<<<< compileJavaClasses - end");
    }

    public static List<String> findJavaSources(String basedir, List<String> exclude) throws EJBDeployException {
        ArrayList<String> javaSourcesNames = new ArrayList<String>();
        List<File> sourceFiles = Util.findFilesFromSourceDirectory(basedir, ".java");
        for (File source : sourceFiles) {
            String src = null;
            try {
                src = source.getCanonicalPath();
            }
            catch (IOException e) {
                String msg = e.getMessage();
                LOG.error(msg);
                throw new EJBDeployException(msg, e);
            }
            if (src.endsWith("src")) {
                LOG.debug("The file " + src + " won't be compiled.");
                continue;
            }
            if (Util.containsIgnoreSlashes(exclude, src)) {
                LOG.debug("The file " + src + " won't be compiled.");
                continue;
            }
            LOG.debug("The file " + src + " will be compiled.");
            javaSourcesNames.add(src);
        }
        LOG.debug("<<<<< findJavaSources(String, List<String>) - end");
        return javaSourcesNames;
    }

    public static boolean containsIgnoreSlashes(List<String> list, String myString) {
        if (myString == null) {
            return false;
        }
        if (list == null) {
            return false;
        }
        String xrr = myString.replace('\\', ' ').replace('/', ' ');
        for (String c : list) {
            String crr = c.replace('\\', ' ').replace('/', ' ');
            if (!xrr.equalsIgnoreCase(crr)) continue;
            return true;
        }
        return false;
    }

    public static List<File> findFilesFromSourceDirectory(String basedirString, final String extensionFilter) {
        File basedir = new File(basedirString);
        FileFilter filter = new FileFilter(){

            public boolean accept(File file) {
                boolean filterAccept = file.getName().endsWith(extensionFilter);
                return filterAccept;
            }
        };
        List<File> directories = Util.findDirectories(basedir);
        ArrayList<File> filterdFiles = new ArrayList<File>();
        for (File dir : directories) {
            File[] innerFilteredFiles = dir.listFiles(filter);
            filterdFiles.addAll(Arrays.asList(innerFilteredFiles));
        }
        return filterdFiles;
    }

    public static List<File> findFilesFromSourceDirectoryFromExactFileName(String basedirString, final String exactName) {
        File basedir = new File(basedirString);
        FileFilter filter = new FileFilter(){

            public boolean accept(File file) {
                boolean filterAccept = file.getName().equals(exactName);
                return filterAccept;
            }
        };
        List<File> directories = Util.findDirectories(basedir);
        directories.add(basedir);
        ArrayList<File> filterdFiles = new ArrayList<File>();
        for (File dir : directories) {
            File[] innerFilteredFiles = dir.listFiles(filter);
            filterdFiles.addAll(Arrays.asList(innerFilteredFiles));
        }
        return filterdFiles;
    }

    private static List<File> findDirectories(File basedir) {
        ArrayList<File> directories = new ArrayList<File>();
        if (basedir == null || "".equals(basedir.getAbsolutePath())) {
            return directories;
        }
        FileFilter directoryFilter = new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
        File[] files = basedir.listFiles(directoryFilter);
        if (files == null) {
            return directories;
        }
        for (int i = 0; i < files.length; ++i) {
            List<File> innerDirectories = Util.findDirectories(files[i]);
            directories.addAll(innerDirectories);
            directories.add(files[i]);
        }
        return directories;
    }

    public static String tweakInterfaceClasses(String portTypeClassName, String classesDirName) throws ClassGenerationException {
        ClassReader cr;
        LOG.debug(">>>>>>>>>> tweakInterfaceClasses - begin");
        LOG.debug("remotizing class: " + portTypeClassName + " in dir: " + classesDirName);
        ClassWriter cw = new ClassWriter(true);
        CheckClassAdapter cc = new CheckClassAdapter((ClassVisitor)cw);
        StringWriter sw = new StringWriter();
        TraceClassVisitor tv = new TraceClassVisitor((ClassVisitor)cc, new PrintWriter(sw));
        RemoteEnancherAdapter cv = new RemoteEnancherAdapter((ClassVisitor)tv, Util.getAsFullyQualifiedNameInternalForm(portTypeClassName));
        LOG.debug("new ClassReader - Begin");
        try {
            cr = new ClassReader((InputStream)new FileInputStream(Util.getAsFileName(classesDirName, portTypeClassName, ".class")));
        }
        catch (IOException e) {
            String msg = e.getMessage();
            LOG.error(msg);
            throw new ClassGenerationException(e);
        }
        cr.accept((ClassVisitor)cv, true);
        LOG.debug("output of tracer during creation of class: " + portTypeClassName + "\n" + sw.toString());
        byte[] newBytecode = cw.toByteArray();
        String relativeFileName = cv.getCompleteName().replace('/', File.separatorChar);
        LOG.debug("relativeFileName=" + relativeFileName + "; cv.getCompleteName()=" + cv.getCompleteName());
        Util.saveAsJavaClass(classesDirName + File.separator + relativeFileName + ".class", newBytecode);
        String remoteClassName = cv.getCompleteName().replace('/', '.');
        LOG.debug("<<<<<<<<<< tweakInterfaceClasses - end:" + remoteClassName);
        return remoteClassName;
    }

    private static String getAsFileName(String basedir, String javaName, String ext) {
        char sep = File.separator.charAt(0);
        String basedirTmp = basedir.replace('\\', sep).replace('/', sep);
        return basedirTmp + sep + javaName.replace('.', sep) + ext;
    }

    private static String getAsFullyQualifiedNameInternalForm(String javaName) {
        return javaName.replace('.', '/');
    }

    public static void saveAsJavaClass(String absoluteFileName, byte[] newBytecode) throws ClassGenerationException {
        LOG.debug(">>>>> saveAs - begin:" + absoluteFileName);
        try {
            FileOutputStream fos = new FileOutputStream(absoluteFileName);
            fos.write(newBytecode);
            fos.close();
        }
        catch (FileNotFoundException e) {
            String msg = e.getMessage();
            LOG.error(msg);
            throw new ClassGenerationException(e);
        }
        catch (IOException e) {
            String msg = e.getMessage();
            LOG.error(msg);
            throw new ClassGenerationException(e);
        }
        LOG.debug("<<<<< saveAs - end");
    }

    public static URLClassLoader getURLClassLoader(String absolutePath, ClassLoader parent) throws MalformedURLException {
        URL u = new URL(PROTOCOL + absolutePath + "/");
        URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{u}, parent);
        LOG.debug("url classloader: " + Arrays.asList(urlClassLoader.getURLs()));
        return urlClassLoader;
    }

    public static URLClassLoader getURLClassLoader(String absolutePath) throws MalformedURLException {
        return Util.getURLClassLoader(absolutePath, Util.class.getClassLoader());
    }

    public static void tweakSerializableDecoration(String absPath, Long newSerialVersionUid) throws ClassGenerationException {
        ClassWriter cw = new ClassWriter(true);
        CheckClassAdapter cc = new CheckClassAdapter((ClassVisitor)cw);
        StringWriter sw = new StringWriter();
        TraceClassVisitor tv = new TraceClassVisitor((ClassVisitor)cc, new PrintWriter(sw));
        SerializableDecorationAdapter cv = new SerializableDecorationAdapter((ClassVisitor)tv, newSerialVersionUid);
        ClassReader cr = Util.getAsmCLassReader(absPath);
        cr.accept((ClassVisitor)cv, true);
        LOG.debug("ClassReader.accept ... done");
        LOG.debug("output of tracer during creation of class: " + absPath + "\n" + sw.toString());
        byte[] newBytecode = cw.toByteArray();
        Util.saveAsJavaClass(absPath, newBytecode);
    }

    public static ClassVisitor tweakSerializableInspection(String absPath) throws ClassGenerationException {
        ClassWriter cw = new ClassWriter(true);
        CheckClassAdapter cc = new CheckClassAdapter((ClassVisitor)cw);
        StringWriter sw = new StringWriter();
        TraceClassVisitor tv = new TraceClassVisitor((ClassVisitor)cc, new PrintWriter(sw));
        SerializableInspectorAdapter cv = new SerializableInspectorAdapter((ClassVisitor)tv);
        ClassReader cr = Util.getAsmCLassReader(absPath);
        cr.accept((ClassVisitor)cv, true);
        LOG.debug("ClassReader.accept ... done");
        return cv;
    }

    public static ClassReader getAsmCLassReader(String className) throws ClassGenerationException {
        LOG.debug(">>>>> getAsmCLassReader - begin");
        ClassReader cr = null;
        try {
            cr = new ClassReader((InputStream)new FileInputStream(className));
        }
        catch (IOException e) {
            Object[] args = new Object[]{className};
            LOG.error("CRB000536_Could_not_instantiate_class_reader_for_class", args, e);
            throw new ClassGenerationException("CRB000536_Could_not_instantiate_class_reader_for_class", args, e);
        }
        LOG.debug("<<<<< getAsmCLassReader - end. ClassReader=" + cr);
        return cr;
    }

    public static Set<Class> findClassUsed(String dir, List<File> classList) throws ClassGenerationException {
        LOG.debug(">>>>> findClassUsedInTheOperations - begin");
        LOG.debug("operationsClass=" + classList);
        if (classList == null || classList.size() == 0) {
            LOG.info("CRB000532_Operations_class_not_found");
            return new HashSet<Class>();
        }
        Set<Class> result = new HashSet<Class>();
        for (int i = 0; i < classList.size(); ++i) {
            Class clazz = Util.classLoad(dir, classList.get(i));
            LOG.debug("classLoad:" + clazz);
            List<Class> types = UtilClassCollector.extractTypes(clazz);
            for (Class currType : types) {
                result = UtilClassCollector.visitClassCollector(result, currType);
            }
        }
        LOG.debug("<<<<< findClassUsedInTheOperations - end:" + result);
        return result;
    }

    private static Class classLoad(String dir, File classAsFile) throws ClassGenerationException {
        URLClassLoader urlClassLoader = null;
        try {
            File fcd = new File(dir);
            if (LOG.isDebugEnabled()) {
                LOG.debug("ClassesDir.getAbsolutePath=" + fcd.getAbsolutePath());
            }
            URL u = new URL(PROTOCOL + fcd.getAbsolutePath() + "/");
            urlClassLoader = new URLClassLoader(new URL[]{u}, Util.class.getClassLoader());
            LOG.debug("url classloader: " + Arrays.asList(urlClassLoader.getURLs()));
            String className = Util.getClassName(classAsFile, dir);
            LOG.debug("class name: " + className);
            return urlClassLoader.loadClass(className);
        }
        catch (MalformedURLException e) {
            String msg = e.getMessage();
            LOG.error(msg);
            throw new ClassGenerationException(msg, e);
        }
        catch (ClassNotFoundException e) {
            String msg = e.getMessage();
            LOG.error(msg);
            throw new ClassGenerationException(msg, e);
        }
    }

    private static String getClassName(File file, String basedir) throws ClassGenerationException {
        LOG.debug(">>>>> getClassName - begin");
        String absoluteFileName = file.getAbsolutePath();
        String absoulteBaseDir = new File(basedir).getAbsolutePath();
        LOG.debug("absoluteFileName: " + absoluteFileName + "; absoulteBaseDir: " + absoulteBaseDir);
        if (!absoluteFileName.startsWith(absoulteBaseDir)) {
            String msg = "The file " + absoluteFileName + " is not present in the directory " + absoulteBaseDir;
            LOG.error(msg);
            throw new ClassGenerationException(msg);
        }
        String relativeFileName = absoluteFileName.substring(absoulteBaseDir.length() + 1);
        LOG.debug("relativeFileName.class=" + relativeFileName);
        if (relativeFileName.endsWith(".class")) {
            relativeFileName = relativeFileName.substring(0, relativeFileName.length() - ".class".length());
            LOG.debug("relativeFileName=" + relativeFileName);
        }
        String className = relativeFileName.replace(File.separator, ".");
        LOG.debug("className=" + className);
        LOG.debug("<<<<< getClassName - end");
        return className;
    }

    public static List<String> prepareClassPath(String libDirName) throws ClassGenerationException {
        LOG.debug(">>>>> prepareClassPath - begin");
        List<File> jarFiles = Util.findFilesFromSourceDirectory(libDirName, ".jar");
        ArrayList<String> jarFilesName = new ArrayList<String>();
        for (File jarFile : jarFiles) {
            try {
                LOG.debug("Adding jar " + jarFile.getCanonicalPath() + " ... ");
                jarFilesName.add(jarFile.getCanonicalPath());
                LOG.debug("... jar " + jarFile.getCanonicalPath() + " added.");
            }
            catch (IOException e) {
                String msg = "Error_getting_canonicalPath_from_file: " + e.getMessage();
                throw new ClassGenerationException(msg, e);
            }
        }
        LOG.debug("<<<<< prepareClassPath - end");
        return jarFilesName;
    }
}

