/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4ejb.jbi.component.runtime;

import it.imolinfo.jbi4ejb.jbi.component.runtime.AbstractMessageExchangeHandler;
import it.imolinfo.jbi4ejb.jbi.component.runtime.RuntimeHelper;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;

public abstract class InOutProviderMessageExchangeHandler
extends AbstractMessageExchangeHandler {
    public static final long SEND_SYNC_TIMEOUT = 60000L;

    protected void validateMessageExchange() throws MessagingException {
        MessageExchange msgExchange = this.getMessageExchange();
        if (this.getMessageExchange() == null) {
            throw new MessagingException("MessageExchange Object is null in MessageExchageHandler");
        }
        if (MessageExchange.Role.CONSUMER.equals(msgExchange.getRole())) {
            throw new MessagingException("Provider Message Exchange Handler can not have MessageExchange with CONSUMER Role");
        }
        if (!(msgExchange instanceof InOut)) {
            throw new MessagingException("InOut Message Exchange Handler MessageExchange object should be instanceof javax.jbi.messaging.InOut ");
        }
    }

    protected void processFault(Fault fault) {
        RuntimeHelper.logError("InOut Message Exchange Provider Handler can not receive Fault on Provider side");
    }

    protected void processDone() {
        RuntimeHelper.logVerbose("InOut Message Exchange Provider handler received DONE : END of service invocation");
    }

    protected void processError(Exception ex) {
        RuntimeHelper.logError("InOut Message Exchange Provider handler received Error");
        RuntimeHelper.logError(ex);
    }

    protected final void processMessage() {
        InOut inOutMX = (InOut)this.getMessageExchange();
        NormalizedMessage inMsg = inOutMX.getInMessage();
        if (inMsg == null) {
            this.sendError((Exception)((Object)new MessagingException("InOut Provider MessageExchange received null In Message")));
            return;
        }
        this.handleInMessage(inMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleInMessage(NormalizedMessage inMsg) {
        Fault fault = null;
        Exception processingEx = null;
        NormalizedMessage outMsg = null;
        boolean result = false;
        InOut inOutExchange = (InOut)this.getMessageExchange();
        try {
            outMsg = inOutExchange.createMessage();
            fault = inOutExchange.createFault();
            result = this.invokeOperation(inMsg, outMsg, fault);
        }
        catch (Exception ex) {
            processingEx = ex;
            ex.printStackTrace();
        }
        finally {
            try {
                if (result) {
                    this.sendOutMessage(outMsg);
                } else if (processingEx != null) {
                    this.sendFault(processingEx);
                } else {
                    this.sendFault(fault);
                }
            }
            catch (MessagingException ex) {
                ex.printStackTrace();
                this.sendError((Exception)((Object)ex));
                return;
            }
        }
        this.processMessageExchange();
    }

    public void sendFault(Fault fault) throws MessagingException {
        InOut inOutMX = (InOut)this.getMessageExchange();
        inOutMX.setFault(fault);
        boolean sent = false;
        try {
            sent = this.getDeliveryChannel().sendSync((MessageExchange)inOutMX, 60000L);
            if (!sent) {
                inOutMX.setError((Exception)((Object)new MessagingException("InOutProvider ME Handler unable to send out message")));
            }
        }
        catch (Exception ex) {
            inOutMX.setError(ex);
        }
    }

    private void sendOutMessage(NormalizedMessage outMsg) throws MessagingException {
        InOut inOutMX = (InOut)this.getMessageExchange();
        inOutMX.setOutMessage(outMsg);
        boolean sent = false;
        try {
            sent = this.getDeliveryChannel().sendSync((MessageExchange)inOutMX, 60000L);
            if (!sent) {
                inOutMX.setError((Exception)((Object)new MessagingException("InOutProvider ME Handler unable to send out message")));
            }
        }
        catch (Exception ex) {
            inOutMX.setError(ex);
        }
    }

    protected abstract boolean invokeOperation(NormalizedMessage var1, NormalizedMessage var2, Fault var3) throws MessagingException;
}

