/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4ejb.jbi.component;

import com.ibm.wsdl.factory.WSDLFactoryImpl;
import com.sun.jbi.management.descriptor.ConfigurationException;
import com.sun.jbi.management.descriptor.EndpointIdentifier;
import com.sun.jbi.management.descriptor.SUDescriptorSupport;
import it.imolinfo.jbi4ejb.Logger;
import it.imolinfo.jbi4ejb.LoggerFactory;
import it.imolinfo.jbi4ejb.descriptor.ProviderServiceDescriptor;
import it.imolinfo.jbi4ejb.exception.Jbi4EjbDeployException;
import it.imolinfo.jbi4ejb.exception.Jbi4EjbException;
import it.imolinfo.jbi4ejb.jbi.component.Jbi4EjbLifeCycle;
import it.imolinfo.jbi4ejb.jbi.component.runtime.ComponentRuntime;
import it.imolinfo.jbi4ejb.jbi.component.runtime.DefaultServiceUnitManager;
import it.imolinfo.jbi4ejb.jbi.component.runtime.RuntimeHelper;
import it.imolinfo.jbi4ejb.jbi.endpoint.Jbi4EjbEndpoint;
import it.imolinfo.jbi4ejb.jbi.endpoint.Jbi4EjbProviderEndpoint;
import it.imolinfo.jbi4ejb.jbi.wsdl.Jbi4EjbAddress;
import it.imolinfo.jbi4ejb.jbi.wsdl.Jbi4EjbBinding;
import it.imolinfo.jbi4ejb.jbi.wsdl.Jbi4EjbExtension;
import it.imolinfo.jbi4ejb.jbi.wsdl.Jbi4EjbExtensionUtils;
import it.imolinfo.jbi4ejb.jbi.wsdl.Jbi4EjbTypes;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.jbi.JBIException;
import javax.jbi.management.DeploymentException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jbi4EjbSUManager
extends DefaultServiceUnitManager {
    private static final Logger LOG = LoggerFactory.getLogger(Jbi4EjbSUManager.class);
    private List<Jbi4EjbEndpoint> deployedEndpoints = new ArrayList<Jbi4EjbEndpoint>();
    private List<Jbi4EjbEndpoint> activatedEndpoints = new ArrayList<Jbi4EjbEndpoint>();
    private Jbi4EjbLifeCycle lifeCycle = null;

    public Jbi4EjbSUManager(ComponentRuntime ctx) {
        super(ctx);
        this.lifeCycle = (Jbi4EjbLifeCycle)ctx.getLifeCycle();
    }

    @Override
    public String deploy(String suName, String suZipPath) throws DeploymentException {
        String taskName = "deploy";
        boolean isSuccess = true;
        LOG.info("Deploying the su " + suName + "in the SA:" + suZipPath);
        String retMsg = this.createComponentTaskResultXML("deploy", isSuccess);
        return retMsg;
    }

    @Override
    public void start(String serviceUnitName) throws DeploymentException {
        LOG.info("Starting the serviceUnit: " + serviceUnitName);
        LOG.info("Deployed Endpoints number: " + this.deployedEndpoints.size());
        for (Jbi4EjbEndpoint endpoint : this.deployedEndpoints) {
            LOG.debug("endpoint.getSuName():" + endpoint.getSuName());
            if (!endpoint.getSuName().equals(serviceUnitName)) continue;
            try {
                LOG.debug("Registering the service: " + endpoint.getServiceName());
                endpoint.registerService();
                LOG.debug("Activating the service: " + endpoint.getServiceName());
                this.activateEndpoint(endpoint);
                this.activatedEndpoints.add(endpoint);
            }
            catch (Jbi4EjbException e) {
                LOG.error(e.getMessage());
                throw new DeploymentException((Throwable)e);
            }
        }
    }

    @Override
    public String undeploy(String serviceUnitName, String suZipPath) throws DeploymentException {
        String taskName = "undeploy";
        boolean isSuccess = true;
        String retMsg = this.createComponentTaskResultXML("undeploy", isSuccess);
        return retMsg;
    }

    @Override
    public void stop(String serviceUnitName) throws DeploymentException {
        ArrayList<Jbi4EjbEndpoint> endpointsToRemove = new ArrayList<Jbi4EjbEndpoint>();
        for (Jbi4EjbEndpoint ejbEndpoint : this.activatedEndpoints) {
            if (!ejbEndpoint.getSuName().equals(serviceUnitName)) continue;
            try {
                ejbEndpoint.unregisterService();
                this.deactivateEndpoint(ejbEndpoint);
                endpointsToRemove.add(ejbEndpoint);
            }
            catch (Jbi4EjbException e) {
                LOG.error(e.getMessage());
                throw new DeploymentException((Throwable)e);
            }
        }
        this.activatedEndpoints.removeAll(endpointsToRemove);
    }

    @Override
    public void init(String serviceUnitName, String serviceUnitRootPath) throws DeploymentException {
        this.deployedEndpoints.addAll(this.processDeploy(serviceUnitName, serviceUnitRootPath));
        LOG.info("Init: do nothing");
    }

    @Override
    public void shutDown(String serviceUnitName) throws DeploymentException {
        ArrayList<Jbi4EjbEndpoint> deployedEndpointsToRemove = new ArrayList<Jbi4EjbEndpoint>();
        for (Jbi4EjbEndpoint ejbEndpoint : this.deployedEndpoints) {
            if (!ejbEndpoint.getSuName().equals(serviceUnitName)) continue;
            deployedEndpointsToRemove.add(ejbEndpoint);
        }
        this.deployedEndpoints.removeAll(deployedEndpointsToRemove);
    }

    public Jbi4EjbEndpoint getStartedEndpoint(ServiceEndpoint endpoint) {
        for (Jbi4EjbEndpoint ejbEndpoint : this.activatedEndpoints) {
            if (!ejbEndpoint.getServiceName().equals(endpoint.getServiceName()) || !ejbEndpoint.getEndpointName().equals(endpoint.getEndpointName())) continue;
            return ejbEndpoint;
        }
        return null;
    }

    private List<Jbi4EjbEndpoint> processDeploy(String suName, String suZipPath) throws DeploymentException {
        File suDir = new File(suZipPath);
        LOG.debug("The SU dir path is: " + suDir.getAbsolutePath());
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            LOG.error(ex.getMessage());
            throw new DeploymentException((Throwable)ex);
        }
        FileToDefinitionInfo[] fileToDefs = this.readAllDefinitions(suDir);
        ArrayList<Jbi4EjbEndpoint> endpoints = new ArrayList<Jbi4EjbEndpoint>();
        LOG.info("About to parse jbi.xml to resolve service end point in path:" + suDir.getAbsolutePath());
        EndpointIdentifier[] svcs = null;
        SUDescriptorSupport descSupport = null;
        try {
            descSupport = new SUDescriptorSupport(suDir.getAbsolutePath());
            svcs = descSupport.getServices();
        }
        catch (ConfigurationException ex) {
            LOG.error(ex.getMessage());
            throw new DeploymentException((Throwable)ex);
        }
        int len = svcs.length;
        LOG.info("Found " + svcs.length + " endpoint declared in the jbi.xml");
        for (int i = 0; i < len; ++i) {
            Document result;
            Jbi4EjbProviderEndpoint ejbEndpoint;
            String msg;
            Definition matchedDef = null;
            File matchedWSDL = null;
            Jbi4EjbBinding ejbBinding = null;
            Jbi4EjbAddress ejbAddress = null;
            Jbi4EjbTypes ejbTypes = null;
            EndpointIdentifier epDesc = svcs[i];
            for (FileToDefinitionInfo element : fileToDefs) {
                ejbBinding = Jbi4EjbExtensionUtils.getEjbBinding(element.getDefinition(), epDesc.getServiceName().toString(), epDesc.getEndpointName());
                if (ejbBinding == null) continue;
                matchedDef = element.getDefinition();
                matchedWSDL = element.getFile();
                break;
            }
            if (ejbBinding == null) continue;
            ejbAddress = Jbi4EjbExtensionUtils.getEjbAddress(matchedDef, epDesc.getServiceName().toString(), epDesc.getEndpointName());
            if (ejbAddress == null) {
                msg = "No address found!";
                throw new DeploymentException(msg);
            }
            ejbTypes = Jbi4EjbExtensionUtils.getEjbTypes(matchedDef);
            if (ejbTypes == null) {
                msg = "No types found";
                LOG.warn(msg);
            }
            PortType portType = Jbi4EjbExtensionUtils.getPortType(matchedDef, epDesc.getServiceName().toString(), epDesc.getEndpointName());
            String endpoint = epDesc.getEndpointName();
            String endpointNameLocalPart = QName.valueOf(endpoint).getLocalPart();
            try {
                ejbEndpoint = new Jbi4EjbProviderEndpoint(epDesc.getServiceName(), endpointNameLocalPart);
            }
            catch (Jbi4EjbException e1) {
                LOG.error(e1.getMessage());
                throw new DeploymentException((Throwable)e1);
            }
            ejbEndpoint.setDefinition(matchedDef);
            ejbEndpoint.setState(0);
            ejbEndpoint.setSuName(suName);
            ejbEndpoint.setSuManager(this);
            ejbEndpoint.setEndpointWSDL(matchedWSDL);
            ProviderServiceDescriptor providerServiceDescriptor = new ProviderServiceDescriptor();
            providerServiceDescriptor.setComponentRootPath(suZipPath);
            providerServiceDescriptor.setName(ejbAddress.getName());
            providerServiceDescriptor.setLocalizationType(ejbAddress.getLocalizationType());
            providerServiceDescriptor.setJndiProperties(ejbBinding.getJndiProperties());
            providerServiceDescriptor.setOrbProperties(ejbBinding.getOrbProperties());
            if (ejbTypes != null) {
                providerServiceDescriptor.setSerialVersionUID(ejbTypes.getTypesSerialVersionUIDs());
            }
            providerServiceDescriptor.setPortTypeName(portType.getQName());
            providerServiceDescriptor.setServiceName(epDesc.getServiceName());
            ejbEndpoint.setServiceDescriptor(providerServiceDescriptor);
            LOG.info("Parses the matched WSDL");
            try {
                result = documentBuilder.parse(matchedWSDL);
            }
            catch (SAXException e) {
                LOG.error("Error in parsing the deploy WSDL:" + e.getMessage());
                throw new DeploymentException((Throwable)e);
            }
            catch (IOException e) {
                LOG.error("Error in parsing the deploy WSDL: " + e.getMessage());
                throw new DeploymentException((Throwable)e);
            }
            ejbEndpoint.setServiceDescription(result);
            endpoints.add(ejbEndpoint);
        }
        return endpoints;
    }

    private void activateEndpoint(Jbi4EjbEndpoint endpoint) throws Jbi4EjbDeployException {
        LOG.info("Activating endpoint: " + endpoint.getUniqueName());
        if (this.activatedEndpoints.indexOf(endpoint) != -1) {
            String msg = "Failed to deploy endpoint: " + endpoint.getUniqueName() + ": endpoint already registered";
            throw new Jbi4EjbDeployException(msg);
        }
        try {
            QName serviceName = endpoint.getServiceName();
            ServiceEndpoint serviceEndpoint = RuntimeHelper.getComponentContext().activateEndpoint(endpoint.getServiceName(), endpoint.getEndpointName());
            endpoint.setServiceEndpoint(serviceEndpoint);
            LOG.info("Endpoint " + serviceName + " activated");
            endpoint.setState(2);
        }
        catch (JBIException me) {
            String msg = "Cannot activate endpoint " + endpoint.getServiceName() + ", reason: " + me.getMessage();
            LOG.error(msg);
            throw new Jbi4EjbDeployException(msg);
        }
    }

    public void deactivateEndpoint(Jbi4EjbEndpoint endpoint) throws Jbi4EjbDeployException {
        LOG.info("Deactivating endpoint: " + endpoint.getUniqueName());
        if (!this.activatedEndpoints.contains(endpoint)) {
            LOG.error("The endpoint " + endpoint.getUniqueName() + " is not active: cannot deactivate");
        } else {
            try {
                RuntimeHelper.getComponentContext().deactivateEndpoint(endpoint.getServiceEndpoint());
                LOG.info("Endpoint " + endpoint.getServiceEndpoint() + " deactivated");
                endpoint.setState(1);
            }
            catch (JBIException me) {
                String msg = "Cannot deactivate endpoint " + endpoint.getServiceName() + ", reason: " + me.getMessage();
                LOG.error(msg);
                throw new Jbi4EjbDeployException(msg);
            }
        }
    }

    private List<File> listWSDLFiles(File currentDir) {
        File[] filesInCurrentDir;
        ArrayList<File> cumulativeResults = new ArrayList<File>();
        for (File element : filesInCurrentDir = currentDir.listFiles()) {
            if (element.isFile()) {
                if (!element.getName().toLowerCase().endsWith(".wsdl")) continue;
                cumulativeResults.add(element);
                continue;
            }
            if (!element.isDirectory()) continue;
            List<File> wsdlsInSubDirectories = this.listWSDLFiles(element);
            cumulativeResults.addAll(wsdlsInSubDirectories);
        }
        return cumulativeResults;
    }

    FileToDefinitionInfo[] readAllDefinitions(File dir) throws DeploymentException {
        List<File> wsdls = this.listWSDLFiles(dir);
        File[] wsdlFiles = wsdls.toArray(new File[0]);
        FileToDefinitionInfo[] fileToDefs = null;
        if (wsdlFiles != null) {
            fileToDefs = new FileToDefinitionInfo[wsdlFiles.length];
            for (int i = 0; i < wsdlFiles.length; ++i) {
                Definition def;
                try {
                    def = Jbi4EjbSUManager.readWsdl(wsdlFiles[i]);
                }
                catch (WSDLException e) {
                    LOG.error(e.getMessage());
                    throw new DeploymentException((Throwable)e);
                }
                fileToDefs[i] = new FileToDefinitionInfo(wsdlFiles[i], def);
            }
        }
        return fileToDefs;
    }

    public static Definition readWsdl(File f) throws WSDLException {
        WSDLFactory wsdlFactory = WSDLFactory.newInstance();
        ExtensionRegistry registry = wsdlFactory.newPopulatedExtensionRegistry();
        WSDLReader reader = ((WSDLFactoryImpl)wsdlFactory).newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setFeature("javax.wsdl.importDocuments", true);
        Jbi4EjbExtension.register(registry);
        LOG.debug("Extension QName: uri://schemas.imola.it/jbi/wsdl-extensions/ejb/");
        reader.setExtensionRegistry(registry);
        Definition def = reader.readWSDL(f.getAbsolutePath());
        return def;
    }

    public Jbi4EjbLifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    public void setLifeCycle(Jbi4EjbLifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public List<Jbi4EjbEndpoint> getDeployedEndpoints() {
        return this.deployedEndpoints;
    }

    static class FileToDefinitionInfo {
        private File mFile;
        private Definition mDefinition;

        FileToDefinitionInfo(File file, Definition definition) {
            this.mFile = file;
            this.mDefinition = definition;
        }

        public File getFile() {
            return this.mFile;
        }

        public Definition getDefinition() {
            return this.mDefinition;
        }
    }
}

