/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.perfdata.monitor.protocol.rmi;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import sun.jvmstat.monitor.HostIdentifier;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.VmIdentifier;
import sun.jvmstat.monitor.event.HostEvent;
import sun.jvmstat.monitor.event.HostListener;
import sun.jvmstat.monitor.event.VmStatusChangeEvent;
import sun.jvmstat.monitor.remote.RemoteHost;
import sun.jvmstat.monitor.remote.RemoteVm;
import sun.jvmstat.perfdata.monitor.CountedTimerTask;
import sun.jvmstat.perfdata.monitor.CountedTimerTaskUtils;
import sun.jvmstat.perfdata.monitor.protocol.rmi.RemoteMonitoredVm;
import sun.jvmstat.perfdata.monitor.protocol.rmi.RemoteVmManager;

public class MonitoredHostProvider
extends MonitoredHost {
    private static final String serverName = "/JStatRemoteHost";
    private static final int DEFAULT_POLLING_INTERVAL = 1000;
    private ArrayList listeners;
    private NotifierTask task;
    private HashSet activeVms;
    private RemoteVmManager vmManager;
    private RemoteHost remoteHost;
    private Timer timer;

    public MonitoredHostProvider(HostIdentifier hostIdentifier) throws MonitorException {
        this.hostId = hostIdentifier;
        this.listeners = new ArrayList();
        this.interval = 1000;
        this.activeVms = new HashSet();
        String string = serverName;
        String string2 = hostIdentifier.getPath();
        if (string2 != null && string2.length() > 0) {
            string = string2;
        }
        String string3 = hostIdentifier.getPort() != -1 ? "rmi://" + hostIdentifier.getHost() + ":" + hostIdentifier.getPort() + string : "rmi://" + hostIdentifier.getHost() + string;
        try {
            this.remoteHost = (RemoteHost)Naming.lookup(string3);
        }
        catch (RemoteException remoteException) {
            String string4 = "RMI Registry not available at " + hostIdentifier.getHost();
            string4 = hostIdentifier.getPort() == -1 ? string4 + ":" + 1099 : string4 + ":" + hostIdentifier.getPort();
            if (remoteException.getMessage() != null) {
                throw new MonitorException(string4 + "\n" + remoteException.getMessage(), remoteException);
            }
            throw new MonitorException(string4, remoteException);
        }
        catch (NotBoundException notBoundException) {
            String string5 = notBoundException.getMessage();
            if (string5 == null) {
                string5 = string3;
            }
            throw new MonitorException("RMI Server " + string5 + " not available", notBoundException);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            throw new IllegalArgumentException("Malformed URL: " + string3);
        }
        this.vmManager = new RemoteVmManager(this.remoteHost);
        this.timer = new Timer(true);
    }

    public MonitoredVm getMonitoredVm(VmIdentifier vmIdentifier) throws MonitorException {
        return this.getMonitoredVm(vmIdentifier, 1000);
    }

    public MonitoredVm getMonitoredVm(VmIdentifier vmIdentifier, int n) throws MonitorException {
        VmIdentifier vmIdentifier2 = null;
        try {
            vmIdentifier2 = this.hostId.resolve(vmIdentifier);
            RemoteVm remoteVm = this.remoteHost.attachVm(vmIdentifier.getLocalVmId(), vmIdentifier.getMode());
            RemoteMonitoredVm remoteMonitoredVm = new RemoteMonitoredVm(remoteVm, vmIdentifier2, this.timer, n);
            remoteMonitoredVm.attach();
            return remoteMonitoredVm;
        }
        catch (RemoteException remoteException) {
            throw new MonitorException("Remote Exception attaching to " + vmIdentifier2.toString(), remoteException);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Malformed URI: " + vmIdentifier.toString(), uRISyntaxException);
        }
    }

    public void detach(MonitoredVm monitoredVm) throws MonitorException {
        RemoteMonitoredVm remoteMonitoredVm = (RemoteMonitoredVm)monitoredVm;
        remoteMonitoredVm.detach();
        try {
            this.remoteHost.detachVm(remoteMonitoredVm.getRemoteVm());
        }
        catch (RemoteException remoteException) {
            throw new MonitorException("Remote Exception detaching from " + monitoredVm.getVmIdentifier().toString(), remoteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHostListener(HostListener hostListener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(hostListener);
            if (this.task == null) {
                this.task = new NotifierTask();
                this.timer.schedule((TimerTask)this.task, 0L, (long)this.interval);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHostListener(HostListener hostListener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(hostListener);
            if (this.listeners.isEmpty() && this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInterval(int n) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            if (n == this.interval) {
                return;
            }
            int n2 = this.interval;
            super.setInterval(n);
            if (this.task != null) {
                this.task.cancel();
                NotifierTask notifierTask = this.task;
                this.task = new NotifierTask();
                CountedTimerTaskUtils.reschedule(this.timer, notifierTask, this.task, n2, n);
            }
        }
    }

    public Set activeVms() throws MonitorException {
        return this.vmManager.activeVms();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireVmStatusChangedEvents(Set set, Set set2, Set set3) {
        ArrayList arrayList = null;
        VmStatusChangeEvent vmStatusChangeEvent = null;
        ArrayList arrayList2 = this.listeners;
        synchronized (arrayList2) {
            arrayList = (ArrayList)this.listeners.clone();
        }
        for (HostListener hostListener : arrayList) {
            if (vmStatusChangeEvent == null) {
                vmStatusChangeEvent = new VmStatusChangeEvent(this, set, set2, set3);
            }
            hostListener.vmStatusChanged(vmStatusChangeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireDisconnectedEvents() {
        ArrayList arrayList = null;
        HostEvent hostEvent = null;
        ArrayList arrayList2 = this.listeners;
        synchronized (arrayList2) {
            arrayList = (ArrayList)this.listeners.clone();
        }
        for (HostListener hostListener : arrayList) {
            if (hostEvent == null) {
                hostEvent = new HostEvent(this);
            }
            hostListener.disconnected(hostEvent);
        }
    }

    private class NotifierTask
    extends CountedTimerTask {
        private NotifierTask() {
        }

        public void run() {
            super.run();
            HashSet hashSet = MonitoredHostProvider.this.activeVms;
            try {
                MonitoredHostProvider.this.activeVms = (HashSet)MonitoredHostProvider.this.vmManager.activeVms();
            }
            catch (MonitorException monitorException) {
                System.err.println("MonitoredHostProvider: polling task caught MonitorException:");
                monitorException.printStackTrace();
                MonitoredHostProvider.this.setLastException(monitorException);
                MonitoredHostProvider.this.fireDisconnectedEvents();
            }
            if (MonitoredHostProvider.this.activeVms.isEmpty()) {
                return;
            }
            HashSet<Integer> hashSet2 = new HashSet<Integer>();
            HashSet<Integer> hashSet3 = new HashSet<Integer>();
            for (Integer n : MonitoredHostProvider.this.activeVms) {
                if (hashSet.contains(n)) continue;
                hashSet2.add(n);
            }
            for (Integer n : hashSet) {
                if (MonitoredHostProvider.this.activeVms.contains(n)) continue;
                hashSet3.add(n);
            }
            if (!hashSet2.isEmpty() || !hashSet3.isEmpty()) {
                MonitoredHostProvider.this.fireVmStatusChangedEvents(MonitoredHostProvider.this.activeVms, hashSet2, hashSet3);
            }
        }
    }
}

