/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.ThreadGroupReference;
import com.sun.tools.example.debug.tty.Env;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

class ThreadGroupIterator
implements Iterator {
    private final Stack stack = new Stack();

    ThreadGroupIterator(List list) {
        this.push(list);
    }

    ThreadGroupIterator(ThreadGroupReference threadGroupReference) {
        ArrayList<ThreadGroupReference> arrayList = new ArrayList<ThreadGroupReference>();
        arrayList.add(threadGroupReference);
        this.push(arrayList);
    }

    ThreadGroupIterator() {
        this(Env.vm().topLevelThreadGroups());
    }

    private Iterator top() {
        return (Iterator)this.stack.peek();
    }

    private void push(List list) {
        this.stack.push(list.iterator());
        while (!this.stack.isEmpty() && !this.top().hasNext()) {
            this.stack.pop();
        }
    }

    public boolean hasNext() {
        return !this.stack.isEmpty();
    }

    public Object next() {
        return this.nextThreadGroup();
    }

    public ThreadGroupReference nextThreadGroup() {
        ThreadGroupReference threadGroupReference = (ThreadGroupReference)this.top().next();
        this.push(threadGroupReference.threadGroups());
        return threadGroupReference;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    static ThreadGroupReference find(String string) {
        ThreadGroupIterator threadGroupIterator = new ThreadGroupIterator();
        while (threadGroupIterator.hasNext()) {
            ThreadGroupReference threadGroupReference = threadGroupIterator.nextThreadGroup();
            if (!threadGroupReference.name().equals(string)) continue;
            return threadGroupReference;
        }
        return null;
    }
}

