/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.util;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IndexBuilder {
    private Map indexmap = new HashMap();
    private boolean noDeprecated;
    private boolean classesOnly;
    protected final Object[] elements;

    public IndexBuilder(Configuration configuration, boolean bl) {
        this(configuration, bl, false);
    }

    public IndexBuilder(Configuration configuration, boolean bl, boolean bl2) {
        if (bl2) {
            configuration.message.notice("doclet.Building_Index_For_All_Classes");
        } else {
            configuration.message.notice("doclet.Building_Index");
        }
        this.noDeprecated = bl;
        this.classesOnly = bl2;
        this.buildIndexMap(configuration.root);
        Set set = this.indexmap.keySet();
        this.elements = set.toArray();
        Arrays.sort(this.elements);
    }

    protected void sortIndexMap() {
        Iterator iterator = this.indexmap.values().iterator();
        while (iterator.hasNext()) {
            Collections.sort((List)iterator.next(), new DocComparator());
        }
    }

    protected void buildIndexMap(RootDoc rootDoc) {
        Doc[] docArray = rootDoc.specifiedPackages();
        Doc[] docArray2 = rootDoc.classes();
        if (!this.classesOnly) {
            if (docArray.length == 0) {
                HashSet<PackageDoc> hashSet = new HashSet<PackageDoc>();
                for (int i = 0; i < docArray2.length; ++i) {
                    PackageDoc packageDoc = docArray2[i].containingPackage();
                    if (packageDoc == null || packageDoc.name().length() <= 0) continue;
                    hashSet.add(packageDoc);
                }
                this.adjustIndexMap((PackageDoc[])hashSet.toArray(docArray));
            } else {
                this.adjustIndexMap(docArray);
            }
        }
        this.adjustIndexMap(docArray2);
        if (!this.classesOnly) {
            for (int i = 0; i < docArray2.length; ++i) {
                if (!this.shouldAddToIndexMap(docArray2[i])) continue;
                this.putMembersInIndexMap((ClassDoc)docArray2[i]);
            }
        }
        this.sortIndexMap();
    }

    protected void putMembersInIndexMap(ClassDoc classDoc) {
        this.adjustIndexMap(classDoc.fields());
        this.adjustIndexMap(classDoc.methods());
        this.adjustIndexMap(classDoc.constructors());
    }

    protected void adjustIndexMap(Doc[] docArray) {
        for (int i = 0; i < docArray.length; ++i) {
            if (!this.shouldAddToIndexMap(docArray[i])) continue;
            String string = docArray[i].name();
            char c = string.length() == 0 ? (char)'*' : (char)Character.toUpperCase(string.charAt(0));
            Character c2 = new Character(c);
            ArrayList<Doc> arrayList = (ArrayList<Doc>)this.indexmap.get(c2);
            if (arrayList == null) {
                arrayList = new ArrayList<Doc>();
                this.indexmap.put(c2, arrayList);
            }
            arrayList.add(docArray[i]);
        }
    }

    protected boolean shouldAddToIndexMap(Doc doc) {
        return !this.noDeprecated || doc.tags("deprecated").length <= 0;
    }

    public Map getIndexMap() {
        return this.indexmap;
    }

    public List getMemberList(Character c) {
        return (List)this.indexmap.get(c);
    }

    public Object[] elements() {
        return this.elements;
    }

    private class DocComparator
    implements Comparator {
        private DocComparator() {
        }

        public int compare(Object object, Object object2) {
            String string;
            String string2 = ((Doc)object).name();
            int n = string2.compareToIgnoreCase(string = ((Doc)object2).name());
            if (n != 0) {
                return n;
            }
            if (object instanceof ProgramElementDoc && object2 instanceof ProgramElementDoc) {
                string2 = ((ProgramElementDoc)object).qualifiedName();
                string = ((ProgramElementDoc)object2).qualifiedName();
                return string2.compareToIgnoreCase(string);
            }
            return 0;
        }
    }
}

