/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.builders;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.SerialFieldTag;
import com.sun.javadoc.Tag;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.SerializedFormWriter;
import com.sun.tools.doclets.internal.toolkit.builders.AbstractBuilder;
import com.sun.tools.doclets.internal.toolkit.builders.LayoutParser;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

public class SerializedFormBuilder
extends AbstractBuilder {
    public static final String NAME = "SerializedForm";
    private SerializedFormWriter writer;
    private SerializedFormWriter.SerialFieldWriter fieldWriter;
    private SerializedFormWriter.SerialMethodWriter methodWriter;
    private static final String SERIAL_VERSION_UID_HEADER = "serialVersionUID:";
    private PackageDoc currentPackage;
    private ClassDoc currentClass;
    protected MemberDoc currentMember;

    private SerializedFormBuilder(Configuration configuration) {
        super(configuration);
    }

    public static SerializedFormBuilder getInstance(Configuration configuration) {
        SerializedFormBuilder serializedFormBuilder = new SerializedFormBuilder(configuration);
        return serializedFormBuilder;
    }

    public void build() throws IOException {
        if (!this.serialClassFoundToDocument(this.configuration.root.classes())) {
            return;
        }
        try {
            this.writer = this.configuration.getWriterFactory().getSerializedFormWriter();
            if (this.writer == null) {
                return;
            }
        }
        catch (Exception exception) {
            throw new DocletAbortException();
        }
        this.build(LayoutParser.getInstance(this.configuration).parseXML(NAME));
        this.writer.close();
    }

    public String getName() {
        return NAME;
    }

    public void buildSerializedForm(List list) throws Exception {
        this.build(list);
        this.writer.close();
    }

    public void invokeMethod(String string, Class[] classArray, Object[] objectArray) throws Exception {
        Method method = this.getClass().getMethod(string, classArray);
        method.invoke((Object)this, objectArray);
    }

    public void buildHeader() {
        this.writer.writeHeader(this.configuration.getText("doclet.Serialized_Form"));
    }

    public void buildSerializedFormSummaries(List list) {
        PackageDoc[] packageDocArray = this.configuration.packages;
        for (int i = 0; i < packageDocArray.length; ++i) {
            this.currentPackage = packageDocArray[i];
            this.build(list);
        }
    }

    public void buildPackageSerializedForm(List list) {
        String string = this.currentPackage.name();
        ClassDoc[] classDocArray = this.currentPackage.allClasses(false);
        if (classDocArray == null || classDocArray.length == 0) {
            return;
        }
        if (!SerializedFormBuilder.serialInclude(this.currentPackage)) {
            return;
        }
        if (!this.serialClassFoundToDocument(classDocArray)) {
            return;
        }
        this.build(list);
    }

    public void buildPackageHeader() {
        this.writer.writePackageHeader(Util.getPackageName(this.currentPackage));
    }

    public void buildClassSerializedForm(List list) {
        Object[] objectArray = this.currentPackage.allClasses(false);
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            this.currentClass = objectArray[i];
            this.fieldWriter = this.writer.getSerialFieldWriter(this.currentClass);
            this.methodWriter = this.writer.getSerialMethodWriter(this.currentClass);
            if (!this.currentClass.isClass() || !this.currentClass.isSerializable() || !SerializedFormBuilder.serialClassInclude(this.currentClass)) continue;
            this.build(list);
        }
    }

    public void buildClassHeader() {
        this.writer.writeClassHeader(this.currentClass);
    }

    public void buildSerialUIDInfo() {
        FieldDoc[] fieldDocArray = this.currentClass.fields(false);
        for (int i = 0; i < fieldDocArray.length; ++i) {
            if (!fieldDocArray[i].name().equals("serialVersionUID") || fieldDocArray[i].constantValueExpression() == null) continue;
            this.writer.writeSerialUIDInfo(SERIAL_VERSION_UID_HEADER, fieldDocArray[i].constantValueExpression());
            return;
        }
    }

    public void buildFooter() {
        this.writer.writeFooter();
    }

    public static boolean serialInclude(Doc doc) {
        if (doc == null) {
            return false;
        }
        return doc.isClass() ? SerializedFormBuilder.serialClassInclude((ClassDoc)doc) : SerializedFormBuilder.serialDocInclude(doc);
    }

    private static boolean serialClassInclude(ClassDoc classDoc) {
        if (classDoc.isEnum()) {
            return false;
        }
        try {
            classDoc.superclassType();
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        if (classDoc.isSerializable()) {
            if (classDoc.tags("serial").length > 0) {
                return SerializedFormBuilder.serialDocInclude(classDoc);
            }
            return classDoc.isPublic() || classDoc.isProtected();
        }
        return false;
    }

    private static boolean serialDocInclude(Doc doc) {
        if (doc.isEnum()) {
            return false;
        }
        Tag[] tagArray = doc.tags("serial");
        if (tagArray.length > 0) {
            String string = tagArray[0].text().toLowerCase();
            if (string.indexOf("exclude") >= 0) {
                return false;
            }
            if (string.indexOf("include") >= 0) {
                return true;
            }
        }
        return true;
    }

    private boolean serialClassFoundToDocument(ClassDoc[] classDocArray) {
        for (int i = 0; i < classDocArray.length; ++i) {
            if (!SerializedFormBuilder.serialClassInclude(classDocArray[i])) continue;
            return true;
        }
        return false;
    }

    public void buildMethodHeader() {
        if (this.currentClass.serializationMethods().length > 0) {
            this.methodWriter.writeHeader(this.configuration.getText("doclet.Serialized_Form_methods"));
            if (this.currentClass.isSerializable() && !this.currentClass.isExternalizable() && this.currentClass.serializationMethods().length == 0) {
                this.methodWriter.writeNoCustomizationMsg(this.configuration.getText("doclet.Serializable_no_customization"));
            }
        }
    }

    public void buildMethodSubHeader() {
        this.methodWriter.writeMemberHeader((MethodDoc)this.currentMember);
    }

    public void buildDeprecatedMethodInfo() {
        this.methodWriter.writeDeprecatedMemberInfo((MethodDoc)this.currentMember);
    }

    public void buildMethodDescription() {
        this.methodWriter.writeMemberDescription((MethodDoc)this.currentMember);
    }

    public void buildMethodTags() {
        this.methodWriter.writeMemberTags((MethodDoc)this.currentMember);
        MethodDoc methodDoc = (MethodDoc)this.currentMember;
        if (methodDoc.name().compareTo("writeExternal") == 0 && methodDoc.tags("serialData").length == 0 && this.configuration.serialwarn) {
            this.configuration.getDocletSpecificMsg().warning(this.currentMember.position(), "doclet.MissingSerialDataTag", methodDoc.containingClass().qualifiedName(), methodDoc.name());
        }
    }

    public void buildMethodInfo(List list) {
        if (this.configuration.nocomment) {
            return;
        }
        this.build(list);
    }

    public void buildMethodFooter() {
        this.methodWriter.writeMemberFooter((MethodDoc)this.currentMember);
    }

    public void buildFieldHeader() {
        if (this.currentClass.serializableFields().length > 0) {
            this.buildFieldSerializationOverview(this.currentClass);
            this.fieldWriter.writeHeader(this.configuration.getText("doclet.Serialized_Form_fields"));
        }
    }

    public void buildFieldSerializationOverview(ClassDoc classDoc) {
        FieldDoc fieldDoc;
        String string;
        if (classDoc.definesSerializableFields() && (string = (fieldDoc = (FieldDoc)Util.asList(classDoc.serializableFields()).get(0)).commentText()).length() > 0) {
            this.fieldWriter.writeHeader(this.configuration.getText("doclet.Serialized_Form_class"));
            if (!this.configuration.nocomment) {
                this.fieldWriter.writeMemberDeprecatedInfo(fieldDoc);
                this.fieldWriter.writeMemberDescription(fieldDoc);
                this.fieldWriter.writeMemberTags(fieldDoc);
                this.fieldWriter.writeMemberFooter(fieldDoc);
            }
        }
    }

    public void buildFieldSubHeader() {
        if (!this.currentClass.definesSerializableFields()) {
            FieldDoc fieldDoc = (FieldDoc)this.currentMember;
            this.fieldWriter.writeMemberHeader(fieldDoc.type().asClassDoc(), fieldDoc.type().typeName(), fieldDoc.type().dimension(), fieldDoc.name());
        }
    }

    public void buildFieldInfo() {
        if (this.configuration.nocomment) {
            return;
        }
        FieldDoc fieldDoc = (FieldDoc)this.currentMember;
        ClassDoc classDoc = fieldDoc.containingClass();
        if (classDoc.definesSerializableFields()) {
            Object[] objectArray = fieldDoc.serialFieldTags();
            Arrays.sort(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                this.fieldWriter.writeMemberHeader(objectArray[i].fieldTypeDoc(), objectArray[i].fieldType(), "", objectArray[i].fieldName());
                this.fieldWriter.writeMemberDescription((SerialFieldTag)objectArray[i]);
            }
        } else {
            if (fieldDoc.tags("serial").length == 0 && !fieldDoc.isSynthetic() && this.configuration.serialwarn) {
                this.configuration.message.warning(fieldDoc.position(), "doclet.MissingSerialTag", classDoc.qualifiedName(), fieldDoc.name());
            }
            this.fieldWriter.writeMemberDeprecatedInfo(fieldDoc);
            this.fieldWriter.writeMemberDescription(fieldDoc);
            this.fieldWriter.writeMemberTags(fieldDoc);
        }
    }

    public void buildFieldFooter() {
        if (!this.currentClass.definesSerializableFields()) {
            this.fieldWriter.writeMemberFooter((FieldDoc)this.currentMember);
        }
    }

    public void buildSerializableMethods(List list) {
        MethodDoc[] methodDocArray = this.currentClass.serializationMethods();
        if (methodDocArray.length > 0) {
            for (int i = 0; i < methodDocArray.length; ++i) {
                this.currentMember = methodDocArray[i];
                this.build(list);
            }
        }
    }

    public void buildSerializableFields(List list) {
        FieldDoc[] fieldDocArray = this.currentClass.serializableFields();
        if (fieldDocArray.length > 0) {
            for (int i = 0; i < fieldDocArray.length; ++i) {
                this.currentMember = fieldDocArray[i];
                this.build(list);
            }
        }
    }
}

