/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.formats.html.AbstractPackageIndexWriter;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class PackageIndexWriter
extends AbstractPackageIndexWriter {
    private RootDoc root;
    private Map groupPackageMap;
    private List groupList;

    public PackageIndexWriter(ConfigurationImpl configurationImpl, String string) throws IOException {
        super(configurationImpl, string);
        this.root = configurationImpl.root;
        this.groupPackageMap = configurationImpl.group.groupPackages(this.packages);
        this.groupList = configurationImpl.group.getGroupList();
    }

    public static void generate(ConfigurationImpl configurationImpl) {
        String string = "overview-summary.html";
        try {
            PackageIndexWriter packageIndexWriter = new PackageIndexWriter(configurationImpl, string);
            packageIndexWriter.generatePackageIndexFile(true);
            packageIndexWriter.close();
        }
        catch (IOException iOException) {
            configurationImpl.standardmessage.error("doclet.exception_encountered", iOException.toString(), string);
            throw new DocletAbortException();
        }
    }

    protected void printIndexRow(PackageDoc packageDoc) {
        if (packageDoc != null && packageDoc.name().length() > 0) {
            this.trBgcolorStyle("white", "TableRowColor");
            this.summaryRow(20);
            this.bold();
            this.printPackageLink(packageDoc, Util.getPackageName(packageDoc), false);
            this.boldEnd();
            this.summaryRowEnd();
            this.summaryRow(0);
            this.printSummaryComment(packageDoc);
            this.summaryRowEnd();
            this.trEnd();
        }
    }

    protected void generateIndex() {
        for (int i = 0; i < this.groupList.size(); ++i) {
            String string = (String)this.groupList.get(i);
            List list = (List)this.groupPackageMap.get(string);
            if (list == null || list.size() <= 0) continue;
            this.printIndexContents(list.toArray(new PackageDoc[list.size()]), string);
        }
    }

    protected void printOverviewHeader() {
        if (this.root.inlineTags().length > 0) {
            this.printSummaryComment(this.root);
            this.p();
            this.bold(this.configuration.getText("doclet.See"));
            this.br();
            this.printNbsps();
            this.printHyperLink("", "overview_description", this.configuration.getText("doclet.Description"), true);
            this.p();
        }
    }

    protected void printIndexHeader(String string) {
        this.tableIndexSummary();
        this.tableHeaderStart("#CCCCFF");
        this.bold(string);
        this.tableHeaderEnd();
    }

    protected void printIndexFooter() {
        this.tableEnd();
        this.p();
        this.space();
    }

    protected void printOverviewComment() {
        if (this.root.inlineTags().length > 0) {
            this.anchor("overview_description");
            this.p();
            this.printInlineComment(this.root);
            this.p();
        }
    }

    protected void printOverview() throws IOException {
        this.printOverviewComment();
        this.printTags(this.root);
    }

    protected void printNavigationBarHeader() {
        this.navLinks(true);
        this.hr();
        this.printConfigurationTitle();
    }

    protected void printNavigationBarFooter() {
        this.hr();
        this.navLinks(false);
        this.printBottom();
    }
}

