/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.HtmlDocletWriter;
import com.sun.tools.doclets.formats.html.LinkInfoImpl;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.doclets.internal.toolkit.util.IndexBuilder;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.List;

public class AllClassesFrameWriter
extends HtmlDocletWriter {
    public static final String OUTPUT_FILE_NAME_FRAMES = "allclasses-frame.html";
    public static final String OUTPUT_FILE_NAME_NOFRAMES = "allclasses-noframe.html";
    protected IndexBuilder indexbuilder;

    public AllClassesFrameWriter(ConfigurationImpl configurationImpl, String string, IndexBuilder indexBuilder) throws IOException {
        super(configurationImpl, string);
        this.indexbuilder = indexBuilder;
    }

    public static void generate(ConfigurationImpl configurationImpl, IndexBuilder indexBuilder) {
        String string = OUTPUT_FILE_NAME_FRAMES;
        try {
            AllClassesFrameWriter allClassesFrameWriter = new AllClassesFrameWriter(configurationImpl, string, indexBuilder);
            allClassesFrameWriter.generateAllClassesFile(true);
            allClassesFrameWriter.close();
            string = OUTPUT_FILE_NAME_NOFRAMES;
            allClassesFrameWriter = new AllClassesFrameWriter(configurationImpl, string, indexBuilder);
            allClassesFrameWriter.generateAllClassesFile(false);
            allClassesFrameWriter.close();
        }
        catch (IOException iOException) {
            configurationImpl.standardmessage.error("doclet.exception_encountered", iOException.toString(), string);
            throw new DocletAbortException();
        }
    }

    protected void generateAllClassesFile(boolean bl) throws IOException {
        String string = this.configuration.getText("doclet.All_Classes");
        this.printHtmlHeader(string, null, false);
        this.printAllClassesTableHeader();
        this.printAllClasses(bl);
        this.printAllClassesTableFooter();
        this.printBodyHtmlEnd();
    }

    protected void printAllClasses(boolean bl) {
        for (int i = 0; i < this.indexbuilder.elements().length; ++i) {
            Character c = (Character)this.indexbuilder.elements()[i];
            this.generateContents(this.indexbuilder.getMemberList(c), bl);
        }
    }

    protected void generateContents(List list, boolean bl) {
        for (int i = 0; i < list.size(); ++i) {
            ClassDoc classDoc = (ClassDoc)list.get(i);
            if (!Util.isCoreClass(classDoc)) continue;
            String string = this.italicsClassName(classDoc, false);
            if (bl) {
                this.printLink(new LinkInfoImpl(1, classDoc, string, "classFrame"));
            } else {
                this.printLink(new LinkInfoImpl(classDoc, string));
            }
            this.br();
        }
    }

    protected void printAllClassesTableHeader() {
        this.fontSizeStyle("+1", "FrameHeadingFont");
        this.boldText("doclet.All_Classes");
        this.fontEnd();
        this.br();
        this.table();
        this.tr();
        this.tdNowrap();
        this.fontStyle("FrameItemFont");
    }

    protected void printAllClassesTableFooter() {
        this.fontEnd();
        this.tdEnd();
        this.trEnd();
        this.tableEnd();
    }
}

