/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.properties;

import java.awt.Component;
import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JTabbedPaneOperator;

public class PropertySheetTabOperator
extends ContainerOperator {
    public PropertySheetTabOperator(ContainerOperator contOper, String tabName) {
        super(PropertySheetTabOperator.resolveParent(contOper));
    }

    public PropertySheetTabOperator(ContainerOperator contOper) {
        super(PropertySheetTabOperator.resolveParent(contOper));
    }

    private static Container resolveParent(ContainerOperator contOper) {
        if (contOper.getParent() == null) {
            return (Container)contOper.getSource();
        }
        return contOper.getParent();
    }

    private static JComponent findPropertySheetTab(ContainerOperator contOper, String tabName) {
        PropertySheetTabChooser chooser = new PropertySheetTabChooser();
        ComponentSearcher searcher = new ComponentSearcher((Container)contOper.getSource());
        searcher.setOutput(TestOut.getNullOutput());
        Component comp = searcher.findComponent((ComponentChooser)chooser);
        if (comp == null) {
            return null;
        }
        JTabbedPaneOperator tabbed = new JTabbedPaneOperator((JTabbedPane)comp.getParent());
        int count = tabbed.getTabCount();
        for (int i = 0; i < count; ++i) {
            if (!contOper.getComparator().equals(tabbed.getTitleAt(i), tabName)) continue;
            tabbed.selectPage(i);
            return (JComponent)tabbed.getSelectedComponent();
        }
        return null;
    }

    private static JComponent waitPropertySheetTab(final ContainerOperator contOper, final String tabName) {
        try {
            Waiter waiter = new Waiter(new Waitable(){

                public Object actionProduced(Object obj) {
                    return PropertySheetTabOperator.findPropertySheetTab(contOper, tabName);
                }

                public String getDescription() {
                    return "Wait PropertySheetTab \"" + tabName + "\".";
                }
            });
            waiter.setOutput(JemmyProperties.getCurrentOutput());
            return (JComponent)waiter.waitAction(null);
        }
        catch (InterruptedException e) {
            throw new JemmyException("Interrupted waiting for PropertySheetTab");
        }
    }

    public int getCount() {
        throw new JemmyException("Don't use this! No JTabbedPane is used in property sheet.");
    }

    private static class PropertySheetTabChooser
    implements ComponentChooser {
        public boolean checkComponent(Component comp) {
            return comp.getClass().getName().equals("org.openide.explorer.propertysheet.SheetTable");
        }

        public String getDescription() {
            return "SheetTable";
        }
    }
}

