/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.model.navigation;

import java.util.ArrayList;
import java.util.Hashtable;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.modules.visualweb.gravy.Bundle;
import org.netbeans.modules.visualweb.gravy.ProjectNavigatorOperator;
import org.netbeans.modules.visualweb.gravy.TestUtils;
import org.netbeans.modules.visualweb.gravy.model.navigation.Link;
import org.netbeans.modules.visualweb.gravy.model.navigation.LinkableSource;
import org.netbeans.modules.visualweb.gravy.model.navigation.LinkableTarget;
import org.netbeans.modules.visualweb.gravy.model.project.Project;
import org.netbeans.modules.visualweb.gravy.navigation.NavigatorOperator;

public class LinkManager {
    private static final String bundle = "org.netbeans.modules.visualweb.gravy.model.navigation.Bundle";
    private static final String navigationBundle = Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.navigation.Bundle", "NavigationBundle");
    private static final String nodeNavigation = Bundle.getStringTrimmed(navigationBundle, Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.navigation.Bundle", "PageNavigation"));
    private static final String popupOpen = Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.navigation.Bundle", "OpenPopupItem");
    private Project project;
    private Hashtable links = new Hashtable();

    public LinkManager(Project project) {
        this.project = project;
    }

    public Link createLink(LinkableSource source, LinkableTarget target, String name) {
        ProjectNavigatorOperator prjNav = ProjectNavigatorOperator.showProjectNavigator();
        TestUtils.wait(1000);
        try {
            ProjectNavigatorOperator.pressPopupItemOnNode(this.project.getName() + "|" + nodeNavigation, popupOpen, (Operator.StringComparator)new Operator.DefaultStringComparator(true, true));
        }
        catch (Exception e) {
            throw new JemmyException(popupOpen + " item in popup menu of " + nodeNavigation + " node can't be found!", (Throwable)e);
        }
        TestUtils.wait(1000);
        NavigatorOperator no = new NavigatorOperator();
        TestUtils.wait(1000);
        try {
            no.linkUsingXmlSource(source.getLinkableSourceName(), target.getLinkableTargetName(), name);
        }
        catch (Exception e) {
            throw new JemmyException("Link can't be created!", (Throwable)e);
        }
        TestUtils.wait(1000);
        Link newLink = new Link(source, target, name);
        this.links.put(name, newLink);
        return newLink;
    }

    public void changeSource(Link link, LinkableSource source) {
        link.source = source;
    }

    public void changeTarget(Link link, LinkableTarget target) {
        link.target = target;
    }

    public void changeName(Link link, String name) {
        link.name = name;
    }

    public void deleteLink(Link link) {
        this.links.remove(link.getName());
    }

    public Link[] getLinks() {
        return this.links.values().toArray(new Link[this.links.size()]);
    }

    public Link[] getFromLinks(LinkableSource source) {
        ArrayList<Link> srcLinks = new ArrayList<Link>();
        Link[] tmpLinks = this.links.values().toArray(new Link[this.links.size()]);
        for (int i = 0; i < tmpLinks.length; ++i) {
            if (!tmpLinks[i].getSource().equals(source)) continue;
            srcLinks.add(tmpLinks[i]);
        }
        return srcLinks.toArray(new Link[srcLinks.size()]);
    }

    public Link[] getToLinks(LinkableTarget target) {
        ArrayList<Link> trgLinks = new ArrayList<Link>();
        Link[] tmpLinks = this.links.values().toArray(new Link[this.links.size()]);
        for (int i = 0; i < tmpLinks.length; ++i) {
            if (!tmpLinks[i].getTarget().equals(target)) continue;
            trgLinks.add(tmpLinks[i]);
        }
        return trgLinks.toArray(new Link[trgLinks.size()]);
    }
}

