/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy;

import java.awt.Component;
import java.awt.Container;
import javax.swing.tree.TreePath;
import org.netbeans.jellytools.ProjectsTabOperator;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.modules.visualweb.gravy.Bundle;
import org.netbeans.modules.visualweb.gravy.TestUtils;
import org.netbeans.modules.visualweb.gravy.Util;
import org.netbeans.modules.visualweb.gravy.actions.ShowFilesAction;
import org.netbeans.modules.visualweb.gravy.actions.ShowProjectsAction;

public class ProjectNavigatorOperator
extends ProjectsTabOperator {
    public void selectPath(String treePath) {
        this.makeComponentVisible();
        TreePath path = this.tree().findPath(treePath);
        this.tree().selectPath(path);
    }

    public static ProjectNavigatorOperator showProjectNavigator() {
        new ShowProjectsAction().perform();
        new QueueTool().waitEmpty();
        Util.wait(500);
        return new ProjectNavigatorOperator();
    }

    public static void selectNode(String node) {
        ProjectNavigatorOperator projectNav = ProjectNavigatorOperator.showProjectNavigator();
        projectNav.makeComponentVisible();
        JTreeOperator tree = projectNav.tree();
        tree.selectPath(tree.findPath(node));
    }

    public void buildProject(String prjName) {
        this.makeComponentVisible();
        ProjectNavigatorOperator.pressPopupItemOnNode(prjName, Bundle.getStringTrimmed("com.sun.rave.project.actions.Bundle", "LBL_BuildProject"));
    }

    public static JTreeOperator switchToFiles() {
        new ShowFilesAction().perform();
        ContainerOperator containerOperator = new ContainerOperator((Container)ProjectNavigatorOperator.waitTopComponent(null, (String)Bundle.getStringTrimmed("org.netbeans.modules.project.ui.Bundle", "LBL_projectTab_tc"), (int)0, (ComponentChooser)new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return comp.getClass().getName().endsWith("ProjectTab");
            }

            public String getDescription() {
                return "org.netbeans.modules.projects.ui.ProjectTab";
            }
        }));
        Util.wait(1000);
        JTreeOperator treeOperator = new JTreeOperator(containerOperator);
        return treeOperator;
    }

    public static ProjectNavigatorOperator switchToProjects() {
        new ShowProjectsAction().perform();
        return new ProjectNavigatorOperator();
    }

    public static ProjectNavigatorOperator pressPopupItemOnNode(String path, String menuItem, Operator.StringComparator comparator) {
        try {
            ProjectNavigatorOperator projectNav = ProjectNavigatorOperator.showProjectNavigator();
            TestUtils.wait(4000);
            JTreeOperator tree = projectNav.tree();
            JPopupMenuOperator popup = path.equals("ROOT") ? new JPopupMenuOperator(tree.callPopupOnPath(new TreePath(tree.getRoot()))) : new JPopupMenuOperator(tree.callPopupOnPath(tree.findPath(path, "|")));
            new QueueTool().waitEmpty();
            Util.wait(1000);
            if (comparator != null) {
                popup.setComparator(comparator);
            }
            popup.pushMenuNoBlock(menuItem, "|");
            new QueueTool().waitEmpty();
            Util.wait(1000);
            return projectNav;
        }
        catch (Exception e) {
            System.out.println("Exception occured in pressPopupItemOnPath function");
            e.printStackTrace();
            return null;
        }
    }

    public static ProjectNavigatorOperator pressPopupItemOnNode(String path, String menuItem) {
        return ProjectNavigatorOperator.pressPopupItemOnNode(path, menuItem, null);
    }

    public void addWebPage(String projectName, String pageName) {
        String treeNodePath = projectName + "|" + Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.Bundle", "ProjectNode_WebPages");
        String popupMenuItem = Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.Bundle", "ProjectMenuItem_New") + "|" + Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.Bundle", "ProjectMenuItem_Page");
        ProjectNavigatorOperator.pressPopupItemOnNode(treeNodePath, popupMenuItem);
        JDialogOperator dialog = new JDialogOperator(Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.Bundle", "Dialog_NewPage"));
        Util.wait(1000);
        JTextFieldOperator textfieldFolderName = new JTextFieldOperator((ContainerOperator)dialog, 0);
        textfieldFolderName.setText(pageName);
        new JButtonOperator((ContainerOperator)dialog, Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.Bundle", "Button_Finish")).pushNoBlock();
        Util.wait(1000);
    }

    public void openWebPage(String projectName, String webPageName) {
        String treeNodePath = projectName + "|" + Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.Bundle", "ProjectNode_WebPages") + "|" + webPageName + Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.Bundle", "WebPage_extension");
        String popupMenuItem = Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.Bundle", "ProjectMenuItem_Open");
        ProjectNavigatorOperator.pressPopupItemOnNode(treeNodePath, popupMenuItem);
    }
}

