/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.util.ArrayList;
import org.netbeans.junit.diff.Diff;

public class LineDiff
implements Diff {
    private static boolean ignoreCase;

    public LineDiff(boolean ignoreCase) {
        LineDiff.ignoreCase = ignoreCase;
    }

    public static boolean getIgnoreCase() {
        return ignoreCase;
    }

    private boolean compareLines(String l1, String l2) {
        return LineDiff.getIgnoreCase() ? l1.equalsIgnoreCase(l2) : l1.equals(l2);
    }

    public boolean diff(String first, String second, String diff) throws IOException {
        File fFirst = new File(first);
        File fSecond = new File(second);
        File fDiff = null != diff ? new File(diff) : null;
        return this.diff(fFirst, fSecond, fDiff);
    }

    public boolean diff(File firstFile, File secondFile, File diffFile) throws IOException {
        LineNumberReader first = new LineNumberReader(new FileReader(firstFile));
        LineNumberReader second = new LineNumberReader(new FileReader(secondFile));
        if (diffFile == null) {
            String firstLine;
            while ((firstLine = first.readLine()) != null) {
                String secondLine = second.readLine();
                if (secondLine == null) {
                    first.close();
                    second.close();
                    return true;
                }
                if (this.compareLines(firstLine, secondLine)) continue;
                first.close();
                second.close();
                return true;
            }
        } else {
            int i;
            String secondLine;
            String firstLine;
            ArrayList<String> a1 = new ArrayList<String>();
            while ((firstLine = first.readLine()) != null) {
                a1.add(firstLine);
            }
            ArrayList<String> a2 = new ArrayList<String>();
            while ((secondLine = second.readLine()) != null) {
                a2.add(secondLine);
            }
            first.close();
            second.close();
            ArrayList<String> newLines = new ArrayList<String>();
            ArrayList<String> missingLines = new ArrayList<String>();
            int j = 0;
            for (i = 0; i < a1.size(); ++i) {
                int k;
                if (j >= a2.size()) {
                    for (k = i; k < a1.size(); ++k) {
                        missingLines.add(k + "> " + a1.get(k));
                    }
                    break;
                }
                firstLine = (String)a1.get(i);
                if (!this.compareLines(firstLine, secondLine = (String)a2.get(j))) {
                    boolean found = false;
                    for (k = j; k < a2.size(); ++k) {
                        secondLine = (String)a2.get(k);
                        if (!this.compareLines(firstLine, secondLine)) continue;
                        for (int l = j; l < k; ++l) {
                            newLines.add(l + "> " + a2.get(l));
                        }
                        j = k;
                        found = true;
                        break;
                    }
                    if (!found) {
                        missingLines.add(i + "> " + firstLine);
                        --j;
                    }
                }
                ++j;
            }
            if (j < a2.size()) {
                for (i = j; i < a2.size(); ++i) {
                    newLines.add(i + "> " + a2.get(i));
                }
            }
            if (missingLines.size() > 0 || newLines.size() > 0) {
                int i2;
                PrintStream pw = null;
                pw = new PrintStream(new FileOutputStream(diffFile));
                if (missingLines.size() > 0) {
                    pw.println("-----------------------------Missing Lines:-----");
                    for (i2 = 0; i2 < missingLines.size(); ++i2) {
                        pw.println(missingLines.get(i2));
                    }
                }
                if (newLines.size() > 0) {
                    pw.println("-----------------------------New Lines:---------");
                    for (i2 = 0; i2 < newLines.size(); ++i2) {
                        pw.println(newLines.get(i2));
                    }
                }
                pw.close();
                return true;
            }
        }
        return false;
    }

    public static void main(String[] argv) {
        try {
            LineDiff diff = new LineDiff(true);
            diff.diff("/tmp/diff/test.pass", "/tmp/diff/test.ref", "/tmp/diff/test.diff");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

