/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy;

import java.awt.Component;
import java.awt.Container;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.EventTool;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JEditorPaneOperator;
import org.netbeans.jemmy.operators.JLabelOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.JTabbedPaneOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.modules.visualweb.gravy.RaveWindowOperator;
import org.netbeans.modules.visualweb.gravy.TopComponentOperator;
import org.netbeans.modules.visualweb.gravy.actions.SaveAction;
import org.openide.cookies.LineCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.CloneableEditor;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.windows.TopComponent;

public class EditorOperator
extends TopComponentOperator {
    private static int WAIT_TIME = 60000;
    private JEditorPaneOperator _txtEditorPane;
    private JLabelOperator _lblRowColumn;
    private JLabelOperator _lblInputMode;
    private JLabelOperator _lblStatusBar;
    private JComboBoxOperator _cboQuickBrowse;

    public EditorOperator(String filename) {
        this(filename, 0);
    }

    public EditorOperator(String filename, int index) {
        super(EditorOperator.waitTopComponent(null, filename, index, new EditorSubchooser(filename)));
        this.requestFocus();
    }

    public EditorOperator(ContainerOperator contOper, String filename) {
        super(contOper, new EditorSubchooser(filename));
        this.requestFocus();
    }

    public EditorOperator(ContainerOperator contOper, String filename, int index) {
        super(EditorOperator.waitTopComponent(contOper, filename, index, new EditorSubchooser(filename)));
        this.copyEnvironment((Operator)contOper);
        this.requestFocus();
    }

    public static void closeDiscardAll() {
        JTabbedPaneOperator tabbed = new JTabbedPaneOperator((ContainerOperator)RaveWindowOperator.getDefault());
        for (int i = 0; i < tabbed.getTabCount(); ++i) {
            EditorOperator.close((TopComponent)tabbed.getComponent(i), false);
        }
    }

    public void close(boolean save) {
        if (save) {
            super.save();
            this.close();
        } else {
            this.closeDiscard();
        }
    }

    static void close(TopComponent tc, boolean save) {
        TopComponentOperator tco = new TopComponentOperator((JComponent)tc);
        if (save) {
            tco.save();
            tco.close();
        } else {
            tco.closeDiscard();
        }
    }

    public JEditorPaneOperator txtEditorPane() {
        if (this._txtEditorPane == null) {
            this._txtEditorPane = new JEditorPaneOperator((ContainerOperator)this);
        }
        return this._txtEditorPane;
    }

    public JLabelOperator lblRowColumn() {
        if (this._lblRowColumn == null) {
            this._lblRowColumn = new JLabelOperator((ContainerOperator)this, 0);
        }
        return this._lblRowColumn;
    }

    public JLabelOperator lblInputMode() {
        if (this._lblInputMode == null) {
            this._lblInputMode = new JLabelOperator((ContainerOperator)this, 1);
        }
        return this._lblInputMode;
    }

    public JLabelOperator lblStatusBar() {
        if (this._lblStatusBar == null) {
            this._lblStatusBar = new JLabelOperator((ContainerOperator)this, 2);
        }
        return this._lblStatusBar;
    }

    public JComboBoxOperator cboQuickBrowse() {
        if (this._cboQuickBrowse == null) {
            this._cboQuickBrowse = new JComboBoxOperator((ContainerOperator)this);
        }
        return this._cboQuickBrowse;
    }

    public void setQuickBrowse(String item) {
        this.cboQuickBrowse().selectItem(item);
    }

    public String getText() {
        return this.txtEditorPane().getText();
    }

    public String getText(int lineNumber) {
        return ((Line)this.getLine(lineNumber)).getText();
    }

    private Object getLine(int lineNumber) {
        Document doc = this.txtEditorPane().getDocument();
        DataObject od = (DataObject)doc.getProperty("stream");
        Line.Set set = ((LineCookie)od.getCookie(LineCookie.class)).getLineSet();
        try {
            return set.getCurrent(lineNumber - 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new JemmyException("Index must be > 0", (Throwable)e);
        }
    }

    public boolean contains(String text) {
        return this.getText().indexOf(text) != -1;
    }

    public void select(int lineNumber) {
        int lineOffset = this.getLineOffset(lineNumber);
        this.setCaretPosition(lineOffset);
        this.txtEditorPane().moveCaretPosition(lineOffset + this.getText(lineNumber).length());
    }

    public void select(int line1, int line2) {
        this.setCaretPosition(this.getLineOffset(line1));
        this.txtEditorPane().moveCaretPosition(this.getLineOffset(line2) + this.getText(line2).length());
    }

    public void select(int lineNumber, int column1, int column2) {
        int lineOffset = this.getLineOffset(lineNumber);
        this.setCaretPosition(lineOffset + column1 - 1);
        this.txtEditorPane().moveCaretPosition(lineOffset + column2);
    }

    public void select(String text, int index) {
        int position = this.txtEditorPane().getPositionByText(text, index);
        if (position == -1) {
            throw new JemmyException(index + "-th occurence of \"" + text + "\" not found.");
        }
        this.setCaretPosition(position);
        this.txtEditorPane().moveCaretPosition(position + text.length());
    }

    public void select(String text) {
        this.select(text, 0);
    }

    public void replace(String oldText, String newText) {
        this.replace(oldText, newText, 0);
    }

    public void replace(String oldText, String newText, int index) {
        this.select(oldText, index);
        this.txtEditorPane().replaceSelection(newText);
    }

    public void insert(final String text) {
        final int offset = this.txtEditorPane().getCaretPosition();
        this.runMapping(new Operator.MapVoidAction("insertString"){

            public void map() {
                try {
                    EditorOperator.this.txtEditorPane().getDocument().insertString(offset, text, null);
                }
                catch (BadLocationException e) {
                    throw new JemmyException("Cannot insert \"" + text + "\" to position " + offset + ".", (Throwable)e);
                }
            }
        });
    }

    public void insert(String text, int lineNumber, int column) {
        this.setCaretPosition(lineNumber, column);
        this.insert(text);
    }

    public void delete(int offset, int length) {
        try {
            this.txtEditorPane().getDocument().remove(offset, length);
        }
        catch (BadLocationException e) {
            throw new JemmyException("Cannot delete " + length + " characters from position " + offset + ".", (Throwable)e);
        }
    }

    public void delete(int length) {
        this.delete(this.txtEditorPane().getCaretPosition(), length);
    }

    public void deleteLine(int line) {
        this.delete(this.getLineOffset(line), this.getText(line).length());
    }

    public void delete(int lineNumber, int column1, int column2) {
        this.delete(this.getLineOffset(lineNumber) + column1 - 1, column2 - column1 + 1);
    }

    public int getLineNumber() {
        StyledDocument doc = (StyledDocument)this.txtEditorPane().getDocument();
        int offset = this.txtEditorPane().getCaretPosition();
        return NbDocument.findLineNumber((StyledDocument)doc, (int)offset) + 1;
    }

    public void pushKey(int keyCode) {
        this.requestFocus();
        this.txtEditorPane().pushKey(keyCode);
    }

    public void pushHomeKey() {
        this.pushKey(36);
    }

    public void pushEndKey() {
        this.pushKey(35);
    }

    public void pushTabKey() {
        this.pushKey(9);
    }

    public void pushDownArrowKey() {
        this.pushKey(40);
    }

    public void pushUpArrowKey() {
        this.pushKey(38);
    }

    private int getLineOffset(int lineNumber) {
        try {
            StyledDocument doc = (StyledDocument)this.txtEditorPane().getDocument();
            return NbDocument.findLineOffset((StyledDocument)doc, (int)(lineNumber - 1));
        }
        catch (IndexOutOfBoundsException e) {
            throw new JemmyException("Invalid line number " + lineNumber, (Throwable)e);
        }
    }

    public void setCaretPositionRelative(int relativeMove) {
        this.setCaretPosition(this.txtEditorPane().getCaretPosition() + relativeMove);
    }

    public void setCaretPositionToLine(int lineNumber) {
        this.txtEditorPane().setCaretPosition(this.getLineOffset(lineNumber));
    }

    public void setCaretPositionToEndOfLine(int lineNumber) {
        this.txtEditorPane().setCaretPosition(this.getLineOffset(lineNumber) + this.getText(lineNumber).length() - 1);
    }

    public void setCaretPosition(int lineNumber, int column) {
        this.setCaretPosition(this.getLineOffset(lineNumber) + column - 1);
    }

    public void setCaretPosition(int position) {
        if (position < 0 || position > this.getText().length()) {
            throw new JemmyException("Invalid caret position " + position);
        }
        this.txtEditorPane().setCaretPosition(position);
    }

    public void setCaretPosition(String text, int index, boolean before) {
        this.setCaretPosition(this.txtEditorPane().getPositionByText(text, index) + (before ? 0 : text.length()));
    }

    public void setCaretPosition(String text, boolean before) {
        this.setCaretPosition(text, 0, before);
    }

    public Object[] getAnnotations(int lineNumber) {
        return this.getAnnotations(this.getLine(lineNumber)).toArray(new Annotation[0]);
    }

    private List getAnnotations(Object line) {
        try {
            Method getAnnotations = Annotatable.class.getDeclaredMethod("getAnnotations", null);
            getAnnotations.setAccessible(true);
            return (List)getAnnotations.invoke(line, null);
        }
        catch (Exception e) {
            throw new JemmyException("getAnnotations() by reflection failed.", (Throwable)e);
        }
    }

    public Object[] getAnnotations() {
        Document doc = this.txtEditorPane().getDocument();
        DataObject dob = (DataObject)doc.getProperty("stream");
        Line.Set set = ((LineCookie)dob.getCookie(LineCookie.class)).getLineSet();
        Iterator iter = set.getLines().iterator();
        ArrayList result = new ArrayList();
        while (iter.hasNext()) {
            result.addAll(this.getAnnotations((Line)iter.next()));
        }
        Class<?> javaEditorClass = null;
        try {
            javaEditorClass = Class.forName("org.netbeans.modules.java.JavaEditor");
        }
        catch (ClassNotFoundException e) {
            this.getOutput().printLine("WARNING: Class org.netbeans.modules.java.JavaEditor not found.");
        }
        Node.Cookie javaEditorInstance = dob.getCookie(javaEditorClass);
        if (javaEditorInstance != null) {
            ArrayList overrideAnnotations;
            ArrayList errorAnnotations;
            try {
                Field annot = javaEditorClass.getDeclaredField("errorAnnotations");
                annot.setAccessible(true);
                errorAnnotations = (ArrayList)annot.get(javaEditorInstance);
            }
            catch (Exception e) {
                throw new JemmyException("Get errorAnnotations field failed.", (Throwable)e);
            }
            result.addAll(errorAnnotations);
            try {
                Field annot = javaEditorClass.getDeclaredField("overrideAnnotations");
                annot.setAccessible(true);
                overrideAnnotations = (ArrayList)annot.get(javaEditorInstance);
            }
            catch (Exception e) {
                throw new JemmyException("Get overrideAnnotations field failed.", (Throwable)e);
            }
            result.addAll(overrideAnnotations);
        }
        return result.toArray(new Annotation[result.size()]);
    }

    public static String getAnnotationType(Object annotation) {
        return ((Annotation)annotation).getAnnotationType();
    }

    public static String getAnnotationShortDescription(Object annotation) {
        return ((Annotation)annotation).getShortDescription();
    }

    public JButtonOperator getToolbarButton(String buttonTooltip) {
        ToolbarButtonChooser chooser = new ToolbarButtonChooser(buttonTooltip, this.getComparator());
        return new JButtonOperator(JButtonOperator.waitJButton((Container)((Container)this.getSource()), (ComponentChooser)chooser));
    }

    public JButtonOperator getToolbarButton(int index) {
        ComponentChooser chooser = new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return comp instanceof JToolBar;
            }

            public String getDescription() {
                return "javax.swing.JToolBar";
            }
        };
        Container toolbar = (Container)EditorOperator.findComponent((Container)((Container)this.getSource()), (ComponentChooser)chooser);
        if (toolbar == null) {
            throw new JemmyException("Toolbar not present.");
        }
        JComboBox combo = JComboBoxOperator.findJComboBox((Container)toolbar, (ComponentChooser)ComponentSearcher.getTrueChooser((String)"JComboBox"));
        if (combo != null) {
            ++index;
        }
        return new JButtonOperator(JButtonOperator.waitJButton((Container)toolbar, (ComponentChooser)ComponentSearcher.getTrueChooser((String)"JButton"), (int)index));
    }

    public void pushToolbarPopupMenu(String popupPath) {
        this.getToolbarButton(0).clickForPopup();
        new JPopupMenuOperator().pushMenu(popupPath, "|");
    }

    public boolean isModified() {
        return this.getName().endsWith("*");
    }

    public void waitModified(final boolean modified) {
        try {
            Waiter waiter = new Waiter(new Waitable(){

                public Object actionProduced(Object obj) {
                    return EditorOperator.this.isModified() == modified ? new Object() : null;
                }

                public String getDescription() {
                    return "Wait Modified State";
                }
            });
            Timeouts times = this.getTimeouts().cloneThis();
            times.setTimeout("Waiter.WaitingTime", times.getTimeout("EditorOperator.WaitModifiedTimeout"));
            waiter.setTimeouts(times);
            waiter.setOutput(this.getOutput());
            waiter.waitAction(null);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void save() {
        new SaveAction().perform((ComponentOperator)this);
        if (this.getVerification()) {
            this.waitModified(false);
        }
    }

    public void closeAndCancelByPopup() {
        this.clickForPopup();
        new JPopupMenuOperator().pushMenu("Close");
        new EventTool().waitNoEvent(500L);
        try {
            JDialogOperator qDialog = new JDialogOperator("Question");
            new QueueTool().waitEmpty(100L);
            new JButtonOperator((ContainerOperator)qDialog, "Cancel").push();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void verify() {
        this.txtEditorPane();
        this.cboQuickBrowse();
        this.lblInputMode();
        this.lblRowColumn();
        this.lblStatusBar();
    }

    static {
        Timeouts.initDefault((String)"EditorOperator.WaitModifiedTimeout", (long)WAIT_TIME);
    }

    private static final class EditorSubchooser
    implements ComponentChooser {
        String ID;

        public EditorSubchooser(String ID) {
            this.ID = ID;
        }

        public boolean checkComponent(Component comp) {
            return comp instanceof CloneableEditor && ((CloneableEditor)comp).getName().indexOf(this.ID) != -1 && comp.isShowing();
        }

        public String getDescription() {
            return "org.openide.text.CloneableEditor";
        }
    }

    private static class ToolbarButtonChooser
    implements ComponentChooser {
        private String buttonTooltip;
        private Operator.StringComparator comparator;

        public ToolbarButtonChooser(String buttonTooltip, Operator.StringComparator comparator) {
            this.buttonTooltip = buttonTooltip;
            this.comparator = comparator;
        }

        public boolean checkComponent(Component comp) {
            return this.comparator.equals(((JComponent)comp).getToolTipText(), this.buttonTooltip);
        }

        public String getDescription() {
            return "Toolbar button with tooltip \"" + this.buttonTooltip + "\".";
        }
    }
}

