/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.ant.taskdefs;

import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.webdav.ant.Utils;
import org.apache.webdav.ant.taskdefs.WebdavTask;

public class Unlock
extends WebdavTask {
    private String locktoken = null;

    public void execute() throws BuildException {
        this.validate();
        try {
            this.log("Unlocking " + this.getUrl(), 2);
            Utils.unlockResource(this.getHttpClient(), this.getUrl(), this.locktoken);
        }
        catch (IOException e) {
            throw Utils.makeBuildException("Can't unlock!", e);
        }
    }

    protected void validate() throws BuildException {
        super.validate();
        if (this.locktoken == null) {
            throw new BuildException("Required locktoken attribute missing!");
        }
    }

    public void setLocktoken(String token) {
        this.locktoken = token;
        if (!this.locktoken.startsWith("opaquelocktoken:")) {
            throw new BuildException("Invalid locktoken: " + token);
        }
    }
}

