/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.ant.taskdefs;

import java.io.IOException;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.URIException;
import org.apache.tools.ant.BuildException;
import org.apache.webdav.ant.Utils;
import org.apache.webdav.ant.taskdefs.WebdavMatchingTask;

public class Copy
extends WebdavMatchingTask {
    private String destination;
    private int depth = Integer.MAX_VALUE;
    private boolean overwrite = false;
    private HttpURL destinationURL;

    public void execute() throws BuildException {
        this.validate();
        try {
            this.log("Copying " + this.getUrl(), this.ifVerbose());
            Utils.copyResource(this.getHttpClient(), this.getUrl(), this.destinationURL.getURI(), this.depth, this.overwrite);
        }
        catch (IOException e) {
            throw Utils.makeBuildException("Can't copy!", e);
        }
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public void setDepth(String value) {
        if ("0".trim().equals(value)) {
            this.depth = 0;
        } else if ("infinity".trim().toLowerCase().equals(value)) {
            this.depth = Integer.MAX_VALUE;
        } else {
            throw new BuildException("Invalid value of depth attribute. (One of '0' or 'infinity' expected)");
        }
    }

    public void setOverwrite(boolean value) {
        this.overwrite = value;
    }

    protected void validate() {
        super.validate();
        if (this.destination == null) {
            throw new BuildException("Missing required attribute destination");
        }
        try {
            this.destinationURL = Utils.createHttpURL(this.getUrl(), this.destination);
            this.destinationURL.setPath(Copy.removeDoubleSlashes(this.destinationURL.getPath()));
        }
        catch (URIException e) {
            throw new BuildException("Invalid destination uri!", (Throwable)e);
        }
    }
}

