/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.DomText;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoGlobal;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoSelection;
import com.nwoods.jgo.JGoTextEdit;
import com.nwoods.jgo.JGoView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class JGoText
extends JGoObject {
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_CENTER = 2;
    public static final int ALIGN_RIGHT = 3;
    public static final int ChangedText = 501;
    public static final int ChangedAlignment = 502;
    public static final int ChangedFontSize = 503;
    public static final int ChangedFaceName = 504;
    public static final int ChangedTextColor = 505;
    public static final int ChangedBkColor = 506;
    public static final int ChangedTransparent = 507;
    public static final int ChangedBold = 508;
    public static final int ChangedUnderline = 509;
    public static final int ChangedItalic = 510;
    public static final int ChangedMultiline = 511;
    public static final int ChangedEditable = 512;
    public static final int ChangedEditOnSingleClick = 513;
    public static final int Changed2DScale = 514;
    public static final int ChangedSelectBackground = 515;
    public static final int ChangedClipping = 516;
    public static final int ChangedStrikeThrough = 517;
    public static final int ChangedAutoResize = 518;
    public static final int ChangedWrapping = 519;
    public static final int ChangedWrappingWidth = 520;
    public static final int ChangedBetterPainting = 521;
    private static final int flagTransparent = 1;
    private static final int flagBold = 2;
    private static final int flagUnderline = 4;
    private static final int flagItalic = 8;
    private static final int flagMultiline = 16;
    private static final int flagEditable = 32;
    private static final int flagEditOnSingleClick = 64;
    private static final int flag2DScale = 128;
    private static final int flagNeedNewFont = 256;
    private static final int flagNeedNewRect = 512;
    private static final int flagNeedRescale = 1024;
    private static final int flagSelectBackground = 2048;
    private static final int flagClipping = 4096;
    private static final int flagStrikeThrough = 8192;
    private static final int flagAutoResize = 16384;
    private static final int flagWrapping = 32768;
    private static final int flagBetterPainting = 65536;
    private static final int flagUnused3 = 131072;
    private static final int flagUnused2 = 262144;
    private static final int flagUnused1 = 524288;
    private static String myDefaultFontName = "SansSerif";
    private static int myDefaultFontSize = 12;
    private static int myThickerLineSize = 20;
    private static double myDefaultPaintNothingScale = 0.15;
    private static double myDefaultPaintGreekScale = 0.3;
    private static int myDefaultWrappingWidth = 150;
    private static boolean myMeasureWarning = false;
    private static boolean myDefaultBetterPainting = JGoGlobal.isAtLeastJavaVersion(1.22);
    private String myString = "";
    private String myFaceName = myDefaultFontName;
    private int myFontSize = myDefaultFontSize;
    private int myAlignment = 1;
    private Color myTextColor = JGoBrush.ColorBlack;
    private Color myBkColor = JGoBrush.ColorWhite;
    private int myTextFlags = 0;
    private int myUserTextFlags = 0;
    private int myWrappingWidth = myDefaultWrappingWidth;
    private transient int myNumLines = 0;
    private transient Font myFont = null;
    private transient FontMetrics myFontMetrics = null;
    private transient AttributedCharacterIterator myAttrStringIter = null;
    private transient AttributedString myAttrString = null;
    private transient LineBreakMeasurer myLineBreakMeasurer = null;
    private transient JGoTextEdit myTextEdit = null;

    public JGoText() {
        this.init(null, myDefaultFontSize, "", myDefaultFontName, false, false, false, 1, false, false);
    }

    public JGoText(String text) {
        this.init(null, myDefaultFontSize, text, myDefaultFontName, false, false, false, 1, false, false);
    }

    public JGoText(Point location, String text) {
        this.init(location, myDefaultFontSize, text, myDefaultFontName, false, false, false, 1, false, false);
    }

    public JGoText(Point location, int fontSize, String text, String fontName, boolean bold, boolean underline, boolean italic, int alignment, boolean multiline, boolean editable) {
        this.init(location, fontSize, text, fontName, bold, underline, italic, alignment, multiline, editable);
    }

    private final void init(Point location, int size, String text, String fontName, boolean bold, boolean underline, boolean italic, int alignment, boolean multiline, boolean editable) {
        this.myString = text;
        this.myFaceName = fontName;
        this.myFontSize = size;
        this.myAlignment = alignment;
        this.myTextColor = JGoBrush.ColorBlack;
        this.myBkColor = JGoBrush.ColorWhite;
        int flags = 16384;
        if (bold) {
            flags |= 2;
        }
        if (underline) {
            flags |= 4;
        }
        if (italic) {
            flags |= 8;
        }
        if (multiline) {
            flags |= 0x10;
        }
        if (editable) {
            flags |= 0x20;
        }
        if (JGoText.isDefaultBetterPainting()) {
            flags |= 0x10000;
        }
        this.myTextFlags = flags;
        this.myNumLines = 1;
        this.myFont = null;
        this.myFontMetrics = null;
        this.myAttrStringIter = null;
        this.myAttrString = null;
        this.myLineBreakMeasurer = null;
        this.myTextEdit = null;
        this.setResizable(false);
        this.setAutoRescale(false);
        this.recalcBoundingRect();
        if (location != null) {
            this.setLocation(location);
        }
    }

    public JGoObject copyObject(JGoCopyEnvironment env) {
        JGoText newobj = (JGoText)super.copyObject(env);
        if (newobj != null) {
            newobj.myString = this.myString;
            newobj.myFaceName = this.myFaceName;
            newobj.myFontSize = this.myFontSize;
            newobj.myAlignment = this.myAlignment;
            newobj.myTextColor = this.myTextColor;
            newobj.myBkColor = this.myBkColor;
            newobj.myTextFlags = this.myTextFlags;
            newobj.myUserTextFlags = this.myUserTextFlags;
            newobj.myWrappingWidth = this.myWrappingWidth;
            newobj.myNumLines = this.myNumLines;
            newobj.myFont = null;
            newobj.myFontMetrics = null;
            newobj.myAttrStringIter = null;
            newobj.myAttrString = null;
            newobj.myLineBreakMeasurer = null;
            newobj.myTextEdit = null;
        }
        return newobj;
    }

    public void setText(String str) {
        String oldText = this.myString;
        if (!oldText.equals(str)) {
            this.myString = str;
            this.fixState(this.isAutoResize() ? 512 : 1024);
            this.update(501, 0, oldText);
        }
    }

    public String getText() {
        return this.myString;
    }

    public void setAlignment(int align) {
        int oldAlignment = this.myAlignment;
        switch (align) {
            default: {
                align = 2;
                break;
            }
            case 1: {
                align = 1;
                break;
            }
            case 2: {
                align = 2;
                break;
            }
            case 3: {
                align = 3;
                break;
            }
            case 4: {
                align = 3;
                break;
            }
            case 5: {
                align = 3;
                break;
            }
            case 6: {
                align = 2;
                break;
            }
            case 7: {
                align = 1;
                break;
            }
            case 8: {
                align = 1;
            }
        }
        if (oldAlignment != align) {
            this.myAlignment = align;
            this.update(502, oldAlignment, null);
        }
    }

    public int getAlignment() {
        return this.myAlignment;
    }

    public void setFontSize(int size) {
        int oldFontSize = this.myFontSize;
        if (size > 0 && oldFontSize != size) {
            this.myFontSize = size;
            this.fixState(768);
            this.update(503, oldFontSize, null);
        }
    }

    public int getFontSize() {
        return this.myFontSize;
    }

    public void setFaceName(String name) {
        String oldFaceName = this.myFaceName;
        if (!oldFaceName.equals(name)) {
            this.myFaceName = name;
            this.fixState(768);
            this.update(504, 0, oldFaceName);
        }
    }

    public String getFaceName() {
        return this.myFaceName;
    }

    public void setTextColor(Color color) {
        Color oldTextColor = this.myTextColor;
        if (!oldTextColor.equals(color)) {
            this.myTextColor = color;
            this.update(505, 0, oldTextColor);
        }
    }

    public Color getTextColor() {
        return this.myTextColor;
    }

    public void setBkColor(Color color) {
        Color oldBkColor = this.myBkColor;
        if (!oldBkColor.equals(color)) {
            this.myBkColor = color;
            this.update(506, 0, oldBkColor);
        }
    }

    public Color getBkColor() {
        return this.myBkColor;
    }

    public final void setTextFlags(int f) {
        this.myUserTextFlags = f;
    }

    public final int getTextFlags() {
        return this.myUserTextFlags;
    }

    public void setTransparent(boolean bFlag) {
        boolean oldTransparent;
        boolean bl = oldTransparent = (this.myTextFlags & 1) != 0;
        if (oldTransparent != bFlag) {
            this.myTextFlags = bFlag ? (this.myTextFlags |= 1) : (this.myTextFlags &= 0xFFFFFFFE);
            this.update(507, oldTransparent ? 1 : 0, null);
        }
    }

    public boolean isTransparent() {
        return (this.myTextFlags & 1) != 0;
    }

    public void setBold(boolean bFlag) {
        boolean oldBold;
        boolean bl = oldBold = (this.myTextFlags & 2) != 0;
        if (oldBold != bFlag) {
            this.myTextFlags = bFlag ? (this.myTextFlags |= 2) : (this.myTextFlags &= 0xFFFFFFFD);
            this.fixState(768);
            this.update(508, oldBold ? 1 : 0, null);
        }
    }

    public boolean isBold() {
        return (this.myTextFlags & 2) != 0;
    }

    public void setUnderline(boolean bFlag) {
        boolean oldUnderline;
        boolean bl = oldUnderline = (this.myTextFlags & 4) != 0;
        if (oldUnderline != bFlag) {
            this.myTextFlags = bFlag ? (this.myTextFlags |= 4) : (this.myTextFlags &= 0xFFFFFFFB);
            this.fixState(768);
            this.update(509, oldUnderline ? 1 : 0, null);
        }
    }

    public boolean isUnderline() {
        return (this.myTextFlags & 4) != 0;
    }

    public void setStrikeThrough(boolean bFlag) {
        boolean oldStrikeThrough;
        boolean bl = oldStrikeThrough = (this.myTextFlags & 0x2000) != 0;
        if (oldStrikeThrough != bFlag) {
            this.myTextFlags = bFlag ? (this.myTextFlags |= 0x2000) : (this.myTextFlags &= 0xFFFFDFFF);
            this.fixState(768);
            this.update(517, oldStrikeThrough ? 1 : 0, null);
        }
    }

    public boolean isStrikeThrough() {
        return (this.myTextFlags & 0x2000) != 0;
    }

    public void setItalic(boolean bFlag) {
        boolean oldItalic;
        boolean bl = oldItalic = (this.myTextFlags & 8) != 0;
        if (oldItalic != bFlag) {
            this.myTextFlags = bFlag ? (this.myTextFlags |= 8) : (this.myTextFlags &= 0xFFFFFFF7);
            this.fixState(768);
            this.update(510, oldItalic ? 1 : 0, null);
        }
    }

    public boolean isItalic() {
        return (this.myTextFlags & 8) != 0;
    }

    public void setMultiline(boolean bFlag) {
        boolean oldMultiline;
        boolean bl = oldMultiline = (this.myTextFlags & 0x10) != 0;
        if (oldMultiline != bFlag) {
            this.myTextFlags = bFlag ? (this.myTextFlags |= 0x10) : (this.myTextFlags &= 0xFFFFFFEF);
            if (!bFlag) {
                this.myNumLines = 1;
            }
            this.fixState(512);
            this.update(511, oldMultiline ? 1 : 0, null);
        }
    }

    public boolean isMultiline() {
        return (this.myTextFlags & 0x10) != 0;
    }

    public void setEditable(boolean bFlag) {
        boolean oldEditable;
        boolean bl = oldEditable = (this.myTextFlags & 0x20) != 0;
        if (oldEditable != bFlag) {
            this.myTextFlags = bFlag ? (this.myTextFlags |= 0x20) : (this.myTextFlags &= 0xFFFFFFDF);
            this.update(512, oldEditable ? 1 : 0, null);
        }
    }

    public boolean isEditable() {
        return (this.myTextFlags & 0x20) != 0;
    }

    public void setEditOnSingleClick(boolean bFlag) {
        boolean oldEdit;
        boolean bl = oldEdit = (this.myTextFlags & 0x40) != 0;
        if (oldEdit != bFlag) {
            this.myTextFlags = bFlag ? (this.myTextFlags |= 0x40) : (this.myTextFlags &= 0xFFFFFFBF);
            this.update(513, oldEdit ? 1 : 0, null);
        }
    }

    public boolean isEditOnSingleClick() {
        return (this.myTextFlags & 0x40) != 0;
    }

    public void setSelectBackground(boolean bFlag) {
        boolean oldSelectBackground;
        boolean bl = oldSelectBackground = (this.myTextFlags & 0x800) != 0;
        if (oldSelectBackground != bFlag) {
            this.myTextFlags = bFlag ? (this.myTextFlags |= 0x800) : (this.myTextFlags &= 0xFFFFF7FF);
            this.update(515, oldSelectBackground ? 1 : 0, null);
        }
    }

    public boolean isSelectBackground() {
        return (this.myTextFlags & 0x800) != 0;
    }

    public void set2DScale(boolean bFlag) {
        boolean old2DScale;
        boolean bl = old2DScale = (this.myTextFlags & 0x80) != 0;
        if (old2DScale != bFlag) {
            this.myTextFlags = bFlag ? (this.myTextFlags |= 0x80) : (this.myTextFlags &= 0xFFFFFF7F);
            this.update(514, old2DScale ? 1 : 0, null);
        }
    }

    public boolean is2DScale() {
        return (this.myTextFlags & 0x80) != 0;
    }

    public void setClipping(boolean bFlag) {
        boolean oldClipping;
        boolean bl = oldClipping = (this.myTextFlags & 0x1000) != 0;
        if (oldClipping != bFlag) {
            this.myTextFlags = bFlag ? (this.myTextFlags |= 0x1000) : (this.myTextFlags &= 0xFFFFEFFF);
            this.update(516, oldClipping ? 1 : 0, null);
        }
    }

    public boolean isClipping() {
        return (this.myTextFlags & 0x1000) != 0;
    }

    public void setAutoResize(boolean bFlag) {
        boolean oldAutoResize;
        boolean bl = oldAutoResize = (this.myTextFlags & 0x4000) != 0;
        if (oldAutoResize != bFlag) {
            this.myTextFlags = bFlag ? (this.myTextFlags |= 0x4000) : (this.myTextFlags &= 0xFFFFBFFF);
            this.update(518, oldAutoResize ? 1 : 0, null);
        }
    }

    public boolean isAutoResize() {
        return (this.myTextFlags & 0x4000) != 0;
    }

    public void setBetterPainting(boolean bFlag) {
        boolean oldBetterPainting;
        boolean bl = oldBetterPainting = (this.myTextFlags & 0x10000) != 0;
        if (oldBetterPainting != bFlag) {
            this.myTextFlags = bFlag ? (this.myTextFlags |= 0x10000) : (this.myTextFlags &= 0xFFFEFFFF);
            this.update(521, oldBetterPainting ? 1 : 0, null);
        }
    }

    public boolean isBetterPainting() {
        return (this.myTextFlags & 0x10000) != 0;
    }

    public void setWrapping(boolean bFlag) {
        boolean oldWrapping;
        boolean bl = oldWrapping = (this.myTextFlags & 0x8000) != 0;
        if (oldWrapping != bFlag) {
            this.myTextFlags = bFlag ? (this.myTextFlags |= 0x8000) : (this.myTextFlags &= 0xFFFF7FFF);
            this.fixState(512);
            this.update(519, oldWrapping ? 1 : 0, null);
        }
    }

    public boolean isWrapping() {
        return (this.myTextFlags & 0x8000) != 0;
    }

    public void setWrappingWidth(int w) {
        int old = this.myWrappingWidth;
        if (old != w) {
            this.myWrappingWidth = w;
            this.fixState(512);
            this.update(520, old, null);
        }
    }

    public int getWrappingWidth() {
        return this.myWrappingWidth;
    }

    public void expandRectByPenWidth(Rectangle rect) {
        int m = 10;
        if (this.myFontMetrics != null) {
            m = this.myFontMetrics.charWidth('M');
        }
        rect.x -= m / 2;
        rect.y -= m / 2;
        rect.width += m;
        rect.height += m;
    }

    public boolean paintGreek(Graphics2D g, JGoView view) {
        double scale = view.getScale();
        double nothing = JGoText.getDefaultPaintNothingScale();
        double greek = JGoText.getDefaultPaintGreekScale();
        if (view.isPrinting()) {
            nothing /= 3.0;
            greek /= 3.0;
        }
        if (scale <= nothing) {
            return true;
        }
        if (scale <= greek) {
            Rectangle rect = this.getBoundingRect();
            this.paintLine(g, view, rect.x, rect.y + rect.height / 2, rect.width);
            return true;
        }
        return false;
    }

    void paintLine(Graphics2D g, JGoView view, int x, int y, int len) {
        if (this.getFontSize() < myThickerLineSize) {
            g.setStroke(JGoPen.black.getStroke());
            g.setColor(this.getTextColor());
        } else {
            int penw = this.getFontSize() / myThickerLineSize + 1;
            g.setStroke(new BasicStroke(penw));
            g.setColor(this.getTextColor());
        }
        g.drawLine(x, y, x + len, y);
    }

    public void paint(Graphics2D g, JGoView view) {
        String myStr;
        if (this.paintGreek(g, view)) {
            return;
        }
        g.setFont(this.getFont());
        Rectangle rect = this.getBoundingRect();
        if (!this.isTransparent()) {
            g.setColor(this.getBkColor());
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
        }
        if ((myStr = this.getText()).equals("")) {
            return;
        }
        g.setColor(this.getTextColor());
        Rectangle oldClip = null;
        if (this.isClipping()) {
            oldClip = g.getClipBounds();
            g.clipRect(rect.x, rect.y, rect.width, rect.height);
        }
        int baseLine = this.getFontMetrics(g).getHeight() - this.getFontMetrics(g).getMaxDescent();
        if (this.isMultiline()) {
            if (this.isWrapping()) {
                AttributedCharacterIterator aci = this.getAttrStringIterator();
                LineBreakMeasurer lbm = this.getLineBreakMeasurer(view.getFontRenderContext());
                float y = rect.y;
                int ww = Math.min(this.getWrappingWidth(), this.getWidth());
                while (lbm.getPosition() < aci.getEndIndex()) {
                    TextLayout tl = lbm.nextLayout(ww);
                    float x = rect.x;
                    if (tl == null) continue;
                    Rectangle2D bounds = tl.getBounds();
                    switch (this.getAlignment()) {
                        default: {
                            break;
                        }
                        case 2: {
                            x += ((float)rect.width - tl.getAdvance()) / 2.0f;
                            break;
                        }
                        case 3: {
                            x += (float)rect.width - tl.getAdvance();
                        }
                    }
                    tl.draw(g, x, y += tl.getAscent());
                    y += tl.getDescent() + tl.getLeading();
                }
            } else {
                int startingIndex = 0;
                int endingIndex = -1;
                boolean done = false;
                while (!done) {
                    endingIndex = myStr.indexOf(10, startingIndex);
                    if (endingIndex == -1) {
                        endingIndex = myStr.length();
                        done = true;
                    }
                    if (startingIndex < endingIndex) {
                        int xpos = this.getXPosForAlign(startingIndex, endingIndex, view.getFontRenderContext());
                        if (this.isBetterPainting()) {
                            g.drawString(this.getAttrString().getIterator(null, startingIndex, endingIndex), xpos, rect.y + baseLine);
                        } else {
                            String str = myStr.substring(startingIndex, endingIndex);
                            g.drawString(str, xpos, rect.y + baseLine);
                            if (this.isUnderline() || this.isStrikeThrough()) {
                                if (this.isUnderline()) {
                                    this.paintLine(g, view, xpos, rect.y + baseLine, this.getFontMetrics(g).stringWidth(str));
                                }
                                if (this.isStrikeThrough()) {
                                    this.paintLine(g, view, xpos, rect.y + baseLine - this.getFontMetrics(g).getAscent() / 3, this.getFontMetrics(g).stringWidth(str));
                                }
                            }
                        }
                    }
                    startingIndex = endingIndex + 1;
                    baseLine += this.getFontMetrics(g).getHeight();
                }
            }
        } else {
            int xpos = this.getXPosForAlign(0, myStr.length(), view.getFontRenderContext());
            if (this.isBetterPainting()) {
                g.drawString(this.getAttrStringIterator(), xpos, rect.y + baseLine);
            } else {
                g.drawString(myStr, xpos, rect.y + baseLine);
                if (this.isUnderline() || this.isStrikeThrough()) {
                    if (this.isUnderline()) {
                        this.paintLine(g, view, xpos, rect.y + baseLine, this.getFontMetrics(g).stringWidth(myStr));
                    }
                    if (this.isStrikeThrough()) {
                        this.paintLine(g, view, xpos, rect.y + baseLine - this.getFontMetrics(g).getAscent() / 3, this.getFontMetrics(g).stringWidth(myStr));
                    }
                }
            }
        }
        if (this.isClipping()) {
            g.setClip(oldClip);
        }
    }

    protected void gainedSelection(JGoSelection selection) {
        if (!this.isResizable()) {
            if (this.isSelectBackground()) {
                this.setTransparent(false);
            } else {
                selection.createBoundingHandle(this);
            }
            return;
        }
        if (this.is2DScale()) {
            super.gainedSelection(selection);
            return;
        }
        Rectangle rect = this.getBoundingRect();
        int x1 = rect.x;
        int x2 = rect.x + rect.width / 2;
        int x3 = rect.x + rect.width;
        int y1 = rect.y;
        int y2 = rect.y + rect.height / 2;
        int y3 = rect.y + rect.height;
        selection.createResizeHandle(this, x1, y1, -1, false);
        selection.createResizeHandle(this, x3, y1, -1, false);
        selection.createResizeHandle(this, x1, y3, -1, false);
        selection.createResizeHandle(this, x3, y3, -1, false);
        if (!this.is4ResizeHandles()) {
            selection.createResizeHandle(this, x2, y1, 2, true);
            selection.createResizeHandle(this, x3, y2, -1, false);
            selection.createResizeHandle(this, x2, y3, 6, true);
            selection.createResizeHandle(this, x1, y2, -1, false);
        }
    }

    protected void lostSelection(JGoSelection selection) {
        if (this.isSelectBackground()) {
            this.setTransparent(true);
        }
        super.lostSelection(selection);
    }

    private boolean fitsInBox(Graphics2D g, FontRenderContext frc, Font font) {
        Rectangle rect = this.getBoundingRect();
        int width = this.calculateWidth(font, frc);
        if (rect.width < width) {
            return false;
        }
        int height = this.calculateHeight(g, frc, font);
        return rect.height >= height;
    }

    private void setToBiggestFont() {
        Font f;
        Graphics2D g2 = JGoGlobal.getGraphics2D();
        FontRenderContext frc = g2.getFontRenderContext();
        String faceName = this.getFont().getFontName();
        int style = this.getFont().getStyle();
        int size = 13;
        while (this.fitsInBox(g2, frc, f = new Font(faceName, style, size))) {
            size += 14;
        }
        --size;
        while (!this.fitsInBox(g2, frc, f = new Font(faceName, style, size)) && size > 1) {
            --size;
        }
        if (size != this.getFontSize()) {
            this.myFontSize = size;
            this.myFont = f;
            this.myFontMetrics = null;
            this.myAttrStringIter = null;
            this.myAttrString = null;
            this.myLineBreakMeasurer = null;
        }
    }

    private boolean fitsInHeight(Graphics2D g, FontRenderContext frc, String facename, int style, int size, int height) {
        Font f = new Font(facename, style, size);
        int h = this.calculateHeight(g, frc, f);
        return h < height;
    }

    private int getPointSizeForHeight(int height, Graphics2D g, FontRenderContext frc) {
        int style = 0;
        if (this.isBold()) {
            style |= 1;
        }
        if (this.isItalic()) {
            style |= 2;
        }
        int size = 13;
        while (this.fitsInHeight(g, frc, this.getFaceName(), style, size, height)) {
            size += 14;
        }
        --size;
        while (!this.fitsInHeight(g, frc, this.getFaceName(), style, size, height) && size > 1) {
            --size;
        }
        return size;
    }

    public Rectangle handleResize(Graphics2D g, JGoView view, Rectangle prevRect, Point newPoint, int whichHandle, int event, int minWidth, int minHeight) {
        if (!this.is2DScale()) {
            Rectangle newRect = new Rectangle(prevRect.x, prevRect.y, prevRect.width, prevRect.height);
            switch (whichHandle) {
                case 2: {
                    if (newPoint.y < prevRect.y + prevRect.height) {
                        newRect.height += prevRect.y - newPoint.y;
                    }
                    newRect.y = newPoint.y;
                    break;
                }
                case 6: {
                    if (newPoint.y <= prevRect.y) break;
                    newRect.height = newPoint.y - prevRect.y;
                }
            }
            if (newRect.height < 1) {
                newRect.height = 1;
            }
            if (newRect.height == prevRect.height) {
                return null;
            }
            if (this.myNumLines < 1) {
                this.myNumLines = 1;
            }
            int lineHeight = newRect.height / this.myNumLines;
            FontRenderContext frc = view.getFontRenderContext();
            this.setFontSize(this.getPointSizeForHeight(lineHeight, g, frc));
            return null;
        }
        return super.handleResize(g, view, prevRect, newPoint, whichHandle, event, 1, 1);
    }

    protected void geometryChange(Rectangle prevRect) {
        Rectangle rect = this.getBoundingRect();
        if (rect.width != prevRect.width || rect.height != prevRect.height) {
            this.fixState(1024);
        }
    }

    private void generateFont() {
        int style = 0;
        if (this.isBold()) {
            style |= 1;
        }
        if (this.isItalic()) {
            style |= 2;
        }
        this.myFont = new Font(this.getFaceName(), style, this.getFontSize());
        this.myFontMetrics = null;
        this.myAttrStringIter = null;
        this.myAttrString = null;
        this.myLineBreakMeasurer = null;
    }

    public Font getFont() {
        if (this.myFont == null) {
            this.generateFont();
        }
        return this.myFont;
    }

    FontMetrics getFontMetrics(Graphics2D g2) {
        if (this.myFontMetrics == null) {
            this.myFontMetrics = g2.getFontMetrics(this.getFont());
        }
        return this.myFontMetrics;
    }

    AttributedString getAttrString() {
        if (this.myAttrString == null) {
            AttributedString as = new AttributedString(this.getText());
            as.addAttribute(TextAttribute.FONT, this.getFont());
            if (this.isUnderline()) {
                as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            if (this.isStrikeThrough()) {
                as.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            }
            this.myAttrString = as;
        }
        return this.myAttrString;
    }

    AttributedCharacterIterator getAttrStringIterator() {
        if (this.myAttrStringIter == null) {
            this.myAttrStringIter = this.getAttrString().getIterator();
        } else {
            this.myAttrStringIter.first();
        }
        return this.myAttrStringIter;
    }

    LineBreakMeasurer getLineBreakMeasurer(FontRenderContext frc) {
        if (this.myLineBreakMeasurer == null) {
            this.myLineBreakMeasurer = new LineBreakMeasurer(this.getAttrStringIterator(), frc);
        }
        this.myLineBreakMeasurer.setPosition(0);
        return this.myLineBreakMeasurer;
    }

    private void fixState(int flags) {
        if (this.isInitializing()) {
            return;
        }
        this.myAttrStringIter = null;
        this.myAttrString = null;
        this.myLineBreakMeasurer = null;
        if ((flags & 0x400) != 0 && this.isResizable()) {
            this.setToBiggestFont();
        }
        if ((flags & 0x100) != 0) {
            this.generateFont();
        }
        if ((flags & 0x200) != 0 && this.isAutoResize()) {
            this.recalcBoundingRect();
        }
    }

    void recalcBoundingRect() {
        Graphics2D g2 = JGoGlobal.getGraphics2D();
        FontRenderContext frc = g2.getFontRenderContext();
        int w = this.calculateWidth(this.getFont(), frc);
        if (w < 10) {
            w = 10;
        }
        int h = this.calculateHeight(g2, frc, this.getFont());
        if (w != this.getWidth() || h != this.getHeight()) {
            int oldflags = this.getInternalFlags();
            this.setInternalFlags(oldflags & 0xFFFFFFEF);
            this.setSizeKeepingLocation(w, h);
            this.setInternalFlags(oldflags);
        }
    }

    private int calculateHeight(Graphics2D g, FontRenderContext frc, Font font) {
        if (this.isMultiline()) {
            if (this.getText().equals("")) {
                FontMetrics fm = g.getFontMetrics(font);
                return fm.getHeight();
            }
            if (this.isWrapping()) {
                AttributedString as = new AttributedString(this.getText());
                as.addAttribute(TextAttribute.FONT, font);
                if (this.isUnderline()) {
                    as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                }
                if (this.isStrikeThrough()) {
                    as.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                }
                AttributedCharacterIterator aci = as.getIterator();
                LineBreakMeasurer lbm = new LineBreakMeasurer(aci, frc);
                float y = 0.0f;
                int ww = Math.min(this.getWrappingWidth(), this.getWidth());
                while (lbm.getPosition() < aci.getEndIndex()) {
                    TextLayout tl = lbm.nextLayout(ww);
                    if (tl == null) continue;
                    y += tl.getAscent() + tl.getDescent() + tl.getLeading();
                }
                return (int)Math.ceil(y);
            }
            FontMetrics fm = g.getFontMetrics(font);
            int height = Math.max(1, this.myNumLines) * fm.getHeight();
            return height;
        }
        FontMetrics fm = g.getFontMetrics(font);
        return fm.getHeight();
    }

    private int calculateWidth(Font font, FontRenderContext frc) {
        if (this.getText().equals("")) {
            this.myNumLines = 1;
            return 0;
        }
        String myStr = this.getText();
        if (this.isMultiline()) {
            int maxWidth = 0;
            int startingIndex = 0;
            boolean done = false;
            this.myNumLines = 0;
            while (!done) {
                int width;
                int endingIndex = myStr.indexOf(10, startingIndex);
                if (endingIndex == -1) {
                    endingIndex = myStr.length();
                    done = true;
                }
                if ((width = this.getStringWidth(startingIndex, endingIndex, font, frc)) > maxWidth) {
                    maxWidth = width;
                }
                startingIndex = endingIndex + 1;
                ++this.myNumLines;
            }
            if (this.isWrapping()) {
                return Math.min(maxWidth, this.getWrappingWidth());
            }
            return maxWidth;
        }
        this.myNumLines = 1;
        return this.getStringWidth(0, myStr.length(), font, frc);
    }

    private int getStringWidth(int start, int end, Font font, FontRenderContext frc) {
        double dwidth;
        if (start >= end) {
            return 0;
        }
        if (this.isBetterPainting()) {
            if (this.isWrapping() && this.isMultiline()) {
                dwidth = font.getStringBounds(this.getAttrStringIterator(), start, end, frc).getWidth();
            } else {
                AttributedString as = new AttributedString(this.getAttrStringIterator(), start, end);
                TextLayout tl = new TextLayout(as.getIterator(), frc);
                dwidth = tl.getBounds().getWidth();
            }
        } else {
            String text = this.getText();
            if (start != 0 || end < text.length()) {
                String str = text.substring(start, end);
                dwidth = font.getStringBounds(str, frc).getWidth();
            } else {
                dwidth = font.getStringBounds(text, frc).getWidth();
            }
        }
        int width = (int)Math.ceil(dwidth + (double)0.999f);
        return width;
    }

    private int getXPosForAlign(int start, int end, FontRenderContext frc) {
        Rectangle rect = this.getBoundingRect();
        switch (this.getAlignment()) {
            default: {
                return rect.x;
            }
            case 2: {
                int strlen = this.getStringWidth(start, end, this.getFont(), frc);
                return rect.x + (rect.width - strlen) / 2;
            }
            case 3: 
        }
        int strlen = this.getStringWidth(start, end, this.getFont(), frc);
        return rect.x + rect.width - strlen;
    }

    public Point getLocation(Point result) {
        Rectangle rect = this.getBoundingRect();
        if (result == null) {
            result = new Point(0, 0);
        }
        switch (this.getAlignment()) {
            default: {
                result.x = rect.x;
                result.y = rect.y;
                break;
            }
            case 2: {
                result.x = rect.x + rect.width / 2;
                result.y = rect.y;
                break;
            }
            case 3: {
                result.x = rect.x + rect.width;
                result.y = rect.y;
            }
        }
        return result;
    }

    public void setLocation(int x, int y) {
        Rectangle rect = this.getBoundingRect();
        switch (this.getAlignment()) {
            default: {
                this.setBoundingRect(x, y, rect.width, rect.height);
                break;
            }
            case 2: {
                this.setBoundingRect(x - rect.width / 2, y, rect.width, rect.height);
                break;
            }
            case 3: {
                this.setBoundingRect(x - rect.width, y, rect.width, rect.height);
            }
        }
    }

    public void setSizeKeepingLocation(int w, int h) {
        Rectangle rect = this.getBoundingRect();
        switch (this.getAlignment()) {
            default: {
                this.setBoundingRect(rect.x, rect.y, w, h);
                break;
            }
            case 2: {
                this.setBoundingRect(rect.x + rect.width / 2 - w / 2, rect.y, w, h);
                break;
            }
            case 3: {
                this.setBoundingRect(rect.x + rect.width - w, rect.y, w, h);
            }
        }
    }

    public boolean doMouseClick(int modifiers, Point dc, Point vc, JGoView view) {
        if (!this.isEditable()) {
            return false;
        }
        if (!this.isEditOnSingleClick()) {
            return false;
        }
        if (this.getLayer() != null && !this.getLayer().isModifiable()) {
            return false;
        }
        this.doStartEdit(view, vc);
        return true;
    }

    public boolean doMouseDblClick(int modifiers, Point dc, Point vc, JGoView view) {
        if (!this.isEditable()) {
            return false;
        }
        if (this.isEditOnSingleClick()) {
            return false;
        }
        if (this.getLayer() != null && !this.getLayer().isModifiable()) {
            return false;
        }
        this.doStartEdit(view, vc);
        return true;
    }

    public void doStartEdit(JGoView view, Point vc) {
        JComponent comp;
        if (view == null) {
            return;
        }
        if (view.getDocument() != null) {
            view.getDocument().startTransaction();
        }
        view.getSelection().clearSelectionHandles(this);
        Rectangle b = this.getBoundingRect();
        Rectangle rect = new Rectangle(b.x, b.y, b.width, b.height);
        if (this.isMultiline()) {
            rect.height += this.getHeight() / Math.max(1, this.myNumLines);
        }
        view.setEditControl(new JGoTextEdit(rect, this.getText(), this.isMultiline(), this));
        this.myTextEdit = view.getEditControl();
        if (this.myTextEdit != null && (comp = this.myTextEdit.getComponent(view)) instanceof JTextComponent) {
            JTextComponent jtext = (JTextComponent)comp;
            jtext.selectAll();
            jtext.grabFocus();
        }
    }

    public boolean doEdit(JGoView view, String oldtext, String newtext) {
        String t = this.computeEdit(oldtext, newtext);
        this.setText(t);
        return true;
    }

    public String computeEdit(String oldtext, String newtext) {
        return newtext;
    }

    public void doEndEdit() {
        if (this.myTextEdit != null) {
            JGoTextEdit editor = this.myTextEdit;
            this.myTextEdit = null;
            JGoView view = editor.getView();
            if (view != null) {
                view.setEditControl(null);
            }
            this.fixState(512);
            if (view != null) {
                JGoObject selobj;
                JGoSelection sel = view.getSelection();
                for (selobj = this; selobj != null && !sel.isSelected(selobj); selobj = selobj.getParent()) {
                }
                if (selobj != null) {
                    sel.restoreSelectionHandles(selobj);
                }
                view.requestFocus();
                if (!view.hasFocus() && JGoGlobal.isAtLeastJavaVersion(1.4)) {
                    view.addFocusListener(new JGoView.JGoViewHelper(view, this));
                    return;
                }
                view.internalFinishedEdit(this);
            }
        }
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit e) {
        switch (e.getFlags()) {
            case 501: {
                e.setNewValue(this.getText());
                return;
            }
            case 502: {
                e.setNewValueInt(this.getAlignment());
                return;
            }
            case 503: {
                e.setNewValueInt(this.getFontSize());
                return;
            }
            case 504: {
                e.setNewValue(this.getFaceName());
                return;
            }
            case 505: {
                e.setNewValue(this.getTextColor());
                return;
            }
            case 506: {
                e.setNewValue(this.getBkColor());
                return;
            }
            case 507: {
                e.setNewValueBoolean(this.isTransparent());
                return;
            }
            case 508: {
                e.setNewValueBoolean(this.isBold());
                return;
            }
            case 509: {
                e.setNewValueBoolean(this.isUnderline());
                return;
            }
            case 510: {
                e.setNewValueBoolean(this.isItalic());
                return;
            }
            case 511: {
                e.setNewValueBoolean(this.isMultiline());
                return;
            }
            case 512: {
                e.setNewValueBoolean(this.isEditable());
                return;
            }
            case 513: {
                e.setNewValueBoolean(this.isEditOnSingleClick());
                return;
            }
            case 514: {
                e.setNewValueBoolean(this.is2DScale());
                return;
            }
            case 515: {
                e.setNewValueBoolean(this.isSelectBackground());
                return;
            }
            case 516: {
                e.setNewValueBoolean(this.isClipping());
                return;
            }
            case 517: {
                e.setNewValueBoolean(this.isStrikeThrough());
                return;
            }
            case 518: {
                e.setNewValueBoolean(this.isAutoResize());
                return;
            }
            case 519: {
                e.setNewValueBoolean(this.isWrapping());
                return;
            }
            case 520: {
                e.setNewValueInt(this.getWrappingWidth());
                return;
            }
            case 521: {
                e.setNewValueBoolean(this.isBetterPainting());
                return;
            }
        }
        super.copyNewValueForRedo(e);
    }

    public void changeValue(JGoDocumentChangedEdit e, boolean undo) {
        switch (e.getFlags()) {
            case 501: {
                this.setInitializing(true);
                this.setText((String)e.getValue(undo));
                this.setInitializing(false);
                return;
            }
            case 502: {
                this.setAlignment(e.getValueInt(undo));
                return;
            }
            case 503: {
                this.setInitializing(true);
                this.setFontSize(e.getValueInt(undo));
                this.setInitializing(false);
                return;
            }
            case 504: {
                this.setInitializing(true);
                this.setFaceName((String)e.getValue(undo));
                this.setInitializing(false);
                return;
            }
            case 505: {
                this.setTextColor((Color)e.getValue(undo));
                return;
            }
            case 506: {
                this.setBkColor((Color)e.getValue(undo));
                return;
            }
            case 507: {
                this.setTransparent(e.getValueBoolean(undo));
                return;
            }
            case 508: {
                this.setInitializing(true);
                this.setBold(e.getValueBoolean(undo));
                this.setInitializing(false);
                return;
            }
            case 509: {
                this.setInitializing(true);
                this.setUnderline(e.getValueBoolean(undo));
                this.setInitializing(false);
                return;
            }
            case 510: {
                this.setInitializing(true);
                this.setItalic(e.getValueBoolean(undo));
                this.setInitializing(false);
                return;
            }
            case 511: {
                this.setInitializing(true);
                this.setMultiline(e.getValueBoolean(undo));
                this.setInitializing(false);
                return;
            }
            case 512: {
                this.setEditable(e.getValueBoolean(undo));
                return;
            }
            case 513: {
                this.setEditOnSingleClick(e.getValueBoolean(undo));
                return;
            }
            case 514: {
                this.set2DScale(e.getValueBoolean(undo));
                return;
            }
            case 515: {
                this.setSelectBackground(e.getValueBoolean(undo));
                return;
            }
            case 516: {
                this.setClipping(e.getValueBoolean(undo));
                return;
            }
            case 517: {
                this.setInitializing(true);
                this.setStrikeThrough(e.getValueBoolean(undo));
                this.setInitializing(false);
                return;
            }
            case 518: {
                this.setAutoResize(e.getValueBoolean(undo));
                return;
            }
            case 519: {
                this.setInitializing(true);
                this.setWrapping(e.getValueBoolean(undo));
                this.setInitializing(false);
                return;
            }
            case 520: {
                this.setInitializing(true);
                this.setWrappingWidth(e.getValueInt(undo));
                this.setInitializing(false);
                return;
            }
            case 521: {
                this.setBetterPainting(e.getValueBoolean(undo));
                return;
            }
        }
        super.changeValue(e, undo);
    }

    public static void setDefaultFontFaceName(String name) {
        if (name != null) {
            myDefaultFontName = name;
        }
    }

    public static String getDefaultFontFaceName() {
        return myDefaultFontName;
    }

    public static void setDefaultFontSize(int size) {
        if (size > 0) {
            myDefaultFontSize = size;
        }
    }

    public static int getDefaultFontSize() {
        return myDefaultFontSize;
    }

    public static double getDefaultPaintNothingScale() {
        return myDefaultPaintNothingScale;
    }

    public static void setDefaultPaintNothingScale(double s) {
        myDefaultPaintNothingScale = s;
    }

    public static double getDefaultPaintGreekScale() {
        return myDefaultPaintGreekScale;
    }

    public static void setDefaultPaintGreekScale(double s) {
        myDefaultPaintGreekScale = s;
    }

    public static void setDefaultWrappingWidth(int w) {
        if (w > 0) {
            myDefaultWrappingWidth = w;
        }
    }

    public static int getDefaultWrappingWidth() {
        return myDefaultWrappingWidth;
    }

    public static void setDefaultBetterPainting(boolean b) {
        myDefaultBetterPainting = b;
    }

    public static boolean isDefaultBetterPainting() {
        return myDefaultBetterPainting;
    }

    public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup) {
        if (svgDoc.JGoXMLOutputEnabled()) {
            DomElement jGoText = svgDoc.createJGoClassElement("com.nwoods.jgo.JGoText", jGoElementGroup);
            jGoText.setAttribute("text", this.myString);
            jGoText.setAttribute("facename", this.myFaceName);
            jGoText.setAttribute("fontsize", Integer.toString(this.myFontSize));
            jGoText.setAttribute("alignment", Integer.toString(this.myAlignment));
            String textColor = "black";
            if (!this.myTextColor.equals(JGoBrush.ColorBlack)) {
                int nRed = this.myTextColor.getRed();
                int nGreen = this.myTextColor.getGreen();
                int nBlue = this.myTextColor.getBlue();
                int nAlpha = this.myTextColor.getAlpha();
                textColor = "rgbalpha(" + Integer.toString(nRed) + "," + Integer.toString(nGreen) + "," + Integer.toString(nBlue) + "," + Integer.toString(nAlpha) + ");";
            }
            jGoText.setAttribute("textcolor", textColor);
            String backColor = "white";
            if (!this.myBkColor.equals(JGoBrush.ColorWhite)) {
                int nRed = this.myBkColor.getRed();
                int nGreen = this.myBkColor.getGreen();
                int nBlue = this.myBkColor.getBlue();
                int nAlpha = this.myBkColor.getAlpha();
                backColor = "rgbalpha(" + Integer.toString(nRed) + "," + Integer.toString(nGreen) + "," + Integer.toString(nBlue) + "," + Integer.toString(nAlpha) + ");";
            }
            jGoText.setAttribute("backcolor", backColor);
            jGoText.setAttribute("textflags", Integer.toString(this.myTextFlags));
            jGoText.setAttribute("usertextflags", Integer.toString(this.myUserTextFlags));
            jGoText.setAttribute("wrappingwidth", Integer.toString(this.myWrappingWidth));
        }
        if (svgDoc.SVGOutputEnabled()) {
            if (!this.getBkColor().equals(JGoBrush.ColorWhite)) {
                int nRed = this.getBkColor().getRed();
                int nGreen = this.getBkColor().getGreen();
                int nBlue = this.getBkColor().getBlue();
                DomElement backrect = svgDoc.createElement("rect");
                jGoElementGroup.appendChild(backrect);
                backrect.setAttribute("x", Integer.toString(this.getTopLeft().x));
                backrect.setAttribute("y", Integer.toString(this.getTopLeft().y));
                backrect.setAttribute("width", Integer.toString(this.getWidth()));
                backrect.setAttribute("height", Integer.toString(this.getHeight()));
                String backColor = "fill:rgb(" + Integer.toString(nRed) + "," + Integer.toString(nGreen) + "," + Integer.toString(nBlue) + ");" + "stroke:none;";
                backrect.setAttribute("style", backColor);
            }
            DomElement group = svgDoc.createElement("g");
            this.SVGWriteAttributes(group);
            jGoElementGroup.appendChild(group);
            String style = "";
            if (this.isUnderline()) {
                style = style + "text-decoration:underline;";
            }
            if (this.isStrikeThrough()) {
                style = style + "text-decoration:line-through;";
            }
            String sText = this.getText();
            int nX = this.getLeft();
            int nY = this.getTop() + this.getFontSize();
            int startingIndex = 0;
            int endingIndex = -1;
            while (true) {
                DomText text;
                DomElement textElement;
                String sLine;
                if ((endingIndex = sText.indexOf(10, startingIndex)) == -1) {
                    sLine = sText.substring(startingIndex);
                    textElement = svgDoc.createElement("text");
                    textElement.setAttribute("x", Integer.toString(nX));
                    textElement.setAttribute("y", Integer.toString(nY));
                    if (style.length() > 0) {
                        textElement.setAttribute("style", style);
                    }
                    group.appendChild(textElement);
                    text = svgDoc.createText(sLine);
                    textElement.appendChild(text);
                    break;
                }
                sLine = sText.substring(startingIndex, endingIndex);
                textElement = svgDoc.createElement("text");
                textElement.setAttribute("x", Integer.toString(nX));
                textElement.setAttribute("y", Integer.toString(nY));
                nY += (int)((double)this.getFontSize() * 1.3);
                if (style.length() > 0) {
                    textElement.setAttribute("style", style);
                }
                group.appendChild(textElement);
                text = svgDoc.createText(sLine);
                textElement.appendChild(text);
                startingIndex = endingIndex + 1;
            }
        }
        super.SVGWriteObject(svgDoc, jGoElementGroup);
    }

    public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement) {
        if (jGoChildElement != null) {
            this.myTextFlags = Integer.parseInt(jGoChildElement.getAttribute("textflags"));
            this.myUserTextFlags = Integer.parseInt(jGoChildElement.getAttribute("usertextflags"));
            this.myString = jGoChildElement.getAttribute("text");
            this.setFaceName(jGoChildElement.getAttribute("facename"));
            this.setFontSize(Integer.parseInt(jGoChildElement.getAttribute("fontsize")));
            String alignstr = jGoChildElement.getAttribute("allignment");
            this.myAlignment = alignstr.length() > 0 ? Integer.parseInt(alignstr) + 1 : Integer.parseInt(jGoChildElement.getAttribute("alignment"));
            String textcolor = jGoChildElement.getAttribute("textcolor");
            if (textcolor.equals("black")) {
                this.myTextColor = JGoBrush.ColorBlack;
            } else if (textcolor.startsWith("rgbalpha")) {
                int nAttStart = textcolor.indexOf("(") + 1;
                int nAttEnd = textcolor.indexOf(",", nAttStart);
                String red = textcolor.substring(nAttStart, nAttEnd);
                nAttStart = nAttEnd + 1;
                nAttEnd = textcolor.indexOf(",", nAttStart);
                String green = textcolor.substring(nAttStart, nAttEnd);
                nAttStart = nAttEnd + 1;
                nAttEnd = textcolor.indexOf(",", nAttStart);
                String blue = textcolor.substring(nAttStart, nAttEnd);
                nAttStart = nAttEnd + 1;
                nAttEnd = textcolor.indexOf(")", nAttStart);
                String alpha = textcolor.substring(nAttStart, nAttEnd);
                this.myTextColor = new Color(Integer.parseInt(red), Integer.parseInt(green), Integer.parseInt(blue), Integer.parseInt(alpha));
            }
            String backcolor = jGoChildElement.getAttribute("backcolor");
            if (backcolor.equals("white")) {
                this.myBkColor = JGoBrush.ColorWhite;
            } else if (backcolor.startsWith("rgbalpha")) {
                int nAttStart = backcolor.indexOf("(") + 1;
                int nAttEnd = backcolor.indexOf(",", nAttStart);
                String red = backcolor.substring(nAttStart, nAttEnd);
                nAttStart = nAttEnd + 1;
                nAttEnd = backcolor.indexOf(",", nAttStart);
                String green = backcolor.substring(nAttStart, nAttEnd);
                nAttStart = nAttEnd + 1;
                nAttEnd = backcolor.indexOf(",", nAttStart);
                String blue = backcolor.substring(nAttStart, nAttEnd);
                nAttStart = nAttEnd + 1;
                nAttEnd = backcolor.indexOf(")", nAttStart);
                String alpha = backcolor.substring(nAttStart, nAttEnd);
                this.myBkColor = new Color(Integer.parseInt(red), Integer.parseInt(green), Integer.parseInt(blue), Integer.parseInt(alpha));
            }
            this.myWrappingWidth = Integer.parseInt(jGoChildElement.getAttribute("wrappingwidth"));
            super.SVGReadObject(svgDoc, jGoDoc, svgElement, jGoChildElement.getNextSiblingJGoClassElement());
            this.fixState(this.isAutoResize() ? 768 : 1280);
        } else if (svgElement.getTagName().equalsIgnoreCase("text")) {
            this.SVGReadAttributes(svgElement);
        }
        return svgElement.getNextSibling();
    }

    public void SVGWriteAttributes(DomElement svgElement) {
        super.SVGWriteAttributes(svgElement);
        svgElement.setAttribute("font-size", Integer.toString(this.getFontSize()));
        if (this.getFaceName().length() > 0) {
            svgElement.setAttribute("font-family", this.getFaceName());
        }
        if (this.isBold()) {
            svgElement.setAttribute("font-weight", "bold");
        }
        if (this.isItalic()) {
            svgElement.setAttribute("font-style", "italic");
        }
        String style = "";
        if (!this.getTextColor().equals(JGoBrush.ColorBlack)) {
            int nRed = this.getTextColor().getRed();
            int nGreen = this.getTextColor().getGreen();
            int nBlue = this.getTextColor().getBlue();
            style = "fill:rgb(" + Integer.toString(nRed) + "," + Integer.toString(nGreen) + "," + Integer.toString(nBlue) + ");";
        }
        if (style.length() > 0) {
            svgElement.setAttribute("style", style);
        }
    }

    public void SVGReadAttributes(DomElement svgElement) {
        String fontDecoration;
        String fontStyle;
        super.SVGReadAttributes(svgElement);
        String fontSize = svgElement.getAttribute("font-size");
        if (fontSize.length() > 0) {
            this.setFontSize(Integer.parseInt(fontSize));
        }
        String fontFamily = svgElement.getAttribute("font-family");
        this.setFaceName(fontFamily);
        String fontWeight = svgElement.getAttribute("font-weight");
        if (fontWeight.equalsIgnoreCase("bold")) {
            this.setBold(true);
        }
        if ((fontStyle = svgElement.getAttribute("font-style")).equalsIgnoreCase("italic")) {
            this.setItalic(true);
        }
        if ((fontDecoration = svgElement.getAttribute("font-decoration")).equalsIgnoreCase("underline")) {
            this.setUnderline(true);
        }
    }
}

