/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoDrawable;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoSelection;
import com.nwoods.jgo.JGoView;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;

public class JGoStroke
extends JGoDrawable {
    public static final int ChangedAddPoint = 101;
    public static final int ChangedRemovePoint = 102;
    public static final int ChangedModifiedPoint = 103;
    public static final int ChangedArrowHeads = 104;
    public static final int ChangedArrowLength = 105;
    public static final int ChangedArrowShaftLength = 106;
    public static final int ChangedArrowAngle = 107;
    public static final int ChangedHighlight = 108;
    public static final int ChangedCubic = 109;
    public static final int ChangedAllPoints = 110;
    public static final int ChangedArrowWidth = 111;
    private static final int LINE_FUZZ = 3;
    private static final int NUM_HEADPOINTS = 4;
    private static final double DEFAULT_ARROW_LENGTH = 10.0;
    private static final double DEFAULT_ARROW_SHAFT_LENGTH = 8.0;
    private static final double DEFAULT_ARROW_WIDTH = 8.0;
    private static final int flagStrokeArrowStart = 32768;
    private static final int flagStrokeArrowEnd = 16384;
    private static final int flagStrokeCubic = 4096;
    protected ArrayList myPoints = new ArrayList();
    private JGoPen myHighlightPen = null;
    private ArrowInfo myArrowInfo = null;
    private transient Point myTempPoint = null;
    private transient GeneralPath myPath = null;

    public JGoStroke() {
        this.setBrush(JGoBrush.black);
    }

    public JGoObject copyObject(JGoCopyEnvironment env) {
        JGoStroke newobj = (JGoStroke)super.copyObject(env);
        if (newobj != null) {
            for (int i = 0; i < this.myPoints.size(); ++i) {
                Point oldpoint = (Point)this.myPoints.get(i);
                newobj.myPoints.add(i, new Point(oldpoint.x, oldpoint.y));
            }
            if (this.myArrowInfo != null) {
                newobj.myArrowInfo = new ArrowInfo();
                newobj.myArrowInfo.myLength = this.myArrowInfo.myLength;
                newobj.myArrowInfo.myShaftLength = this.myArrowInfo.myShaftLength;
                newobj.myArrowInfo.myWidth = this.myArrowInfo.myWidth;
            }
            newobj.myHighlightPen = this.myHighlightPen;
        }
        return newobj;
    }

    public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup) {
        int i;
        if (svgDoc.JGoXMLOutputEnabled()) {
            DomElement jGoStroke = svgDoc.createJGoClassElement("com.nwoods.jgo.JGoStroke", jGoElementGroup);
            JGoPen highlight = this.getHighlight();
            if (highlight != null) {
                if (!svgDoc.isRegisteredReference(this.getHighlight())) {
                    jGoStroke.setAttribute("embeddedhighlightpen", "true");
                    DomElement subGroup = svgDoc.createElement("g");
                    jGoStroke.appendChild(subGroup);
                    this.getHighlight().SVGWriteObject(svgDoc, subGroup);
                }
                svgDoc.registerReferencingNode(jGoStroke, "highlightpen", this.getHighlight());
            }
            if (this.myArrowInfo != null) {
                this.myArrowInfo.SVGWriteJGoElementAttributes(jGoStroke);
            }
            String xPoints = "";
            String yPoints = "";
            for (i = 0; i < this.myPoints.size(); ++i) {
                Point point = (Point)this.myPoints.get(i);
                if (i > 0) {
                    xPoints = xPoints + " ";
                    yPoints = yPoints + " ";
                }
                xPoints = xPoints + Integer.toString(point.x);
                yPoints = yPoints + Integer.toString(point.y);
            }
            jGoStroke.setAttribute("xpoints", xPoints);
            jGoStroke.setAttribute("ypoints", yPoints);
        }
        if (svgDoc.SVGOutputEnabled()) {
            Point point;
            DomElement path = svgDoc.createElement("path");
            String pathArgs = "";
            int length = this.myPoints.size();
            if (this.isCubic() && length >= 4) {
                point = (Point)this.myPoints.get(0);
                pathArgs = pathArgs + "M";
                pathArgs = pathArgs + " " + Integer.toString(point.x);
                pathArgs = pathArgs + " " + Integer.toString(point.y);
                for (i = 1; i < this.myPoints.size(); i += 3) {
                    Point point1 = (Point)this.myPoints.get(i);
                    if (i + 6 > this.myPoints.size()) {
                        i = this.myPoints.size() - 3;
                    }
                    Point point2 = (Point)this.myPoints.get(i + 1);
                    Point point3 = (Point)this.myPoints.get(i + 2);
                    pathArgs = pathArgs + " C " + Integer.toString(point1.x);
                    pathArgs = pathArgs + " " + Integer.toString(point1.y);
                    pathArgs = pathArgs + " " + Integer.toString(point2.x);
                    pathArgs = pathArgs + " " + Integer.toString(point2.y);
                    pathArgs = pathArgs + " " + Integer.toString(point3.x);
                    pathArgs = pathArgs + " " + Integer.toString(point3.y);
                }
                path.setAttribute("d", pathArgs);
            } else if (length > 0) {
                point = (Point)this.myPoints.get(0);
                pathArgs = pathArgs + "M";
                pathArgs = pathArgs + " " + Integer.toString(point.x);
                pathArgs = pathArgs + " " + Integer.toString(point.y);
                for (i = 1; i < this.myPoints.size(); ++i) {
                    point = (Point)this.myPoints.get(i);
                    pathArgs = pathArgs + " L " + Integer.toString(point.x);
                    pathArgs = pathArgs + " " + Integer.toString(point.y);
                }
                path.setAttribute("d", pathArgs);
            }
            DomElement polygonEndArrow = null;
            DomElement polygonStartArrow = null;
            if (this.myArrowInfo != null) {
                int i2;
                Point end;
                Point start;
                String arrowPoints;
                int[] headx = this.myArrowInfo.getXs();
                int[] heady = this.myArrowInfo.getYs();
                if (this.hasArrowAtEnd()) {
                    polygonEndArrow = svgDoc.createElement("polygon");
                    arrowPoints = "";
                    start = this.getArrowToAnchorPoint();
                    end = this.getArrowToEndPoint();
                    if (start != null && end != null) {
                        this.calculateFilledArrowhead(start.x, start.y, end.x, end.y, 1, headx, heady);
                        for (i2 = 0; i2 < headx.length; ++i2) {
                            arrowPoints = arrowPoints + " " + Integer.toString(headx[i2]) + " " + Integer.toString(heady[i2]);
                        }
                        polygonEndArrow.setAttribute("points", arrowPoints);
                    }
                }
                if (this.hasArrowAtStart()) {
                    polygonStartArrow = svgDoc.createElement("polygon");
                    arrowPoints = "";
                    start = this.getArrowFromAnchorPoint();
                    end = this.getArrowFromEndPoint();
                    if (start != null && end != null) {
                        this.calculateFilledArrowhead(start.x, start.y, end.x, end.y, 0, headx, heady);
                        for (i2 = 0; i2 < headx.length; ++i2) {
                            arrowPoints = arrowPoints + " " + Integer.toString(headx[i2]) + " " + Integer.toString(heady[i2]);
                        }
                        polygonStartArrow.setAttribute("points", arrowPoints);
                    }
                }
            }
            this.SVGWriteAttributes(path);
            String sStyle = path.getAttribute("style");
            int nStartIdx = sStyle.indexOf("fill:");
            if (nStartIdx != -1) {
                int nEndIdx = sStyle.indexOf(";", nStartIdx) + 1;
                String sNewStyle = sStyle.substring(0, nStartIdx) + "fill:none;" + sStyle.substring(nEndIdx);
                path.setAttribute("style", sNewStyle);
            }
            jGoElementGroup.appendChild(path);
            if (polygonEndArrow != null) {
                this.SVGWriteAttributes(polygonEndArrow);
                jGoElementGroup.appendChild(polygonEndArrow);
            }
            if (polygonStartArrow != null) {
                this.SVGWriteAttributes(polygonStartArrow);
                jGoElementGroup.appendChild(polygonStartArrow);
            }
        }
        super.SVGWriteObject(svgDoc, jGoElementGroup);
    }

    public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement) {
        if (jGoChildElement != null) {
            if (jGoChildElement.getAttribute("embeddedhighlightpen").equals("true")) {
                svgDoc.SVGTraverseChildren(jGoDoc, jGoChildElement, null, false);
            }
            String pen = jGoChildElement.getAttribute("highlightpen");
            svgDoc.registerReferencingObject(this, "highlightpen", pen);
            if (jGoChildElement.getAttribute("arrow_length").length() > 0) {
                if (this.myArrowInfo == null) {
                    this.myArrowInfo = new ArrowInfo();
                }
                this.myArrowInfo.SVGReadJGoElementAttributes(jGoChildElement);
            }
            String xPoints = jGoChildElement.getAttribute("xpoints");
            String yPoints = jGoChildElement.getAttribute("ypoints");
            while (xPoints.length() > 0 && yPoints.length() > 0) {
                int nEnd = xPoints.indexOf(" ");
                if (nEnd == -1) {
                    nEnd = xPoints.length();
                }
                String sX = xPoints.substring(0, nEnd);
                xPoints = nEnd >= xPoints.length() ? "" : xPoints.substring(nEnd + 1);
                nEnd = yPoints.indexOf(" ");
                if (nEnd == -1) {
                    nEnd = yPoints.length();
                }
                String sY = yPoints.substring(0, nEnd);
                yPoints = nEnd >= yPoints.length() ? "" : yPoints.substring(nEnd + 1);
                this.addPoint(Integer.parseInt(sX), Integer.parseInt(sY));
            }
            super.SVGReadObject(svgDoc, jGoDoc, svgElement, jGoChildElement.getNextSiblingJGoClassElement());
            this.setBoundingRectInvalid(true);
        } else if (svgElement.getTagName().equalsIgnoreCase("line")) {
            String x1 = svgElement.getAttribute("x1");
            String y1 = svgElement.getAttribute("y1");
            String x2 = svgElement.getAttribute("x2");
            String y2 = svgElement.getAttribute("y2");
            this.addPoint(new Float(x1).intValue(), new Float(y1).intValue());
            this.addPoint(new Float(x2).intValue(), new Float(y2).intValue());
            this.SVGReadAttributes(svgElement);
            super.SVGReadObject(svgDoc, jGoDoc, svgElement, null);
        }
        return svgElement.getNextSibling();
    }

    public void SVGUpdateReference(String attr, Object referencedObject) {
        super.SVGUpdateReference(attr, referencedObject);
        if (attr.equals("highlightpen")) {
            this.setHighlight((JGoPen)referencedObject);
        }
    }

    public void paint(Graphics2D g, JGoView view) {
        Point topnt;
        Point frompnt;
        JGoPen pen = this.getPen();
        if (pen == null || pen.getStyle() == 0) {
            return;
        }
        int npoints = this.getNumPoints();
        JGoPen highlight = this.getHighlight();
        if (highlight != null && highlight.getStyle() != 0) {
            if (npoints == 2) {
                frompnt = this.getPoint(0);
                topnt = this.getPoint(1);
                JGoStroke.drawLine(g, highlight, frompnt.x, frompnt.y, topnt.x, topnt.y);
            } else {
                JGoStroke.drawPath(g, highlight, null, this.getPath(view));
            }
        }
        if (npoints == 2) {
            frompnt = this.getPoint(0);
            topnt = this.getPoint(1);
            JGoStroke.drawLine(g, pen, frompnt.x, frompnt.y, topnt.x, topnt.y);
        } else {
            JGoStroke.drawPath(g, pen, null, this.getPath(view));
        }
        this.drawArrowHeads(g);
    }

    void makePath(GeneralPath path, JGoView view) {
        block4: {
            int npoints;
            block3: {
                npoints = this.getNumPoints();
                if (!this.isCubic() || npoints < 4) break block3;
                Point start = this.getPoint(0);
                path.moveTo(start.x, start.y);
                for (int i = 3; i < npoints; i += 3) {
                    Point startControl = this.getPoint(i - 2);
                    if (i + 3 >= npoints) {
                        i = npoints - 1;
                    }
                    Point endControl = this.getPoint(i - 1);
                    Point end = this.getPoint(i);
                    path.curveTo(startControl.x, startControl.y, endControl.x, endControl.y, end.x, end.y);
                }
                break block4;
            }
            if (npoints < 2) break block4;
            Point from = this.getPoint(0);
            path.moveTo(from.x, from.y);
            for (int i = 1; i < npoints; ++i) {
                Point to = this.getPoint(i);
                path.lineTo(to.x, to.y);
            }
        }
    }

    GeneralPath getPath(JGoView view) {
        if (this.myPath == null) {
            int npoints = this.getNumPoints();
            this.myPath = new GeneralPath(1, 2 * npoints);
        }
        if (this.myPath.getCurrentPoint() == null) {
            this.makePath(this.myPath, view);
        }
        return this.myPath;
    }

    void resetPath() {
        if (this.myPath != null) {
            this.myPath.reset();
        }
    }

    public boolean isCubic() {
        return (this.getInternalFlags() & 0x1000) != 0;
    }

    public void setCubic(boolean c) {
        boolean oldCubic;
        boolean bl = oldCubic = (this.getInternalFlags() & 0x1000) != 0;
        if (oldCubic != c) {
            if (c) {
                this.setInternalFlags(this.getInternalFlags() | 0x1000);
            } else {
                this.setInternalFlags(this.getInternalFlags() & 0xFFFFEFFF);
            }
            this.resetPath();
            this.update(109, oldCubic ? 1 : 0, null);
        }
    }

    public final int addPoint(Point point) {
        return this.addPoint(point.x, point.y);
    }

    public int addPoint(int x, int y) {
        return this.internalInsertPoint(this.myPoints.size(), x, y, false);
    }

    public final int insertPoint(int i, Point point) {
        return this.insertPoint(i, point.x, point.y);
    }

    public int insertPoint(int i, int x, int y) {
        return this.internalInsertPoint(i, x, y, false);
    }

    private int internalInsertPoint(int i, int x, int y, boolean undoing) {
        Point p = new Point(x, y);
        int idx = i;
        try {
            this.myPoints.add(i, p);
        }
        catch (Exception e) {
            this.myPoints.add(p);
            idx = this.myPoints.size() - 1;
        }
        if (!undoing) {
            this.setBoundingRectInvalid(true);
        }
        this.resetPath();
        this.update(101, idx, p);
        return idx;
    }

    public void removePoint(int i) {
        this.internalRemovePoint(i, false);
    }

    private void internalRemovePoint(int i, boolean undoing) {
        if (i >= 0 && i < this.getNumPoints()) {
            Point oldPoint = null;
            try {
                oldPoint = (Point)this.myPoints.remove(i);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!undoing) {
                this.setBoundingRectInvalid(true);
            }
            this.resetPath();
            this.update(102, i, oldPoint);
        }
    }

    public Point getPoint(int i) {
        if (i >= 0 && i < this.getNumPoints()) {
            return (Point)this.myPoints.get(i);
        }
        return null;
    }

    public int getPointX(int i) {
        Point p = this.getPoint(i);
        if (p != null) {
            return p.x;
        }
        return -1;
    }

    public int getPointY(int i) {
        Point p = this.getPoint(i);
        if (p != null) {
            return p.y;
        }
        return -1;
    }

    public final void setPoint(int i, Point point) {
        this.setPoint(i, point.x, point.y);
    }

    public void setPoint(int i, int x, int y) {
        this.internalSetPoint(i, x, y, false);
    }

    private void internalSetPoint(int i, int x, int y, boolean undoing) {
        Point oldpnt = this.getPoint(i);
        if (oldpnt != null && (oldpnt.x != x || oldpnt.y != y)) {
            if (this.myTempPoint == null) {
                this.myTempPoint = new Point(oldpnt.x, oldpnt.y);
            } else {
                this.myTempPoint.x = oldpnt.x;
                this.myTempPoint.y = oldpnt.y;
            }
            oldpnt.x = x;
            oldpnt.y = y;
            if (!undoing) {
                this.setBoundingRectInvalid(true);
            }
            this.resetPath();
            this.update(103, i, this.myTempPoint);
        }
    }

    public void removeAllPoints() {
        this.foredate(110);
        this.myPoints.clear();
        this.setBoundingRectInvalid(true);
        this.resetPath();
        this.update(110, 0, null);
    }

    public void setPoints(Vector points) {
        this.foredate(110);
        this.myPoints.clear();
        for (int i = 0; i < points.size(); ++i) {
            Point pt = (Point)points.get(i);
            Point newp = new Point(pt.x, pt.y);
            this.myPoints.add(newp);
        }
        this.setBoundingRectInvalid(true);
        this.resetPath();
        this.update(110, 0, null);
    }

    public void setPoints(ArrayList points) {
        this.internalSetPoints(points, false);
    }

    void internalSetPoints(ArrayList points, boolean undoing) {
        this.foredate(110);
        this.myPoints.clear();
        for (int i = 0; i < points.size(); ++i) {
            Point pt = (Point)points.get(i);
            Point newp = new Point(pt.x, pt.y);
            this.myPoints.add(newp);
        }
        if (!undoing) {
            this.setBoundingRectInvalid(true);
        }
        this.resetPath();
        this.update(110, 0, null);
    }

    public Vector copyPoints() {
        Vector<Point> v = new Vector<Point>();
        int numpts = this.getNumPoints();
        for (int i = 0; i < numpts; ++i) {
            Point oldpoint = this.getPoint(i);
            v.add(i, new Point(oldpoint.x, oldpoint.y));
        }
        return v;
    }

    public ArrayList copyPointsArray() {
        ArrayList<Point> v = new ArrayList<Point>();
        int numpts = this.getNumPoints();
        for (int i = 0; i < numpts; ++i) {
            Point oldpoint = this.getPoint(i);
            v.add(i, new Point(oldpoint.x, oldpoint.y));
        }
        return v;
    }

    public int getNumPoints() {
        return this.myPoints.size();
    }

    public Point getStartPoint() {
        return this.getPoint(0);
    }

    public Point getEndPoint() {
        return this.getPoint(this.getNumPoints() - 1);
    }

    public int getFirstPickPoint() {
        return 0;
    }

    public int getLastPickPoint() {
        return this.getNumPoints() - 1;
    }

    public Rectangle handleResize(Graphics2D g, JGoView view, Rectangle prevRect, Point newPoint, int whichHandle, int event, int minWidth, int minHeight) {
        if (whichHandle < 100) {
            return super.handleResize(g, view, prevRect, newPoint, whichHandle, event, minWidth, minHeight);
        }
        this.setPoint(whichHandle - 100, newPoint);
        return null;
    }

    protected void geometryChange(Rectangle prevRect) {
        if (prevRect.width == this.getWidth() && prevRect.height == this.getHeight()) {
            Rectangle newRect = this.getBoundingRect();
            int offsetx = newRect.x - prevRect.x;
            int offsety = newRect.y - prevRect.y;
            if (offsetx == 0 && offsety == 0) {
                return;
            }
            this.foredate(110);
            this.setSuspendUpdates(true);
            for (int i = 0; i < this.getNumPoints(); ++i) {
                Point pnt = this.getPoint(i);
                if (pnt == null) continue;
                int newx = pnt.x + offsetx;
                int newy = pnt.y + offsety;
                this.setPoint(i, newx, newy);
            }
            this.setBoundingRectInvalid(false);
            this.setSuspendUpdates(false);
            this.resetPath();
            this.update(110, 0, null);
        } else {
            Rectangle newRect = this.getBoundingRect();
            double scaleFactorX = 1.0;
            if (prevRect.width != 0) {
                scaleFactorX = (double)newRect.width / (double)prevRect.width;
            }
            double scaleFactorY = 1.0;
            if (prevRect.height != 0) {
                scaleFactorY = (double)newRect.height / (double)prevRect.height;
            }
            this.foredate(110);
            this.setSuspendUpdates(true);
            for (int i = 0; i < this.getNumPoints(); ++i) {
                Point pnt = this.getPoint(i);
                if (pnt == null) continue;
                int newx = newRect.x + (int)Math.rint((double)(pnt.x - prevRect.x) * scaleFactorX);
                int newy = newRect.y + (int)Math.rint((double)(pnt.y - prevRect.y) * scaleFactorY);
                this.setPoint(i, newx, newy);
            }
            this.setBoundingRectInvalid(false);
            this.setSuspendUpdates(false);
            this.resetPath();
            this.update(110, 0, null);
        }
    }

    protected void gainedSelection(JGoSelection selection) {
        if (!this.isResizable()) {
            selection.createBoundingHandle(this);
            return;
        }
        int nLastPoint = this.getLastPickPoint();
        for (int i = this.getFirstPickPoint(); i <= nLastPoint; ++i) {
            Point pnt = this.getPoint(i);
            if (pnt == null) continue;
            selection.createResizeHandle(this, pnt.x, pnt.y, 100 + i, true);
        }
    }

    protected Rectangle computeBoundingRect() {
        int numpts = this.getNumPoints();
        if (numpts == 0) {
            return null;
        }
        Point pnt = this.getPoint(0);
        int left = pnt.x;
        int top = pnt.y;
        int right = pnt.x;
        int bottom = pnt.y;
        if (this.isCubic() && numpts >= 4) {
            for (int i = 3; i < numpts; i += 3) {
                Point s = this.getPoint(i - 3);
                Point sc = this.getPoint(i - 2);
                if (i + 3 >= numpts) {
                    i = numpts - 1;
                }
                Point ec = this.getPoint(i - 1);
                Point e = this.getPoint(i);
                Rectangle brect = JGoStroke.BezierBounds(s.x, s.y, sc.x, sc.y, ec.x, ec.y, e.x, e.y);
                left = Math.min(left, brect.x);
                top = Math.min(top, brect.y);
                right = Math.max(right, brect.x + brect.width);
                bottom = Math.max(bottom, brect.y + brect.height);
            }
        } else {
            for (int i = 1; i < numpts; ++i) {
                pnt = this.getPoint(i);
                left = Math.min(left, pnt.x);
                top = Math.min(top, pnt.y);
                right = Math.max(right, pnt.x);
                bottom = Math.max(bottom, pnt.y);
            }
        }
        return new Rectangle(left, top, right - left, bottom - top);
    }

    public void expandRectByPenWidth(Rectangle rect) {
        JGoPen pen = this.getPen();
        if (pen != null) {
            int penWidth = 5 * pen.getWidth();
            if (this.getHighlight() != null) {
                penWidth = Math.max(penWidth, 5 * this.getHighlight().getWidth());
            }
            if (this.hasArrowAtEnd() || this.hasArrowAtStart()) {
                penWidth = Math.max(penWidth, (int)this.getArrowLength());
                penWidth = Math.max(penWidth, (int)this.getArrowWidth());
            }
            rect.x -= penWidth;
            rect.y -= penWidth;
            rect.width += penWidth * 2;
            rect.height += penWidth * 2;
        }
    }

    public boolean isPointInObj(Point pnt) {
        int idx = this.getSegmentNearPoint(pnt);
        return idx >= 0;
    }

    public int getSegmentNearPoint(Point pnt) {
        int line_width;
        Rectangle rect = this.getBoundingRect();
        int n = line_width = this.getPen() != null ? this.getPen().getWidth() : 1;
        if (pnt.x < rect.x - line_width || pnt.x > rect.x + rect.width + line_width || pnt.y < rect.y - line_width || pnt.y > rect.y + rect.height + line_width) {
            return -1;
        }
        int numpts = this.getNumPoints();
        if (numpts <= 1) {
            return -1;
        }
        line_width += 3;
        if (this.isCubic() && numpts >= 4) {
            line_width *= Math.max(1, Math.max(rect.width, rect.height) / 100);
            for (int i = 3; i < numpts; i += 3) {
                int firsti = i;
                Point s = this.getPoint(i - 3);
                Point sc = this.getPoint(i - 2);
                if (i + 3 >= numpts) {
                    i = numpts - 1;
                }
                Point ec = this.getPoint(i - 1);
                Point e = this.getPoint(i);
                if (!JGoStroke.BezierContainsPoint(s.x, s.y, sc.x, sc.y, ec.x, ec.y, e.x, e.y, line_width, pnt)) continue;
                return firsti;
            }
        } else {
            for (int i = 0; i < numpts - 1; ++i) {
                Point s = this.getPoint(i);
                Point e = this.getPoint(i + 1);
                if (!JGoStroke.LineContainsPoint(s.x, s.y, e.x, e.y, line_width, pnt)) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean LineContainsPoint(int ax, int ay, int bx, int by, int fuzz, Point p) {
        int maxy;
        int miny;
        int maxx;
        int minx;
        if (ax < bx) {
            minx = ax;
            maxx = bx;
        } else {
            minx = bx;
            maxx = ax;
        }
        if (ay < by) {
            miny = ay;
            maxy = by;
        } else {
            miny = by;
            maxy = ay;
        }
        if (ax == bx && ax - fuzz <= p.x && p.x <= ax + fuzz && miny <= p.y && p.y <= maxy) {
            return true;
        }
        if (ay == by && ay - fuzz <= p.y && p.y <= ay + fuzz && minx <= p.x && p.x <= maxx) {
            return true;
        }
        int xrange_high = maxx + fuzz;
        int xrange_low = minx - fuzz;
        if (xrange_low > p.x || p.x > xrange_high) return false;
        int yrange_high = maxy + fuzz;
        int yrange_low = miny - fuzz;
        if (yrange_low > p.y || p.y > yrange_high) return false;
        if (xrange_high - xrange_low > yrange_high - yrange_low) {
            if (Math.abs(ax - bx) <= fuzz) return true;
            double slope = (double)(by - ay) / (double)(bx - ax);
            double guess_y = slope * (double)(p.x - ax) + (double)ay;
            if (!(guess_y - (double)fuzz <= (double)p.y) || !((double)p.y <= guess_y + (double)fuzz)) return false;
            return true;
        }
        if (Math.abs(ay - by) <= fuzz) return true;
        double slope = (double)(bx - ax) / (double)(by - ay);
        double guess_x = slope * (double)(p.y - ay) + (double)ax;
        if (!(guess_x - (double)fuzz <= (double)p.x) || !((double)p.x <= guess_x + (double)fuzz)) return false;
        return true;
    }

    static boolean BezierContainsPoint(int b0x, int b0y, int b1x, int b1y, int b2x, int b2y, int b3x, int b3y, int fuzz, Point p) {
        int c0x = b0x;
        int c0y = b0y;
        int c1x = (b0x + b1x) / 2;
        int c1y = (b0y + b1y) / 2;
        int c2x = (b1x + b2x) / 2;
        int c2y = (b1y + b2y) / 2;
        int c3x = (b2x + b3x) / 2;
        int c3y = (b2y + b3y) / 2;
        int c4x = b3x;
        int c4y = b3y;
        int d0x = c0x;
        int d0y = c0y;
        int d1x = (c0x + c1x) / 2;
        int d1y = (c0y + c1y) / 2;
        int d2x = (c1x + c2x) / 2;
        int d2y = (c1y + c2y) / 2;
        int d3x = (c2x + c3x) / 2;
        int d3y = (c2y + c3y) / 2;
        int d4x = (c3x + c4x) / 2;
        int d4y = (c3y + c4y) / 2;
        int d5x = c4x;
        int d5y = c4y;
        if (JGoStroke.LineContainsPoint(d0x, d0y, d1x, d1y, fuzz, p)) {
            return true;
        }
        if (JGoStroke.LineContainsPoint(d1x, d1y, d2x, d2y, fuzz, p)) {
            return true;
        }
        if (JGoStroke.LineContainsPoint(d2x, d2y, d3x, d3y, fuzz, p)) {
            return true;
        }
        if (JGoStroke.LineContainsPoint(d3x, d3y, d4x, d4y, fuzz, p)) {
            return true;
        }
        return JGoStroke.LineContainsPoint(d4x, d4y, d5x, d5y, fuzz, p);
    }

    static void BezierMidPoint(int b0x, int b0y, int b1x, int b1y, int b2x, int b2y, int b3x, int b3y, Point v, Point w) {
        int c0x = b0x;
        int c0y = b0y;
        int c1x = (b0x + b1x) / 2;
        int c1y = (b0y + b1y) / 2;
        int c2x = (b1x + b2x) / 2;
        int c2y = (b1y + b2y) / 2;
        int c3x = (b2x + b3x) / 2;
        int c3y = (b2y + b3y) / 2;
        int c4x = b3x;
        int c4y = b3y;
        v.x = (c1x + c2x) / 2;
        v.y = (c1y + c2y) / 2;
        w.x = (c2x + c3x) / 2;
        w.y = (c2y + c3y) / 2;
    }

    static Rectangle BezierBounds(int b0x, int b0y, int b1x, int b1y, int b2x, int b2y, int b3x, int b3y) {
        int c0x = b0x;
        int c0y = b0y;
        int c1x = (b0x + b1x) / 2;
        int c1y = (b0y + b1y) / 2;
        int c2x = (b1x + b2x) / 2;
        int c2y = (b1y + b2y) / 2;
        int c3x = (b2x + b3x) / 2;
        int c3y = (b2y + b3y) / 2;
        int c4x = b3x;
        int c4y = b3y;
        int d0x = c0x;
        int d0y = c0y;
        int d1x = (c0x + c1x) / 2;
        int d1y = (c0y + c1y) / 2;
        int d2x = (c1x + c2x) / 2;
        int d2y = (c1y + c2y) / 2;
        int d3x = (c2x + c3x) / 2;
        int d3y = (c2y + c3y) / 2;
        int d4x = (c3x + c4x) / 2;
        int d4y = (c3y + c4y) / 2;
        int d5x = c4x;
        int d5y = c4y;
        int minx = d0x;
        int maxx = d0x;
        if (d1x < minx) {
            minx = d1x;
        } else if (d1x > maxx) {
            maxx = d1x;
        }
        if (d2x < minx) {
            minx = d2x;
        } else if (d2x > maxx) {
            maxx = d2x;
        }
        if (d3x < minx) {
            minx = d3x;
        } else if (d3x > maxx) {
            maxx = d3x;
        }
        if (d4x < minx) {
            minx = d4x;
        } else if (d4x > maxx) {
            maxx = d4x;
        }
        if (d5x < minx) {
            minx = d5x;
        } else if (d5x > maxx) {
            maxx = d5x;
        }
        int miny = d0y;
        int maxy = d0y;
        if (d1y < miny) {
            miny = d1y;
        } else if (d1y > maxy) {
            maxy = d1y;
        }
        if (d2y < miny) {
            miny = d2y;
        } else if (d2y > maxy) {
            maxy = d2y;
        }
        if (d3y < miny) {
            miny = d3y;
        } else if (d3y > maxy) {
            maxy = d3y;
        }
        if (d4y < miny) {
            miny = d4y;
        } else if (d4y > maxy) {
            maxy = d4y;
        }
        if (d5y < miny) {
            miny = d5y;
        } else if (d5y > maxy) {
            maxy = d5y;
        }
        return new Rectangle(minx - 10, miny - 10, maxx - minx + 20, maxy - miny + 20);
    }

    static boolean BezierNearestIntersectionOnLine(int b0x, int b0y, int b1x, int b1y, int b2x, int b2y, int b3x, int b3y, int p1x, int p1y, int p2x, int p2y, Point result) {
        float dist;
        int c0x = b0x;
        int c0y = b0y;
        int c1x = (b0x + b1x) / 2;
        int c1y = (b0y + b1y) / 2;
        int c2x = (b1x + b2x) / 2;
        int c2y = (b1y + b2y) / 2;
        int c3x = (b2x + b3x) / 2;
        int c3y = (b2y + b3y) / 2;
        int c4x = b3x;
        int c4y = b3y;
        int d0x = c0x;
        int d0y = c0y;
        int d1x = (c0x + c1x) / 2;
        int d1y = (c0y + c1y) / 2;
        int d2x = (c1x + c2x) / 2;
        int d2y = (c1y + c2y) / 2;
        int d3x = (c2x + c3x) / 2;
        int d3y = (c2y + c3y) / 2;
        int d4x = (c3x + c4x) / 2;
        int d4y = (c3y + c4y) / 2;
        int d5x = c4x;
        int d5y = c4y;
        Point R = new Point(0, 0);
        double closestdist = 1.0E21;
        if (JGoStroke.getNearestIntersectionOnLine(d0x, d0y, d1x, d1y, p1x, p1y, p2x, p2y, R) && (double)(dist = (float)((R.x - p1x) * (R.x - p1x) + (R.y - p1y) * (R.y - p1y))) < closestdist) {
            closestdist = dist;
            result.x = R.x;
            result.y = R.y;
        }
        if (JGoStroke.getNearestIntersectionOnLine(d1x, d1y, d2x, d2y, p1x, p1y, p2x, p2y, R) && (double)(dist = (float)((R.x - p1x) * (R.x - p1x) + (R.y - p1y) * (R.y - p1y))) < closestdist) {
            closestdist = dist;
            result.x = R.x;
            result.y = R.y;
        }
        if (JGoStroke.getNearestIntersectionOnLine(d2x, d2y, d3x, d3y, p1x, p1y, p2x, p2y, R) && (double)(dist = (float)((R.x - p1x) * (R.x - p1x) + (R.y - p1y) * (R.y - p1y))) < closestdist) {
            closestdist = dist;
            result.x = R.x;
            result.y = R.y;
        }
        if (JGoStroke.getNearestIntersectionOnLine(d3x, d3y, d4x, d4y, p1x, p1y, p2x, p2y, R) && (double)(dist = (float)((R.x - p1x) * (R.x - p1x) + (R.y - p1y) * (R.y - p1y))) < closestdist) {
            closestdist = dist;
            result.x = R.x;
            result.y = R.y;
        }
        if (JGoStroke.getNearestIntersectionOnLine(d4x, d4y, d5x, d5y, p1x, p1y, p2x, p2y, R) && (double)(dist = (float)((R.x - p1x) * (R.x - p1x) + (R.y - p1y) * (R.y - p1y))) < closestdist) {
            closestdist = dist;
            result.x = R.x;
            result.y = R.y;
        }
        return closestdist < (double)1.0E21f;
    }

    public static boolean getNearestPointOnLine(Point A, Point B, Point P, Point R) {
        return JGoStroke.getNearestPointOnLine(A.x, A.y, B.x, B.y, P.x, P.y, R);
    }

    public static boolean getNearestPointOnLine(int Ax, int Ay, int Bx, int By, int Px, int Py, Point R) {
        if (Ax == Bx) {
            int max;
            int min;
            if (Ay < By) {
                min = Ay;
                max = By;
            } else {
                min = By;
                max = Ay;
            }
            int p = Py;
            if (p < min) {
                R.x = Ax;
                R.y = min;
                return false;
            }
            if (p > max) {
                R.x = Ax;
                R.y = max;
                return false;
            }
            R.x = Ax;
            R.y = p;
            return true;
        }
        if (Ay == By) {
            int max;
            int min;
            if (Ax < Bx) {
                min = Ax;
                max = Bx;
            } else {
                min = Bx;
                max = Ax;
            }
            int p = Px;
            if (p < min) {
                R.x = min;
                R.y = Ay;
                return false;
            }
            if (p > max) {
                R.x = max;
                R.y = Ay;
                return false;
            }
            R.x = p;
            R.y = Ay;
            return true;
        }
        double L = (Bx - Ax) * (Bx - Ax) + (By - Ay) * (By - Ay);
        double Q = (double)((Ax - Px) * (Ax - Bx) + (Ay - Py) * (Ay - By)) / L;
        if (Q < 0.0) {
            R.x = Ax;
            R.y = Ay;
            return false;
        }
        if (Q > 1.0) {
            R.x = Bx;
            R.y = By;
            return false;
        }
        double x = (double)Ax + Q * (double)(Bx - Ax);
        double y = (double)Ay + Q * (double)(By - Ay);
        R.x = (int)Math.rint(x);
        R.y = (int)Math.rint(y);
        return true;
    }

    public static boolean getNearestIntersectionOnLine(int Ax, int Ay, int Bx, int By, int Px, int Py, int Qx, int Qy, Point R) {
        if (Px == Qx) {
            if (Ax == Bx) {
                JGoStroke.getNearestPointOnLine(Ax, Ay, Bx, By, Px, Py, R);
                return false;
            }
            double M = (double)(By - Ay) / (double)(Bx - Ax);
            int y = (int)Math.rint(M * (double)(Px - Ax) + (double)Ay);
            return JGoStroke.getNearestPointOnLine(Ax, Ay, Bx, By, Px, y, R);
        }
        double S = (double)(Qy - Py) / (double)(Qx - Px);
        if (Ax == Bx) {
            int y = (int)Math.rint(S * (double)(Ax - Px) + (double)Py);
            if (y < Math.min(Ay, By)) {
                R.x = Ax;
                R.y = Math.min(Ay, By);
                return false;
            }
            if (y > Math.max(Ay, By)) {
                R.x = Ax;
                R.y = Math.max(Ay, By);
                return false;
            }
            R.x = Ax;
            R.y = y;
            return true;
        }
        double M = (double)(By - Ay) / (double)(Bx - Ax);
        if (S == M) {
            JGoStroke.getNearestPointOnLine(Ax, Ay, Bx, By, Px, Py, R);
            return false;
        }
        int x = (int)Math.rint((M * (double)Ax - S * (double)Px + (double)Py - (double)Ay) / (M - S));
        if (M == 0.0) {
            if (x < Math.min(Ax, Bx)) {
                R.x = Math.min(Ax, Bx);
                R.y = Ay;
                return false;
            }
            if (x > Math.max(Ax, Bx)) {
                R.x = Math.max(Ax, Bx);
                R.y = Ay;
                return false;
            }
            R.x = x;
            R.y = Ay;
            return true;
        }
        int y = (int)Math.rint(M * (double)(x - Ax) + (double)Ay);
        return JGoStroke.getNearestPointOnLine(Ax, Ay, Bx, By, x, y, R);
    }

    public boolean getNearestIntersectionPoint(int px, int py, int cx, int cy, Point result) {
        Rectangle r = this.getBoundingRect();
        Point P = new Point(0, 0);
        double closestdist = 1.0E21;
        int numpts = this.getNumPoints();
        if (this.isCubic() && numpts >= 4) {
            for (int i = 3; i < numpts; i += 3) {
                double dist;
                Point s = this.getPoint(i - 3);
                Point sc = this.getPoint(i - 2);
                if (i + 3 >= numpts) {
                    i = numpts - 1;
                }
                Point ec = this.getPoint(i - 1);
                Point e = this.getPoint(i);
                if (!JGoStroke.BezierNearestIntersectionOnLine(s.x, s.y, sc.x, sc.y, ec.x, ec.y, e.x, e.y, px, py, cx, cy, P) || !((dist = (double)((P.x - px) * (P.x - px) + (P.y - py) * (P.y - py))) < closestdist)) continue;
                closestdist = dist;
                result.x = P.x;
                result.y = P.y;
            }
        } else {
            for (int i = 0; i < numpts - 1; ++i) {
                double dist;
                Point A = this.getPoint(i);
                Point B = this.getPoint(i + 1);
                if (!JGoStroke.getNearestIntersectionOnLine(A.x, A.y, B.x, B.y, px, py, cx, cy, P) || !((dist = (double)((P.x - px) * (P.x - px) + (P.y - py) * (P.y - py))) < closestdist)) continue;
                closestdist = dist;
                result.x = P.x;
                result.y = P.y;
            }
        }
        return closestdist < 1.0E21;
    }

    public void setArrowHeads(boolean from, boolean to) {
        boolean oldArrowAtStart;
        boolean oldArrowAtEnd = (this.getInternalFlags() & 0x4000) != 0;
        boolean bl = oldArrowAtStart = (this.getInternalFlags() & 0x8000) != 0;
        if (oldArrowAtEnd != to || oldArrowAtStart != from) {
            int on = 0;
            int off = 0;
            if (from) {
                on |= 0x8000;
            } else {
                off |= 0x8000;
            }
            if (to) {
                on |= 0x4000;
            } else {
                off |= 0x4000;
            }
            this.setInternalFlags(this.getInternalFlags() & ~off | on);
            this.update(104, (oldArrowAtEnd ? 2 : 0) + (oldArrowAtStart ? 1 : 0), null);
        }
    }

    public boolean hasArrowAtEnd() {
        return (this.getInternalFlags() & 0x4000) != 0;
    }

    public boolean hasArrowAtStart() {
        return (this.getInternalFlags() & 0x8000) != 0;
    }

    public Point getArrowToEndPoint() {
        return this.getEndPoint();
    }

    public Point getArrowToAnchorPoint() {
        return this.getPoint(this.getNumPoints() - 2);
    }

    public Point getArrowFromEndPoint() {
        return this.getStartPoint();
    }

    public Point getArrowFromAnchorPoint() {
        return this.getPoint(1);
    }

    public void setArrowLength(double len) {
        double oldArrowLength = this.getArrowLength();
        if (oldArrowLength != len) {
            if (this.myArrowInfo == null) {
                this.myArrowInfo = new ArrowInfo();
            }
            this.myArrowInfo.myLength = len;
            this.update(105, 0, new Double(oldArrowLength));
        }
    }

    public double getArrowLength() {
        if (this.myArrowInfo != null) {
            return this.myArrowInfo.myLength;
        }
        return 10.0;
    }

    public void setArrowShaftLength(double len) {
        double oldArrowShaftLength = this.getArrowShaftLength();
        if (oldArrowShaftLength != len) {
            if (this.myArrowInfo == null) {
                this.myArrowInfo = new ArrowInfo();
            }
            this.myArrowInfo.myShaftLength = len;
            this.update(106, 0, new Double(oldArrowShaftLength));
        }
    }

    public double getArrowShaftLength() {
        if (this.myArrowInfo != null) {
            return this.myArrowInfo.myShaftLength;
        }
        return 8.0;
    }

    public void setArrowAngle(double angle) {
        this.setArrowWidth(this.getArrowLength() * Math.tan(angle / 2.0) * 2.0);
    }

    public double getArrowAngle() {
        double length = this.getArrowLength();
        if (length < 1.0) {
            length = 1.0;
        }
        return Math.atan(this.getArrowWidth() / (length * 2.0)) * 2.0;
    }

    public void setArrowWidth(double width) {
        double oldArrowWidth = this.getArrowWidth();
        if (oldArrowWidth != width && width >= 0.0) {
            if (this.myArrowInfo == null) {
                this.myArrowInfo = new ArrowInfo();
            }
            this.myArrowInfo.myWidth = width;
            this.update(111, 0, new Double(oldArrowWidth));
        }
    }

    public double getArrowWidth() {
        if (this.myArrowInfo != null) {
            return this.myArrowInfo.myWidth;
        }
        return 8.0;
    }

    protected void drawArrowHeads(Graphics2D g) {
        boolean atend = this.hasArrowAtEnd();
        boolean atstart = this.hasArrowAtStart();
        if (atend || atstart) {
            Point end;
            Point start;
            if (this.myArrowInfo == null) {
                this.myArrowInfo = new ArrowInfo();
            }
            int[] headx = this.myArrowInfo.getXs();
            int[] heady = this.myArrowInfo.getYs();
            if (atend) {
                start = this.getArrowToAnchorPoint();
                end = this.getArrowToEndPoint();
                if (start != null && end != null) {
                    this.calculateFilledArrowhead(start.x, start.y, end.x, end.y, 1, headx, heady);
                    this.drawArrowhead(g, true, headx, heady);
                }
            }
            if (atstart) {
                start = this.getArrowFromAnchorPoint();
                end = this.getArrowFromEndPoint();
                if (start != null && end != null) {
                    this.calculateFilledArrowhead(start.x, start.y, end.x, end.y, 0, headx, heady);
                    this.drawArrowhead(g, false, headx, heady);
                }
            }
        }
    }

    protected void calculateFilledArrowhead(int x0, int y0, int x1, int y1, int atend, int[] headx, int[] heady) {
        int xPart = x1 - x0;
        int yPart = y1 - y0;
        double line_length = Math.sqrt(xPart * xPart + yPart * yPart);
        if (line_length <= 1.0) {
            line_length = 1.0;
        }
        double cosine = (double)xPart / line_length;
        double sine = (double)yPart / line_length;
        double length = this.getArrowLength();
        double shaftlength = this.getArrowShaftLength();
        int width = (int)Math.round(this.getArrowWidth() / 2.0);
        double initx0 = -shaftlength;
        double inity0 = 0.0;
        double initx1 = -length;
        double inity1 = width;
        double initx3 = -length;
        double inity3 = -width;
        headx[0] = x1 + (int)Math.round(cosine * initx0 - sine * inity0);
        heady[0] = y1 + (int)Math.round(sine * initx0 + cosine * inity0);
        headx[1] = x1 + (int)Math.round(cosine * initx1 - sine * inity1);
        heady[1] = y1 + (int)Math.round(sine * initx1 + cosine * inity1);
        headx[2] = x1;
        heady[2] = y1;
        headx[3] = x1 + (int)Math.round(cosine * initx3 - sine * inity3);
        heady[3] = y1 + (int)Math.round(sine * initx3 + cosine * inity3);
    }

    protected void drawArrowhead(Graphics2D g, boolean atend, int[] headx, int[] heady) {
        JGoPen p = this.getPen();
        if (p.getStyle() != 65535 || p.getWidth() > 1) {
            p = JGoPen.makeStockPen(p.getColor());
        }
        JGoStroke.drawPolygon(g, p, this.getBrush(), headx, heady, 4);
    }

    public void setHighlight(JGoPen pen) {
        JGoPen oldHighlight = this.myHighlightPen;
        if (oldHighlight != pen) {
            this.myHighlightPen = pen;
            this.update(108, 0, oldHighlight);
        }
    }

    public JGoPen getHighlight() {
        return this.myHighlightPen;
    }

    public void copyOldValueForUndo(JGoDocumentChangedEdit e) {
        switch (e.getFlags()) {
            case 101: {
                Point p = (Point)e.getOldValue();
                e.setOldValue(new Point(p.x, p.y));
                return;
            }
            case 102: {
                Point p = (Point)e.getOldValue();
                e.setOldValue(new Point(p.x, p.y));
                return;
            }
            case 103: {
                Point p = (Point)e.getOldValue();
                e.setOldValue(new Point(p.x, p.y));
                return;
            }
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 111: {
                return;
            }
            case 110: {
                JGoDocumentChangedEdit before;
                if (!e.isBeforeChanging() && (before = e.findBeforeChangingEdit()) != null) {
                    e.setOldValue(before.getNewValue());
                }
                return;
            }
        }
        super.copyOldValueForUndo(e);
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit e) {
        switch (e.getFlags()) {
            case 101: {
                Point p = this.getPoint(e.getOldValueInt());
                e.setNewValue(new Point(p.x, p.y));
                return;
            }
            case 102: {
                Point p = this.getPoint(e.getOldValueInt());
                e.setNewValue(new Point(p.x, p.y));
                return;
            }
            case 103: {
                Point p = this.getPoint(e.getOldValueInt());
                e.setNewValue(new Point(p.x, p.y));
                return;
            }
            case 104: {
                e.setNewValueInt((this.hasArrowAtEnd() ? 2 : 0) + (this.hasArrowAtStart() ? 1 : 0));
                return;
            }
            case 105: {
                e.setNewValue(new Double(this.getArrowLength()));
                return;
            }
            case 106: {
                e.setNewValue(new Double(this.getArrowShaftLength()));
                return;
            }
            case 111: {
                e.setNewValue(new Double(this.getArrowWidth()));
                return;
            }
            case 108: {
                e.setNewValue(this.getHighlight());
                return;
            }
            case 109: {
                e.setNewValueBoolean(this.isCubic());
                return;
            }
            case 110: {
                ArrayList copy = this.copyPointsArray();
                e.setNewValue(copy);
                return;
            }
        }
        super.copyNewValueForRedo(e);
    }

    public void changeValue(JGoDocumentChangedEdit e, boolean undo) {
        switch (e.getFlags()) {
            case 101: {
                if (undo) {
                    this.internalRemovePoint(e.getOldValueInt(), true);
                } else {
                    Point p = (Point)e.getNewValue();
                    this.internalInsertPoint(e.getOldValueInt(), p.x, p.y, true);
                }
                return;
            }
            case 102: {
                if (undo) {
                    Point p = (Point)e.getOldValue();
                    this.internalInsertPoint(e.getOldValueInt(), p.x, p.y, true);
                } else {
                    this.internalRemovePoint(e.getOldValueInt(), true);
                }
                return;
            }
            case 103: {
                if (undo) {
                    Point p = (Point)e.getOldValue();
                    this.internalSetPoint(e.getOldValueInt(), p.x, p.y, true);
                } else {
                    Point p = (Point)e.getNewValue();
                    this.internalSetPoint(e.getOldValueInt(), p.x, p.y, true);
                }
                return;
            }
            case 104: {
                int flags = e.getValueInt(undo);
                boolean end = (flags & 2) != 0;
                boolean start = (flags & 1) != 0;
                this.setArrowHeads(start, end);
                return;
            }
            case 105: {
                this.setArrowLength(e.getValueDouble(undo));
                return;
            }
            case 106: {
                this.setArrowShaftLength(e.getValueDouble(undo));
                return;
            }
            case 111: {
                this.setArrowWidth(e.getValueDouble(undo));
                return;
            }
            case 108: {
                this.setHighlight((JGoPen)e.getValue(undo));
                return;
            }
            case 109: {
                this.setCubic(e.getValueBoolean(undo));
                return;
            }
            case 110: {
                ArrayList pts = (ArrayList)e.getValue(undo);
                this.internalSetPoints(pts, true);
                return;
            }
        }
        super.changeValue(e, undo);
    }

    class ArrowInfo
    implements Serializable {
        double myLength = 10.0;
        double myShaftLength = 8.0;
        double myWidth = 8.0;
        transient int[] headx = null;
        transient int[] heady = null;

        ArrowInfo() {
        }

        int[] getXs() {
            if (this.headx == null) {
                this.headx = new int[4];
            }
            return this.headx;
        }

        int[] getYs() {
            if (this.heady == null) {
                this.heady = new int[4];
            }
            return this.heady;
        }

        public void SVGWriteJGoElementAttributes(DomElement svgElement) {
            svgElement.setAttribute("arrow_length", Double.toString(this.myLength));
            svgElement.setAttribute("arrow_shaftlength", Double.toString(this.myShaftLength));
            svgElement.setAttribute("arrow_width", Double.toString(this.myWidth));
        }

        public void SVGReadJGoElementAttributes(DomElement svgElement) {
            String arrow_length = svgElement.getAttribute("arrow_length");
            this.myLength = Double.parseDouble(arrow_length);
            String arrow_shaftlength = svgElement.getAttribute("arrow_shaftlength");
            this.myShaftLength = Double.parseDouble(arrow_shaftlength);
            String arrow_angle = svgElement.getAttribute("arrow_angle");
            if (arrow_angle.length() > 0) {
                double angle = Double.parseDouble(arrow_angle);
                this.myWidth = this.myLength * Math.tan(angle / 2.0) * 2.0;
            } else {
                String arrow_width = svgElement.getAttribute("arrow_width");
                this.myWidth = Double.parseDouble(arrow_width);
            }
        }
    }
}

