/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.coco.runtime.messages;

import com.sun.encoder.coco.runtime.messages.ErrorManager;
import java.awt.Window;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

class DefaultErrorManager
extends ErrorManager {
    private static final Map<ErrorManager.Severity, Integer> cJOptionDialogSeverity;
    private static final Map<ErrorManager.Severity, Level> cLoggerSeverityMap;
    private final Logger mLogger;
    private Window mRoot;

    public DefaultErrorManager(Object name) {
        this.mLogger = Logger.getLogger(name.toString());
        this.mRoot = null;
    }

    public DefaultErrorManager(Object name, Window interfaceRoot) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (interfaceRoot == null) {
            throw new NullPointerException("interfaceRoot");
        }
        this.mRoot = interfaceRoot;
        this.mLogger = Logger.getLogger(name.toString());
    }

    protected void postNotification(final Object level, final String msg, final Throwable t) {
        if (this.mRoot == null) {
            this.postToLog(level, msg, t);
        } else if (SwingUtilities.isEventDispatchThread()) {
            this.postToLog(level, msg, t);
            int severity = ((SeverityMapping)level).getNotificationType();
            if (severity != Integer.MIN_VALUE) {
                JOptionPane.showMessageDialog(this.mRoot, msg, "", severity);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DefaultErrorManager.this.postNotification(level, msg, t);
                }
            });
        }
    }

    protected void logNotification(Object level, String msg, Throwable t) {
        this.postToLog(level, msg, t);
    }

    protected void postToLog(Object level, String msg, Throwable t) {
        Level logLevel = (Level)((SeverityMapping)level).getLoggingLevel();
        if (t != null) {
            this.mLogger.log(logLevel, msg, t);
        } else {
            this.mLogger.log(logLevel, msg);
        }
    }

    protected Object mapSeverityToNativeLevel(ErrorManager.Severity sev) {
        int messageType;
        Integer swingMapping = null;
        Level loggerMapping = null;
        if (sev != null) {
            swingMapping = cJOptionDialogSeverity.get(sev);
            loggerMapping = cLoggerSeverityMap.get(sev);
        }
        int n = messageType = swingMapping != null ? swingMapping : Integer.MIN_VALUE;
        if (loggerMapping == null) {
            loggerMapping = Level.FINE;
        }
        return new SeverityMapping(messageType, loggerMapping);
    }

    static {
        HashMap<ErrorManager.Severity, Integer> map = new HashMap<ErrorManager.Severity, Integer>();
        map.put(ErrorManager.Severity.ERROR, new Integer(0));
        map.put(ErrorManager.Severity.WARN, new Integer(2));
        map.put(ErrorManager.Severity.INFO, new Integer(1));
        cJOptionDialogSeverity = Collections.unmodifiableMap(map);
        HashMap<ErrorManager.Severity, Level> map2 = new HashMap<ErrorManager.Severity, Level>();
        map2.put(ErrorManager.Severity.ERROR, Level.SEVERE);
        map2.put(ErrorManager.Severity.WARN, Level.WARNING);
        map2.put(ErrorManager.Severity.INFO, Level.INFO);
        map2.put(ErrorManager.Severity.DEBUG, Level.FINE);
        cLoggerSeverityMap = Collections.unmodifiableMap(map2);
    }

    private class SeverityMapping {
        private final int mNotificationType;
        private final Object mLoggingLevel;

        public SeverityMapping(int swingMapping, Object logMapping) {
            this.mNotificationType = swingMapping;
            this.mLoggingLevel = logMapping;
        }

        public int getNotificationType() {
            return this.mNotificationType;
        }

        public Object getLoggingLevel() {
            return this.mLoggingLevel;
        }
    }
}

