/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.coco.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class CocoLanguage {
    public static final String SPACE = " ";
    public static final String PLUS = "+";
    public static final String HYPHEN = "-";
    public static final String ASTERISK = "*";
    public static final String SLANT = "/";
    public static final String EQUAL = "=";
    public static final String CURRENCY = "$";
    public static final String COMMA = ",";
    public static final String COMMA_S = ", ";
    public static final String SEMICOLON = ";";
    public static final String SEMICOLON_S = "; ";
    public static final String COLON = ":";
    public static final String PERIOD = ".";
    public static final String PERIOD_S = ". ";
    public static final String QUOTATION = "\"";
    public static final String QUOTATION_S = "\" ";
    public static final String LPARENS = "(";
    public static final String RPARENS = ")";
    public static final String GREATER = ">";
    public static final String LESS = "<";
    public static final String APOSTROPHE = "'";
    public static final String APOSTROPHE_S = "' ";
    public static final String NONNUMERIC_LIT_OPEN = "X\"";
    public static final String NONNUMERIC_LIT_OPEN_APOS = "X'";
    public static final String NONNUMERIC_LIT_DBCSG_OPEN = "G\"";
    public static final String NONNUMERIC_LIT_DBCSG_OPEN_APOS = "G'";
    public static final String NONNUMERIC_LIT_DBCSN_OPEN = "N\"";
    public static final String NONNUMERIC_LIT_DBCSN_OPEN_APOS = "N'";
    public static final String NONNUMERIC_NULL_LIT_OPEN = "Z\"";
    public static final String NONNUMERIC_NULL_LIT_OPEN_APOS = "Z'";
    public static final String PSEUDOTEXT_DELIM = "==";
    public static final String DEBUGGING_INDICATOR = "D";
    public static final String ZERO_FIGCONST = "ZERO";
    public static final String ZEROS_FIGCONST = "ZEROS";
    public static final String ZEROES_FIGCONST = "ZEROES";
    public static final String SPACE_FIGCONST = "SPACE";
    public static final String SPACES_FIGCONST = "SPACES";
    public static final String HIGHVALUE_FIGCONST = "HIGH-VALUE";
    public static final String HIGHVALUES_FIGCONST = "HIGH-VALUES";
    public static final String LOWVALUE_FIGCONST = "LOW-VALUE";
    public static final String LOWVALUES_FIGCONST = "LOW-VALUES";
    public static final String QUOTE_FIGCONST = "QUOTE";
    public static final String QUOTES_FIGCONST = "QUOTES";
    public static final String ALL_FIGCONST = "ALL";
    public static final String NULL_FIGCONST = "NULL";
    public static final String NULLS_FIGCONST = "NULLS";
    public static final int NUMLITERAL_MAX_LENGTH = 30;
    public static final int NONNUMLITERAL_MAX_LENGTH = 160;
    public static final int WORD_MAX_LENGTH = 30;
    public static final int SEPARATOR_MAX_LENGTH = 2;
    public static final int MIN_LEVEL_NUMBER = 1;
    public static final int MAX_LEVEL_NUMBER = 49;
    protected static Set mSpecialCharacterSet = CocoLanguage.buildSpecialCharacterSet();
    protected static Set mSeparators = CocoLanguage.buildSeparatorSet();
    protected static Set mReservedWords = CocoLanguage.buildReservedWordSet();
    protected static Set mFigurativeConstants = CocoLanguage.buildFigurativeConstantSet();
    protected static Set mClauseWords = CocoLanguage.buildClauseWordSet();
    private static final Pattern cNumericLiteralPattern = Pattern.compile("[+-]?(?:(?:\\d+\\.\\d+[Ee][+-]\\d\\d)|(?:(?:\\d+\\.?\\d+)|(?:\\d+)))", 2);
    private static final Pattern cNonumericLiteralStartPattern = Pattern.compile("[GNXZ]?[\"']", 2);

    public static boolean isInCobolCharSet(char ch) {
        boolean isInSet = false;
        isInSet |= Character.isLetterOrDigit(ch);
        return isInSet |= mSpecialCharacterSet.contains(String.valueOf(ch));
    }

    public static boolean isNumericLiteral(String str) {
        return cNumericLiteralPattern.matcher(str).matches();
    }

    public static boolean isNonnumericLiteralStart(String str) {
        return cNonumericLiteralStartPattern.matcher(str).matches();
    }

    public static boolean isSeparator(String str) {
        if (!CocoLanguage.isAllCaps(str)) {
            str = str.toUpperCase();
        }
        return mSeparators.contains(str);
    }

    public static boolean isSeparator(char ch) {
        return mSeparators.contains(String.valueOf(ch = Character.toUpperCase(ch))) || ch == '\u000e' || ch == '\u000f';
    }

    public static boolean isSeparator(char ch1, char ch2) {
        ch1 = Character.toUpperCase(ch1);
        ch2 = Character.toUpperCase(ch2);
        char[] chr = new char[]{ch1, ch2};
        String str = String.valueOf(chr);
        return mSeparators.contains(str);
    }

    public static boolean isSeparator(byte byt) {
        return (byt = (byte)(byt & 0x7F)) == 14 || byt == 15 || mSeparators.contains(String.valueOf(byt));
    }

    public static boolean isReservedWord(String str) {
        if (!CocoLanguage.isAllCaps(str)) {
            str = str.toUpperCase();
        }
        return mReservedWords.contains(str);
    }

    public static boolean isCobolWord(String str) {
        if (!CocoLanguage.isAllCaps(str)) {
            str = str.toUpperCase();
        }
        boolean isWord = false;
        if (str != null) {
            isWord = mReservedWords.contains(str);
            isWord &= str.length() > 0 && str.length() <= 30;
            isWord &= Character.isLetterOrDigit(str.charAt(0));
            if (isWord &= Character.isLetterOrDigit(str.charAt(str.length() - 1))) {
                for (int i = 1; isWord && i < str.length() - 1; isWord &= Character.isLetterOrDigit(str.charAt(i)) || str.charAt(i) == HYPHEN.charAt(0), ++i) {
                }
            }
        }
        return isWord;
    }

    public static boolean isClauseWord(String word) {
        if (!CocoLanguage.isAllCaps(word)) {
            word = word.toUpperCase();
        }
        return mClauseWords.contains(word);
    }

    public static boolean isFigurativeConstant(String str) {
        if (!CocoLanguage.isAllCaps(str)) {
            str = str.toUpperCase();
        }
        return mFigurativeConstants.contains(str);
    }

    public static boolean isCurrencySymbol(String str) {
        return str.equals(CURRENCY);
    }

    protected static Set buildFigurativeConstantSet() {
        HashSet<String> set = new HashSet<String>();
        set.add(ZERO_FIGCONST);
        set.add(ZEROS_FIGCONST);
        set.add(ZEROES_FIGCONST);
        set.add(HIGHVALUE_FIGCONST);
        set.add(HIGHVALUES_FIGCONST);
        set.add(SPACE_FIGCONST);
        set.add(SPACES_FIGCONST);
        set.add(LOWVALUE_FIGCONST);
        set.add(LOWVALUES_FIGCONST);
        set.add(QUOTE_FIGCONST);
        set.add(QUOTES_FIGCONST);
        set.add(ALL_FIGCONST);
        set.add(NULL_FIGCONST);
        set.add(NULLS_FIGCONST);
        return Collections.unmodifiableSet(set);
    }

    protected static Set buildSeparatorSet() {
        HashSet<String> set = new HashSet<String>();
        set.add(SPACE);
        set.add(PERIOD);
        set.add(PERIOD_S);
        set.add(COMMA);
        set.add(COMMA_S);
        set.add(COLON);
        set.add(SEMICOLON);
        set.add(SEMICOLON_S);
        set.add(LPARENS);
        set.add(RPARENS);
        set.add(QUOTATION);
        set.add(QUOTATION_S);
        set.add(APOSTROPHE);
        set.add(APOSTROPHE_S);
        set.add(NONNUMERIC_LIT_OPEN);
        set.add(NONNUMERIC_LIT_OPEN_APOS);
        set.add(NONNUMERIC_LIT_DBCSG_OPEN);
        set.add(NONNUMERIC_LIT_DBCSG_OPEN_APOS);
        set.add(NONNUMERIC_LIT_DBCSN_OPEN);
        set.add(NONNUMERIC_LIT_DBCSN_OPEN_APOS);
        set.add(NONNUMERIC_NULL_LIT_OPEN);
        set.add(NONNUMERIC_NULL_LIT_OPEN_APOS);
        set.add(PSEUDOTEXT_DELIM);
        return Collections.unmodifiableSet(set);
    }

    protected static Set buildSpecialCharacterSet() {
        HashSet<String> set = new HashSet<String>();
        set.add(SPACE);
        set.add(PLUS);
        set.add(HYPHEN);
        set.add(ASTERISK);
        set.add(SLANT);
        set.add(EQUAL);
        set.add(CURRENCY);
        set.add(COMMA);
        set.add(SEMICOLON);
        set.add(COLON);
        set.add(PERIOD);
        set.add(QUOTATION);
        set.add(LPARENS);
        set.add(RPARENS);
        set.add(GREATER);
        set.add(LESS);
        set.add(APOSTROPHE);
        return Collections.unmodifiableSet(set);
    }

    protected static Set buildReservedWordSet() {
        HashSet<String> set = new HashSet<String>();
        set.add("ACCEPT");
        set.add("ACCESS");
        set.add("ADD");
        set.add("ADDRESS");
        set.add("ADVANCING");
        set.add("AFTER");
        set.add(ALL_FIGCONST);
        set.add("ALPHABET");
        set.add("ALPHABETIC");
        set.add("ALPHABETIC-LOWER");
        set.add("ALPHABETIC-UPPER");
        set.add("ALPHANUMERIC");
        set.add("ALPHANUMERIC-EDITED");
        set.add("ALSO");
        set.add("ALTER");
        set.add("ALTERNATE");
        set.add("AND");
        set.add("ANY");
        set.add("APPLY");
        set.add("ARE");
        set.add("AREA");
        set.add("AREAS");
        set.add("ASCENDING");
        set.add("ASSIGN");
        set.add("AT");
        set.add("AUTHOR");
        set.add("AUTOMATIC");
        set.add("BASIS");
        set.add("BEFORE");
        set.add("BEGINNING");
        set.add("BINARY");
        set.add("BLOCK");
        set.add("BOTTOM");
        set.add("BY");
        set.add("CALL");
        set.add("CANCEL");
        set.add("CBL");
        set.add("CD");
        set.add("CF");
        set.add("CH");
        set.add("CHARACTER");
        set.add("CHARACTERS");
        set.add("CLASS");
        set.add("CLASS-ID");
        set.add("CLOCK-UNITS");
        set.add("CLOSE");
        set.add("COBOL");
        set.add("CODE");
        set.add("CODE-SET");
        set.add("COLLATING");
        set.add("COLUMN");
        set.add("COM-REG");
        set.add("COMMA");
        set.add("COMMON");
        set.add("COMMUNICATION");
        set.add("COMP");
        set.add("COMP-1");
        set.add("COMP-2");
        set.add("COMP-3");
        set.add("COMP-4");
        set.add("COMP-5");
        set.add("COMPUTATIONAL");
        set.add("COMPUTATIONAL-1");
        set.add("COMPUTATIONAL-2");
        set.add("COMPUTATIONAL-3");
        set.add("COMPUTATIONAL-4");
        set.add("COMPUTATIONAL-5");
        set.add("COMPUTE");
        set.add("CONFIGURATION");
        set.add("CONTAINS");
        set.add("CONTENT");
        set.add("CONTINUE");
        set.add("CONTROL");
        set.add("CONTROLS");
        set.add("CONVERTING");
        set.add("COPY");
        set.add("CORR");
        set.add("CORRESPONDING");
        set.add("COUNT");
        set.add("CURRENCY");
        set.add("DATA");
        set.add("DATE");
        set.add("DATE-COMPILED");
        set.add("DATE-WRITTEN");
        set.add("DAY");
        set.add("DAY-OF-WEEK");
        set.add("DBCS");
        set.add("DE");
        set.add("DEBUG-CONTENTS");
        set.add("DEBUG-ITEM");
        set.add("DEBUG-LINE");
        set.add("DEBUG-NAME");
        set.add("DEBUG-SUB-1");
        set.add("DEBUG-SUB-2");
        set.add("DEBUG-SUB-3");
        set.add("DEBUGGING");
        set.add("DECIMAL-POINT");
        set.add("DECLARATIVES");
        set.add("DELETE");
        set.add("DELIMITED");
        set.add("DELIMITER");
        set.add("DEPENDING");
        set.add("DESCENDING");
        set.add("DESTINATION");
        set.add("DETAIL");
        set.add("DISPLAY");
        set.add("DISPLAY-1");
        set.add("DIVIDE");
        set.add("DIVISION");
        set.add("DOWN");
        set.add("DUPLICATES");
        set.add("DYNAMIC");
        set.add("EGCS");
        set.add("EGI");
        set.add("EJECT");
        set.add("ELSE");
        set.add("EMI");
        set.add("ENABLE");
        set.add("END");
        set.add("END-ADD");
        set.add("END-CALL");
        set.add("END-COMPUTE");
        set.add("END-DELETE");
        set.add("END-DIVIDE");
        set.add("END-EVALUATE");
        set.add("END-IF");
        set.add("END-INVOKE");
        set.add("END-MULTIPLY");
        set.add("END-OF-PAGE");
        set.add("END-PERFORM");
        set.add("END-READ");
        set.add("END-RECEIVE");
        set.add("END-RETURN");
        set.add("END-REWRITE");
        set.add("END-SEARCH");
        set.add("END-START");
        set.add("END-STRING");
        set.add("END-SUBTRACT");
        set.add("END-UNSTRING");
        set.add("END-WRITE");
        set.add("ENDING");
        set.add("ENTER");
        set.add("ENTRY");
        set.add("ENVIRONMENT");
        set.add("EOP");
        set.add("EQUAL");
        set.add("ERROR");
        set.add("ESI");
        set.add("EVALUATE");
        set.add("EVERY");
        set.add("EXCEPTION");
        set.add("EXIT");
        set.add("EXTEND");
        set.add("EXTERNAL");
        set.add("FALSE");
        set.add("FD");
        set.add("FILE");
        set.add("FILE-CONTROL");
        set.add("FINAL");
        set.add("FIRST");
        set.add("FOOTING");
        set.add("FOR");
        set.add("FORMAT");
        set.add("FROM");
        set.add("FUNCTION");
        set.add("GENERATE");
        set.add("GIVING");
        set.add("GLOBAL");
        set.add("GO");
        set.add("GOBACK");
        set.add("GREATER");
        set.add("GROUP");
        set.add("HEADING");
        set.add(HIGHVALUE_FIGCONST);
        set.add(HIGHVALUES_FIGCONST);
        set.add("I-O");
        set.add("I-O-CONTROL");
        set.add("ID");
        set.add("IDENTIFICATION");
        set.add("IF");
        set.add("IN");
        set.add("INDEX");
        set.add("INDEXED");
        set.add("INDICATE");
        set.add("INHERITS");
        set.add("INITIAL");
        set.add("INITIALIZE");
        set.add("INITIATE");
        set.add("INPUT");
        set.add("INPUT-OUTPUT");
        set.add("INSERT");
        set.add("INSPECT");
        set.add("INSTALLATION");
        set.add("INTO");
        set.add("INVALID");
        set.add("INVOKE");
        set.add("IS");
        set.add("JUST");
        set.add("JUSTIFIED");
        set.add("KANJI");
        set.add("KEY");
        set.add("LABEL");
        set.add("LAST");
        set.add("LEADING");
        set.add("LEFT");
        set.add("LENGTH");
        set.add("LESS");
        set.add("LIMIT");
        set.add("LIMITS");
        set.add("LINAGE");
        set.add("LINAGE-COUNTER");
        set.add("LINE");
        set.add("LINE-COUNTER");
        set.add("LINES");
        set.add("LINKAGE");
        set.add("LOCAL-STORAGE");
        set.add("LOCK");
        set.add(LOWVALUE_FIGCONST);
        set.add(LOWVALUES_FIGCONST);
        set.add("MEMORY");
        set.add("MERGE");
        set.add("MESSAGE");
        set.add("METACLASS");
        set.add("METHOD");
        set.add("METHOD-ID");
        set.add("MODE");
        set.add("MODULES");
        set.add("MORE-LABELS");
        set.add("MOVE");
        set.add("MULTIPLE");
        set.add("NATIVE");
        set.add("NEGATIVE");
        set.add("NEXT");
        set.add("NO");
        set.add("NOT");
        set.add(NULL_FIGCONST);
        set.add(NULLS_FIGCONST);
        set.add("NUMBER");
        set.add("NUMERIC");
        set.add("NUMERIC-EDITED");
        set.add("OBJECT");
        set.add("OBJECT-COMPUTER");
        set.add("OCCURS");
        set.add("OF");
        set.add("OFF");
        set.add("OMITTED");
        set.add("ON");
        set.add("OPEN");
        set.add("OPTIONAL");
        set.add("OR");
        set.add("ORDER");
        set.add("ORGANIZATION");
        set.add("OTHER");
        set.add("OUTPUT");
        set.add("OVERFLOW");
        set.add("OVERRIDE");
        set.add("PACKED-DECIMAL");
        set.add("PADDING");
        set.add("PAGE");
        set.add("PAGE-COUNTER");
        set.add("PASSWORD");
        set.add("PERFORM");
        set.add("PF");
        set.add("PH");
        set.add("PIC");
        set.add("PICTURE");
        set.add("PLUS");
        set.add("POINTER");
        set.add("POSITION");
        set.add("POSITIVE");
        set.add("PREVIOUS");
        set.add("PRINTING");
        set.add("PROCEDURE");
        set.add("PROCEDURE-POINTER");
        set.add("PROCEDURES");
        set.add("PROCEED");
        set.add("PROCESSING");
        set.add("PROGRAM");
        set.add("PROGRAM-ID");
        set.add("PURGE");
        set.add("QUEUE");
        set.add(QUOTE_FIGCONST);
        set.add(QUOTES_FIGCONST);
        set.add("RANDOM");
        set.add("RD");
        set.add("READ");
        set.add("READY");
        set.add("RECEIVE");
        set.add("RECORD");
        set.add("RECORDING");
        set.add("RECORDS");
        set.add("RECURSIVE");
        set.add("REDEFINES");
        set.add("REEL");
        set.add("REFERENCE");
        set.add("REFERENCES");
        set.add("RELATIVE");
        set.add("RELEASE");
        set.add("RELOAD");
        set.add("REMAINDER");
        set.add("REMOVAL");
        set.add("RENAMES");
        set.add("REPLACE");
        set.add("REPLACING");
        set.add("REPORT");
        set.add("REPORTING");
        set.add("REPORTS");
        set.add("REPOSITORY");
        set.add("RERUN");
        set.add("RESERVE");
        set.add("RESET");
        set.add("RETURN");
        set.add("RETURN-CODE");
        set.add("RETURNING");
        set.add("REVERSED");
        set.add("REWIND");
        set.add("REWRITE");
        set.add("RF");
        set.add("RH");
        set.add("RIGHT");
        set.add("ROUNDED");
        set.add("RUN");
        set.add("SAME");
        set.add("SD");
        set.add("SEARCH");
        set.add("SECTION");
        set.add("SECURITY");
        set.add("SEGMENT");
        set.add("SEGMENT-LIMIT");
        set.add("SELECT");
        set.add("SELF");
        set.add("SEND");
        set.add("SENTENCE");
        set.add("SEPARATE");
        set.add("SEQUENCE");
        set.add("SEQUENTIAL");
        set.add("SERVICE");
        set.add("SET");
        set.add("SHIFT-IN");
        set.add("SHIFT-OUT");
        set.add("SIGN");
        set.add("SIZE");
        set.add("SKIP1");
        set.add("SKIP2");
        set.add("SKIP3");
        set.add("SORT");
        set.add("SORT-CONTROL");
        set.add("SORT-CORE-SIZE");
        set.add("SORT-FILE-SIZE");
        set.add("SORT-MERGE");
        set.add("SORT-MESSAGE");
        set.add("SORT-MODE-SIZE");
        set.add("SORT-RETURN");
        set.add("SOURCE");
        set.add("SOURCE-COMPUTER");
        set.add(SPACE_FIGCONST);
        set.add(SPACES_FIGCONST);
        set.add("SPECIAL-NAMES");
        set.add("STANDARD");
        set.add("STANDARD-1");
        set.add("STANDARD-2");
        set.add("START");
        set.add("STATUS");
        set.add("STOP");
        set.add("STRING");
        set.add("SUB-QUEUE-1");
        set.add("SUB-QUEUE-2");
        set.add("SUB-QUEUE-3");
        set.add("SUBTRACT");
        set.add("SUM");
        set.add("SUPER");
        set.add("SUPPRESS");
        set.add("SYMBOLIC");
        set.add("SYNC");
        set.add("SYNCHRONIZED");
        set.add("TABLE");
        set.add("TALLY");
        set.add("TALLYING");
        set.add("TAPE");
        set.add("TERMINAL");
        set.add("TERMINATE");
        set.add("TEST");
        set.add("TEXT");
        set.add("THAN");
        set.add("THEN");
        set.add("THROUGH");
        set.add("THRU");
        set.add("TIME");
        set.add("TIMES");
        set.add("TITLE");
        set.add("TO");
        set.add("TOP");
        set.add("TRACE");
        set.add("TRAILING");
        set.add("TRUE");
        set.add("TYPE");
        set.add("UNIT");
        set.add("UNSTRING");
        set.add("UNTIL");
        set.add("UP");
        set.add("UPON");
        set.add("USAGE");
        set.add("USE");
        set.add("USING");
        set.add("VALUE");
        set.add("VALUES");
        set.add("VARYING");
        set.add("WHEN");
        set.add("WHEN-COMPILED");
        set.add("WITH");
        set.add("WORDS");
        set.add("WORKING-STORAGE");
        set.add("WRITE");
        set.add("WRITE-ONLY");
        set.add(ZERO_FIGCONST);
        set.add(ZEROES_FIGCONST);
        set.add(ZEROS_FIGCONST);
        return Collections.unmodifiableSet(set);
    }

    protected static Set buildClauseWordSet() {
        HashSet<String> set = new HashSet<String>();
        set.add("BLANK");
        set.add("DATE");
        set.add("EXTERNAL");
        set.add("GLOBAL");
        set.add("JUSTIFIED");
        set.add("JUST");
        set.add("OCCURS");
        set.add("PIC");
        set.add("PICTURE");
        set.add("REDEFINES");
        set.add("RENAMES");
        set.add("SIGN");
        set.add("LEADING");
        set.add("TRAILING");
        set.add("SYNC");
        set.add("SYNCHRONIZED");
        set.add("USAGE");
        set.add("BINARY");
        set.add("COMP");
        set.add("COMP-1");
        set.add("COMP-2");
        set.add("COMP-3");
        set.add("COMP-4");
        set.add("COMP-5");
        set.add("COMPUTATIONAL");
        set.add("COMPUTATIONAL-1");
        set.add("COMPUTATIONAL-2");
        set.add("COMPUTATIONAL-3");
        set.add("COMPUTATIONAL-4");
        set.add("COMPUTATIONAL-5");
        set.add("DISPLAY");
        set.add("DISPLAY-1");
        set.add("INDEX");
        set.add("PACKED-DECIMAL");
        set.add("POINTER");
        set.add("PROCEDURE-POINTER");
        set.add("OBJECT");
        set.add("NATIVE");
        set.add("VALUE");
        return set;
    }

    private static boolean isAllCaps(String str) {
        boolean isCaps = true;
        if (str != null) {
            for (int i = 0; isCaps && i < str.length(); ++i) {
                char ch = str.charAt(i);
                if (!Character.isLetterOrDigit(ch)) continue;
                isCaps &= Character.isUpperCase(ch);
            }
        }
        return isCaps;
    }
}

