/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.coco.model;

import com.sun.encoder.coco.model.CocoDescriptionEntry;
import com.sun.encoder.coco.runtime.messages.ErrorManager;
import com.sun.encoder.coco.runtime.messages.Message;
import com.sun.encoder.coco.runtime.messages.MessageCatalog;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CocoDataModel {
    private CocoDescriptionEntry mRootEntry;
    private List<CocoDescriptionEntry> mEntries;
    private boolean mImplied01;
    private long mFillerCount;
    private long mBlankCount;
    private Map<String, Object> mNames;
    private Map<String, Vector> mBaseNames;
    private Map<String, Integer> mHlqs;
    private List mUnresolvedOccurs;
    private final ErrorManager mErrorMgr = ErrorManager.getManager("OpenESB.encoder.CobolCopybook." + this.getClass().getName());

    public CocoDataModel() {
        this.mEntries = Collections.synchronizedList(new ArrayList());
        this.mRootEntry = new CocoDescriptionEntry("FILLER", 1);
        this.mRootEntry.setFQN(this.mRootEntry.getName());
        this.mImplied01 = true;
        this.mFillerCount = 0L;
        this.mBlankCount = 0L;
        this.mNames = new HashMap<String, Object>();
        this.mBaseNames = new HashMap<String, Vector>();
        this.mHlqs = new HashMap<String, Integer>();
        this.mEntries.add(this.mRootEntry);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addEntry(CocoDescriptionEntry entry) throws IllegalArgumentException {
        this.validateName(entry);
        int level = entry.getLevel();
        if (level < 1) return;
        if (level == 66) return;
        if (level == 77) return;
        if (level == 88) {
            return;
        }
        this.mEntries.add(entry);
        if (entry.isRedefinition()) {
            CocoDescriptionEntry redefTarget = entry.getRedefinedTarget();
            if (redefTarget == null) return;
            this.registerBaseName(entry);
            CocoDescriptionEntry parent = redefTarget.getParent();
            String fqn = null;
            fqn = parent != null ? parent.getFQN() + ":" + entry.getName() : entry.getName();
            entry.setFQN(fqn);
            if (!this.mNames.containsKey(fqn)) {
                this.registerFQN(entry);
                return;
            }
            String parentName = "";
            if (parent != null) {
                parentName = parent.getInfo();
            }
            Message msg = MessageCatalog.getMessage("CCCB4228");
            String text = msg.formatText(new Object[]{entry.getInfo() + "(REDEFINE)", parentName});
            this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
            throw new IllegalArgumentException(text);
        }
        if (level == 1) {
            if (this.mImplied01) {
                this.mImplied01 = false;
                this.mEntries.remove(this.mRootEntry);
                this.mRootEntry = entry;
                entry.setFQN(entry.getName());
                this.mNames.put(entry.getFQN(), entry);
                this.registerBaseName(entry);
                return;
            }
            Message msg = MessageCatalog.getMessage("CCCB4104");
            String text = msg.toString();
            this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
            throw new IllegalArgumentException(text);
        }
        this.mImplied01 = false;
        int entryIx = this.mEntries.size() - 1;
        do {
            CocoDescriptionEntry last;
            int lastLevel;
            if ((lastLevel = (last = this.mEntries.get(entryIx)).getLevel()) >= level) continue;
            last.addChild(entry);
            String pic = last.getPicture();
            if (pic != null && pic.trim().length() != 0) {
                Message msg = MessageCatalog.getMessage("CCCB4229");
                String text = msg.formatText(new Object[]{entry.getInfo(), last.getInfo()});
                this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
                throw new IllegalArgumentException(text);
            }
            String fqn = this.obtainFQN(entry);
            entry.setFQN(fqn);
            if (!this.mNames.containsKey(fqn)) {
                this.registerFQN(entry);
                this.registerBaseName(entry);
                return;
            }
            String parentName = "";
            CocoDescriptionEntry parent = entry.getParent();
            if (parent != null) {
                parentName = parent.getInfo();
            }
            Message msg = MessageCatalog.getMessage("CCCB4228");
            String text = msg.formatText(new Object[]{entry.getInfo(), parentName});
            this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
            throw new IllegalArgumentException(text);
        } while (--entryIx >= 0);
    }

    private String obtainFQN(CocoDescriptionEntry entry_added) {
        StringBuffer fqn = new StringBuffer(entry_added.getName());
        CocoDescriptionEntry parent = entry_added.getParent();
        if (parent != null) {
            fqn.insert(0, ":").insert(0, parent.getFQN());
        }
        return fqn.toString();
    }

    public void validate() {
        if (this.mEntries != null) {
            int cnt = this.mEntries.size();
            CocoDescriptionEntry entry = null;
            for (int i = 0; i < cnt; ++i) {
                String patternStr;
                Pattern pattern;
                Matcher match;
                entry = this.mEntries.get(i);
                if (entry.countChildren() != 0 || entry.isRedefinition()) continue;
                String pic = entry.getPicture();
                int usage = this.getRealUsage(entry);
                if (usage != 21 && usage != 22 && (pic == null || pic.trim().length() == 0)) {
                    Message msg = MessageCatalog.getMessage("CCCB4230");
                    String text = msg.formatText(new Object[]{entry.getInfo()});
                    this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
                    throw new IllegalArgumentException(text);
                }
                if (usage != 2 && usage != 1 && usage != 4 && usage != 23 && usage != 25 || (match = (pattern = Pattern.compile(patternStr = "^[sS]*9*[\\([0-9]+\\)]*[vV]*9*[\\([0-9]+\\)]*[pP]*$")).matcher(pic)).matches()) continue;
                Message msg = MessageCatalog.getMessage("CCCB4231");
                String text = msg.formatText(new Object[]{entry.getInfo(), pic, entry.getUsageName(usage)});
                this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
                throw new IllegalArgumentException(text);
            }
        }
    }

    private int getRealUsage(CocoDescriptionEntry entry) {
        CocoDescriptionEntry e;
        int usage = entry.getUsage();
        for (e = entry; e != null && !e.usageExplicit(); e = e.getParent()) {
        }
        if (e != null) {
            usage = e.getUsage();
        }
        return usage;
    }

    private void validateName(CocoDescriptionEntry entry) throws IllegalArgumentException {
        int at;
        String name = entry.getName();
        if (name == null || "".equals(name.trim())) {
            name = "BLANK";
        }
        if ((name = name.toUpperCase()).startsWith("FILLER") && !name.equalsIgnoreCase("FILLER")) {
            at = 5;
            while (++at < name.length() && Character.isDigit(name.charAt(at))) {
            }
            if (name.length() == at) {
                Message msg = MessageCatalog.getMessage("CCCB4105");
                String text = msg.formatText(new Object[]{name});
                this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
                throw new IllegalArgumentException(text);
            }
        }
        if (name.startsWith("BLANK") && !name.equalsIgnoreCase("BLANK")) {
            at = 4;
            while (++at < name.length() && Character.isDigit(name.charAt(at))) {
            }
            if (name.length() == at) {
                Message msg = MessageCatalog.getMessage("CCCB4106");
                String text = msg.formatText(new Object[]{name});
                this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
                throw new IllegalArgumentException(text);
            }
        }
        if (name.equalsIgnoreCase("FILLER")) {
            entry.setName("FILLER" + ++this.mFillerCount);
            entry.setNameFiller(true);
        } else if (name.equalsIgnoreCase("BLANK")) {
            entry.setName("BLANK" + ++this.mBlankCount);
            entry.setNameBlank(true);
        } else {
            name = this.normalizeHlq(name);
            entry.setName(name);
        }
    }

    private String normalizeHlq(String name) {
        StringBuffer buffer = new StringBuffer(name.length());
        int hlqStart = name.indexOf(58);
        int start = 0;
        while (hlqStart != -1) {
            String hlqName;
            int hlqEnd = name.indexOf(58, hlqStart + 1);
            if (hlqStart + 1 >= hlqEnd) {
                Message msg = MessageCatalog.getMessage("CCCB4107");
                String text = msg.formatText(new Object[]{name});
                this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
                throw new IllegalArgumentException(text);
            }
            if (!this.mHlqs.containsKey(hlqName = name.substring(hlqStart, ++hlqEnd).toUpperCase())) {
                this.mHlqs.put(hlqName, new Integer(this.mHlqs.size() + 1));
            }
            int hlqNum = this.mHlqs.get(hlqName);
            buffer.append(name.substring(start, hlqStart) + "HLQ" + hlqNum);
            start = hlqEnd;
            hlqStart = name.indexOf(58, start);
        }
        buffer.append(name.substring(start));
        return buffer.toString();
    }

    public CocoDescriptionEntry getRoot() {
        return this.mRootEntry;
    }

    public CocoDescriptionEntry getEntry(String name, String[] qualifiers) {
        if (name == null) {
            return null;
        }
        if (this.mRootEntry.getName().equalsIgnoreCase(name) || name.equalsIgnoreCase(this.mRootEntry.getName())) {
            return this.mRootEntry;
        }
        name = this.normalizeHlq(name);
        CocoDescriptionEntry match = null;
        ListIterator<CocoDescriptionEntry> it = this.mEntries.listIterator();
        if (name != null) {
            while (match == null && it.hasNext()) {
                CocoDescriptionEntry entry = it.next();
                if (!name.equalsIgnoreCase(entry.getName())) continue;
                match = entry;
            }
        }
        return match;
    }

    public CocoDescriptionEntry findRedefineTarget(CocoDescriptionEntry redefiner, String name) {
        CocoDescriptionEntry target = null;
        String realName = name.toUpperCase();
        int ix = this.mEntries.size() - 1;
        if (realName != null) {
            int level;
            CocoDescriptionEntry last;
            int lastLevel;
            while (ix >= 0 && (lastLevel = (last = this.mEntries.get(ix--)).getLevel()) >= (level = redefiner.getLevel())) {
                if (lastLevel != level || !last.getName().equalsIgnoreCase(realName)) continue;
                target = last;
                break;
            }
        }
        return target;
    }

    public void toStream(PrintStream outStream) {
        ListIterator<CocoDescriptionEntry> it = this.mEntries.listIterator();
        while (it.hasNext()) {
            CocoDescriptionEntry entry = it.next();
            if (entry.isComment()) {
                outStream.print("**COMMENT**");
            } else {
                CocoDescriptionEntry occursEntry;
                String picture;
                if (entry.isContinuation()) {
                    outStream.print("- ");
                } else {
                    outStream.print("  ");
                }
                outStream.print(entry.getIndicatorValue() + " ");
                outStream.print(entry.getLevel() + " ");
                outStream.print(entry.getName() + " ");
                outStream.print("USAGE " + entry.getUsage() + " ");
                if (entry.isBlankWhenZero()) {
                    outStream.print("BLANK ");
                }
                if (entry.isJustified()) {
                    outStream.print("JUST ");
                }
                if (!(picture = entry.getPicture()).equals("")) {
                    outStream.print("PIC " + picture + " ");
                }
                if (entry.isRedefinition()) {
                    outStream.print("REDEFINES " + entry.getRedefinedTarget().getName() + " ");
                }
                if (entry.getMinimumOccurs() > 1 && entry.getMaximumOccurs() > 1) {
                    outStream.print("OCCURS " + entry.getMinimumOccurs() + " ");
                    if (entry.getMaximumOccurs() > entry.getMinimumOccurs()) {
                        outStream.print("TO " + entry.getMaximumOccurs() + " ");
                    }
                }
                if ((occursEntry = entry.getOccursOn()) != null) {
                    outStream.print("DEPENDS ON " + occursEntry.getName() + " ");
                    List qualifiers = occursEntry.getDependOnNameQualifiers();
                    if (qualifiers != null && qualifiers.size() > 0) {
                        for (int i = 0; i < qualifiers.size(); ++i) {
                            outStream.print(" OF " + qualifiers.get(i));
                        }
                    }
                }
            }
            outStream.println();
        }
        outStream.flush();
    }

    public void makeBaseNamesUnique() {
        Vector l = null;
        int suffix_count = 0;
        CocoDescriptionEntry entry = null;
        Iterator<String> it = this.mBaseNames.keySet().iterator();
        if (it == null) {
            return;
        }
        while (it.hasNext()) {
            String key = it.next();
            l = this.mBaseNames.get(key);
            if (l == null) {
                Message msg = MessageCatalog.getMessage("CCCB4227");
                String text = msg.formatText(new Object[]{"Resolving name conflicts after copy book parsing and before OTD generation.", "CocoDataModel.makeBaseNamesUnique()", "No entry found for registered base name : " + key});
                this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
                throw new IllegalArgumentException(text);
            }
            if (l.size() <= 1) continue;
            for (int i = 1; i < l.size(); ++i) {
                entry = (CocoDescriptionEntry)l.get(i);
                entry.setName(entry.getName() + "_" + suffix_count++);
            }
        }
    }

    public void resolveOccurs() {
        if (this.mUnresolvedOccurs != null && this.mUnresolvedOccurs.size() > 0) {
            int cnt = this.mUnresolvedOccurs.size();
            CocoDescriptionEntry entry = null;
            String baseName = null;
            List qualifiers = null;
            for (int i = 0; i < cnt; ++i) {
                Message msg;
                entry = (CocoDescriptionEntry)this.mUnresolvedOccurs.get(i);
                qualifiers = entry.getDependOnNameQualifiers();
                baseName = entry.getDependOnName();
                if (baseName != null) {
                    baseName = baseName.toUpperCase();
                }
                String fqName = this.getQualifiedName(qualifiers, baseName);
                List depends = this.lookupEntry(qualifiers, baseName, 2);
                if (depends == null || depends.size() == 0) {
                    msg = MessageCatalog.getMessage("CCCB4226");
                    String text = msg.formatText(new Object[]{baseName, fqName});
                    this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
                    throw new IllegalArgumentException(text);
                }
                if (depends.size() >= 2) {
                    msg = MessageCatalog.getMessage("CCCB4225");
                    String text = msg.formatText(new Object[]{baseName, fqName, ((CocoDescriptionEntry)depends.get(0)).getInfo(), ((CocoDescriptionEntry)depends.get(1)).getInfo()});
                    this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
                    throw new IllegalArgumentException(text);
                }
                CocoDescriptionEntry dependsObj = (CocoDescriptionEntry)depends.get(0);
                if (dependsObj.getMinimumOccurs() != 1 && dependsObj.getMaximumOccurs() != 1) {
                    Message msg2 = MessageCatalog.getMessage("CCCB4211");
                    String text = msg2.formatText(new Object[]{dependsObj.getName()});
                    this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
                    throw new IllegalArgumentException(text);
                }
                if (dependsObj.getJavaType() == 1 || dependsObj.getJavaType() == 3) {
                    Message msg3 = MessageCatalog.getMessage("CCCB4212");
                    String text = msg3.formatText(new Object[]{dependsObj.getName()});
                    this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
                    throw new IllegalArgumentException(text);
                }
                if (dependsObj.getJavaType() != 0) {
                    Message msg4 = MessageCatalog.getMessage("CCCB4213");
                    String text = msg4.formatText(new Object[]{dependsObj.getName()});
                    this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
                    throw new IllegalArgumentException(text);
                }
                entry.setDependsOnTarget(dependsObj);
            }
        }
    }

    private String getQualifiedName(List qualifiers, String base) {
        StringBuffer sb = new StringBuffer(base);
        if (qualifiers != null && qualifiers.size() > 0) {
            for (int i = 0; i < qualifiers.size(); ++i) {
                sb.append(" OF ").append(qualifiers.get(i));
            }
        }
        return sb.toString();
    }

    private List lookupEntry(List qualifiers, String name, int count) {
        ArrayList result = null;
        String currentName = null;
        Iterator<String> it = this.mNames.keySet().iterator();
        CocoDescriptionEntry entry = null;
        Vector entry_list = null;
        int cnt = 0;
        boolean matched = true;
        while (it.hasNext()) {
            currentName = it.next();
            if (!currentName.endsWith(name)) continue;
            matched = true;
            entry_list = (Vector)this.mNames.get(currentName);
            entry = (CocoDescriptionEntry)entry_list.get(0);
            if (!name.equalsIgnoreCase(entry.getName())) continue;
            if (qualifiers != null && qualifiers.size() > 0) {
                CocoDescriptionEntry tempEntry = entry;
                for (int j = 0; j < qualifiers.size(); ++j) {
                    CocoDescriptionEntry parent = tempEntry.getParent();
                    if (parent == null) {
                        matched = false;
                        break;
                    }
                    String qualifierName = (String)qualifiers.get(j);
                    if (qualifierName == null || !parent.getName().equalsIgnoreCase(qualifierName.toUpperCase())) {
                        matched = false;
                        break;
                    }
                    tempEntry = parent;
                }
            }
            if (!matched) continue;
            if (result == null) {
                result = new ArrayList();
            }
            result.addAll(entry_list);
            if ((cnt += entry_list.size()) < count) continue;
            break;
        }
        return result;
    }

    public void addOccurs(CocoDescriptionEntry entry) {
        if (this.mUnresolvedOccurs == null) {
            this.mUnresolvedOccurs = new ArrayList();
        }
        this.mUnresolvedOccurs.add(entry);
    }

    private void registerBaseName(CocoDescriptionEntry entry) {
        Vector l = null;
        if (this.mBaseNames.containsKey(entry.getName())) {
            l = this.mBaseNames.get(entry.getName());
            if (l == null) {
                Message msg = MessageCatalog.getMessage("CCCB4227");
                String text = msg.formatText(new Object[]{"Registering base name.", "CocoDataModel.registerBaseName()", "No entry found for registered base name : " + entry.getName()});
                this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
                throw new IllegalArgumentException(text);
            }
            int sz = l.size();
            l.add(sz, entry);
        } else {
            l = new Vector(1);
            l.add(0, entry);
            this.mBaseNames.put(entry.getName(), l);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void registerFQN(CocoDescriptionEntry entry) {
        if (!this.mNames.containsKey(entry.getFQN())) {
            Vector<CocoDescriptionEntry> l = new Vector<CocoDescriptionEntry>(1);
            l.add(0, entry);
            this.mNames.put(entry.getFQN(), l);
            return;
        }
        Vector l = (Vector)this.mNames.get(entry.getFQN());
        if (l != null) {
            int sz = l.size();
            l.add(sz, entry);
            return;
        }
        Message msg = MessageCatalog.getMessage("CCCB4227");
        String text = msg.formatText(new Object[]{"Registering FQN - fully qualified name.", "CocoDataModel.registerFQN()", "No entry found for registered FQN : " + entry.getFQN()});
        this.mErrorMgr.log(ErrorManager.Severity.ERROR, null, text);
        throw new IllegalArgumentException(text);
    }
}

