/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.IO;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Random;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.net.Socket;
import java.util.Hashtable;

class ChannelX11
extends Channel {
    private static final int LOCAL_WINDOW_SIZE_MAX = 131072;
    private static final int LOCAL_MAXIMUM_PACKET_SIZE = 16384;
    static String host = "127.0.0.1";
    static int port = 6000;
    boolean init = true;
    static byte[] cookie = null;
    static byte[] cookie_hex = null;
    private static Hashtable faked_cookie_pool = new Hashtable();
    private static Hashtable faked_cookie_hex_pool = new Hashtable();
    static byte[] table = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    Socket socket = null;

    static int revtable(byte by) {
        for (int i = 0; i < table.length; ++i) {
            if (table[i] != by) continue;
            return i;
        }
        return 0;
    }

    static void setCookie(String string) {
        cookie_hex = string.getBytes();
        cookie = new byte[16];
        for (int i = 0; i < 16; ++i) {
            ChannelX11.cookie[i] = (byte)(ChannelX11.revtable(cookie_hex[i * 2]) << 4 & 0xF0 | ChannelX11.revtable(cookie_hex[i * 2 + 1]) & 0xF);
        }
    }

    static void setHost(String string) {
        host = string;
    }

    static void setPort(int n) {
        port = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] getFakedCookie(Session session) {
        Hashtable hashtable = faked_cookie_hex_pool;
        synchronized (hashtable) {
            Object object = (byte[])faked_cookie_hex_pool.get(session);
            if (object == null) {
                Random random = Session.random;
                object = new byte[16];
                Object object2 = random;
                synchronized (object2) {
                    random.fill((byte[])object, 0, 16);
                }
                faked_cookie_pool.put(session, object);
                object2 = new byte[32];
                for (int i = 0; i < 16; ++i) {
                    object2[2 * i] = table[object[i] >>> 4 & 0xF];
                    object2[2 * i + 1] = table[object[i] & 0xF];
                }
                faked_cookie_hex_pool.put(session, object2);
                object = object2;
            }
            return object;
        }
    }

    ChannelX11() {
        this.setLocalWindowSizeMax(131072);
        this.setLocalWindowSize(131072);
        this.setLocalPacketSize(16384);
        this.type = "x11".getBytes();
        try {
            this.socket = new Socket(host, port);
            this.socket.setTcpNoDelay(true);
            this.io = new IO();
            this.io.setInputStream(this.socket.getInputStream());
            this.io.setOutputStream(this.socket.getOutputStream());
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void run() {
        this.thread = Thread.currentThread();
        Buffer buffer = new Buffer(this.rmpsize);
        Packet packet = new Packet(buffer);
        int n = 0;
        try {
            while (this.thread != null) {
                n = this.io.in.read(buffer.buffer, 14, buffer.buffer.length - 14 - 32 - 20);
                if (n <= 0) {
                    this.eof();
                } else if (!this.close) {
                    packet.reset();
                    buffer.putByte((byte)94);
                    buffer.putInt(this.recipient);
                    buffer.putInt(n);
                    buffer.skip(n);
                    this.session.write(packet, this, n);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.init) {
            int n3 = (byArray[n + 6] & 0xFF) * 256 + (byArray[n + 7] & 0xFF);
            int n4 = (byArray[n + 8] & 0xFF) * 256 + (byArray[n + 9] & 0xFF);
            if ((byArray[n] & 0xFF) != 66 && (byArray[n] & 0xFF) == 108) {
                n3 = n3 >>> 8 & 0xFF | n3 << 8 & 0xFF00;
                n4 = n4 >>> 8 & 0xFF | n4 << 8 & 0xFF00;
            }
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, n + 12 + n3 + (-n3 & 3), byArray2, 0, n4);
            byte[] byArray3 = null;
            Hashtable hashtable = faked_cookie_pool;
            synchronized (hashtable) {
                byArray3 = (byte[])faked_cookie_pool.get(this.session);
            }
            if (ChannelX11.equals(byArray2, byArray3)) {
                if (cookie != null) {
                    System.arraycopy(cookie, 0, byArray, n + 12 + n3 + (-n3 & 3), n4);
                }
            } else {
                System.out.println("wrong cookie");
            }
            this.init = false;
        }
        this.io.put(byArray, n, n2);
    }

    private static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }
}

