/* 
 *   Creation Date: <1999/03/18 03:19:43 samuel>
 *   Time-stamp: <2001/06/18 19:57:56 samuel>
 *   
 *	<os_interface.h>
 *	
 *	This file includes definitions for drivers
 *	running in the "emulated" OS. (Mainly the 'sc'
 *	mechanism of communicating)
 *   
 *   Copyright (C) 1999, 2000, 2001 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#ifndef _H_OS_INTERFACE
#define _H_OS_INTERFACE

/* Magic register values loaded into r3 and r4 before the 'sc' assembly instruction */
#define OSI_SC_MAGIC_R3		0x113724FA
#define OSI_SC_MAGIC_R4		0x77810F9B

#ifndef __KERNEL__

/* By default, we are compiling under Linux */
#ifndef DRIVER_COMPILE
#ifdef macintosh
#define DRIVER_COMPILE	1
#else
#define DRIVER_COMPILE	0
#endif
#endif

#ifndef __ASSEMBLY__
#if !DRIVER_COMPILE
extern void os_interface_init( void );
extern void os_interface_cleanup( void );
#endif
#endif

/* #if DRIVER_COMPILE */

	/* The following macro might be useful */
	#define OSI_CALL( selector ) 		   \
		li	r3,0x24FA		;  \
		addis	r3,r3,0x1137		;  \
		li	r4,0x0F9B		;  \
		addis	r4,r4,0x7781		;  \
		li	r5,selector	    	;  \
		sc ;

/* #endif */

/* selectors, passed in r5 */
#define OSI_ENABLED			0	/* returns 0 if services should be disabled */
#define OSI_DEBUGGER 			1	/* enter debugger */
#define OSI_LOG_NUM			2	/* print the number in r6 */
#define OSI_LOG_STR			3	/* print string in r6 */
#define OSI_LOG_HEX			4	/* print the number in r6 in hexadecimal */

#define OSI_SCSI_ACTION	 		5 	/* MacOS ScsiSIM action (r6= r7=pb*) */
#define OSI_SCSI_CONTINUE_ACTION 	6
#define OSI_SCSI_POLL			7
#define OSI_SCSI_SERVICE		8

#define OSI_GET_DATE			9	/* return time in secs from 01/01/04 */

#define OSI_ENET_OPEN			10
#define OSI_ENET_CLOSE			11
#define OSI_ENET_GET_ADDR		12
#define OSI_ENET_GET_STATUS		13
#define OSI_ENET_CONTROL		14
#define OSI_ENET_ADD_MULTI		16
#define OSI_ENET_DEL_MULTI		17
#define OSI_ENET_GET_PACKET		18
#define OSI_ENET_SEND_PACKET		19

#define OSI_OF_INTERFACE		20
#define OSI_OF_TRAP			21
#define OSI_OF_RTAS			22

#define OSI_BLK_READ			23
#define OSI_BLK_WRITE			24
#define OSI_BLK_DRIVE_INFO	       	25

#define OSI_GET_MOUSE			26	/* void -- r3-r5 mouse data */
#define OSI_HAS_HW_CURSOR		27	/* -- int */

#define OSI_SET_VMODE			28	/* modeID, depth -- error */
#define OSI_GET_VMODE_INFO		29	/* int prevID -- r3 status, r4-r7 pb */
#define OSI_GET_MOUSE_DPI		30	/* -- mouse_dpi */

#define OSI_SET_VIDEO_POWER		31

#define OSI_SND_SOUND			32	/* reserved for MOLAudio */

#define OSI_SOUND_WRITE			33
#define OSI_SOUND_CNTL			34
#define OSI_SET_SOUND_VOLUME		35
#define OSI_SOUND_FLUSH			36
#define OSI_GETSET_SOUND_SYNCVAL	37

#define OSI_BLK_IRQ_ACK			38
#define OSI_BLK_TASK			39

#define OSI_SOUND_IRQ_ACK		40
#define OSI_SOUND_START_STOP		41

#define OSI_REGISTER_IRQ		42	/* reg_property[0] appl_int -- irq_cookie */
#define OSI_POLL_IRQ			43	/* irq_cookie -- irq_status */
#define OSI_ACK_IRQ			44	/* irq_cookie */
#define OSI_DEREGISTER_IRQ		45	/* irq_cookie */
#define OSI_ENABLE_IRQ			46	/* irq_cookie enable_flag -- old_flag */

// 47-53 currently only used by MacOS X/Darwin
#define OSI_LOG_PUTC			47	/* char -- */
#define OSI_X_BLK_READ			48	/* char -- */
#define OSI_X_BLK_WRITE			49	/* char -- */
#define OSI_X_BLK_SIZE			50	/* char -- */
#define OSI_GET_ADB_KEY			51	/* -- adb_keycode */

#define OSI_WRITE_NVRAM_BYTE		52	/* offs, byte -- */
#define OSI_READ_NVRAM_BYTE		53	/* offs -- byte */

#define OSI_EXIT			54

#define NUM_OSI_SELECTORS		55	/* remember to increase this... */



#ifndef __ASSEMBLY__
/************************************************************************/
/*	argument definitions						*/
/************************************************************************/

/* OSI_GET_NEXT_VMODE, returned in r4-r9 */
typedef struct {
	short	num_vmodes;
	short	cur_vmode;		/* 1,2,... */
	short	num_depths;
	short	cur_depth_mode;		/* 0,1,2,... */
	short	w,h;
	int	refresh;		/* Hz/65536 */

	int	depth;
	short	row_bytes;
	short	offset;
} osi_get_next_vmode_t;

/************************************************************************/
/*	Linux interface							*/
/************************************************************************/

#if !DRIVER_COMPILE && !defined(ASM)
typedef int (*osi_proc)( int selector, int *params );

extern int	os_interface_add_proc( int selector, osi_proc proc );
extern int	os_interface_remove_proc( int sel );

#endif /* !DRIVER_COMPILE */
#endif /* __ASSEMBLY__ */
#endif /* __KERNEL__ */


#endif   /* _H_OS_INTERFACE */
