/* 
 *   Creation Date: <2001/06/11 22:41:04 samuel>
 *   Time-stamp: <2001/06/23 22:56:43 samuel>
 *   
 *	<selftest.c>
 *	
 *	This piece of code is run inside MOL. That is, it is
 *	not linked against glibc.
 *   
 *   Copyright (C) 2001 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#include "mol_config.h"
#include <stdarg.h>
#include "os_interface.h"

extern int osi_call( int sel, int arg1, int arg2, int arg3, int arg4 );
#define osi_call1( sel, v1 ) { osi_call(sel,v1,0,0,0); }

extern int entry( void );
extern void performance( void );

int
entry( void )
{
	printf("\n");
	printf(" ******************************\n");
	printf(" *    Testing performance     *\n");
	printf(" ******************************\n");
	printf("\n");

	performance();

	printf("\n");
	printf(" ******************************\n");
	printf(" *    Self-test successful    *\n");
	printf(" ******************************\n");
	printf("\n");

	return 0;
}

extern void perf_print( char *str, ulong count );

void
perf_print( char *str, ulong count )
{
	static int calibration=0;
	ulong v;
	
	if( !calibration )
		calibration=count;

	v = (ulong)((double)calibration / (double)count * 20000.0 + 0.5);
	printf(" %-19s %3ld.%02ld %%\n", str, v/100, v%100 );
}
