#ifndef __LYXIM_H__
#define __LYXIM_H__
#ifdef I18N
#include FORMS_H_LOCATION
#include "lyxfont.h"
#include "BufferView.h"
extern BufferView *current_view;

class LyXIM
{
  public:
    
    void IMCreate(Window window);
//    void SetRegister();
    void SetIMSpot();
    void SetIMSpotAndArea();
    XIC  GetIC();
    void Close()const;
    

    void focusIn();
    void focusOut();
  private:
    void Restart();
    void SpotandFont();
    void SetStatusArea();
    void SetPreeditArea();
//    void IMDestroy(XIM xim, XPointer client_data, XPointer call_data);
    
    XIM xim;
    XIC xic;
    XRectangle              input_rect;
    XRectangle              status_rect;
    XPoint                  preeditspot;
    
    LyXFont current_font;
    XFontSet current_fontset;
    XIMStyle        input_style;
    
};

inline XIC LyXIM::GetIC()
{
    if (xic)
        return xic;
    else
        return NULL;
}

inline void LyXIM::Close() const
{
    if (xic) {
		XDestroyIC(xic);
		XCloseIM(xim);
    }
}

inline void LyXIM::focusIn()
{
    if (current_view->available() && xic)
        XSetICFocus(xic);
}

inline void LyXIM::focusOut()
{
    if (current_view->available() && xic)
        XUnsetICFocus(xic);
}

#endif
#endif
