// -*- C++ -*-
/* This file is part of
 * ======================================================
 * 
 *           LyX, The Document Processor
 * 	 
 *           Copyright 1997 Asger Alstrup
 * 	     and the LyX Team.
 *
 * ====================================================== */

#ifndef FONTLOADER_H_
#define FONTLOADER_H_ 

#ifdef __GNUG__
#pragma interface
#endif


#include FORMS_H_LOCATION
#include "lyxfont.h"
#include "LString.h"

#ifdef I18N
class lyxstring;
#endif

class FontInfo;

/** This class takes care of loading fonts. It uses FontInfo to make 
intelligent guesses about matching font size, and it tries different tags 
itself in order to match the font loading demands.  Later, I plan to extend 
this with support for T1Lib, probably via a new class building on this. 
(Asger) */
class FontLoader {
public:
	///
	FontLoader();

	///
	~FontLoader();

	/// Update fonts after zoom, dpi, font names, or norm change
	void update();

	/// Load font
#ifdef I18N
    /// Load fontset
	XFontSet load(LyXFont::FONT_FAMILY family,
			  LyXFont::FONT_SERIES series,
			  LyXFont::FONT_SHAPE shape,
			  LyXFont::FONT_SIZE size)
	{
		if (fontset[family][series][shape][size]!=0)
			return fontset[family][series][shape][size];
		else
                    return doLoad(family,series,shape,size);
	};
        XFontStruct* loadMath(LyXFont::FONT_FAMILY family,
                                LyXFont::FONT_SERIES series,
			  LyXFont::FONT_SHAPE shape,
			  LyXFont::FONT_SIZE size)
        {
		if (math[family][series][shape][size]!=0)
			return math[family][series][shape][size];
		else
			return doLoadMath(family,series,shape,size);
	};
#else	
	XFontStruct * load(LyXFont::FONT_FAMILY family, 
			   LyXFont::FONT_SERIES series, 
			   LyXFont::FONT_SHAPE shape, 
			   LyXFont::FONT_SIZE size) {
		if (fontstruct[family][series][shape][size] != 0)
			return fontstruct[family][series][shape][size];
		else
			return doLoad(family, series, shape, size);
	};
#endif

private:
	/// Array of font structs
#ifdef I18N
        XFontSet fontset[4][2][4][10];
        XFontStruct* math[4][2][4][10];
        FontInfo * fontinfo[3][4][2][4];
        void getFontinfo(int fonttype,
                         LyXFont::FONT_FAMILY family,
			 LyXFont::FONT_SERIES series,
			 LyXFont::FONT_SHAPE shape);
#else	
	XFontStruct * fontstruct[4][2][4][10];

	/// Array of font infos
	FontInfo * fontinfo[4][2][4];
#endif
	/// Reset font handler
	void reset();

	/// Unload all fonts
	void unload();
 #ifndef I18N
	/// Get font info
	void getFontinfo(LyXFont::FONT_FAMILY family,
			 LyXFont::FONT_SERIES series,
			 LyXFont::FONT_SHAPE shape);
#endif

	/** Does the actual loading of a font. Updates fontstruct. */
#ifdef I18N
       XFontSet doLoad(LyXFont::FONT_FAMILY family,
                       LyXFont::FONT_SERIES series,
                       LyXFont::FONT_SHAPE shape,
                       LyXFont::FONT_SIZE size);
       XFontStruct*  doLoadMath(LyXFont::FONT_FAMILY family,
                                   LyXFont::FONT_SERIES series,
                                   LyXFont::FONT_SHAPE shape,
                                   LyXFont::FONT_SIZE size);
#else	
	XFontStruct * doLoad(LyXFont::FONT_FAMILY family, 
			     LyXFont::FONT_SERIES series, 
			     LyXFont::FONT_SHAPE shape, 
			     LyXFont::FONT_SIZE size);
#endif
};

///
extern FontLoader fontloader;

#endif
