/* mixer.c
 *
 * Copyright (c) 1999 Scott Manley, Barath Raghavan, Jack Moffitt, and Alexander Havng
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License  
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

/* Minor changes by Eugene Crosser 28th July 1999 */


/* Mixer system..... */

#include "mixer.h"
#include "liveice.h"
#include "playlist.h"
#include "audio_proc.h"
#include "controls.h"


#ifdef SOUNDCARD_SUPORT
#ifdef HAVE_SYS_SOUNDCARD_H
#include <sys/soundcard.h>
#else
#include <machine/soundcard.h>
#endif
#endif
#include <time.h>


short audio_buffer[BUF_SIZE];  
int   process_buffer[BUF_SIZE];

/* working space for the compressor... */
int   filt_prebuf[BUF_SIZE];

int  re_read_signal=0;

void siguser_handler(int signo){
	write_message("caught siguser1 - re-reading playlist",0);
	re_read_signal=1;
}



void reset_track_pointers(void){
	int i;
	for(i=0;i<MAX_CHANNELS;i++)
		if(mixer.c_list[i])
			mixer.c_list[i]->curnt=mixer.t_list->prev;
}


/* add a channel to the channel list */

int add_channel(cptr *new,char name[]){
	char mesg[256];
	if(*new==NULL){
		sprintf(mesg,"Adding New Channel %s",name);
		write_message(mesg,0);
		*new=malloc(sizeof(channel));
		strncpy((*new)->name,name,63);
		(*new)->curnt=mixer.t_list;
		(*new)->volume=1.0;
		(*new)->speed=1.0;
		(*new)->rate=0;
		(*new)->channels=0;
		(*new)->on=0;
		(*new)->stayon=0;
		(*new)->bad=0;
		
		(*new)->title=strdup("None");
		(*new)->artist=strdup("None");
		(*new)->album=strdup("None");
		(*new)->url=strdup("None");
		mixer.c_number++;
		return 0;
	} else {
		write_message("Channel already allocated",0);
		return -1;
	}
}

/* Remove a channel from teh channel list */
int del_channel(cptr *old){
	char mesg[256];
	sprintf(mesg,"Removing Channel %s",(*old)->name);
	write_message(mesg,0);
	free((*old)->title);
	free((*old)->artist);
	free((*old)->album);
	free((*old)->url);
	free(*old);
	*old=NULL;
	mixer.c_number--;
	return 0;
}

/* initialise mixer structure */
void init_mixer(int rate,int channels){
	int i;
	mixer.t_number=0;
	mixer.c_number=0;
	mixer.rate=rate;
	mixer.channels=channels;
	mixer.soundcard=0;
	mixer.out_mode=0;   
	/*
	  mixer.compression_vol=10000;
	  mixer.noise_gate=10;
	  mixer.compression_power=0.5;
	*/
	mixer.compression_vol=10000;
	mixer.noise_gate=10;
	mixer.compression_power=0.0;
	for(i=0;i<BUF_SIZE;i++) filt_prebuf[i]=0;
	/* open the control file */
	if(g_conf.mix_control==1){
		if((mixer.control_file=fopen(g_conf.mix_control_file,"w"))==NULL) {
			g_conf.mix_control=0;
			write_message("can't open mixer command file",0);
			write_message("Commangs will not be logged",0);
		}
	} else if(g_conf.mix_control==2) {
		if((mixer.control_file=fopen(g_conf.mix_control_file,"r"))==NULL){
			g_conf.mix_control=0;
			write_message("can't open mixer command file",0);
			write_message("reverting to full manual control",0);
		}
	}
	mixer.time_resolution=BUF_SIZE/((float)(g_conf.sample_rate)*(g_conf.stereo ? 2 : 1));
	mixer.seq_time=0;
	for(i=0;i<MAX_CHANNELS;i++)
		mixer.c_list[i]=NULL;
	
	mixer.t_list=NULL;
}

/* stop the channel and clear up all the lose ends */
void kill_channel(cptr ch){
	int i;
	/* if we've spawned a subprocess then kill it */
	if(ch->pid > 0 ) 
		kill((*ch).pid,15);
		
	/* dont' want to close anything important by accident */
	if(ch->stream > 2) 
		fclose((*ch).fstr);
	
	/* if there's a control stream then kill it */
	if(ch->control > 2)
		close(ch->control);

	ch->pid=0;
	ch->on=0;
	ch->stream=0;
	ch->control=0;

	for(i=0;i<BUF_SIZE;i++) (*ch).inbuf[i]=0;
}


/* step up through the list of tracks */
void change_channel(cptr ch,int inc){
	ch->curnt=get_relative_track(ch->curnt,inc);
	(*ch).speed=1;
	kill_channel(ch);
#ifdef HAVE_LIBCURSES
	init_channel_display(ch);
#else
	fprintf(stderr,"Channel %s selecting \n %s\n",ch->name,ch->curnt->filename);
#endif
}

char *my_basename(char *wholefilename)
{
return strrchr (wholefilename, '/');
}


/* ok - look at the file type - try id3 tags we're lookign at an mp3 */
/* then look at the formvar string passed to us */
void parse_channel_metadata(cptr ch){
        char *title,*artist,*album,*url;
	char *workspc,*buff,*field,*value;
	int x;
	/* look at the file first */
	parse_file_metadata(ch->curnt->filename,&title,&artist,&album,&url);

	/* now parse the formvars */
	workspc=strdup(ch->curnt->formvars);
	buff=workspc;
	for(x=0;buff[0]!=0;x++){
	        getword(value,buff,'&');
		/* this of course assumes that no formvars need to be escaped
		   so I'll be a good boy and not support any */
		plustospace(value);
		unescape_url(value);
		getword(field,value,'=');
		/* so got my pair - go match them up */
		if(!strcmp(field,"title")){
		        free(title);
			title=strdup(value);		  
		} else if(!strcmp(field,"artist")){
		        free(artist);
			artist=strdup(value);
		} else if(!strcmp(field,"album")){
		        free(album);
			album=strdup(album);
		} else if(!strcmp(field,"url")){
		        free(url);
			url=strdup(url);
		} else if(!strcmp(field,"speed")){
		        /* we can automatically set the speed of the channel */
		        ch->speed=atof(value);
		} 
	}
	free(workspc);
	/* and finally replace the old vars */
	free(ch->title);
	free(ch->artist);
	free(ch->album);
	free(ch->url);
	ch->title=title;
	ch->artist=artist;
	ch->album=album;
	ch->url=url;
}


/* spawn mpg123 */
int spawn_mp3_stream(cptr ch){
	int strm[2],control[2],rate,channels;
	pid_t pid;

	rate=format_of (ch->curnt->filename,&channels);
	ch->rate=rate;
	ch->channels=channels;
	if(rate>0){ 
		pipe(strm);
		pipe(control);
		pid=fork();
		if(pid){
			(*ch).pid=pid;
			close(strm[1]);
			(*ch).stream=strm[0];
			(*ch).fstr=fdopen((*ch).stream,"rb");
			/* connect stdin */
			close(control[0]);
			(*ch).control=control[1];
			
		} else {
			close(strm[0]);
			close(1);
			dup(strm[1]);
			close(strm[0]);
			close(strm[1]);
			/* duplicate stdin */
			close(control[1]);
			close(0);
			dup(control[0]);
			close(control[0]);
			/* close audio too - don't use the close_soundcard because it causes glitches*/
			close(2);
			open("/dev/null",O_WRONLY);
			if(g_conf.soundcard){
				close(g_conf.audio_fd);
			}
			execlp(g_conf.decoder_cmd,g_conf.decoder_cmd,"-sq",ch->curnt->filename,NULL);
			fatal("bugger - no decoder - check DECODER_COMMAND");
		}
		return 0;
	} else {
		return -1;
	}
}

/* Spawn SOX to convert miscelaneous audio types */
/* sample_rate fix from Eugene Crosser crosser@online.ru */
int spawn_sox_stream(cptr ch){
	int strm[2],control[2];
	pid_t pid;
	char sample_rate[16];

	pipe(strm);
	pipe(control);
	pid=fork();
	if(pid) {
	    (*ch).pid=pid;
		close(strm[1]);
		(*ch).stream=strm[0];
		(*ch).fstr=fdopen((*ch).stream,"rb");
		/* connect stdin */
		close(control[0]);
		(*ch).control=control[1];
	} else {
	    close(strm[0]);
		close(1);
		dup(strm[1]);
		close(strm[0]);
		close(strm[1]);
		/* duplicate stdin */
		close(control[1]);
		close(0);
		dup(control[0]);
		close(control[0]);
		/* close audio too - don't use the close_soundcard because it causes glitches*/
		if(g_conf.soundcard){
		    close(g_conf.audio_fd);
		}
		sprintf(sample_rate,"%d",g_conf.sample_rate);
		execlp("sox","sox",ch->curnt->filename,"-t","RAW","-r",sample_rate,"-w","-s","-c",(g_conf.stereo ? "2" : "1"),"-",NULL);
		fatal("bugger - no converter - check you've got sox");
	}
	return 0;
}

/* Major problem right now... can't be bothered to do a proper fix */

int spawn_cat_stream(cptr ch){
	int strm[2];
	pid_t pid;
	
	pipe(strm);
	pid=fork();
	if(pid){
	    (*ch).pid=pid;
		close(strm[1]);
		(*ch).stream=strm[0];
		(*ch).fstr=fdopen((*ch).stream,"rb");
		/* set no control channl */
		(*ch).control=-1;
	} else {
	    close(strm[0]);
		close(1);
		dup(strm[1]);
		close(strm[0]);
		close(strm[1]);
		/* close audio too - don't use the close_soundcard because it causes glitches*/
		if(g_conf.soundcard){
		    close(g_conf.audio_fd);
		}
		execlp("cat","cat",ch->curnt->filename,NULL);
		fatal("bugger - no converter - check you've got sox");
	}
	return 0;
}

int spawn_executable(cptr ch){
        int strm[2];
	pid_t pid;
	
	pipe(strm);
	pid=fork();
	if(pid){
	        ch->pid=pid;
		close(strm[1]);
		ch->stream=strm[0];
		ch->fstr=fdopen((*ch).stream,"rb");
		/* set no control channl */
		(*ch).control=-1;
	} else {
	    close(strm[0]);
		close(1);
		dup(strm[1]);
		close(strm[0]);
		close(strm[1]);
		/* close audio too - don't use the close_soundcard because it causes glitches*/
		if(g_conf.soundcard){
		    close(g_conf.audio_fd);
		}
		/* obviously you'd better trust your playlist */
		if(system(ch->curnt->filename)<0){
		        fatal("bugger execution failed ");
		}
	}
	return 0;
}



int spawn_raw_stream(cptr ch){
	ch->pid=0;
	if((ch->fstr=fopen(ch->curnt->filename,"rb"))==NULL){
		return -1;
	} else {
		ch->pid=-1;
		ch->control=-1;
		ch->stream=3;
		return 0;
	}
}



int spawn_stream(cptr ch){
	int bad=1;
	char mesg[1024],name[1024];
	time_t now;
	FILE *logfile;
	
#ifdef HAVE_BASENAME
	sprintf(name,"%s",basename(ch->curnt->filename));
#else
	sprintf(mesg,"%s",my_basename(ch->curnt->filename));
#endif
	
/* try to play next track */
	if(ch->curnt->t_type==MPEG)
		bad=spawn_mp3_stream(ch);
	else if(ch->curnt->t_type==MISC_AUDIO)
		bad=spawn_sox_stream(ch);
	else if(ch->curnt->t_type==RAW_AUDIO)
		bad=spawn_raw_stream(ch);
	else if(ch->curnt->t_type==EXECUTABLE)
	        bad=spawn_executable(ch);
	else
		bad=1;
			
	if(bad){
		sprintf(mesg,"Unable to play %s",name);
		write_message(mesg,0);
		change_channel(ch,1);
		ch->bad++;
		/* too many bad tracks - stop trying */
		if((ch->bad) > 100){
			ch->stayon=0;
			ch->on=0;
			write_message("Too many Bad Tracks stopping",0);
		} else {
			ch->on=1;
		}
		return -1;
	} else {
		sprintf(mesg,"Playing %s",name);
		write_message(mesg,0);
		/* this will be the call which actually reads id3's 
		   and all that stuff */
		parse_channel_metadata(ch);
		write_logfile(ch);
		execute_update_script(ch);
		ch->bad=0;       /* reset bad counter */
		return 0;
	}
}





void init_data_structures(int nch){
  int i;
  char chan_name[64];
	init_mixer(g_conf.sample_rate,1+g_conf.stereo);
	
	mixer.t_number=load_playlist(&(mixer.t_list),g_conf.playlist);
	/* just add 2 channels.... because that's all the interface supports */
	if(!(mixer.t_number>0))
		fatal("No legal tracks in playlist file");
	for(i=0;i<nch;i++){
	  sprintf(chan_name,"%d",i+1);
	  add_channel(&mixer.c_list[i],chan_name);
	  
#ifdef HAVE_LIBCURSES
	  /* shit! I really should think along the lines of widget packing.*/
	  mixer.c_list[i]->c_display=newwin(2,COLS-2,10+3i,1);
#endif
	}
}

/* channel operations */

/*
void reset_channel(cptr ch){
	int i;
	for(i=0;i<BUF_SIZE;i++) (*ch).inbuf[i]=0;
	(*ch).volume=1.0;
	(*ch).speed=1.0;
	(*ch).on=0;
	(*ch).stream=0;
	(*ch).pid=0;
	(*ch).stayon=0;
}
*/


/* get audio flls the current channel's buffer with the next chunk of audio */
/* because of differing sample rates I whacked a fairly hefty buffer into this
   routine */
void get_audio(cptr ch){
	static short inbuf[BUF_SIZE*40];
	int i;
	unsigned int num_samples;
	
	/* try starting up the decoder stream */
	if(ch->on) 
		if(!ch->pid)
			if(spawn_stream(ch))
				ch->pid=0;

      

	if((ch->on)&&(ch->pid)){

		num_samples=(int)((BUF_SIZE*ch->rate*ch->speed)/(mixer.rate*mixer.channels));
 
		i=fread(inbuf,2,num_samples*ch->channels,ch->fstr);
		/* if we reach  the end of the stream then pad */
		if(i<num_samples*ch->channels){
			while(i<num_samples*ch->channels){
				inbuf[i]=0;
				i++;
			}
			/* and skip to the next rack is required */
			if(ch->stayon==-1)
				change_channel(ch,random_number(&(g_conf.random_seed))*mixer.t_number);
			else
				change_channel(ch,1);
			/* changing the channel sets ch->on to zero */
			if(ch->stayon)
				ch->on=1;
		}
		/* now convert the audio into something useful */
		convert_audio(inbuf,ch->inbuf,ch->channels,mixer.channels,num_samples,BUF_SIZE/mixer.channels);
	} else {
		for(i=0;i<BUF_SIZE;i++)
			ch->inbuf[i]=0;
	}
#ifdef HAVE_LIBCURSES
	/* ho hum - lazy display */
	update_channel_display(ch,BUF_SIZE);
#endif
}


int play_chunks(){
	int i,j,num,max;
	static float last_avg=0;
	int played,err;

	num=BUF_SIZE;
#ifndef HAVE_LIBCURSES  
	printf("\r");
#endif
	played=0;   /* keeps track of whether the soundcard has been used */
	/* if we're in half duplex mode and using line in then we've already monopolised the device :-( */
	if((mixer.soundcard) && !(g_conf.full_duplex) )
		played=1;
	/* And of course if we#re not using the card at all */
	if(!g_conf.soundcard)
		played=1;

	if((mixer.soundcard)&&(g_conf.soundcard)){
		read(g_conf.audio_fd,audio_buffer,BUF_SIZE*2);
		for(i=0;i<BUF_SIZE;i++) process_buffer[i]=audio_buffer[i];
		max=0;
		for(i=0;i<BUF_SIZE;i++){
			if(abs(audio_buffer[i])>max)
				max=abs(audio_buffer[i]);
		}
#ifdef HAVE_LIBCURSES
		mv_draw_volume(8,20,max);
#else
		printf("%6d      ",max);
#endif
	} else {
		for(i=0;i<BUF_SIZE;i++) process_buffer[i]=0;
#ifdef HAVE_LIBCURSES
		mv_draw_volume(8,20,0);
#endif
	}
	
	for(i=0;i<MAX_CHANNELS;i++){
		if(mixer.c_list[i]!=NULL){
			if(mixer.c_list[i]->on){
				get_audio(mixer.c_list[i]);
				/* if the correct output mode is selected then ply this channel */
				if((mixer.out_mode==(i+1)) && (!played)) {
					played=1;
					write(g_conf.audio_fd,mixer.c_list[i]->inbuf,num*2);
				}
				for(j=0;j<num;j++)
					process_buffer[j] += mixer.c_list[i]->inbuf[j] * mixer.c_list[i]->volume;
			}
		}
	}

	/* HACK HACK HACK !*/
	/* No I'm not coughing.. I'mt trying out some effects processing */
	/* apply some compression to the audio */
	compress_audio2(process_buffer,&last_avg,num,num,mixer.compression_power, mixer.compression_vol, mixer.noise_gate);

      	/* now clip the audio stream  and copy it ot the audio buffer*/

	clip_audio(process_buffer,audio_buffer,num,0.9);

	/* get the volume of the stream */
	max=get_max_level16(audio_buffer,num);

#ifdef HAVE_LIBCURSES
	mv_draw_volume(16,20,max);
#else
	printf("%6d     ",max);
#endif

	/*fwrite(audio_buffer,2,num,pipe);*/
	err=write_streams(audio_buffer,num);
	if(!played)
		write(g_conf.audio_fd,audio_buffer,num*2);
		
	/* if soundcard is not being used we need to keep sync ourselves */
	synchronise_time(num);
	return err;
}

/* this new update call is only going to look at the loudest channel*/
void update_remote_names(){
  char mesg[4096];
  char url[4096];
  int i,chan;
  float max=0;
  mesg[0]=0; 
  fprintf(stderr,"Updating Titles\n");
  chan=-1;
  for(i=0;i<MAX_CHANNELS;i++){
    if(mixer.c_list[i]!=NULL){
      if(mixer.c_list[i]->on){
	if(mixer.c_list[i]->volume > max){
	  max=mixer.c_list[i]->volume;
	  chan=i;
	}
      }
    }
  }
  if(chan==-1){
    /* nothing is playing */
    /* set the url to the icy url */
    strcpy(url,g_conf.icy_url);
  } else {
    /* now - use the meta info for the channel which is loudest */
    sprintf(mesg,"%s by %s ",mixer.c_list[chan]->title,mixer.c_list[chan]->artist);
    strcpy(url,mixer.c_list[chan]->url);
  }
  if((mixer.soundcard)&&(g_conf.soundcard)){
    strcat(mesg,"(live audio)");
  }
  update_all_servers(mesg,g_conf.icy_url);
  
}


/* mp3mixer mode.... requires input file called playlist which lists mp3's */
/* try find / -name "*.mp3" > playlist */
/* in theory..... you can stream from other live sources by putting */
/* http: streams in the playlist file.....  */
void mp3mixer(void){
	char inp=0;
	int err=0;
	time_t now,last;
	signal(SIGCHLD,SIG_IGN);
	signal (SIGUSR1, siguser_handler);
	if(g_conf.soundcard)
		open_soundcard(O_RDWR);

	draw_mixer_display();
	/* 2 channels - we know this works */
	init_data_structures(2);
	change_channel(mixer.c_list[0],0);
	change_channel(mixer.c_list[1],0);
	/* a lot of people want this to go straight into playing the playlist */ 
	mixer.c_list[0]->stayon = !mixer.c_list[0]->stayon;
	mixer.c_list[0]->on=1;
#ifdef HAVE_LIBCURSES
	init_channel_display(mixer.c_list[0]);
#endif
	time(&last);
	while((inp!='+')&&(!err)){
		err=play_chunks();	
		if(re_read_signal){
			re_read_signal=0;
			reread_playlist(&(mixer.t_list));
			reset_track_pointers();
		}
		inp=do_mixer_control();
#ifdef HAVE_LIBCURSES
		refresh();
		doupdate();
#endif
		time(&now);
		if((g_conf.meta_data>0) && (now > (last + g_conf.meta_data*60))){
			update_remote_names();
			time(&last);
		}
	}
	if(g_conf.mix_control)
		fclose(mixer.control_file);
	kill_channel(mixer.c_list[0]);
	kill_channel(mixer.c_list[1]);
	empty_playlist(&(mixer.t_list));
	if(g_conf.soundcard)
		close_soundcard();
}

/* this is how 90% of the user population think about using this....*/
/* simply a special case of the streamer with only one channel and no */
/* real interface */
void shout_streamer(void){
	char inp=0;
	int err=0;
	time_t now,last;
	signal(SIGCHLD,SIG_IGN);
	signal (SIGUSR1, siguser_handler);
	/* this mode *never* uses the soundcard */
	g_conf.soundcard=0;
	fprintf(stderr,"entering shout stremer function\n");
	/* I think one channel will work */
	draw_mixer_display();
	init_data_structures(1);
	change_channel(mixer.c_list[0],0);
	/* a lot of people want this to go straight into playing the playlist */ 
	mixer.c_list[0]->stayon = !mixer.c_list[0]->stayon;
	mixer.c_list[0]->on=1;
#ifdef HAVE_LIBCURSES
	init_channel_display(mixer.c_list[0]);
#endif

	time(&last);
	while((inp!='+')&&(!err)){
		err=play_chunks();	
		if(re_read_signal){
			re_read_signal=0;
			reread_playlist(&(mixer.t_list));
			reset_track_pointers();
		}
		inp=get_inp_char();
#ifdef HAVE_LIBCURSES
		refresh();
		doupdate();
#endif		
		time(&now);
		if((g_conf.meta_data>0) && (now > (last + g_conf.meta_data*60))){
			update_remote_names();
			time(&last);
		}
	}
	kill_channel(mixer.c_list[0]);

	empty_playlist(&(mixer.t_list));
}





