/***************************************************************************
                          mainpainter.h  -  description
                             -------------------
    begin                : Fri Jan 4 2002
    copyright            : (C) 2002 by Sebastian Schildt
    email                : sebastian@frozenlight.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MAINPAINTER_H
#define MAINPAINTER_H

#include <unistd.h>

#include <qpainter.h>
#include <qstring.h>
#include <qtimer.h>
#include <qwidget.h>
#include <qdir.h>
#include <qstringlist.h>
#include <qlist.h>
#include <qprocess.h>

#include <ksimpleconfig.h>

#include "painthelpers.h"
#include "configuration.h"
#include "setilocation.h"

#include "intermediatescreen.h"
#include "positionscreen.h"
#include "gaussianscreen.h"
#include "pulsescreen.h"
#include "tripletscreen.h"
#include "errorscreen.h"
#include "taskinfoscreen.h"
#include "transferscreen.h"

#include "setiparse.h"

/**
  *@author Sebastian Schildt
  */

class mainPainter {
public: 
	mainPainter(const configuration *c);
	~mainPainter();
	
	int paint(QPainter *p, QWidget *rpTarget, QTimer *timer);

private:

	void setErrorMsg(int nr);
	void getNextSahDir();

	paintHelpers *ph;

	const configuration *conf;

	IntermediateScreen iScreen;
	PositionScreen     posScreen;
	GaussianScreen		 gScreen;
	PulseScreen	       pScreen;
	TripletScreen      tScreen;
	ErrorScreen        eScreen;
	TaskinfoScreen     tiScreen;
	TransferScreen     trScreen;

	QWidget *rpt;

  SoundBox *sound;

	setiparse sp;

	QStringList sahdirs;
	QList<SetiLocation> sahlist;
	SetiLocation *currSL;

	enum Modes {INIT,POSITION,GAUSSIAN,PULSE,TRIPLET,ACCESS,LOADNEXT,ERROR,INFO,TRANSFER} mode;
	Modes lastmode;
	QString errorMsg;

	Modes getMode(Modes lm);

	bool startclient;
};

#endif
