/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.runtime.CommonToken;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.Tree;
import org.antlr.test.BaseTest;

public class TestTreeNodeStream
extends BaseTest {
    public void testSingleNode() throws Exception {
        CommonTree t = new CommonTree(new CommonToken(101));
        CommonTreeNodeStream stream = new CommonTreeNodeStream(t);
        String expecting = " 101";
        String found = stream.toNodesOnlyString();
        TestTreeNodeStream.assertEquals((String)expecting, (String)found);
        expecting = " 101";
        found = stream.toString();
        TestTreeNodeStream.assertEquals((String)expecting, (String)found);
    }

    public void test4Nodes() throws Exception {
        CommonTree t = new CommonTree(new CommonToken(101));
        t.addChild(new CommonTree(new CommonToken(102)));
        t.getChild(0).addChild(new CommonTree(new CommonToken(103)));
        t.addChild(new CommonTree(new CommonToken(104)));
        CommonTreeNodeStream stream = new CommonTreeNodeStream(t);
        String expecting = " 101 102 103 104";
        String found = stream.toNodesOnlyString();
        TestTreeNodeStream.assertEquals((String)expecting, (String)found);
        expecting = " 101 2 102 2 103 3 104 3";
        found = stream.toString();
        TestTreeNodeStream.assertEquals((String)expecting, (String)found);
    }

    public void testList() throws Exception {
        CommonTree root = new CommonTree(null);
        CommonTree t = new CommonTree(new CommonToken(101));
        t.addChild(new CommonTree(new CommonToken(102)));
        t.getChild(0).addChild(new CommonTree(new CommonToken(103)));
        t.addChild(new CommonTree(new CommonToken(104)));
        CommonTree u = new CommonTree(new CommonToken(105));
        root.addChild(t);
        root.addChild(u);
        CommonTreeNodeStream stream = new CommonTreeNodeStream(root);
        String expecting = " 101 102 103 104 105";
        String found = stream.toNodesOnlyString();
        TestTreeNodeStream.assertEquals((String)expecting, (String)found);
        expecting = " 101 2 102 2 103 3 104 3 105";
        found = stream.toString();
        TestTreeNodeStream.assertEquals((String)expecting, (String)found);
    }

    public void testFlatList() throws Exception {
        CommonTree root = new CommonTree(null);
        root.addChild(new CommonTree(new CommonToken(101)));
        root.addChild(new CommonTree(new CommonToken(102)));
        root.addChild(new CommonTree(new CommonToken(103)));
        CommonTreeNodeStream stream = new CommonTreeNodeStream(root);
        String expecting = " 101 102 103";
        String found = stream.toNodesOnlyString();
        TestTreeNodeStream.assertEquals((String)expecting, (String)found);
        expecting = " 101 102 103";
        found = stream.toString();
        TestTreeNodeStream.assertEquals((String)expecting, (String)found);
    }

    public void testListWithOneNode() throws Exception {
        CommonTree root = new CommonTree(null);
        root.addChild(new CommonTree(new CommonToken(101)));
        CommonTreeNodeStream stream = new CommonTreeNodeStream(root);
        String expecting = " 101";
        String found = stream.toNodesOnlyString();
        TestTreeNodeStream.assertEquals((String)expecting, (String)found);
        expecting = " 101";
        found = stream.toString();
        TestTreeNodeStream.assertEquals((String)expecting, (String)found);
    }

    public void testAoverB() throws Exception {
        CommonTree t = new CommonTree(new CommonToken(101));
        t.addChild(new CommonTree(new CommonToken(102)));
        CommonTreeNodeStream stream = new CommonTreeNodeStream(t);
        String expecting = " 101 102";
        String found = stream.toNodesOnlyString();
        TestTreeNodeStream.assertEquals((String)expecting, (String)found);
        expecting = " 101 2 102 3";
        found = stream.toString();
        TestTreeNodeStream.assertEquals((String)expecting, (String)found);
    }

    public void testLT() throws Exception {
        CommonTree t = new CommonTree(new CommonToken(101));
        t.addChild(new CommonTree(new CommonToken(102)));
        t.getChild(0).addChild(new CommonTree(new CommonToken(103)));
        t.addChild(new CommonTree(new CommonToken(104)));
        CommonTreeNodeStream stream = new CommonTreeNodeStream(t);
        TestTreeNodeStream.assertEquals((int)101, (int)((Tree)stream.LT(1)).getType());
        TestTreeNodeStream.assertEquals((int)2, (int)((Tree)stream.LT(2)).getType());
        TestTreeNodeStream.assertEquals((int)102, (int)((Tree)stream.LT(3)).getType());
        TestTreeNodeStream.assertEquals((int)2, (int)((Tree)stream.LT(4)).getType());
        TestTreeNodeStream.assertEquals((int)103, (int)((Tree)stream.LT(5)).getType());
        TestTreeNodeStream.assertEquals((int)3, (int)((Tree)stream.LT(6)).getType());
        TestTreeNodeStream.assertEquals((int)104, (int)((Tree)stream.LT(7)).getType());
        TestTreeNodeStream.assertEquals((int)3, (int)((Tree)stream.LT(8)).getType());
        TestTreeNodeStream.assertEquals((int)-1, (int)((Tree)stream.LT(9)).getType());
        TestTreeNodeStream.assertEquals((int)-1, (int)((Tree)stream.LT(100)).getType());
    }

    public void testMarkRewindEntire() throws Exception {
        CommonTree r0 = new CommonTree(new CommonToken(101));
        CommonTree r1 = new CommonTree(new CommonToken(102));
        r0.addChild(r1);
        r1.addChild(new CommonTree(new CommonToken(103)));
        CommonTree r2 = new CommonTree(new CommonToken(106));
        r2.addChild(new CommonTree(new CommonToken(107)));
        r1.addChild(r2);
        r0.addChild(new CommonTree(new CommonToken(104)));
        r0.addChild(new CommonTree(new CommonToken(105)));
        CommonTreeNodeStream stream = new CommonTreeNodeStream(r0);
        int m = stream.mark();
        int k = 1;
        while (k <= 13) {
            stream.LT(1);
            stream.consume();
            ++k;
        }
        TestTreeNodeStream.assertEquals((int)-1, (int)((Tree)stream.LT(1)).getType());
        TestTreeNodeStream.assertEquals((int)3, (int)((Tree)stream.LT(-1)).getType());
        stream.rewind(m);
        k = 1;
        while (k <= 13) {
            stream.LT(1);
            stream.consume();
            ++k;
        }
        TestTreeNodeStream.assertEquals((int)-1, (int)((Tree)stream.LT(1)).getType());
        TestTreeNodeStream.assertEquals((int)3, (int)((Tree)stream.LT(-1)).getType());
    }

    public void testMarkRewindInMiddle() throws Exception {
        CommonTree r0 = new CommonTree(new CommonToken(101));
        CommonTree r1 = new CommonTree(new CommonToken(102));
        r0.addChild(r1);
        r1.addChild(new CommonTree(new CommonToken(103)));
        CommonTree r2 = new CommonTree(new CommonToken(106));
        r2.addChild(new CommonTree(new CommonToken(107)));
        r1.addChild(r2);
        r0.addChild(new CommonTree(new CommonToken(104)));
        r0.addChild(new CommonTree(new CommonToken(105)));
        CommonTreeNodeStream stream = new CommonTreeNodeStream(r0);
        int k = 1;
        while (k <= 7) {
            stream.consume();
            ++k;
        }
        TestTreeNodeStream.assertEquals((int)107, (int)((Tree)stream.LT(1)).getType());
        int m = stream.mark();
        stream.consume();
        stream.consume();
        stream.consume();
        stream.consume();
        stream.rewind(m);
        TestTreeNodeStream.assertEquals((int)107, (int)((Tree)stream.LT(1)).getType());
        stream.consume();
        TestTreeNodeStream.assertEquals((int)3, (int)((Tree)stream.LT(1)).getType());
        stream.consume();
        TestTreeNodeStream.assertEquals((int)3, (int)((Tree)stream.LT(1)).getType());
        stream.consume();
        TestTreeNodeStream.assertEquals((int)104, (int)((Tree)stream.LT(1)).getType());
        stream.consume();
        TestTreeNodeStream.assertEquals((int)105, (int)((Tree)stream.LT(1)).getType());
        stream.consume();
        TestTreeNodeStream.assertEquals((int)3, (int)((Tree)stream.LT(1)).getType());
        stream.consume();
        TestTreeNodeStream.assertEquals((int)-1, (int)((Tree)stream.LT(1)).getType());
        TestTreeNodeStream.assertEquals((int)3, (int)((Tree)stream.LT(-1)).getType());
    }

    public void testMarkRewindNested() throws Exception {
        CommonTree r0 = new CommonTree(new CommonToken(101));
        CommonTree r1 = new CommonTree(new CommonToken(102));
        r0.addChild(r1);
        r1.addChild(new CommonTree(new CommonToken(103)));
        CommonTree r2 = new CommonTree(new CommonToken(106));
        r2.addChild(new CommonTree(new CommonToken(107)));
        r1.addChild(r2);
        r0.addChild(new CommonTree(new CommonToken(104)));
        r0.addChild(new CommonTree(new CommonToken(105)));
        CommonTreeNodeStream stream = new CommonTreeNodeStream(r0);
        int m = stream.mark();
        stream.consume();
        stream.consume();
        int m2 = stream.mark();
        stream.consume();
        stream.consume();
        stream.consume();
        stream.consume();
        stream.rewind(m2);
        TestTreeNodeStream.assertEquals((int)102, (int)((Tree)stream.LT(1)).getType());
        stream.consume();
        TestTreeNodeStream.assertEquals((int)2, (int)((Tree)stream.LT(1)).getType());
        stream.consume();
        stream.rewind(m);
        TestTreeNodeStream.assertEquals((int)101, (int)((Tree)stream.LT(1)).getType());
        stream.consume();
        TestTreeNodeStream.assertEquals((int)2, (int)((Tree)stream.LT(1)).getType());
        stream.consume();
        TestTreeNodeStream.assertEquals((int)102, (int)((Tree)stream.LT(1)).getType());
        stream.consume();
        TestTreeNodeStream.assertEquals((int)2, (int)((Tree)stream.LT(1)).getType());
    }

    public void testSeek() throws Exception {
        CommonTree r0 = new CommonTree(new CommonToken(101));
        CommonTree r1 = new CommonTree(new CommonToken(102));
        r0.addChild(r1);
        r1.addChild(new CommonTree(new CommonToken(103)));
        CommonTree r2 = new CommonTree(new CommonToken(106));
        r2.addChild(new CommonTree(new CommonToken(107)));
        r1.addChild(r2);
        r0.addChild(new CommonTree(new CommonToken(104)));
        r0.addChild(new CommonTree(new CommonToken(105)));
        CommonTreeNodeStream stream = new CommonTreeNodeStream(r0);
        stream.consume();
        stream.consume();
        stream.consume();
        stream.seek(7);
        TestTreeNodeStream.assertEquals((int)107, (int)((Tree)stream.LT(1)).getType());
        stream.consume();
        stream.consume();
        stream.consume();
        TestTreeNodeStream.assertEquals((int)104, (int)((Tree)stream.LT(1)).getType());
    }

    public void testSeekFromStart() throws Exception {
        CommonTree r0 = new CommonTree(new CommonToken(101));
        CommonTree r1 = new CommonTree(new CommonToken(102));
        r0.addChild(r1);
        r1.addChild(new CommonTree(new CommonToken(103)));
        CommonTree r2 = new CommonTree(new CommonToken(106));
        r2.addChild(new CommonTree(new CommonToken(107)));
        r1.addChild(r2);
        r0.addChild(new CommonTree(new CommonToken(104)));
        r0.addChild(new CommonTree(new CommonToken(105)));
        CommonTreeNodeStream stream = new CommonTreeNodeStream(r0);
        stream.seek(7);
        TestTreeNodeStream.assertEquals((int)107, (int)((Tree)stream.LT(1)).getType());
        stream.consume();
        stream.consume();
        stream.consume();
        TestTreeNodeStream.assertEquals((int)104, (int)((Tree)stream.LT(1)).getType());
    }

    public void testBufferOverflow() throws Exception {
        StringBuffer buf = new StringBuffer();
        StringBuffer buf2 = new StringBuffer();
        CommonTree t = new CommonTree(new CommonToken(101));
        buf.append(" 101");
        buf2.append(" 101");
        buf2.append(" ");
        buf2.append(2);
        int i = 0;
        while (i <= 15) {
            t.addChild(new CommonTree(new CommonToken(102 + i)));
            buf.append(" ");
            buf.append(102 + i);
            buf2.append(" ");
            buf2.append(102 + i);
            ++i;
        }
        buf2.append(" ");
        buf2.append(3);
        CommonTreeNodeStream stream = new CommonTreeNodeStream(t);
        String expecting = buf.toString();
        String found = stream.toNodesOnlyString();
        TestTreeNodeStream.assertEquals((String)expecting, (String)found);
        expecting = buf2.toString();
        found = stream.toString();
        TestTreeNodeStream.assertEquals((String)expecting, (String)found);
    }

    public void testBufferWrap() throws Exception {
        int N = 10;
        CommonTree t = new CommonTree(null);
        int i = 0;
        while (i < 5 + N) {
            t.addChild(new CommonTree(new CommonToken(i + 1)));
            ++i;
        }
        CommonTreeNodeStream stream = new CommonTreeNodeStream(t);
        int i2 = 1;
        while (i2 <= N) {
            Tree node = (Tree)stream.LT(1);
            TestTreeNodeStream.assertEquals((int)i2, (int)node.getType());
            stream.consume();
            ++i2;
        }
        int remaining = 5 - N;
        int wrapBy = 4;
        boolean bl = false;
        if (wrapBy < N) {
            bl = true;
        }
        TestTreeNodeStream.assertTrue((String)"bad test code; wrapBy must be less than N", (boolean)bl);
        int i3 = 1;
        while (i3 <= remaining + wrapBy) {
            Tree node = (Tree)stream.LT(i3);
            TestTreeNodeStream.assertEquals((int)(N + i3), (int)node.getType());
            ++i3;
        }
    }
}

