/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.analysis.DFA;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.test.BaseTest;
import org.antlr.tool.Grammar;

public class TestDFAMatching
extends BaseTest {
    public void testSimpleAltCharTest() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : {;}'a' | 'b' | 'c';");
        g.createNFAs();
        g.createLookaheadDFAs();
        DFA dfa = g.getLookaheadDFA(1);
        this.checkPrediction(dfa, "a", 1);
        this.checkPrediction(dfa, "b", 2);
        this.checkPrediction(dfa, "c", 3);
        this.checkPrediction(dfa, "d", -1);
    }

    public void testSets() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : {;}'a'..'z' | ';' | '0'..'9' ;");
        g.createNFAs();
        g.createLookaheadDFAs();
        DFA dfa = g.getLookaheadDFA(1);
        this.checkPrediction(dfa, "a", 1);
        this.checkPrediction(dfa, "q", 1);
        this.checkPrediction(dfa, "z", 1);
        this.checkPrediction(dfa, ";", 2);
        this.checkPrediction(dfa, "9", 3);
    }

    public void testFiniteCommonLeftPrefixes() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : 'a' 'b' | 'a' 'c' | 'd' 'e' ;");
        g.createNFAs();
        g.createLookaheadDFAs();
        DFA dfa = g.getLookaheadDFA(1);
        this.checkPrediction(dfa, "ab", 1);
        this.checkPrediction(dfa, "ac", 2);
        this.checkPrediction(dfa, "de", 3);
        this.checkPrediction(dfa, "q", -1);
    }

    public void testSimpleLoops() throws Exception {
        Grammar g = new Grammar("lexer grammar t;\nA : (DIGIT)+ '.' DIGIT | (DIGIT)+ ;\nfragment DIGIT : '0'..'9' ;\n");
        g.createNFAs();
        g.createLookaheadDFAs();
        DFA dfa = g.getLookaheadDFA(3);
        this.checkPrediction(dfa, "32", 2);
        this.checkPrediction(dfa, "999.2", 1);
        this.checkPrediction(dfa, ".2", -1);
    }

    protected void checkPrediction(DFA dfa, String input, int expected) throws Exception {
        ANTLRStringStream stream = new ANTLRStringStream(input);
        TestDFAMatching.assertEquals((int)dfa.predict(stream), (int)expected);
    }
}

